/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.perfdmf.Context;
import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.DataSourceException;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.LineData;
import edu.uoregon.tau.perfdmf.Node;
import edu.uoregon.tau.perfdmf.Thread;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.Vector;

public class GprofDataSource
extends DataSource {
    private boolean fixNames = false;
    private int linenumber = 0;
    private boolean fixLengths = true;
    private String currentFile;
    private File[] files;

    public GprofDataSource(File[] fileArray, boolean bl) {
        this.fixNames = bl;
        this.files = fileArray;
    }

    public void cancelLoad() {
    }

    public int getProgress() {
        return 0;
    }

    public void load() throws FileNotFoundException, IOException {
        long l = System.currentTimeMillis();
        Function function = null;
        FunctionProfile functionProfile = null;
        Node node = null;
        Context context = null;
        Thread thread = null;
        int n = -1;
        String string = null;
        Function function2 = null;
        for (int i = 0; i < this.files.length; ++i) {
            File file = this.files[i];
            this.currentFile = this.files[i].toString();
            FileInputStream fileInputStream = new FileInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            node = this.addNode(++n);
            context = node.addContext(0);
            thread = context.addThread(0);
            this.addMetric("Time");
            boolean bl = false;
            boolean bl2 = true;
            Vector<LineData> vector = new Vector<LineData>();
            LineData lineData = null;
            Vector<LineData> vector2 = new Vector<LineData>();
            this.fixLengths = true;
            this.linenumber = 1;
            while ((string = bufferedReader.readLine()) != null) {
                if (string.startsWith("gmon") && this.linenumber == 1) {
                    throw new DataSourceException("Error: this appears to be a gmon.out file, please run gprof > gprof.out and load gprof.out instead");
                }
                int n2 = string.length();
                if (n2 != 0) {
                    int n3 = string.indexOf("granularity: ");
                    if (n3 == 0 || n3 == 1) {
                        bl = !bl;
                    }
                    if (bl) {
                        if (string.indexOf("index") != 0 || string.indexOf("time") < 0 || string.indexOf("self") < 0 || string.indexOf("called") < 0 || string.indexOf("name") < 0) {
                            if (string.charAt(0) == '[') {
                                lineData = this.getSelfLineData(string);
                                bl2 = false;
                            } else if (string.charAt(0) == '-') {
                                LineData lineData2;
                                int n4;
                                function = this.addFunction(lineData.s0, 1);
                                function.addGroup(this.addGroup("TAU_DEFAULT"));
                                functionProfile = new FunctionProfile(function);
                                thread.addFunctionProfile(functionProfile);
                                functionProfile.setInclusive(0, lineData.d1 + lineData.d2);
                                functionProfile.setExclusive(0, lineData.d1);
                                functionProfile.setNumCalls(lineData.d3);
                                double d = 0.0;
                                for (n4 = 0; n4 < vector2.size(); ++n4) {
                                    lineData2 = (LineData)vector2.get(n4);
                                    d += lineData2.d3;
                                }
                                functionProfile.setNumSubr(d);
                                for (n4 = 0; n4 < vector.size(); ++n4) {
                                    lineData2 = (LineData)vector.elementAt(n4);
                                    function = this.addFunction(lineData2.s0, 1);
                                    function.addGroup(this.addGroup("TAU_DEFAULT"));
                                    function2 = this.addFunction(lineData2.s0 + " => " + lineData.s0 + "  ", 1);
                                    function2.addGroup(this.addGroup("TAU_DEFAULT"));
                                    function2.addGroup(this.addGroup("TAU_CALLPATH"));
                                    functionProfile = new FunctionProfile(function2);
                                    thread.addFunctionProfile(functionProfile);
                                    functionProfile.setInclusive(0, lineData2.d0 + lineData2.d1);
                                    functionProfile.setExclusive(0, lineData2.d0);
                                    functionProfile.setNumCalls(lineData2.d3);
                                }
                                vector.clear();
                                for (n4 = 0; n4 < vector2.size(); ++n4) {
                                    lineData2 = (LineData)vector2.elementAt(n4);
                                    function = this.addFunction(lineData2.s0, 1);
                                    function.addGroup(this.addGroup("TAU_DEFAULT"));
                                    function2 = this.addFunction(lineData.s0 + " => " + lineData2.s0 + "  ", 1);
                                    function2.addGroup(this.addGroup("TAU_DEFAULT"));
                                    function2.addGroup(this.addGroup("TAU_CALLPATH"));
                                    functionProfile = new FunctionProfile(function2);
                                    thread.addFunctionProfile(functionProfile);
                                    functionProfile.setInclusive(0, lineData2.d0 + lineData2.d1);
                                    functionProfile.setExclusive(0, lineData2.d0);
                                    functionProfile.setNumCalls(lineData2.d3);
                                }
                                vector2.clear();
                                bl2 = true;
                            } else if (string.charAt(n2 - 1) == ']') {
                                if (string.indexOf("<cycle") >= 0) {
                                    if (bl2) {
                                        vector.add(this.getParentChildLineData(string));
                                    } else {
                                        vector2.add(this.getParentChildLineData(string));
                                    }
                                } else if (bl2) {
                                    vector.add(this.getParentChildLineData(string));
                                } else {
                                    vector2.add(this.getParentChildLineData(string));
                                }
                            }
                        }
                    } else if (string.charAt(n2 - 1) == ']') {
                        // empty if block
                    }
                }
                ++this.linenumber;
            }
        }
        this.generateDerivedData();
        l = System.currentTimeMillis() - l;
    }

    private LineData getSelfLineData(String string) {
        Object object;
        boolean bl;
        LineData lineData = new LineData();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r");
        stringTokenizer.nextToken();
        lineData.d0 = Double.parseDouble(stringTokenizer.nextToken());
        lineData.d1 = 1000000.0 * Double.parseDouble(stringTokenizer.nextToken());
        String string2 = stringTokenizer.nextToken();
        lineData.d2 = 1000000.0 * Double.parseDouble(string2);
        if (this.fixLengths) {
            this.fixLengths = false;
        }
        String string3 = stringTokenizer.nextToken();
        try {
            Integer.parseInt(string3);
            bl = true;
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        if (!bl) {
            lineData.d3 = 1.0;
            lineData.s0 = string3;
        } else {
            if (string3.indexOf("+") < 0) {
                object = new StringTokenizer(string3, "+");
                lineData.d3 = Double.parseDouble(((StringTokenizer)object).nextToken());
            }
            lineData.s0 = stringTokenizer.nextToken();
        }
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            if (((String)object).indexOf("[") == 0 || ((String)object).endsWith("]")) continue;
            lineData.s0 = lineData.s0 + " " + (String)object;
        }
        lineData.s0 = this.fix(lineData.s0);
        return lineData;
    }

    private LineData getParentChildLineData(String string) {
        Object object;
        String string2 = string.trim();
        boolean bl = false;
        if (string2.length() < string.length() - 20) {
            bl = true;
        }
        LineData lineData = new LineData();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r");
        String string3 = null;
        if (bl) {
            lineData.d0 = 0.0;
            lineData.d1 = 0.0;
        } else {
            string3 = stringTokenizer.nextToken().trim();
            lineData.d0 = string3.length() > 0 ? 1000000.0 * Double.parseDouble(string3) : 0.0;
            try {
                string3 = stringTokenizer.nextToken().trim();
                lineData.d1 = string3.length() > 0 ? 1000000.0 * Double.parseDouble(string3) : 0.0;
            }
            catch (Exception exception) {
                System.err.println("Error parsing file: " + this.currentFile + ", line: " + this.linenumber);
                System.err.println(exception.getMessage());
                throw new DataSourceException(exception, this.currentFile);
            }
        }
        string3 = stringTokenizer.nextToken().trim();
        if (string3.indexOf("/") >= 0) {
            object = new StringTokenizer(string3, "/");
            try {
                lineData.d3 = Double.parseDouble(((StringTokenizer)object).nextToken());
                ((StringTokenizer)object).nextToken();
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        } else {
            if (string3.indexOf(43) >= 0) {
                string3 = string3.split("\\+")[0];
            }
            lineData.d4 = lineData.d3 = Double.parseDouble(string3);
        }
        object = "";
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (!stringTokenizer.hasMoreTokens()) continue;
            object = (String)object + " " + string4;
        }
        lineData.s0 = object = ((String)object).trim();
        return lineData;
    }

    private String fix(String string) {
        String string2 = string;
        if (this.fixNames) {
            if (string.indexOf(".*") == 0) {
                string2 = string.substring(2, string.length());
            } else if (string.indexOf(".") == 0) {
                string2 = string.substring(1, string.length());
            } else if (string.endsWith("_")) {
                string2 = string.substring(0, string.length() - 1);
            }
        }
        return string2;
    }
}

