/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.IPMDataSource;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.Thread;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class IPMXMLHandler
extends DefaultHandler {
    private StringBuffer accumulator = new StringBuffer();
    protected String currentElement = "";
    private String functionCount = "";
    private boolean firstTask = false;
    private IPMDataSource dataSource;
    private Function function = null;
    private FunctionProfile fp = null;
    private RegionData region = null;

    public IPMXMLHandler(IPMDataSource iPMDataSource) {
        this.dataSource = iPMDataSource;
    }

    private String getInsensitiveValue(Attributes attributes, String string) {
        for (int i = 0; i < attributes.getLength(); ++i) {
            if (!attributes.getLocalName(i).equalsIgnoreCase(string)) continue;
            return attributes.getValue(i);
        }
        return null;
    }

    private void processAttributes(Attributes attributes) {
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string = attributes.getLocalName(i);
            String string2 = attributes.getValue(i);
            this.dataSource.getThread().getMetaData().put(this.currentElement + ":" + string, string2);
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.accumulator.setLength(0);
        if (!string2.equalsIgnoreCase("ipm_job_profile")) {
            if (string2.equalsIgnoreCase("task")) {
                this.currentElement = string2;
                this.dataSource.initializeThread(this.firstTask);
                this.firstTask = true;
                this.processAttributes(attributes);
            } else if (string2.equalsIgnoreCase("job")) {
                this.currentElement = string2;
                this.processAttributes(attributes);
            } else if (string2.equalsIgnoreCase("host")) {
                this.currentElement = string2;
                this.processAttributes(attributes);
            } else if (string2.equalsIgnoreCase("perf")) {
                this.currentElement = string2;
                this.processAttributes(attributes);
            } else if (string2.equalsIgnoreCase("switch")) {
                this.currentElement = string2;
                this.processAttributes(attributes);
            } else if (string2.equalsIgnoreCase("cmdline")) {
                this.currentElement = string2;
                this.processAttributes(attributes);
            } else if (string2.equalsIgnoreCase("exec") || string2.equalsIgnoreCase("exec_bin")) {
                this.currentElement = string2;
            } else if (!string2.equalsIgnoreCase("pre")) {
                if (string2.equalsIgnoreCase("internal")) {
                    this.currentElement = string2;
                    this.processAttributes(attributes);
                } else if (string2.equalsIgnoreCase("region")) {
                    this.currentElement = string2;
                    String string4 = this.getInsensitiveValue(attributes, "label");
                    this.region = new RegionData(string4);
                    String[] stringArray = new String[]{"nexits", "wtime", "utime", "stime", "mtime"};
                    for (int i = 0; i < stringArray.length; ++i) {
                        String string5 = this.getInsensitiveValue(attributes, stringArray[i]);
                        this.region.measurements.put(stringArray[i], string5);
                    }
                } else if (string2.equalsIgnoreCase("counter")) {
                    this.currentElement = this.getInsensitiveValue(attributes, "name");
                } else if (string2.equalsIgnoreCase("func")) {
                    this.currentElement = this.getInsensitiveValue(attributes, "name");
                    this.functionCount = this.getInsensitiveValue(attributes, "count");
                }
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.accumulator.append(cArray, n, n2);
    }

    public void endElement(String string, String string2, String string3) {
        if (!string2.equalsIgnoreCase("task")) {
            if (string2.equalsIgnoreCase("job")) {
                String string4 = this.accumulator.toString().trim();
                this.dataSource.getThread().getMetaData().put(string2, string4);
            } else if (string2.equalsIgnoreCase("host")) {
                String string5 = this.accumulator.toString().trim();
                this.dataSource.getThread().getMetaData().put(string2, string5);
            } else if (!string2.equalsIgnoreCase("perf") && !string2.equalsIgnoreCase("switch")) {
                if (string2.equalsIgnoreCase("cmdline")) {
                    String string6 = this.accumulator.toString().trim();
                    this.dataSource.getThread().getMetaData().put(string2, string6);
                } else if (string2.equalsIgnoreCase("pre")) {
                    String string7 = this.accumulator.toString().trim();
                    this.dataSource.getThread().getMetaData().put(this.currentElement + ":" + string2, string7);
                } else if (string2.equalsIgnoreCase("env")) {
                    String string8 = this.accumulator.toString().trim();
                    StringTokenizer stringTokenizer = new StringTokenizer(string8, "=");
                    if (stringTokenizer.countTokens() == 2) {
                        String string9 = stringTokenizer.nextToken();
                        string8 = stringTokenizer.nextToken();
                        this.dataSource.getThread().getMetaData().put("env:" + string9, string8);
                    }
                } else if (string2.equalsIgnoreCase("ru_s_ti") || string2.equalsIgnoreCase("ru_s_tf") || string2.equalsIgnoreCase("ru_c_ti") || string2.equalsIgnoreCase("ru_c_tf")) {
                    String string10 = this.accumulator.toString().trim();
                    this.dataSource.getThread().getMetaData().put(string2, string10);
                } else if (string2.equalsIgnoreCase("counter")) {
                    String string11 = this.accumulator.toString().trim();
                    this.region.measurements.put(this.currentElement, string11);
                } else if (string2.equalsIgnoreCase("func")) {
                    String string12 = this.accumulator.toString().trim();
                    RegionData regionData = new RegionData(this.currentElement);
                    regionData.numCalls = Integer.parseInt(this.functionCount);
                    regionData.measurements.put("wtime", string12);
                    this.region.functions.add(regionData);
                } else if (string2.equalsIgnoreCase("region")) {
                    this.createFunction(this.dataSource.getThread(), this.region, "");
                }
            }
        }
    }

    private void createFunction(Thread thread, RegionData regionData, String string) {
        this.function = this.dataSource.addFunction(string + regionData.name);
        if (string.length() > 0) {
            this.function.addGroup(this.dataSource.addGroup("TAU_CALLPATH"));
        } else {
            this.function.addGroup(this.dataSource.addGroup("TAU_DEFAULT"));
        }
        if (regionData.name.startsWith("MPI_")) {
            this.function.addGroup(this.dataSource.addGroup("MPI"));
        }
        Set<String> set = this.region.measurements.keySet();
        this.fp = new FunctionProfile(this.function, set.size());
        thread.addFunctionProfile(this.fp);
        this.fp.setNumCalls(regionData.numCalls);
        this.fp.setNumSubr(regionData.functions.size());
        for (String object : set) {
            Metric metric = this.dataSource.addMetric(object, thread);
            String string2 = regionData.measurements.get(object);
            if (string2 == null) continue;
            double d = Double.parseDouble(regionData.measurements.get(object));
            this.fp.setInclusive(metric.getID(), d);
            this.fp.setExclusive(metric.getID(), d);
        }
        for (RegionData regionData2 : regionData.functions) {
            this.createFunction(this.dataSource.getThread(), regionData2, "");
            this.createFunction(this.dataSource.getThread(), regionData2, regionData.name + " => ");
        }
    }

    private class RegionData {
        public String name;
        public TreeMap<String, String> measurements = new TreeMap();
        public int numCalls = 1;
        public List<RegionData> functions = new ArrayList<RegionData>();

        public RegionData(String string) {
            this.name = string;
        }
    }
}

