/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.perfdmf.Context;
import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.DataSourceException;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.NoOpEntityResolver;
import edu.uoregon.tau.perfdmf.Node;
import edu.uoregon.tau.perfdmf.PSRunLoadHandler;
import edu.uoregon.tau.perfdmf.Thread;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PSRunDataSource
extends DataSource {
    private Thread thread = null;
    private int nodeID = -1;
    private int contextID = -1;
    private int threadID = -1;
    private int threadCounter = 0;
    PSRunLoadHandler handler;
    private Hashtable<String, Integer> nodeHash = new Hashtable();
    private List<File[]> initializeObject;

    public PSRunDataSource(List<File[]> list) {
        this.setMetrics(new Vector<Metric>());
        this.initializeObject = list;
    }

    @Override
    public void cancelLoad() {
    }

    @Override
    public int getProgress() {
        return 0;
    }

    @Override
    public void load() throws DataSourceException {
        try {
            List<File[]> list = this.initializeObject;
            XMLReader xMLReader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            this.handler = new PSRunLoadHandler(this);
            xMLReader.setContentHandler(this.handler);
            xMLReader.setErrorHandler(this.handler);
            xMLReader.setEntityResolver(new NoOpEntityResolver());
            for (File[] fileArray : list) {
                for (int i = 0; i < fileArray.length; ++i) {
                    Object object;
                    Serializable serializable;
                    Object object2;
                    Object object3;
                    long l = System.currentTimeMillis();
                    StringTokenizer stringTokenizer = new StringTokenizer(fileArray[i].getName(), ".");
                    if (stringTokenizer.countTokens() == 2) {
                        ++this.nodeID;
                        ++this.threadCounter;
                        this.threadID = this.threadID;
                    } else if (stringTokenizer.countTokens() == 3) {
                        ++this.nodeID;
                    } else {
                        stringTokenizer.nextToken();
                        object3 = stringTokenizer.nextToken();
                        try {
                            this.threadID = Integer.parseInt((String)object3);
                            object2 = stringTokenizer.nextToken();
                            serializable = new Hashtable<Object, Integer>();
                            object = (Integer)((Hashtable)serializable).get(object2);
                            if (object == null) {
                                this.nodeID = ((Hashtable)serializable).size();
                                ((Hashtable)serializable).put(object2, new Integer(this.nodeID));
                            } else {
                                this.nodeID = (Integer)object;
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            ++this.threadCounter;
                            this.threadID = this.threadID;
                        }
                    }
                    this.thread = null;
                    object3 = fileArray[i];
                    if (((File)object3).toString().toLowerCase().startsWith("http:")) {
                        serializable = new URL("http://" + ((File)object3).toString().substring(6).replace('\\', '/'));
                        object2 = ((URL)serializable).openStream();
                    } else {
                        object2 = new FileInputStream((File)object3);
                    }
                    xMLReader.parse(new InputSource((InputStream)object2));
                    if (!this.handler.getIsProfile()) {
                        serializable = this.handler.getMetricHash();
                        object = ((Hashtable)serializable).keys();
                        while (object.hasMoreElements()) {
                            String string = (String)object.nextElement();
                            String string2 = (String)((Hashtable)serializable).get(string);
                            this.processHardwareCounter(string, string2);
                        }
                    }
                    l = System.currentTimeMillis() - l;
                }
            }
            this.processSnapshots();
            this.generateDerivedData();
            this.aggregateMetaData();
            this.buildXMLMetaData();
            this.setGroupNamesPresent(true);
        }
        catch (Exception exception) {
            if (exception instanceof DataSourceException) {
                throw (DataSourceException)exception;
            }
            throw new DataSourceException(exception);
        }
    }

    private void processSnapshots() {
        for (Thread thread : this.getThreads()) {
            for (int i = 1; i < thread.getNumSnapshots(); ++i) {
                Iterator<Function> iterator = this.getFunctions();
                while (iterator.hasNext()) {
                    Function function = iterator.next();
                    FunctionProfile functionProfile = thread.getFunctionProfile(function);
                    if (functionProfile == null) continue;
                    double d = functionProfile.getExclusive(i - 1, 0);
                    double d2 = functionProfile.getInclusive(i - 1, 0);
                    double d3 = functionProfile.getExclusive(i, 0);
                    double d4 = functionProfile.getInclusive(i, 0);
                    functionProfile.setExclusive(i, 0, d + d3);
                    functionProfile.setInclusive(i, 0, d2 + d4);
                }
            }
        }
    }

    private void initializeThread() {
        this.nodeID = this.nodeID == -1 ? 0 : this.nodeID;
        this.contextID = this.contextID == -1 ? 0 : this.contextID;
        this.threadID = this.threadID == -1 ? 0 : this.threadID;
        Node node = this.addNode(this.nodeID);
        Context context = node.addContext(this.contextID);
        this.thread = context.addThread(this.threadID);
    }

    public void incrementThread(String string, String string2) {
        this.threadID = Integer.parseInt(string);
        Integer n = this.nodeHash.get(string2);
        if (n == null) {
            this.nodeID = this.nodeHash.size();
            this.nodeHash.put(string2, new Integer(this.nodeID));
        } else {
            this.nodeID = n;
        }
        this.thread = null;
    }

    public Thread getThread() {
        if (this.thread == null) {
            Map<String, String> map = this.handler.getAttributes();
            String string = map.get("nct");
            if (string != null) {
                String[] stringArray = string.split(":");
                this.nodeID = Integer.parseInt(stringArray[0]);
                this.contextID = Integer.parseInt(stringArray[1]);
                this.threadID = Integer.parseInt(stringArray[2]);
            }
            this.initializeThread();
        }
        return this.thread;
    }

    private void processHardwareCounter(String string, String string2) {
        Thread thread = this.getThread();
        double d = Double.parseDouble(string2);
        Metric metric = this.addMetric(string);
        int n = metric.getID();
        Function function = this.addFunction("Entire application");
        FunctionProfile functionProfile = thread.getFunctionProfile(function);
        if (functionProfile == null) {
            functionProfile = new FunctionProfile(function, this.getNumberOfMetrics());
        }
        thread.addFunctionProfile(functionProfile);
        functionProfile.setExclusive(n, d);
        functionProfile.setInclusive(n, d);
        functionProfile.setNumCalls(1.0);
        functionProfile.setNumSubr(0.0);
    }
}

