/*
 * Decompiled with CFR 0.152.
 */
package org.xeustechnologies.jtar;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.xeustechnologies.jtar.TarEntry;

public class TarInputStream
extends FilterInputStream {
    private static final int SKIP_BUFFER_SIZE = 2048;
    private TarEntry currentEntry;
    private long currentFileSize = 0L;
    private long bytesRead = 0L;

    public TarInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public boolean markSupported() {
        return false;
    }

    public synchronized void mark(int n) {
    }

    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    public int read() throws IOException {
        byte[] byArray = new byte[1];
        int n = this.read(byArray, 0, 1);
        if (n != -1) {
            return byArray[0];
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (this.currentEntry != null) {
            if (this.currentFileSize == this.currentEntry.getSize()) {
                return -1;
            }
            if (this.currentEntry.getSize() - this.currentFileSize < (long)n2) {
                n2 = (int)(this.currentEntry.getSize() - this.currentFileSize);
            }
        }
        if ((n3 = super.read(byArray, n, n2)) != -1) {
            if (this.currentEntry != null) {
                this.currentFileSize += (long)n3;
            }
            this.bytesRead += (long)n3;
        }
        return n3;
    }

    public TarEntry getNextEntry() throws IOException {
        int n;
        this.closeCurrentEntry();
        byte[] byArray = new byte[512];
        byte[] byArray2 = new byte[512];
        for (int i = 0; i < 512 && (n = this.read(byArray2, 0, 512 - i)) >= 0; i += n) {
            System.arraycopy(byArray2, 0, byArray, i, n);
        }
        n = 1;
        for (byte by : byArray) {
            if (by == 0) continue;
            n = 0;
            break;
        }
        if (n == 0) {
            this.bytesRead += (long)byArray.length;
            this.currentEntry = new TarEntry(byArray);
        }
        return this.currentEntry;
    }

    protected void closeCurrentEntry() throws IOException {
        if (this.currentEntry != null) {
            if (this.currentEntry.getSize() > this.currentFileSize) {
                long l;
                for (long i = 0L; i < this.currentEntry.getSize() - this.currentFileSize; i += l) {
                    l = this.skip(this.currentEntry.getSize() - this.currentFileSize - i);
                }
            }
            this.currentEntry = null;
            this.currentFileSize = 0L;
            this.skipPad();
        }
    }

    protected void skipPad() throws IOException {
        int n;
        if (this.bytesRead > 0L && (n = (int)(this.bytesRead % 512L)) > 0) {
            long l;
            for (long i = 0L; i < (long)(512 - n); i += l) {
                l = this.skip((long)(512 - n) - i);
            }
        }
    }

    public long skip(long l) throws IOException {
        long l2;
        int n;
        if (l <= 0L) {
            return 0L;
        }
        byte[] byArray = new byte[2048];
        for (l2 = l; l2 > 0L && (n = this.read(byArray, 0, (int)(l2 < 2048L ? l2 : 2048L))) >= 0; l2 -= (long)n) {
        }
        return l - l2;
    }
}

