/*
 * Decompiled with CFR 0.152.
 */
package scalasca.cubex.cube;

import java.util.ArrayList;
import scalasca.cubex.cube.Cnode;
import scalasca.cubex.cube.CubeCalculationFlavour;
import scalasca.cubex.cube.NamedVertex;
import scalasca.cubex.cube.Thread;
import scalasca.cubex.cube.datalayout.Matrix;
import scalasca.cubex.cube.datalayout.data.DataChooser;
import scalasca.cubex.cube.datalayout.data.DataRows;
import scalasca.cubex.cube.datalayout.data.value.Value;
import scalasca.cubex.cube.datalayout.data.value.ValueType;
import scalasca.cubex.cube.datalayout.index.Index;
import scalasca.cubex.cube.datalayout.index.IndexHeader;
import scalasca.cubex.cube.errors.BadCubeReportLayoutException;
import scalasca.cubex.cube.errors.NotEnumeratedCnodeException;
import scalasca.cubex.cube.errors.UnknownValueTypeException;
import scalasca.cubex.cube.services.CnodesEnumeration;
import scalasca.cubex.cube.services.ProgressReportContext;
import scalasca.cubex.cube.services.ProgressReportInterface;
import scalasca.cubex.cube.services.transformation.Endianess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Metric
extends NamedVertex
implements ProgressReportInterface {
    private ProgressReportContext progressContext = new ProgressReportContext();
    protected String display_name;
    protected String uom;
    protected String dtype;
    protected String url;
    protected String description;
    protected Value metric_value;
    protected Matrix matrix;
    private double progress;
    private String progress_message;
    protected CnodesEnumeration enumeration;

    public Metric(int n, Metric metric) {
        super(n, "", metric);
    }

    public void init(String string, String string2, String string3, String string4, String string5, String string6) throws UnknownValueTypeException {
        this.setName(string);
        this.display_name = string2;
        this.uom = string4;
        this.dtype = string3;
        this.url = string5;
        this.description = string6;
        this.metric_value = Value.getValue(ValueType.getValueType(this.dtype));
    }

    @Override
    public double getProgress() {
        return this.progressContext.getProgress();
    }

    @Override
    public String getProgressMessage() {
        return this.progressContext.getProgressMessage();
    }

    @Override
    public void setActiveProgressReportContext(ProgressReportContext progressReportContext) {
        this.progressContext = progressReportContext;
    }

    public String getUniqName() {
        return this.getName();
    }

    public String getDisplayName() {
        return this.display_name;
    }

    public String getDType() {
        return this.dtype;
    }

    public String getUOM() {
        return this.uom;
    }

    public String getUrl() {
        return this.url;
    }

    public String getDescription() {
        return this.description;
    }

    public void createDataMatrix(int n, int n2) {
        this.progressContext.setNextStep(1.0);
        this.progressContext.setProgressMessage("Create empty sdata matric...");
        this.matrix = new Matrix(this.metric_value, n, n2);
        this.progressContext.setAchievedStep();
    }

    public void createDataMatrix(byte[] byArray, byte[] byArray2, int n, int n2) throws BadCubeReportLayoutException, Exception {
        this.progressContext.setNextStep(0.03);
        this.progressContext.setProgressMessage("Read index header for Metric \"" + this.display_name + "\"...");
        IndexHeader indexHeader = new IndexHeader(byArray);
        this.progressContext.setAchievedStep();
        this.progressContext.setNextStep(0.03);
        this.progressContext.setProgressMessage("Create index for Metric \"" + this.display_name + "\"...");
        Index index = indexHeader.getIndex(n, n2);
        Endianess endianess = indexHeader.getEndianess();
        this.progressContext.setAchievedStep();
        this.progressContext.setNextStep(0.24);
        this.progressContext.setProgressMessage("Load data rows for Metric \"" + this.display_name + "\"...");
        DataRows dataRows = DataChooser.getDataRows(byArray2, this.metric_value, endianess);
        this.progressContext.setAchievedStep();
        this.progressContext.setNextStep(0.7);
        this.progressContext.setProgressMessage("Create data container for Metric \"" + this.display_name + "\"...");
        this.matrix = new Matrix(dataRows, index, n, n2);
        indexHeader = null;
        index = null;
        dataRows.removeRowsFromMemory();
        dataRows = null;
        this.progressContext.setAchievedStep();
    }

    public void set_sev(Cnode cnode, Thread thread, String string) throws NotEnumeratedCnodeException {
        int n = this.enumeration.getCID(cnode);
        if (this.matrix != null) {
            this.matrix.setValue(n, thread.getId(), string);
        }
    }

    public Value get_sev(Cnode cnode, CubeCalculationFlavour cubeCalculationFlavour, Thread thread) throws NotEnumeratedCnodeException {
        int n = this.enumeration.getCID(cnode);
        Value value = this.matrix != null ? this.matrix.getValue(n, thread.getId()) : this.metric_value;
        return value;
    }

    public void createEnumeration(ArrayList<Cnode> arrayList) {
        this.enumeration = new CnodesEnumeration(arrayList);
    }
}

