/*
 * Decompiled with CFR 0.152.
 */
package scalasca.cubex.cube.cubeparser;

import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.Stack;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import scalasca.cubex.cube.Cartesian;
import scalasca.cubex.cube.Cnode;
import scalasca.cubex.cube.Cube;
import scalasca.cubex.cube.Machine;
import scalasca.cubex.cube.Metric;
import scalasca.cubex.cube.MetricType;
import scalasca.cubex.cube.Node;
import scalasca.cubex.cube.Process;
import scalasca.cubex.cube.Thread;
import scalasca.cubex.cube.cubeparser.CartesianContext;
import scalasca.cubex.cube.cubeparser.CnodeContext;
import scalasca.cubex.cube.cubeparser.CubeContext;
import scalasca.cubex.cube.cubeparser.CubeRawTag;
import scalasca.cubex.cube.cubeparser.CubeTag;
import scalasca.cubex.cube.cubeparser.MachineContext;
import scalasca.cubex.cube.cubeparser.MetricContext;
import scalasca.cubex.cube.cubeparser.NodeContext;
import scalasca.cubex.cube.cubeparser.ProcessContext;
import scalasca.cubex.cube.cubeparser.RegionContext;
import scalasca.cubex.cube.cubeparser.ThreadContext;
import scalasca.cubex.cube.errors.NotEnumeratedCnodeException;
import scalasca.cubex.cube.errors.UnknownMetricTypeException;
import scalasca.cubex.cube.errors.UnknownValueTypeException;
import scalasca.cubex.cube.services.ProgressReportContext;
import scalasca.cubex.cube.services.ProgressReportInterface;

public class CubeParser
extends DefaultHandler
implements ProgressReportInterface {
    private ProgressReportContext progressContext = new ProgressReportContext();
    private Cube cube;
    private CubeContext actualCubeContext = CubeContext.UNKNOWN;
    private StringBuffer tagContent = new StringBuffer();
    private Metric actualMetric = null;
    private Metric parentMetric = null;
    private MetricContext metricContext = new MetricContext();
    private Stack<MetricContext> metricContextes = new Stack();
    private RegionContext regionContext = null;
    private Cnode actualCnode = null;
    private CnodeContext cnodeContext = new CnodeContext();
    private Stack<CnodeContext> cnodeContextes = new Stack();
    private Machine actualMachine = null;
    private MachineContext machineContext = null;
    private Node actualNode = null;
    private NodeContext nodeContext = null;
    private Process actualProcess = null;
    private ProcessContext processContext = null;
    private Thread actualThread = null;
    private ThreadContext threadContext = null;
    private CartesianContext cartesianContext = null;

    public CubeParser(Cube cube) {
        this.cube = cube;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4 = "";
        String string5 = "";
        switch (this.getTag(string2, this.actualCubeContext)) {
            case CUBE: {
                this.progressContext.setAchievedStep();
                this.progressContext.setNextStep(0.1);
                this.progressContext.setProgressMessage("Read metadata about cube report...");
                this.cube.set_version(attributes.getValue("", "version"));
                this.actualCubeContext = CubeContext.CUBE;
                break;
            }
            case ATTR: {
                this.cube.def_attr(attributes.getValue("", "key"), attributes.getValue("", "value"));
                break;
            }
            case MURL: {
                this.cube.def_mirror(this.tagContent.toString());
                this.tagContent.setLength(0);
                break;
            }
            case METRICS: {
                this.progressContext.setAchievedStep();
                this.progressContext.setNextStep(0.2);
                this.progressContext.setProgressMessage("Read metadata about metrics...");
                string5 = attributes.getValue("", "title");
                if (string5 == null) break;
                this.cube.set_metricstree_title(string5);
                break;
            }
            case METRIC: {
                try {
                    this.actualCubeContext = CubeContext.METRIC;
                    if (this.metricContext != null) {
                        this.metricContextes.push(this.metricContext);
                    }
                    this.parentMetric = this.actualMetric;
                    this.metricContext = new MetricContext();
                    this.metricContext.id = Integer.parseInt(attributes.getValue("", "id"));
                    this.metricContext.metricType = MetricType.getMetricType(attributes.getValue("", "type"));
                    this.metricContext.parent = this.parentMetric;
                    this.metricContext.metric = this.actualMetric = this.cube.def_met(this.metricContext.id, this.metricContext.metricType, this.metricContext.parent);
                }
                catch (UnknownMetricTypeException unknownMetricTypeException) {
                    System.out.println("Ignore metric becuase of error:" + unknownMetricTypeException.toString());
                }
                break;
            }
            case PROGRAM: {
                this.progressContext.setAchievedStep();
                this.progressContext.setNextStep(0.2);
                this.progressContext.setProgressMessage("Read metadata about program...");
                string5 = attributes.getValue("", "title");
                if (string5 == null) break;
                this.cube.set_calltree_title(string5);
                break;
            }
            case REGION: {
                this.actualCubeContext = CubeContext.REGION;
                this.regionContext = new RegionContext();
                this.regionContext.id = Integer.parseInt(attributes.getValue("", "id"));
                this.regionContext.mod = attributes.getValue("", "mod");
                this.regionContext.beginln = Integer.parseInt(attributes.getValue("", "begin"));
                this.regionContext.endln = Integer.parseInt(attributes.getValue("", "end"));
                break;
            }
            case CNODE: {
                this.actualCubeContext = CubeContext.CNODE;
                if (this.cnodeContext != null) {
                    this.cnodeContextes.push(this.cnodeContext);
                }
                Cnode cnode = this.actualCnode;
                this.cnodeContext = new CnodeContext();
                this.cnodeContext.id = Integer.parseInt(attributes.getValue("", "id"));
                this.cnodeContext.region_id = Integer.parseInt(attributes.getValue("", "calleeId"));
                this.cnodeContext.parent = cnode;
                this.cnodeContext.cnode = this.actualCnode = this.cube.def_cnode(this.cnodeContext.id, this.cnodeContext.region_id, this.cnodeContext.parent);
                break;
            }
            case CNODE_PARAMETER: {
                if (this.actualCubeContext != CubeContext.CNODE) {
                    throw new SAXException("Found cnode parameter outside of <cnode ...> </cnode>.");
                }
                String string6 = attributes.getValue("", "partype");
                String string7 = attributes.getValue("", "parkey");
                String string8 = attributes.getValue("", "parvalue");
                if (string6.equalsIgnoreCase("numeric")) {
                    try {
                        this.cnodeContext.num_parameters.put(string7, new Long(string8));
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new SAXException("Cannot read numerical parameter \"" + string7 + " of cnode id=" + this.cnodeContext.id);
                    }
                }
                if (!string6.equalsIgnoreCase("string")) break;
                this.cnodeContext.str_parameters.put(string7, string8);
                break;
            }
            case SYSTEM: {
                this.progressContext.setAchievedStep();
                this.progressContext.setNextStep(0.2);
                this.progressContext.setProgressMessage("Read metadata about system...");
                string5 = attributes.getValue("", "title");
                if (string5 == null) break;
                this.cube.set_systemtree_title(string5);
                break;
            }
            case MACHINE: {
                this.actualCubeContext = CubeContext.MACHINE;
                this.machineContext = new MachineContext();
                string4 = attributes.getValue("", "id");
                if (string4 == null) {
                    string4 = attributes.getValue("", "Id");
                }
                this.machineContext.id = Integer.parseInt(string4);
                this.actualMachine = this.cube.def_machine(this.machineContext.id);
                break;
            }
            case NODE: {
                this.actualCubeContext = CubeContext.NODE;
                this.nodeContext = new NodeContext();
                string4 = attributes.getValue("", "id");
                if (string4 == null) {
                    string4 = attributes.getValue("", "Id");
                }
                this.nodeContext.id = Integer.parseInt(string4);
                this.actualNode = this.cube.def_node(this.nodeContext.id, this.actualMachine);
                break;
            }
            case PROCESS: {
                this.actualCubeContext = CubeContext.PROCESS;
                this.processContext = new ProcessContext();
                string4 = attributes.getValue("", "id");
                if (string4 == null) {
                    string4 = attributes.getValue("", "Id");
                }
                this.processContext.id = Integer.parseInt(string4);
                this.actualProcess = this.cube.def_proc(this.processContext.id, this.actualNode);
                break;
            }
            case THREAD: {
                this.actualCubeContext = CubeContext.THREAD;
                this.threadContext = new ThreadContext();
                string4 = attributes.getValue("", "id");
                if (string4 == null) {
                    string4 = attributes.getValue("", "Id");
                }
                this.threadContext.id = Integer.parseInt(string4);
                this.actualThread = this.cube.def_thrd(this.threadContext.id, this.actualProcess);
                break;
            }
            case TOPOLOGIES: {
                this.actualCubeContext = CubeContext.TOPOLOGIES;
                break;
            }
            case CART: {
                if (this.actualCubeContext != CubeContext.TOPOLOGIES) {
                    throw new SAXException("Found <cart ...> outside of <topologies> ..</topologies>");
                }
                this.actualCubeContext = CubeContext.CARTESIAN;
                this.cartesianContext = new CartesianContext();
                this.cartesianContext.ndims = Integer.parseInt(attributes.getValue("", "ndims"));
                this.cartesianContext.name = attributes.getValue("", "name");
                break;
            }
            case DIM: {
                if (this.actualCubeContext != CubeContext.CARTESIAN) {
                    throw new SAXException("Found <dim ...> outside of <cart> ..</cart>");
                }
                this.cartesianContext.dim_sizes.add(new Integer(attributes.getValue("", "size")));
                this.cartesianContext.dim_periodicity.add(new Boolean(attributes.getValue("", "periodic")));
                break;
            }
            case COORD: {
                if (this.actualCubeContext != CubeContext.CARTESIAN) {
                    throw new SAXException("Found <coord ...> outside of <cart> ..</cart>");
                }
                this.actualCubeContext = CubeContext.COORDINATES;
                this.cartesianContext.actualThreadId = Integer.parseInt(attributes.getValue("", "thrdId"));
                this.tagContent.setLength(0);
                break;
            }
            case SEVERITY: {
                this.progressContext.setAchievedStep();
                this.progressContext.setNextStep(0.4);
                this.progressContext.setProgressMessage("Read severity data ...");
                if (this.actualCubeContext != CubeContext.CUBE) {
                    throw new SAXException("Found <severity ...> before </system>");
                }
                this.actualCubeContext = CubeContext.SEVERITY;
                this.cube.prepareForCube3();
                break;
            }
            case MATRIX: {
                if (this.actualCubeContext != CubeContext.SEVERITY) {
                    throw new SAXException("Found <matrix ...> outside of  <severity>...</severity>");
                }
                this.actualCubeContext = CubeContext.MATRIX;
                this.actualMetric = this.cube.get_metv().get(new Integer(attributes.getValue("", "metricId")));
                break;
            }
            case ROW: {
                if (this.actualCubeContext != CubeContext.MATRIX) {
                    throw new SAXException("Found <row ...> outside of  <matrix>...</matrix>");
                }
                this.actualCubeContext = CubeContext.ROW;
                this.actualCnode = this.cube.get_cnodev().get(new Integer(attributes.getValue("", "cnodeId")));
                break;
            }
            default: {
                this.tagContent.setLength(0);
            }
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        switch (this.getTag(string2, this.actualCubeContext)) {
            case CUBE: {
                break;
            }
            case METRIC: {
                try {
                    this.actualMetric.init(this.metricContext.uniq_name, this.metricContext.disp_name, this.metricContext.dtype, this.metricContext.uom, this.metricContext.url, this.metricContext.descr);
                    this.metricContext = this.metricContextes.pop();
                    this.actualMetric = this.metricContext.metric;
                    this.parentMetric = this.metricContext.parent;
                }
                catch (EmptyStackException emptyStackException) {
                }
                catch (UnknownValueTypeException unknownValueTypeException) {
                    System.out.println("Do not initialize metric becuase of error:" + unknownValueTypeException.toString());
                }
                break;
            }
            case UNIQ_NAME: {
                this.metricContext.uniq_name = this.tagContent.toString();
                this.tagContent.setLength(0);
                break;
            }
            case DISP_NAME: {
                this.metricContext.disp_name = this.tagContent.toString();
                this.tagContent.setLength(0);
                break;
            }
            case DTYPE: {
                this.metricContext.dtype = this.tagContent.toString();
                this.tagContent.setLength(0);
                break;
            }
            case UOM: {
                this.metricContext.uom = this.tagContent.toString();
                this.tagContent.setLength(0);
                break;
            }
            case METURL: {
                this.metricContext.url = this.tagContent.toString();
                this.tagContent.setLength(0);
                break;
            }
            case METDESCR: {
                this.metricContext.descr = this.tagContent.toString();
                this.tagContent.setLength(0);
                break;
            }
            case REGION: {
                this.cube.def_region(this.regionContext.id, this.regionContext.name, this.regionContext.beginln, this.regionContext.endln, this.regionContext.url, this.regionContext.descr, this.regionContext.mod);
                break;
            }
            case RURL: {
                this.regionContext.url = this.tagContent.toString();
                this.tagContent.setLength(0);
                break;
            }
            case RNAME: {
                this.regionContext.name = this.tagContent.toString();
                this.tagContent.setLength(0);
                break;
            }
            case RDESCR: {
                this.regionContext.descr = this.tagContent.toString();
                this.tagContent.setLength(0);
                break;
            }
            case CNODE: {
                this.actualCnode.add_str_parameters(this.cnodeContext.str_parameters);
                this.actualCnode.add_num_parameters(this.cnodeContext.num_parameters);
                try {
                    this.cnodeContext = this.cnodeContextes.pop();
                    this.actualCnode = this.cnodeContext.cnode;
                }
                catch (EmptyStackException emptyStackException) {}
                break;
            }
            case MACHINE: {
                this.actualMachine.init(this.machineContext.name, this.machineContext.description);
                break;
            }
            case MACHNAME: {
                this.machineContext.name = this.tagContent.toString();
                this.tagContent.setLength(0);
                break;
            }
            case MACHDESCR: {
                this.machineContext.description = this.tagContent.toString();
                this.tagContent.setLength(0);
                break;
            }
            case NODE: {
                this.actualNode.init(this.nodeContext.name, this.nodeContext.description);
                this.actualCubeContext = CubeContext.MACHINE;
                break;
            }
            case NNAME: {
                this.nodeContext.name = this.tagContent.toString();
                this.tagContent.setLength(0);
                break;
            }
            case NDESCR: {
                this.nodeContext.description = this.tagContent.toString();
                this.tagContent.setLength(0);
                break;
            }
            case PROCESS: {
                this.actualProcess.init(this.processContext.rank, this.processContext.name);
                this.actualCubeContext = CubeContext.NODE;
                break;
            }
            case PNAME: {
                this.processContext.name = this.tagContent.toString();
                this.tagContent.setLength(0);
                break;
            }
            case PRANK: {
                this.processContext.rank = Long.parseLong(this.tagContent.toString());
                this.tagContent.setLength(0);
                break;
            }
            case THREAD: {
                this.actualThread.init(this.threadContext.rank, this.threadContext.name);
                this.actualCubeContext = CubeContext.PROCESS;
                break;
            }
            case TNAME: {
                this.threadContext.name = this.tagContent.toString();
                this.tagContent.setLength(0);
                break;
            }
            case TRANK: {
                this.threadContext.rank = Long.parseLong(this.tagContent.toString());
                this.tagContent.setLength(0);
                break;
            }
            case CART: {
                if (this.actualCubeContext != CubeContext.CARTESIAN) {
                    throw new SAXException("Found </cart> outside without corresponding <cart ...>");
                }
                Cartesian cartesian = this.cube.def_cart(this.cartesianContext.ndims, this.cartesianContext.dim_sizes, this.cartesianContext.dim_periodicity);
                ArrayList<ArrayList<Integer>> arrayList = this.cartesianContext.coordinates;
                ArrayList<Thread> arrayList2 = this.cube.get_thrdv();
                for (Thread thread : arrayList2) {
                    if (thread.getId() >= arrayList.size()) continue;
                    cartesian.def_coords(thread, arrayList.get(thread.getId()));
                }
                if (this.cartesianContext.name != null) {
                    cartesian.set_name(this.cartesianContext.name);
                }
                this.actualCubeContext = CubeContext.TOPOLOGIES;
                break;
            }
            case COORD: {
                if (this.actualCubeContext != CubeContext.COORDINATES) {
                    throw new SAXException("Found <coord ...> </coord> outside of <cart ...> </cart>");
                }
                String string4 = this.tagContent.toString();
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                StringTokenizer stringTokenizer = new StringTokenizer(string4, " \t");
                boolean bl = false;
                while (stringTokenizer.hasMoreTokens()) {
                    try {
                        arrayList.add(new Integer(stringTokenizer.nextToken()));
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new SAXException("Cannot read thread coordinate coordinate: " + numberFormatException.getMessage());
                    }
                }
                if (arrayList.size() != this.cartesianContext.ndims) {
                    throw new SAXException("Number of coordinates for thread id= " + this.cartesianContext.actualThreadId + " ( " + arrayList.size() + ") is different than number of dimensions in that topology (" + this.cartesianContext.ndims + ")");
                }
                if (this.cartesianContext.coordinates.size() <= this.cartesianContext.actualThreadId) {
                    this.cartesianContext.coordinates.ensureCapacity(this.cartesianContext.actualThreadId + 1);
                    for (int i = this.cartesianContext.coordinates.size(); i < this.cartesianContext.actualThreadId + 1; ++i) {
                        this.cartesianContext.coordinates.add(null);
                    }
                }
                this.cartesianContext.coordinates.set(this.cartesianContext.actualThreadId, arrayList);
                this.tagContent.setLength(0);
                this.actualCubeContext = CubeContext.CARTESIAN;
                break;
            }
            case SYSTEM: {
                this.actualCubeContext = CubeContext.CUBE;
                break;
            }
            case MATRIX: {
                this.actualCubeContext = CubeContext.SEVERITY;
                break;
            }
            case ROW: {
                StringTokenizer stringTokenizer = new StringTokenizer(this.tagContent.toString(), "\n");
                int n = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    String string5 = stringTokenizer.nextToken().trim();
                    if (string5.equalsIgnoreCase("")) continue;
                    Thread thread = this.cube.get_thrdv().get(n);
                    try {
                        this.cube.set_sev(this.actualMetric, this.actualCnode, thread, string5);
                    }
                    catch (NotEnumeratedCnodeException notEnumeratedCnodeException) {
                        throw new SAXException("Internal cube error: " + notEnumeratedCnodeException.getMessage());
                    }
                    ++n;
                }
                this.tagContent.setLength(0);
                this.actualCubeContext = CubeContext.MATRIX;
                break;
            }
        }
    }

    public void endDocument() throws SAXException {
        this.tagContent.setLength(0);
    }

    public void startDocument() throws SAXException {
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.tagContent.append(cArray, n, n2);
    }

    public CubeRawTag getRawTag(String string) {
        if (string.equalsIgnoreCase("cube")) {
            return CubeRawTag.CUBE;
        }
        if (string.equalsIgnoreCase("attr")) {
            return CubeRawTag.ATTR;
        }
        if (string.equalsIgnoreCase("doc")) {
            return CubeRawTag.DOC;
        }
        if (string.equalsIgnoreCase("mirrors")) {
            return CubeRawTag.MIRRORS;
        }
        if (string.equalsIgnoreCase("murl")) {
            return CubeRawTag.MURL;
        }
        if (string.equalsIgnoreCase("metrics")) {
            return CubeRawTag.METRICS;
        }
        if (string.equalsIgnoreCase("metric")) {
            return CubeRawTag.METRIC;
        }
        if (string.equalsIgnoreCase("uniq_name")) {
            return CubeRawTag.UNIQ_NAME;
        }
        if (string.equalsIgnoreCase("disp_name")) {
            return CubeRawTag.DISP_NAME;
        }
        if (string.equalsIgnoreCase("dtype")) {
            return CubeRawTag.DTYPE;
        }
        if (string.equalsIgnoreCase("uom")) {
            return CubeRawTag.UOM;
        }
        if (string.equalsIgnoreCase("url")) {
            return CubeRawTag.URL;
        }
        if (string.equalsIgnoreCase("descr")) {
            return CubeRawTag.DESCR;
        }
        if (string.equalsIgnoreCase("program")) {
            return CubeRawTag.PROGRAM;
        }
        if (string.equalsIgnoreCase("region")) {
            return CubeRawTag.REGION;
        }
        if (string.equalsIgnoreCase("name")) {
            return CubeRawTag.NAME;
        }
        if (string.equalsIgnoreCase("cnode")) {
            return CubeRawTag.CNODE;
        }
        if (string.equalsIgnoreCase("parameter")) {
            return CubeRawTag.CNODE_PARAMETER;
        }
        if (string.equalsIgnoreCase("system")) {
            return CubeRawTag.SYSTEM;
        }
        if (string.equalsIgnoreCase("machine")) {
            return CubeRawTag.MACHINE;
        }
        if (string.equalsIgnoreCase("node")) {
            return CubeRawTag.NODE;
        }
        if (string.equalsIgnoreCase("process")) {
            return CubeRawTag.PROCESS;
        }
        if (string.equalsIgnoreCase("thread")) {
            return CubeRawTag.THREAD;
        }
        if (string.equalsIgnoreCase("rank")) {
            return CubeRawTag.RANK;
        }
        if (string.equalsIgnoreCase("topologies")) {
            return CubeRawTag.TOPOLOGIES;
        }
        if (string.equalsIgnoreCase("cart")) {
            return CubeRawTag.CART;
        }
        if (string.equalsIgnoreCase("dim")) {
            return CubeRawTag.DIM;
        }
        if (string.equalsIgnoreCase("coord")) {
            return CubeRawTag.COORD;
        }
        if (string.equalsIgnoreCase("severity")) {
            return CubeRawTag.SEVERITY;
        }
        if (string.equalsIgnoreCase("matrix")) {
            return CubeRawTag.MATRIX;
        }
        if (string.equalsIgnoreCase("row")) {
            return CubeRawTag.ROW;
        }
        return CubeRawTag.UNKNOWN;
    }

    public CubeTag getTag(String string, CubeContext cubeContext) {
        CubeRawTag cubeRawTag = this.getRawTag(string);
        switch (cubeContext) {
            case METRIC: {
                return this.getTagInMetricContext(cubeRawTag);
            }
            case REGION: {
                return this.getTagInRegionContext(cubeRawTag);
            }
            case MACHINE: {
                return this.getTagInMachineContext(cubeRawTag);
            }
            case NODE: {
                return this.getTagInNodeContext(cubeRawTag);
            }
            case PROCESS: {
                return this.getTagInProcessContext(cubeRawTag);
            }
            case THREAD: {
                return this.getTagInThreadContext(cubeRawTag);
            }
        }
        return this.getEqualTag(cubeRawTag);
    }

    public CubeTag getTagInMetricContext(CubeRawTag cubeRawTag) {
        switch (cubeRawTag) {
            case URL: {
                return CubeTag.METURL;
            }
            case DESCR: {
                return CubeTag.METDESCR;
            }
        }
        return this.getEqualTag(cubeRawTag);
    }

    public CubeTag getTagInRegionContext(CubeRawTag cubeRawTag) {
        switch (cubeRawTag) {
            case NAME: {
                return CubeTag.RNAME;
            }
            case URL: {
                return CubeTag.RURL;
            }
            case DESCR: {
                return CubeTag.RDESCR;
            }
        }
        return this.getEqualTag(cubeRawTag);
    }

    public CubeTag getTagInMachineContext(CubeRawTag cubeRawTag) {
        switch (cubeRawTag) {
            case NAME: {
                return CubeTag.MACHNAME;
            }
            case DESCR: {
                return CubeTag.MACHDESCR;
            }
        }
        return this.getEqualTag(cubeRawTag);
    }

    public CubeTag getTagInNodeContext(CubeRawTag cubeRawTag) {
        switch (cubeRawTag) {
            case NAME: {
                return CubeTag.NNAME;
            }
            case DESCR: {
                return CubeTag.NDESCR;
            }
        }
        return this.getEqualTag(cubeRawTag);
    }

    public CubeTag getTagInProcessContext(CubeRawTag cubeRawTag) {
        switch (cubeRawTag) {
            case NAME: {
                return CubeTag.PNAME;
            }
            case RANK: {
                return CubeTag.PRANK;
            }
        }
        return this.getEqualTag(cubeRawTag);
    }

    public CubeTag getTagInThreadContext(CubeRawTag cubeRawTag) {
        switch (cubeRawTag) {
            case NAME: {
                return CubeTag.TNAME;
            }
            case RANK: {
                return CubeTag.TRANK;
            }
        }
        return this.getEqualTag(cubeRawTag);
    }

    public CubeTag getEqualTag(CubeRawTag cubeRawTag) {
        switch (cubeRawTag) {
            case CUBE: {
                return CubeTag.CUBE;
            }
            case ATTR: {
                return CubeTag.ATTR;
            }
            case DOC: {
                return CubeTag.DOC;
            }
            case MIRRORS: {
                return CubeTag.MIRRORS;
            }
            case MURL: {
                return CubeTag.MURL;
            }
            case METRICS: {
                return CubeTag.METRICS;
            }
            case METRIC: {
                return CubeTag.METRIC;
            }
            case UNIQ_NAME: {
                return CubeTag.UNIQ_NAME;
            }
            case DISP_NAME: {
                return CubeTag.DISP_NAME;
            }
            case DTYPE: {
                return CubeTag.DTYPE;
            }
            case UOM: {
                return CubeTag.UOM;
            }
            case PROGRAM: {
                return CubeTag.PROGRAM;
            }
            case REGION: {
                return CubeTag.REGION;
            }
            case CNODE: {
                return CubeTag.CNODE;
            }
            case CNODE_PARAMETER: {
                return CubeTag.CNODE_PARAMETER;
            }
            case SYSTEM: {
                return CubeTag.SYSTEM;
            }
            case MACHINE: {
                return CubeTag.MACHINE;
            }
            case NODE: {
                return CubeTag.NODE;
            }
            case PROCESS: {
                return CubeTag.PROCESS;
            }
            case THREAD: {
                return CubeTag.THREAD;
            }
            case TOPOLOGIES: {
                return CubeTag.TOPOLOGIES;
            }
            case CART: {
                return CubeTag.CART;
            }
            case DIM: {
                return CubeTag.DIM;
            }
            case COORD: {
                return CubeTag.COORD;
            }
            case SEVERITY: {
                return CubeTag.SEVERITY;
            }
            case MATRIX: {
                return CubeTag.MATRIX;
            }
            case ROW: {
                return CubeTag.ROW;
            }
        }
        return CubeTag.UNKNOWN;
    }

    public double getProgress() {
        return this.progressContext.getProgress();
    }

    public String getProgressMessage() {
        return this.progressContext.getProgressMessage();
    }

    public void setActiveProgressReportContext(ProgressReportContext progressReportContext) {
        this.progressContext = progressReportContext;
    }
}

