/*
 * Decompiled with CFR 0.152.
 */
package scalasca.cubex.cube.datalayout.data;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.zip.InflaterInputStream;
import scalasca.cubex.cube.datalayout.data.DataRows;
import scalasca.cubex.cube.datalayout.data.value.Value;
import scalasca.cubex.cube.datalayout.data.zHeader;
import scalasca.cubex.cube.datalayout.data.zTriplet;
import scalasca.cubex.cube.errors.BadDataException;
import scalasca.cubex.cube.services.transformation.Endianess;

public class CompressedDataRows
extends DataRows {
    public CompressedDataRows(byte[] byArray, Value value, Endianess endianess) throws BadDataException {
        super(byArray, value, endianess);
    }

    public void print() {
        System.out.println("======== Compressed rows of data ============");
    }

    protected void loadData(byte[] byArray, Value value, Endianess endianess) throws BadDataException {
        byte[] byArray2 = this.decompress(byArray, endianess);
        super.loadData(byArray2, value, endianess);
    }

    protected byte[] decompress(byte[] byArray, Endianess endianess) throws BadDataException {
        try {
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            zHeader zHeader2 = new zHeader(dataInputStream, endianess);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            for (zTriplet zTriplet2 : zHeader2.getTriplets()) {
                int n;
                long l = zTriplet2.getCompressedSize();
                if (l == 0L) continue;
                byte[] byArray2 = new byte[(int)l];
                dataInputStream.read(byArray2);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
                InflaterInputStream inflaterInputStream = new InflaterInputStream(byteArrayInputStream);
                byte[] byArray3 = new byte[0x500000];
                while (inflaterInputStream.available() != 0 && (n = inflaterInputStream.read(byArray3, 0, 0x500000)) != -1) {
                    byteArrayOutputStream.write(byArray3, 0, n);
                }
                byArray2 = null;
                byArray3 = null;
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new BadDataException("Error in loading header for compressed data: " + iOException.toString());
        }
    }
}

