/*
 * Decompiled with CFR 0.152.
 */
package scalasca.cubex.cube.datalayout.data.value;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import scalasca.cubex.cube.datalayout.data.value.CubeDouble;
import scalasca.cubex.cube.datalayout.data.value.Value;
import scalasca.cubex.cube.services.transformation.Endianess;

public class CubeComplex
extends Value {
    protected CubeDouble re;
    protected CubeDouble im;

    public CubeComplex() {
        this.re = new CubeDouble();
        this.im = new CubeDouble();
    }

    public CubeComplex(double d, double d2) {
        this.re = new CubeDouble(d);
        this.im = new CubeDouble(d2);
    }

    public String getName() {
        return "Complex";
    }

    public String toString() {
        return this.re.toString() + " + i" + this.im.toString();
    }

    public int size() {
        return -1;
    }

    public void correctEndianess(Endianess endianess, DataInputStream dataInputStream, DataOutputStream dataOutputStream) throws IOException {
        this.re.correctEndianess(endianess, dataInputStream, dataOutputStream);
        this.im.correctEndianess(endianess, dataInputStream, dataOutputStream);
    }

    public Value clone() {
        return new CubeComplex();
    }

    public Value clone(DataInputStream dataInputStream) throws IOException {
        double d = dataInputStream.readDouble();
        double d2 = dataInputStream.readDouble();
        return new CubeComplex(d, d2);
    }

    public void setValue(String string) {
    }

    public void setValue(byte by) {
    }

    public void setValue(short s) {
    }

    public void setValue(int n) {
    }

    public void setValue(long l) {
    }

    public void setValue(double d) {
    }

    public double getDouble() {
        return this.re.getDouble();
    }

    public double getRe() {
        return this.re.getDouble();
    }

    public double getIm() {
        return this.im.getDouble();
    }

    public void addValue(Value value) {
        CubeComplex cubeComplex = (CubeComplex)value;
        this.re.addValue(cubeComplex.re);
        this.im.addValue(cubeComplex.im);
    }

    public void subtractValue(Value value) {
        CubeComplex cubeComplex = (CubeComplex)value;
        this.re.subtractValue(cubeComplex.re);
        this.im.subtractValue(cubeComplex.im);
    }
}

