/*
 * Decompiled with CFR 0.152.
 */
package scalasca.cubex.cube.datalayout.data.value;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import scalasca.cubex.cube.datalayout.data.value.Value;
import scalasca.cubex.cube.services.transformation.Endianess;

public class CubeInt32
extends Value {
    protected int value;

    public CubeInt32() {
        this.value = 0;
    }

    public CubeInt32(int n) {
        this.value = n;
    }

    public String getName() {
        return "INT32";
    }

    public String toString() {
        return Integer.valueOf(this.value).toString();
    }

    public int size() {
        return 4;
    }

    public void correctEndianess(Endianess endianess, DataInputStream dataInputStream, DataOutputStream dataOutputStream) throws IOException {
        int n = dataInputStream.readInt();
        int n2 = endianess.applyOn(n);
        dataOutputStream.writeInt(n2);
    }

    public Value clone() {
        return new CubeInt32();
    }

    public Value clone(DataInputStream dataInputStream) throws IOException {
        return new CubeInt32(dataInputStream.readInt());
    }

    public void setValue(String string) {
        this.value = Integer.parseInt(string);
    }

    public void setValue(byte by) {
        this.value = by;
    }

    public void setValue(short s) {
        this.value = s;
    }

    public void setValue(int n) {
        this.value = n;
    }

    public void setValue(long l) {
        this.value = (int)l;
    }

    public void setValue(double d) {
        this.value = (int)d;
    }

    public double getDouble() {
        return Integer.valueOf(this.value).doubleValue();
    }

    public void addValue(Value value) {
        CubeInt32 cubeInt32 = (CubeInt32)value;
        this.value += cubeInt32.value;
    }

    public void subtractValue(Value value) {
        CubeInt32 cubeInt32 = (CubeInt32)value;
        this.value -= cubeInt32.value;
    }
}

