/*
 * Decompiled with CFR 0.152.
 */
package scalasca.cubex.cube.datalayout.data.value;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import scalasca.cubex.cube.datalayout.data.value.Value;
import scalasca.cubex.cube.services.transformation.Endianess;

public class CubeInt64
extends Value {
    protected long value;

    public CubeInt64() {
        this.value = 0L;
    }

    public CubeInt64(long l) {
        this.value = l;
    }

    public String getName() {
        return "INT64";
    }

    public String toString() {
        return Long.valueOf(this.value).toString();
    }

    public int size() {
        return 8;
    }

    public void correctEndianess(Endianess endianess, DataInputStream dataInputStream, DataOutputStream dataOutputStream) throws IOException {
        long l = dataInputStream.readLong();
        long l2 = endianess.applyOn(l);
        dataOutputStream.writeLong(l2);
    }

    public Value clone() {
        return new CubeInt64();
    }

    public Value clone(DataInputStream dataInputStream) throws IOException {
        return new CubeInt64(dataInputStream.readLong());
    }

    public void setValue(String string) {
        this.value = Long.parseLong(string);
    }

    public void setValue(byte by) {
        this.value = by;
    }

    public void setValue(short s) {
        this.value = s;
    }

    public void setValue(int n) {
        this.value = n;
    }

    public void setValue(long l) {
        this.value = l;
    }

    public void setValue(double d) {
        this.value = (long)d;
    }

    public double getDouble() {
        return Long.valueOf(this.value).doubleValue();
    }

    public void addValue(Value value) {
        CubeInt64 cubeInt64 = (CubeInt64)value;
        this.value += cubeInt64.value;
    }

    public void subtractValue(Value value) {
        CubeInt64 cubeInt64 = (CubeInt64)value;
        this.value -= cubeInt64.value;
    }
}

