/*
 * Decompiled with CFR 0.152.
 */
package scalasca.cubex.cube.datalayout.data.value;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import scalasca.cubex.cube.datalayout.data.value.Value;
import scalasca.cubex.cube.services.transformation.Endianess;

public class CubeInt8
extends Value {
    protected byte value;

    public CubeInt8() {
        this.value = 0;
    }

    public CubeInt8(byte by) {
        this.value = by;
    }

    public String getName() {
        return "INT8";
    }

    public String toString() {
        return Byte.valueOf(this.value).toString();
    }

    public int size() {
        return 1;
    }

    public void correctEndianess(Endianess endianess, DataInputStream dataInputStream, DataOutputStream dataOutputStream) throws IOException {
        byte by = dataInputStream.readByte();
        byte by2 = endianess.applyOn(by);
        dataOutputStream.writeByte(by2);
    }

    public Value clone() {
        return new CubeInt8();
    }

    public Value clone(DataInputStream dataInputStream) throws IOException {
        return new CubeInt8(dataInputStream.readByte());
    }

    public void setValue(String string) {
        this.value = Byte.parseByte(string);
    }

    public void setValue(byte by) {
        this.value = by;
    }

    public void setValue(short s) {
        this.value = (byte)s;
    }

    public void setValue(int n) {
        this.value = (byte)n;
    }

    public void setValue(long l) {
        this.value = (byte)l;
    }

    public void setValue(double d) {
        this.value = (byte)d;
    }

    public double getDouble() {
        return Byte.valueOf(this.value).doubleValue();
    }

    public void addValue(Value value) {
        CubeInt8 cubeInt8 = (CubeInt8)value;
        this.value = (byte)(this.value + cubeInt8.value);
    }

    public void subtractValue(Value value) {
        CubeInt8 cubeInt8 = (CubeInt8)value;
        this.value = (byte)(this.value - cubeInt8.value);
    }
}

