/*
 * Decompiled with CFR 0.152.
 */
package scalasca.cubex.cube.datalayout.data.value;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import scalasca.cubex.cube.datalayout.data.value.Value;
import scalasca.cubex.cube.services.transformation.Endianess;

public class CubeUint16
extends Value {
    protected int value;

    public CubeUint16() {
        this.value = 0;
    }

    public CubeUint16(short s) {
        this.value = s;
    }

    public String getName() {
        return "UINT16";
    }

    public String toString() {
        return Integer.valueOf(this.value).toString();
    }

    public int size() {
        return 2;
    }

    public void correctEndianess(Endianess endianess, DataInputStream dataInputStream, DataOutputStream dataOutputStream) throws IOException {
        short s = dataInputStream.readShort();
        short s2 = endianess.applyOn(s);
        dataOutputStream.writeShort(s2);
    }

    public Value clone() {
        return new CubeUint16();
    }

    public Value clone(DataInputStream dataInputStream) throws IOException {
        return new CubeUint16(dataInputStream.readShort());
    }

    public void setValue(String string) {
        this.value = Integer.parseInt(string);
    }

    public void setValue(byte by) {
        this.value = by;
    }

    public void setValue(short s) {
        this.value = s;
    }

    public void setValue(int n) {
        this.value = n;
    }

    public void setValue(long l) {
        this.value = (int)l;
    }

    public void setValue(double d) {
        this.value = (int)d;
    }

    public double getDouble() {
        return Integer.valueOf(this.value).doubleValue();
    }

    public void addValue(Value value) {
        CubeUint16 cubeUint16 = (CubeUint16)value;
        this.value += cubeUint16.value;
    }

    public void subtractValue(Value value) {
        CubeUint16 cubeUint16 = (CubeUint16)value;
        this.value -= cubeUint16.value;
    }
}

