/*
 * Decompiled with CFR 0.152.
 */
package scalasca.cubex.cube.datalayout.data.value;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import scalasca.cubex.cube.datalayout.data.value.Value;
import scalasca.cubex.cube.services.transformation.Endianess;

public class CubeUint64
extends Value {
    protected BigInteger value;

    public CubeUint64() {
        this.value = BigInteger.valueOf(0L);
    }

    public CubeUint64(long l) {
        this.value = BigInteger.valueOf(l);
    }

    public String getName() {
        return "UINT64";
    }

    public String toString() {
        return this.value.toString();
    }

    public int size() {
        return 8;
    }

    public void correctEndianess(Endianess endianess, DataInputStream dataInputStream, DataOutputStream dataOutputStream) throws IOException {
        long l = dataInputStream.readLong();
        long l2 = endianess.applyOn(l);
        dataOutputStream.writeLong(l2);
    }

    public Value clone() {
        return new CubeUint64();
    }

    public Value clone(DataInputStream dataInputStream) throws IOException {
        return new CubeUint64(dataInputStream.readLong());
    }

    public void setValue(String string) {
        try {
            this.value = new BigInteger(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.value = new BigInteger(new Long((long)Double.valueOf(string).doubleValue()).toString());
        }
    }

    public void setValue(byte by) {
        this.value = new BigInteger(Byte.toString(by));
    }

    public void setValue(short s) {
        this.value = new BigInteger(Short.toString(s));
    }

    public void setValue(int n) {
        this.value = new BigInteger(Integer.toString(n));
    }

    public void setValue(long l) {
        this.value = new BigInteger(Long.toString(l));
    }

    public void setValue(double d) {
        this.value = new BigInteger(Double.toString(d));
    }

    public double getDouble() {
        return this.value.doubleValue();
    }

    public void addValue(Value value) {
        CubeUint64 cubeUint64 = (CubeUint64)value;
        this.value = this.value.add(cubeUint64.value);
    }

    public void subtractValue(Value value) {
        CubeUint64 cubeUint64 = (CubeUint64)value;
        this.value = this.value.subtract(cubeUint64.value);
    }
}

