/*
 * Decompiled with CFR 0.152.
 */
package scalasca.cubex.cube.datalayout.data.value;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import scalasca.cubex.cube.datalayout.data.value.Value;
import scalasca.cubex.cube.services.transformation.Endianess;

public class CubeUint8
extends Value {
    protected short value;

    public CubeUint8() {
        this.value = 0;
    }

    public CubeUint8(byte by) {
        this.value = by;
    }

    public String getName() {
        return "UINT8";
    }

    public String toString() {
        return Short.valueOf(this.value).toString();
    }

    public int size() {
        return 1;
    }

    public void correctEndianess(Endianess endianess, DataInputStream dataInputStream, DataOutputStream dataOutputStream) throws IOException {
        byte by = dataInputStream.readByte();
        byte by2 = endianess.applyOn(by);
        dataOutputStream.writeByte(by2);
    }

    public Value clone() {
        return new CubeUint8();
    }

    public Value clone(DataInputStream dataInputStream) throws IOException {
        return new CubeUint8(dataInputStream.readByte());
    }

    public void setValue(String string) {
        this.value = Short.parseShort(string);
    }

    public void setValue(byte by) {
        this.value = by;
    }

    public void setValue(short s) {
        this.value = s;
    }

    public void setValue(int n) {
        this.value = (short)n;
    }

    public void setValue(long l) {
        this.value = (short)l;
    }

    public void setValue(double d) {
        this.value = (short)d;
    }

    public double getDouble() {
        return Short.valueOf(this.value).doubleValue();
    }

    public void addValue(Value value) {
        CubeUint8 cubeUint8 = (CubeUint8)value;
        this.value = (short)(this.value + cubeUint8.value);
    }

    public void subtractValue(Value value) {
        CubeUint8 cubeUint8 = (CubeUint8)value;
        this.value = (short)(this.value - cubeUint8.value);
    }
}

