/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.client;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jfree.data.DefaultKeyedValues;
import org.jfree.data.KeyedValues2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PEKeyedValues2D
implements KeyedValues2D,
Cloneable,
Serializable {
    private static final long serialVersionUID = 4248823134357439655L;
    private List<Comparable<Object>> rowKeys = new ArrayList<Comparable<Object>>();
    private List<Comparable<Object>> columnKeys = new ArrayList<Comparable<Object>>();
    private List<DefaultKeyedValues> rows = new ArrayList<DefaultKeyedValues>();
    private boolean sortRowKeys;

    public PEKeyedValues2D() {
        this(false);
    }

    public PEKeyedValues2D(boolean bl) {
        this.sortRowKeys = bl;
    }

    public int getRowCount() {
        return this.rowKeys.size();
    }

    public int getColumnCount() {
        return this.columnKeys.size();
    }

    public Number getValue(int n, int n2) {
        Comparable<Object> comparable;
        Number number = null;
        DefaultKeyedValues defaultKeyedValues = this.rows.get(n);
        if (defaultKeyedValues != null && (comparable = this.columnKeys.get(n2)) != null) {
            try {
                number = defaultKeyedValues.getValue(comparable);
            }
            catch (Exception exception) {
                return null;
            }
        }
        return number;
    }

    public Comparable<Object> getRowKey(int n) {
        return this.rowKeys.get(n);
    }

    public int getRowIndex(Comparable comparable) {
        if (this.sortRowKeys) {
            return Collections.binarySearch(this.rowKeys, comparable);
        }
        return this.rowKeys.indexOf(comparable);
    }

    public List<Comparable<Object>> getRowKeys() {
        return Collections.unmodifiableList(this.rowKeys);
    }

    public Comparable<Object> getColumnKey(int n) {
        return this.columnKeys.get(n);
    }

    public int getColumnIndex(Comparable comparable) {
        return this.columnKeys.indexOf(comparable);
    }

    public List<Comparable<Object>> getColumnKeys() {
        return Collections.unmodifiableList(this.columnKeys);
    }

    public Number getValue(Comparable comparable, Comparable comparable2) {
        Number number = null;
        int n = this.getRowIndex(comparable);
        if (n >= 0) {
            DefaultKeyedValues defaultKeyedValues = this.rows.get(n);
            number = defaultKeyedValues.getValue(comparable2);
        }
        return number;
    }

    public void addValue(Number number, Comparable<Object> comparable, Comparable<Object> comparable2) {
        this.setValue(number, comparable, comparable2);
    }

    public void setValue(Number number, Comparable<Object> comparable, Comparable<Object> comparable2) {
        DefaultKeyedValues defaultKeyedValues;
        int n = this.getRowIndex(comparable);
        if (n >= 0) {
            defaultKeyedValues = this.rows.get(n);
        } else {
            defaultKeyedValues = new DefaultKeyedValues();
            if (this.sortRowKeys) {
                n = -n - 1;
                this.rowKeys.add(n, comparable);
                this.rows.add(n, defaultKeyedValues);
            } else {
                this.rowKeys.add(comparable);
                this.rows.add(defaultKeyedValues);
            }
        }
        defaultKeyedValues.setValue(comparable2, number);
        int n2 = this.columnKeys.indexOf(comparable2);
        if (n2 < 0) {
            this.columnKeys.add(comparable2);
            Collections.sort(this.columnKeys);
        }
    }

    public void removeValue(Comparable<Object> comparable, Comparable<Object> comparable2) {
        int n;
        this.setValue(null, comparable, comparable2);
        boolean bl = true;
        int n2 = this.getRowIndex(comparable);
        DefaultKeyedValues defaultKeyedValues = this.rows.get(n2);
        int n3 = defaultKeyedValues.getItemCount();
        for (n = 0; n < n3; ++n) {
            if (defaultKeyedValues.getValue(n) == null) continue;
            bl = false;
            break;
        }
        if (bl) {
            this.rowKeys.remove(n2);
            this.rows.remove(n2);
        }
        bl = true;
        n = this.getColumnIndex(comparable2);
        int n4 = this.rows.size();
        for (n3 = 0; n3 < n4; ++n3) {
            defaultKeyedValues = this.rows.get(n3);
            if (defaultKeyedValues.getValue(n) == null) continue;
            bl = false;
            break;
        }
        if (bl) {
            n4 = this.rows.size();
            for (n3 = 0; n3 < n4; ++n3) {
                defaultKeyedValues = this.rows.get(n3);
                defaultKeyedValues.removeValue(n);
            }
            this.columnKeys.remove(n);
        }
    }

    public void removeRow(int n) {
        this.rowKeys.remove(n);
        this.rows.remove(n);
    }

    public void removeRow(Comparable<Object> comparable) {
        this.removeRow(this.getRowIndex(comparable));
    }

    public void removeColumn(int n) {
        Comparable<Object> comparable = this.getColumnKey(n);
        this.removeColumn(comparable);
    }

    public void removeColumn(Comparable<Object> comparable) {
        for (DefaultKeyedValues defaultKeyedValues : this.rows) {
            defaultKeyedValues.removeValue(comparable);
        }
        this.columnKeys.remove(comparable);
    }

    public void clear() {
        this.rowKeys.clear();
        this.columnKeys.clear();
        this.rows.clear();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof KeyedValues2D)) {
            return false;
        }
        KeyedValues2D keyedValues2D = (KeyedValues2D)object;
        if (!((Object)this.getRowKeys()).equals(keyedValues2D.getRowKeys())) {
            return false;
        }
        if (!((Object)this.getColumnKeys()).equals(keyedValues2D.getColumnKeys())) {
            return false;
        }
        int n = this.getRowCount();
        if (n != keyedValues2D.getRowCount()) {
            return false;
        }
        int n2 = this.getColumnCount();
        if (n2 != keyedValues2D.getColumnCount()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                Number number = this.getValue(i, j);
                Number number2 = keyedValues2D.getValue(i, j);
                if (!(number == null ? number2 != null : !number.equals(number2))) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int n = ((Object)this.rowKeys).hashCode();
        n = 29 * n + ((Object)this.columnKeys).hashCode();
        n = 29 * n + ((Object)this.rows).hashCode();
        return n;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

