/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.client;

import edu.uoregon.tau.common.ImageExport;
import edu.uoregon.tau.common.PythonInterpreterFactory;
import edu.uoregon.tau.common.Utility;
import edu.uoregon.tau.perfdmf.database.DBConnector;
import edu.uoregon.tau.perfdmf.database.PasswordCallback;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerActionListener;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerConnection;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerJTabbedPane;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerJTree;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerMainJMenuBar;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerModel;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerNoGUI;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerWindowUtility;
import edu.uoregon.tau.perfexplorer.common.Console;
import edu.uoregon.tau.perfexplorer.common.PerfExplorerOutput;
import edu.uoregon.tau.perfexplorer.common.RMIPerfExplorerModel;
import edu.uoregon.tau.perfexplorer.common.ScriptThread;
import jargs.gnu.CmdLineParser;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ToolTipManager;

public class PerfExplorerClient
extends JFrame
implements ImageExport {
    private static final long serialVersionUID = 2320242528462409027L;
    private static String USAGE = "\nPerfExplorer\n****************************************************************************\nUsage: perfexplorer [OPTIONS]\nwhere [OPTIONS] are:\n[{-h,--help}]  ............................................ print this help.\n[{-g,--configfile}=<config_file>] .. specify one PerfDMF configuration file.\n[{-c,--config}=<config_name>] ........... specify one PerfDMF configuration.\n[{-n,--nogui}] ..................................................... no GUI.\n[{-i,--script}=<script_name>] ................ execute script <script_name>.\n";
    private ActionListener listener = null;
    private static PerfExplorerClient mainFrame = null;
    private JComponent mainComponent = null;
    private static String tauHome;
    private static String tauArch;
    public static final OutputStream DEV_NULL;

    public static PerfExplorerClient getMainFrame() {
        return mainFrame;
    }

    public ActionListener getListener() {
        return this.listener;
    }

    public PerfExplorerClient(boolean bl, String string, boolean bl2) {
        super("TAU: PerfExplorer Client");
        DBConnector.setPasswordCallback((PasswordCallback)PasswordCallback.guiPasswordCallback);
        PerfExplorerOutput.setQuiet(bl2);
        PerfExplorerConnection.setStandalone(bl);
        PerfExplorerConnection.setConfigFile(string);
        PerfExplorerConnection.setTauHome(tauHome);
        PerfExplorerConnection.setTauArch(tauArch);
        this.listener = new PerfExplorerActionListener(this);
        PerfExplorerJTree perfExplorerJTree = PerfExplorerJTree.getTree();
        JScrollPane jScrollPane = new JScrollPane(perfExplorerJTree);
        JScrollBar jScrollBar = jScrollPane.getVerticalScrollBar();
        jScrollBar.setUnitIncrement(35);
        jScrollPane.setPreferredSize(new Dimension(300, 650));
        PerfExplorerJTabbedPane perfExplorerJTabbedPane = PerfExplorerJTabbedPane.getPane();
        perfExplorerJTabbedPane.setPreferredSize(new Dimension(890, 650));
        JSplitPane jSplitPane = new JSplitPane(1);
        jSplitPane.setLeftComponent(jScrollPane);
        jSplitPane.setRightComponent(perfExplorerJTabbedPane);
        this.mainComponent = jSplitPane;
        this.getContentPane().add((Component)jSplitPane, "Center");
        this.setJMenuBar(new PerfExplorerMainJMenuBar(this.listener));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        int n = 1190;
        int n2 = 620;
        PerfExplorerWindowUtility.centerWindow(this, n, n2, 0, 0, false);
        URL uRL = Utility.getResource((String)"tau32x32.gif");
        if (uRL != null) {
            this.setIconImage(Toolkit.getDefaultToolkit().getImage(uRL));
        }
        mainFrame = this;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            String string;
            Object object = actionEvent.getSource();
            if (object instanceof JMenuItem && (string = actionEvent.getActionCommand()).equals("Quit")) {
                System.exit(0);
            }
        }
        catch (Exception exception) {
            System.err.println("actionPerformed Exception: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    public Dimension getImageSize(boolean bl, boolean bl2) {
        return this.mainComponent.getSize();
    }

    public void export(Graphics2D graphics2D, boolean bl, boolean bl2, boolean bl3) {
        this.mainComponent.setDoubleBuffered(false);
        this.mainComponent.paintAll(graphics2D);
        this.mainComponent.setDoubleBuffered(true);
    }

    public void refreshDatabases() {
        System.out.println("update the database tree!");
        PerfExplorerJTree.refreshDatabases();
    }

    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        Object object3;
        System.setProperty("derby.stream.error.field", "edu.uoregon.tau.perfexplorer.client.PerfExplorerClient.DEV_NULL");
        ToolTipManager.sharedInstance().setDismissDelay(20000);
        CmdLineParser cmdLineParser = new CmdLineParser();
        CmdLineParser.Option option = cmdLineParser.addBooleanOption('h', "help");
        CmdLineParser.Option option2 = cmdLineParser.addBooleanOption('s', "standalone");
        CmdLineParser.Option option3 = cmdLineParser.addBooleanOption('l', "client");
        CmdLineParser.Option option4 = cmdLineParser.addStringOption('g', "configfile");
        CmdLineParser.Option option5 = cmdLineParser.addStringOption('c', "config");
        CmdLineParser.Option option6 = cmdLineParser.addBooleanOption('v', "verbose");
        CmdLineParser.Option option7 = cmdLineParser.addStringOption('t', "tauhome");
        CmdLineParser.Option option8 = cmdLineParser.addStringOption('a', "tauarch");
        CmdLineParser.Option option9 = cmdLineParser.addBooleanOption('n', "nogui");
        CmdLineParser.Option option10 = cmdLineParser.addStringOption('i', "script");
        CmdLineParser.Option option11 = cmdLineParser.addStringOption('p', "scriptparams");
        CmdLineParser.Option option12 = cmdLineParser.addBooleanOption('w', "consoleWindow");
        try {
            cmdLineParser.parse(stringArray);
        }
        catch (CmdLineParser.OptionException optionException) {
            System.err.println(optionException.getMessage());
            System.err.println(USAGE);
            System.exit(-1);
        }
        Boolean bl = (Boolean)cmdLineParser.getOptionValue(option);
        Boolean bl2 = (Boolean)cmdLineParser.getOptionValue(option2);
        Boolean bl3 = (Boolean)cmdLineParser.getOptionValue(option3);
        String string = (String)cmdLineParser.getOptionValue(option4);
        String string2 = (String)cmdLineParser.getOptionValue(option5);
        Boolean bl4 = (Boolean)cmdLineParser.getOptionValue(option6);
        tauHome = (String)cmdLineParser.getOptionValue(option7);
        tauArch = (String)cmdLineParser.getOptionValue(option8);
        Boolean bl5 = (Boolean)cmdLineParser.getOptionValue(option9);
        String string3 = (String)cmdLineParser.getOptionValue(option10);
        String string4 = (String)cmdLineParser.getOptionValue(option11);
        Boolean bl6 = (Boolean)cmdLineParser.getOptionValue(option12);
        if (bl != null && bl.booleanValue()) {
            System.err.println(USAGE);
            System.exit(-1);
        }
        if (bl4 == null) {
            bl4 = new Boolean(true);
        }
        if (bl2 == null) {
            bl2 = new Boolean(true);
        }
        if (bl3 != null && bl3.booleanValue()) {
            bl2 = new Boolean(false);
        }
        if (bl5 == null) {
            bl5 = new Boolean(false);
        }
        if (bl6 == null) {
            bl6 = new Boolean(false);
        }
        if (bl2.booleanValue()) {
            if (string == null && string2 != null) {
                object3 = System.getProperty("user.home");
                object2 = System.getProperty("file.separator");
                string = (String)object3 + (String)object2 + ".ParaProf" + (String)object2 + "perfdmf.cfg." + string2;
            }
            if (string2 == "NO_DATABASE" && !bl5.booleanValue() && string3 == null) {
                System.err.println("The NO_DATABASE configuration option is only valid when running a script in command line mode.");
                System.err.println(USAGE);
                System.exit(-1);
            }
        }
        if (string4 != null) {
            object3 = PerfExplorerModel.getModel();
            object2 = new StringTokenizer(string4, ",");
            while (((StringTokenizer)object2).hasMoreTokens()) {
                object = ((StringTokenizer)object2).nextToken();
                StringTokenizer stringTokenizer = new StringTokenizer((String)object, "=");
                String string5 = stringTokenizer.nextToken();
                String string6 = stringTokenizer.nextToken();
                ((RMIPerfExplorerModel)object3).addScriptParameter(string5, string6);
            }
            if (string2 != null) {
                ((RMIPerfExplorerModel)object3).addScriptParameter("config", string2);
            }
        }
        object3 = new ArrayList();
        object3.add("edu.uoregon.tau.perfexplorer.client");
        object3.add("edu.uoregon.tau.perfexplorer.glue");
        object3.add("edu.uoregon.tau.perfexplorer.rules");
        object3.add("edu.uoregon.tau.perfdmf");
        object3.add("edu.uoregon.tau.perfdmf.database");
        PythonInterpreterFactory.defaultfactory.addPackagesFromList((List)object3);
        if (bl5.booleanValue()) {
            new PerfExplorerNoGUI(string, bl4);
            if (string3 != null) {
                PythonInterpreterFactory.defaultfactory.getPythonInterpreter().execfile(string3);
                System.exit(0);
            }
        } else {
            if (bl6.booleanValue()) {
                try {
                    new Console();
                }
                catch (IOException iOException) {
                    System.err.println("An error occurred setting up the console:");
                    System.err.println(iOException.getMessage());
                    iOException.printStackTrace();
                    System.exit(-1);
                }
            }
            object2 = new PerfExplorerClient(bl2, string, bl4);
            ((Window)object2).pack();
            ((Window)object2).setVisible(true);
            ((Window)object2).toFront();
            if (string3 != null) {
                object = (PerfExplorerActionListener)((PerfExplorerClient)object2).getListener();
                ((PerfExplorerActionListener)object).setScriptName(string3);
                new ScriptThread(string3);
            }
        }
    }

    public static String getTauHome() {
        return tauHome;
    }

    public static void setTauHome(String string) {
        tauHome = string;
    }

    public static String getTauArch() {
        return tauArch;
    }

    public static void setTauArch(String string) {
        tauArch = string;
    }

    static {
        DEV_NULL = new OutputStream(){

            public void write(int n) {
            }
        };
    }
}

