/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.client;

import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerClient;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerConnection;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerImageButton;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerModel;
import edu.uoregon.tau.perfexplorer.common.RMIPerformanceResults;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;

public class PerfExplorerCorrelationPane
extends JScrollPane
implements ActionListener {
    private static final long serialVersionUID = -1776096417971557334L;
    private static PerfExplorerCorrelationPane thePane = null;
    private JPanel imagePanel = null;
    private Hashtable<String, RMIPerformanceResults> resultsHash = null;
    private RMIPerformanceResults results = null;
    private boolean sortByR = false;
    private ButtonGroup corSortGroup;
    private JRadioButton corsortR;
    private JRadioButton corsortN;
    private static final String RValue = "RValue";
    private static final String DName = "DName";
    CorSortListener CSL = new CorSortListener();

    public static PerfExplorerCorrelationPane getPane() {
        if (thePane == null) {
            JPanel jPanel = new JPanel(new BorderLayout());
            thePane = new PerfExplorerCorrelationPane(jPanel);
        }
        thePane.repaint();
        return thePane;
    }

    private PerfExplorerCorrelationPane(JPanel jPanel) {
        super(jPanel);
        this.imagePanel = jPanel;
        this.resultsHash = new Hashtable();
        JScrollBar jScrollBar = this.getVerticalScrollBar();
        jScrollBar.setUnitIncrement(35);
    }

    public JPanel getImagePanel() {
        return this.imagePanel;
    }

    public void updateImagePanel() {
        this.imagePanel.removeAll();
        PerfExplorerModel perfExplorerModel = PerfExplorerModel.getModel();
        if (perfExplorerModel.getCurrentSelection() instanceof Metric || perfExplorerModel.getCurrentSelection() instanceof Trial) {
            PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
            this.results = perfExplorerConnection.getCorrelationResults(perfExplorerModel);
            if (this.results.getResultCount() == 0) {
                return;
            }
            int n = 0;
            List<String> list = this.results.getDescriptions();
            List<byte[]> list2 = this.results.getThumbnails();
            int n2 = list.size();
            this.resultsHash.put(perfExplorerModel.toString(), this.results);
            JPanel jPanel = null;
            this.corSortGroup = new ButtonGroup();
            this.corsortN = new JRadioButton();
            this.corsortN.setText("Alphabetical Ordering");
            this.corsortN.setSelected(!this.sortByR);
            this.corsortN.addActionListener(this.CSL);
            this.corsortN.setActionCommand(DName);
            this.corsortR = new JRadioButton();
            this.corsortR.setText("R Value Ordering");
            this.corsortR.setSelected(this.sortByR);
            this.corsortR.addActionListener(this.CSL);
            this.corsortR.setActionCommand(RValue);
            this.corSortGroup.add(this.corsortN);
            this.corSortGroup.add(this.corsortR);
            if (this.sortByR) {
                int n3;
                int n4;
                ArrayList<DescribedImage> arrayList = new ArrayList<DescribedImage>(n2);
                for (n4 = 0; n4 < n2; ++n4) {
                    arrayList.add(new DescribedImage(list.get(n4), list2.get(n4), n4));
                }
                Collections.sort(arrayList);
                n4 = 5;
                jPanel = new JPanel(new GridLayout(this.results.getResultCount() / n4 + 1, n4));
                jPanel.add(this.corsortN);
                jPanel.add(this.corsortR);
                for (n3 = 0; n3 < n4 - 1; ++n3) {
                    jPanel.add(new JLabel());
                }
                for (n3 = n; n3 < n2; ++n3) {
                    DescribedImage describedImage = (DescribedImage)arrayList.get(n3);
                    ImageIcon imageIcon = new ImageIcon(describedImage.getThumbnail());
                    String string = describedImage.getDescription();
                    int n5 = describedImage.getID();
                    PerfExplorerImageButton perfExplorerImageButton = new PerfExplorerImageButton(imageIcon, n5, string);
                    perfExplorerImageButton.addActionListener(this);
                    jPanel.add(perfExplorerImageButton);
                }
            } else {
                int n6;
                int n7 = (int)Math.sqrt(this.results.getResultCount());
                jPanel = new JPanel(new GridLayout(this.results.getResultCount() / n7 + 1, n7));
                jPanel.add(this.corsortN);
                jPanel.add(this.corsortR);
                for (n6 = 0; n6 < n7 - 2; ++n6) {
                    jPanel.add(new JLabel());
                }
                for (n6 = n; n6 < n2; ++n6) {
                    ImageIcon imageIcon = new ImageIcon(list2.get(n6));
                    String string = list.get(n6);
                    PerfExplorerImageButton perfExplorerImageButton = new PerfExplorerImageButton(imageIcon, n6, string);
                    perfExplorerImageButton.addActionListener(this);
                    jPanel.add(perfExplorerImageButton);
                }
            }
            this.imagePanel.add((Component)jPanel, "South");
        }
    }

    private static double getR(String string) {
        String string2;
        int n = string.lastIndexOf("R:");
        double d = Double.NaN;
        if (n >= 0 && (string2 = string.substring(n += 2)) != null && string2.length() > 0) {
            d = Double.parseDouble(string2);
        }
        return d;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n = Integer.parseInt(actionEvent.getActionCommand());
        String string = this.results.getDescriptions().get(n);
        ImageIcon imageIcon = new ImageIcon(this.results.getImages().get(n));
        JOptionPane.showMessageDialog(PerfExplorerClient.getMainFrame(), null, string, -1, imageIcon);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DescribedImage
    implements Comparable<DescribedImage> {
        private String description;
        private byte[] thumbnail;
        private int id;

        public String getDescription() {
            return this.description;
        }

        public byte[] getThumbnail() {
            return this.thumbnail;
        }

        public DescribedImage(String string, byte[] byArray, int n) {
            this.description = string;
            this.thumbnail = byArray;
            this.id = n;
        }

        public int getID() {
            return this.id;
        }

        @Override
        public int compareTo(DescribedImage describedImage) {
            Double d = PerfExplorerCorrelationPane.getR(this.description);
            Double d2 = PerfExplorerCorrelationPane.getR(describedImage.description);
            return Double.compare(d, d2);
        }
    }

    private class CorSortListener
    implements ActionListener {
        private CorSortListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == PerfExplorerCorrelationPane.this.corsortR) {
                // empty if block
            }
            if (actionEvent.getActionCommand().equals(PerfExplorerCorrelationPane.RValue)) {
                PerfExplorerCorrelationPane.this.sortByR = true;
            } else {
                PerfExplorerCorrelationPane.this.sortByR = false;
            }
            PerfExplorerCorrelationPane.this.imagePanel.setVisible(false);
            PerfExplorerCorrelationPane.this.updateImagePanel();
            PerfExplorerCorrelationPane.this.imagePanel.repaint();
            PerfExplorerCorrelationPane.this.imagePanel.setVisible(true);
        }
    }
}

