/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.clustering;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DendrogramTree {
    private DendrogramTree left = null;
    private DendrogramTree right = null;
    private int id = 0;
    private double height = 0.0;
    private int maxDepth = 0;

    public DendrogramTree(int n, double d) {
        this.id = n;
        this.height = d;
    }

    public void setLeft(DendrogramTree dendrogramTree) {
        this.left = dendrogramTree;
        this.maxDepth = this.right == null || dendrogramTree.getDepth() > this.right.getDepth() ? dendrogramTree.getDepth() + 1 : this.right.getDepth() + 1;
    }

    public void setRight(DendrogramTree dendrogramTree) {
        this.right = dendrogramTree;
        this.maxDepth = this.left == null || dendrogramTree.getDepth() > this.left.getDepth() ? dendrogramTree.getDepth() + 1 : this.left.getDepth() + 1;
    }

    public void setLeftAndRight(DendrogramTree dendrogramTree, DendrogramTree dendrogramTree2) {
        this.left = dendrogramTree;
        this.right = dendrogramTree2;
        this.maxDepth = dendrogramTree2.getDepth() > dendrogramTree.getDepth() ? dendrogramTree2.getDepth() + 1 : dendrogramTree.getDepth() + 1;
    }

    public boolean isLeaf() {
        return this.left == null && this.right == null;
    }

    public DendrogramTree getLeft() {
        return this.left;
    }

    public DendrogramTree getRight() {
        return this.right;
    }

    public double getHeight() {
        return this.height;
    }

    public int[] findCenters(int n) {
        int[] nArray = new int[n];
        if (n == 1) {
            nArray[0] = this.getRepresentative();
        } else if (n == 2) {
            nArray[0] = this.left.getRepresentative();
            nArray[1] = this.right.getRepresentative();
        } else {
            ArrayList<DendrogramTree> arrayList = new ArrayList<DendrogramTree>(n);
            arrayList.add(this.left);
            arrayList.add(this.right);
            DendrogramTree dendrogramTree = null;
            while (arrayList.size() < n) {
                DendrogramTree dendrogramTree2 = (DendrogramTree)arrayList.get(0);
                for (int i = 0; i < arrayList.size(); ++i) {
                    dendrogramTree = (DendrogramTree)arrayList.get(i);
                    if (!(dendrogramTree.getHeight() > dendrogramTree2.getHeight())) continue;
                    dendrogramTree2 = dendrogramTree;
                }
                arrayList.remove(dendrogramTree2);
                arrayList.add(dendrogramTree2.getLeft());
                arrayList.add(dendrogramTree2.getRight());
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                dendrogramTree = (DendrogramTree)arrayList.get(i);
                nArray[i] = dendrogramTree.getRepresentative();
            }
        }
        return nArray;
    }

    public int getRepresentative() {
        if (this.isLeaf()) {
            return Math.abs(this.id);
        }
        if (this.left.getDepth() == this.right.getDepth()) {
            if (this.left.getHeight() < this.right.getHeight()) {
                return this.left.getRepresentative();
            }
            return this.right.getRepresentative();
        }
        if (this.left.getDepth() > this.right.getDepth()) {
            return this.left.getRepresentative();
        }
        return this.right.getRepresentative();
    }

    public int getDepth() {
        return this.maxDepth;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.isLeaf()) {
            stringBuilder.append(this.left.toString());
            stringBuilder.append(this.right.toString());
            stringBuilder.append("node [" + this.id + "] " + this.left.id + ", " + this.right.id + ": " + this.height + "\n");
        } else {
            stringBuilder.append("leaf [" + this.id + "] \n");
        }
        return stringBuilder.toString();
    }

    public int getID() {
        return Math.abs(this.id);
    }

    public List<Integer> getIndexes() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (this.left != null) {
            arrayList.addAll(this.left.getIndexes());
        }
        if (this.right != null) {
            arrayList.addAll(this.right.getIndexes());
        }
        if (this.isLeaf()) {
            arrayList.add(new Integer(Math.abs(this.id) - 1));
        }
        return arrayList;
    }
}

