/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.glue;

import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfexplorer.glue.AbstractPerformanceOperation;
import edu.uoregon.tau.perfexplorer.glue.DeriveMetricEquation;
import edu.uoregon.tau.perfexplorer.glue.MergeTrialsOperation;
import edu.uoregon.tau.perfexplorer.glue.PerformanceResult;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeriveMetricsFileOperation
extends AbstractPerformanceOperation {
    private static final long serialVersionUID = 1530523733671075551L;
    private PerformanceResult input = null;
    private String filename;

    public DeriveMetricsFileOperation() {
    }

    public DeriveMetricsFileOperation(List<PerformanceResult> list) {
        super(list);
    }

    public DeriveMetricsFileOperation(PerformanceResult performanceResult) {
        super(performanceResult);
    }

    public DeriveMetricsFileOperation(PerformanceResult performanceResult, String string) {
        super(performanceResult);
        this.filename = string;
        this.input = performanceResult;
    }

    public DeriveMetricsFileOperation(Trial trial) {
        super(trial);
    }

    @Override
    public List<PerformanceResult> processData() {
        try {
            LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(this.filename));
            String string = lineNumberReader.readLine();
            while (string != null) {
                DeriveMetricEquation deriveMetricEquation = new DeriveMetricEquation(this.input, string);
                if (deriveMetricEquation.noErrors()) {
                    MergeTrialsOperation mergeTrialsOperation = new MergeTrialsOperation(this.input);
                    PerformanceResult performanceResult = deriveMetricEquation.processData().get(0);
                    mergeTrialsOperation.addInput(performanceResult);
                    this.input = mergeTrialsOperation.processData().get(0);
                } else {
                    System.err.println("\n\n *** ERROR: This equation was not derived: " + string + " ***\n\n");
                }
                string = lineNumberReader.readLine();
            }
            this.outputs.add(this.input);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return this.outputs;
    }
}

