/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.glue;

import edu.uoregon.tau.common.ImageExport;
import edu.uoregon.tau.common.Utility;
import edu.uoregon.tau.common.VectorExport;
import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfexplorer.client.MyCategoryAxis;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerChart;
import edu.uoregon.tau.perfexplorer.glue.AbstractPerformanceOperation;
import edu.uoregon.tau.perfexplorer.glue.PerformanceResult;
import edu.uoregon.tau.perfexplorer.glue.TrialMetadata;
import java.awt.BasicStroke;
import java.awt.Stroke;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.LogarithmicAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.xy.DefaultTableXYDataset;
import org.jfree.data.xy.TableXYDataset;
import org.jfree.data.xy.XYSeries;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrawGraph
extends AbstractPerformanceOperation {
    private static final long serialVersionUID = -5587605162968129610L;
    protected Set<String> _events = null;
    protected Set<String> _metrics = null;
    protected Set<Integer> _threads = null;
    public static final int TRIALNAME = 0;
    public static final int EVENTNAME = 1;
    public static final int METRICNAME = 2;
    public static final int THREADNAME = 3;
    public static final int USEREVENTNAME = 4;
    public static final int PROCESSORCOUNT = 5;
    public static final int METADATA = 6;
    public static final int MICROSECONDS = 1;
    public static final int MILLISECONDS = 1000;
    public static final int THOUSANDS = 1000;
    public static final int SECONDS = 1000000;
    public static final int MILLIONS = 1000000;
    public static final int MINUTES = 60000000;
    public static final int BILLIONS = 1000000000;
    public static final int LINECHART = 1;
    public static final int STACKEDAREACHART = 2;
    public static final int STACKEDBARCHART = 3;
    protected int units = 1;
    protected int seriesType = 2;
    protected int categoryType = 3;
    protected int valueType = 1;
    protected boolean logYAxis = false;
    protected boolean showZero = false;
    protected int categoryNameLength = 0;
    protected String title = "My Chart";
    protected String yAxisLabel = "value";
    protected String xAxisLabel = "category";
    protected boolean userEvents = false;
    protected String metadataField = "";
    protected PerfExplorerChart chartWindow = null;
    protected boolean shortenNames = false;
    protected int chartType = 1;

    public DrawGraph(PerformanceResult performanceResult) {
        super(performanceResult);
    }

    public DrawGraph(Trial trial) {
        super(trial);
    }

    public DrawGraph(List<PerformanceResult> list) {
        super(list);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<PerformanceResult> processData() {
        Object object;
        Object object2;
        PerformanceResult performanceResult22;
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<Object> hashSet2 = new HashSet<Object>();
        for (PerformanceResult performanceResult22 : this.inputs) {
            object2 = null;
            Object i = null;
            object = null;
            object2 = this._events == null ? (this.userEvents ? performanceResult22.getUserEvents() : performanceResult22.getEvents()) : this._events;
            if (this._metrics == null) {
                Set<String> logarithmicAxis = performanceResult22.getMetrics();
            } else {
                Set<String> set = this._metrics;
            }
            object = this._threads == null ? performanceResult22.getThreads() : this._threads;
            Object object3 = "";
            String string4 = "";
            if (this.userEvents) {
                for (String string2 : object2) {
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        Integer n = (Integer)iterator.next();
                        if (this.seriesType == 0) {
                            object3 = performanceResult22.getTrial().getName();
                        } else if (this.seriesType == 4) {
                            object3 = string2;
                        } else if (this.seriesType == 3) {
                            object3 = n.toString();
                        }
                        if (this.categoryType == 0) {
                            string4 = performanceResult22.getTrial().getName();
                        } else if (this.categoryType == 4) {
                            string4 = string2;
                        } else if (this.categoryType == 3) {
                            string4 = n.toString();
                        } else if (this.categoryType == 5) {
                            string4 = Integer.toString(performanceResult22.getOriginalThreads());
                        }
                        defaultCategoryDataset.addValue(performanceResult22.getDataPoint(n, string2, null, this.valueType) / (double)this.units, (Comparable)object3, (Comparable)((Object)string4));
                        hashSet.add(string4);
                        hashSet2.add(object3);
                        this.categoryNameLength = this.categoryNameLength += string4.length();
                    }
                }
                continue;
            }
            for (String string2 : object2) {
                void set;
                for (String string3 : set) {
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        Integer n = (Integer)iterator.next();
                        if (this.seriesType == 0) {
                            object3 = performanceResult22.getTrial().getName();
                        } else if (this.seriesType == 1) {
                            object3 = this.shortenNames ? this.shortName(string2) : string2;
                        } else if (this.seriesType == 2) {
                            object3 = string3;
                        } else if (this.seriesType == 3) {
                            object3 = n.toString();
                        }
                        if (this.categoryType == 0) {
                            string4 = performanceResult22.getName();
                        } else if (this.categoryType == 1) {
                            string4 = this.shortenNames ? this.shortName(string2) : string2;
                        } else if (this.categoryType == 2) {
                            string4 = string3;
                        } else if (this.categoryType == 3) {
                            string4 = n.toString();
                        } else if (this.categoryType == 5) {
                            string4 = Integer.toString(performanceResult22.getOriginalThreads());
                        } else if (this.categoryType == 6) {
                            TrialMetadata trialMetadata = new TrialMetadata(performanceResult22.getTrial());
                            string4 = trialMetadata.getCommonAttributes().get(this.metadataField);
                        }
                        defaultCategoryDataset.addValue(performanceResult22.getDataPoint(n, string2, string3, this.valueType) / (double)this.units, (Comparable)object3, (Comparable)((Object)string4));
                        hashSet.add(string4);
                        hashSet2.add(object3);
                        this.categoryNameLength = this.categoryNameLength += string4.length();
                    }
                }
            }
        }
        JFreeChart jFreeChart = null;
        if (this.chartType == 2) {
            performanceResult22 = new DefaultTableXYDataset();
            for (String string : hashSet2) {
                object = new XYSeries((Comparable)((Object)string), true, false);
                for (String string4 : hashSet) {
                    object.add(Double.parseDouble(string4), defaultCategoryDataset.getValue((Comparable)((Object)string), (Comparable)((Object)string4)));
                }
                performanceResult22.addSeries((XYSeries)object);
            }
            jFreeChart = ChartFactory.createStackedXYAreaChart((String)this.title, (String)this.xAxisLabel, (String)this.yAxisLabel, (TableXYDataset)performanceResult22, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
            Utility.applyDefaultChartTheme((JFreeChart)jFreeChart);
        } else if (this.chartType == 3) {
            jFreeChart = ChartFactory.createStackedBarChart((String)this.title, (String)this.xAxisLabel, (String)this.yAxisLabel, (CategoryDataset)defaultCategoryDataset, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)true, (boolean)true, (boolean)false);
            Utility.applyDefaultChartTheme((JFreeChart)jFreeChart);
        } else {
            void var7_14;
            jFreeChart = ChartFactory.createLineChart((String)this.title, (String)this.xAxisLabel, (String)this.yAxisLabel, (CategoryDataset)defaultCategoryDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
            Utility.applyDefaultChartTheme((JFreeChart)jFreeChart);
            performanceResult22 = (CategoryPlot)jFreeChart.getPlot();
            object2 = (LineAndShapeRenderer)performanceResult22.getRenderer();
            object2.setBaseShapesFilled(true);
            object2.setBaseShapesVisible(true);
            object2.setDrawOutlines(true);
            object2.setBaseItemLabelsVisible(true);
            boolean bl = false;
            while (var7_14 < defaultCategoryDataset.getRowCount()) {
                object2.setSeriesStroke((int)var7_14, (Stroke)new BasicStroke(2.0f));
                ++var7_14;
            }
            if (this.logYAxis) {
                LogarithmicAxis logarithmicAxis = new LogarithmicAxis(this.yAxisLabel);
                logarithmicAxis.setAutoRangeIncludesZero(true);
                logarithmicAxis.setAllowNegativesFlag(true);
                logarithmicAxis.setLog10TickLabelsFlag(true);
                performanceResult22.setRangeAxis(0, (ValueAxis)logarithmicAxis);
            }
            NumberAxis numberAxis = (NumberAxis)performanceResult22.getRangeAxis();
            numberAxis.setAutoRangeIncludesZero(this.showZero);
            object = null;
            object = new MyCategoryAxis(this.xAxisLabel);
            if (hashSet.size() > 40) {
                ((MyCategoryAxis)((Object)object)).setTickLabelSkip(hashSet.size() / 20);
                ((MyCategoryAxis)((Object)object)).setCategoryLabelPositions(CategoryLabelPositions.UP_45);
            } else if (hashSet.size() > 20) {
                ((MyCategoryAxis)((Object)object)).setCategoryLabelPositions(CategoryLabelPositions.UP_45);
            } else if (this.categoryNameLength / hashSet.size() > 10) {
                ((MyCategoryAxis)((Object)object)).setCategoryLabelPositions(CategoryLabelPositions.UP_45);
            }
            performanceResult22.setDomainAxis((CategoryAxis)object);
        }
        this.chartWindow = new PerfExplorerChart(jFreeChart, "General Chart");
        return null;
    }

    public void setEvents(Set<String> set) {
        this._events = set;
    }

    public void setMetrics(Set<String> set) {
        this._metrics = set;
    }

    public void setThreads(Set<Integer> set) {
        this._threads = set;
    }

    public void setCategoryType(int n) {
        this.categoryType = n;
    }

    public void setLogYAxis(boolean bl) {
        this.logYAxis = bl;
    }

    public void setSeriesType(int n) {
        this.seriesType = n;
    }

    public void setType(int n) {
        this.chartType = n;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setValueType(int n) {
        this.valueType = n;
    }

    public void setXAxisLabel(String string) {
        this.xAxisLabel = string;
    }

    public void setYAxisLabel(String string) {
        this.yAxisLabel = string;
    }

    public void setUserEvents(boolean bl) {
        this.userEvents = bl;
    }

    public void setShowZero(boolean bl) {
        this.showZero = bl;
    }

    public void setMetadataField(String string) {
        this.metadataField = string;
    }

    public void setUnits(int n) {
        this.units = n;
    }

    public void drawChartToFile(String string) {
        try {
            VectorExport.export((ImageExport)this.chartWindow, (File)new File(string), (boolean)true, (String)"PerfExplorer", (boolean)true, (boolean)true);
        }
        catch (Exception exception) {
            System.err.println("Could not write graph to file:");
            System.err.println(exception.getMessage());
            exception.printStackTrace();
        }
    }

    private String shortName(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "(");
        String string2 = null;
        try {
            string2 = stringTokenizer.nextToken();
            if (string2.length() < string.length()) {
                string2 = string2 + "()";
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            string2 = string;
        }
        string = string2;
        stringTokenizer = new StringTokenizer(string, "[{");
        string2 = null;
        try {
            string2 = stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            string2 = string;
        }
        return string2;
    }

    public void setShortenNames(boolean bl) {
        this.shortenNames = bl;
    }
}

