/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.glue;

import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfdmf.database.DB;
import edu.uoregon.tau.perfexplorer.glue.PerformanceResult;
import edu.uoregon.tau.perfexplorer.server.PerfExplorerServer;
import edu.uoregon.tau.perfexplorer.server.TauNamespaceContext;
import java.io.StringReader;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrialMetadata {
    private Hashtable<String, String> commonAttributes = new Hashtable();
    private Hashtable<String, Double> accumulator = new Hashtable();
    private Trial trial = null;
    private PerformanceResult performanceResult = null;

    public TrialMetadata(int n) {
        this.trial = PerfExplorerServer.getServer().getSession().setTrial(n, false);
        this.getMetadata();
    }

    public TrialMetadata(Trial trial) {
        this.trial = trial;
        this.getMetadata();
    }

    public TrialMetadata(PerformanceResult performanceResult) {
        this.trial = performanceResult.getTrial();
        this.performanceResult = performanceResult;
        this.getMetadata();
    }

    private void getMetadata() {
        try {
            String string;
            Object object;
            Object object2;
            Object object4;
            String[] stringArray22;
            Map map = this.trial.getMetaData();
            for (String[] stringArray22 : map.keySet()) {
                String string2 = (String)map.get(stringArray22);
                this.commonAttributes.put((String)stringArray22, string2);
            }
            this.commonAttributes.put("Trial.Name", this.trial.getName());
            stringArray22 = Trial.getFieldNames((DB)PerfExplorerServer.getServer().getDB());
            for (int i = 0; i < stringArray22.length; ++i) {
                if (stringArray22[i].equalsIgnoreCase("XML_METADATA") || stringArray22[i].equalsIgnoreCase("XML_METADATA_GZ")) continue;
                if (this.trial.getField(i) == null) {
                    this.commonAttributes.put(stringArray22[i].toLowerCase(), new String(""));
                    continue;
                }
                this.commonAttributes.put(stringArray22[i].toLowerCase(), this.trial.getField(i));
            }
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            StringReader stringReader = new StringReader(this.trial.getField("XML_METADATA"));
            InputSource inputSource = new InputSource(stringReader);
            Document document = documentBuilder.parse(inputSource);
            XPath xPath = XPathFactory.newInstance().newXPath();
            xPath.setNamespaceContext(new TauNamespaceContext());
            NodeList nodeList = (NodeList)xPath.evaluate("/metadata/ProfileAttributes", document, XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                object4 = nodeList.item(i).getChildNodes();
                for (int j = 0; j < object4.getLength(); ++j) {
                    Node sQLException = object4.item(j);
                    object2 = sQLException.getFirstChild();
                    while (object2.getFirstChild() == null || object2.getFirstChild().getNodeValue() == null) {
                        object2 = object2.getNextSibling();
                    }
                    for (object = object2.getNextSibling(); object != null && (object.getFirstChild() == null || object.getFirstChild().getNodeValue() == null); object = object.getNextSibling()) {
                    }
                    if (object == null) continue;
                    string = object.getFirstChild().getNodeValue();
                    String string2 = object2.getFirstChild().getNodeValue();
                    if (string == null || string2 == null || string2.equals("pid") || string2.toLowerCase().contains("time")) continue;
                    try {
                        Double d = Double.parseDouble(string);
                        Double d2 = this.accumulator.get(string2);
                        if (d2 == null) {
                            this.accumulator.put(string2, d);
                            continue;
                        }
                        this.accumulator.put(string2, d2 + d);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.commonAttributes.put(string2, string);
                    }
                }
                for (String string3 : this.accumulator.keySet()) {
                    this.commonAttributes.put(string3, Double.toString(this.accumulator.get(string3) / (double)nodeList.getLength()));
                }
            }
            if (this.performanceResult != null) {
                DB dB = PerfExplorerServer.getServer().getDB();
                object4 = new StringBuilder();
                Object object5 = null;
                try {
                    ((StringBuilder)object4).append("select interval_event, category_name, parameter_name, ");
                    ((StringBuilder)object4).append("parameter_type, parameter_value from metadata_parameters ");
                    ((StringBuilder)object4).append("where trial = ? order by 1");
                    object5 = dB.prepareStatement(((StringBuilder)object4).toString());
                    object5.setInt(1, this.trial.getID());
                    ResultSet resultSet = object5.executeQuery();
                    while (resultSet.next()) {
                        object2 = resultSet.getString(1);
                        if (object2 != null && (object2 == null || !this.performanceResult.getEvents().contains(object2)) && (object2 == null || !this.performanceResult.getEvents().contains(this.performanceResult.getMainEvent() + "  => " + (String)object2))) continue;
                        object = resultSet.getString(3);
                        string = resultSet.getString(5);
                        this.commonAttributes.put((String)object, string);
                    }
                    resultSet.close();
                    object5.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            exception.printStackTrace();
        }
    }

    public Hashtable<String, String> getCommonAttributes() {
        return this.commonAttributes;
    }

    public void setCommonAttributes(Hashtable<String, String> hashtable) {
        this.commonAttributes = hashtable;
    }

    public Trial getTrial() {
        return this.trial;
    }

    public void setTrial(Trial trial) {
        this.trial = trial;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        Set<String> set = this.commonAttributes.keySet();
        for (String string : set) {
            stringBuilder.append(string + ": " + this.commonAttributes.get(string) + "\n");
        }
        return stringBuilder.toString();
    }
}

