/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.glue;

import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfexplorer.glue.AbstractResult;
import edu.uoregon.tau.perfexplorer.glue.PerformanceResult;
import edu.uoregon.tau.perfexplorer.glue.TrialResult;
import edu.uoregon.tau.perfexplorer.server.TauNamespaceContext;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrialThreadMetadata
extends AbstractResult {
    private static final long serialVersionUID = 2805778968974861504L;
    protected Map<Integer, Map<String, String>> stringData = new HashMap<Integer, Map<String, String>>();
    protected Set<String> fields = new TreeSet<String>();

    public TrialThreadMetadata(Trial trial) {
        this.getMetadata(trial);
    }

    public TrialThreadMetadata() {
    }

    public TrialThreadMetadata(PerformanceResult performanceResult) {
        super(performanceResult);
        if (performanceResult instanceof TrialResult) {
            TrialResult trialResult = (TrialResult)performanceResult;
            Trial trial = trialResult.getTrial();
            this.getMetadata(trial);
        }
    }

    private void getMetadata(Trial trial) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            StringReader stringReader = new StringReader(trial.getField("XML_METADATA"));
            InputSource inputSource = new InputSource(stringReader);
            Document document = documentBuilder.parse(inputSource);
            XPath xPath = XPathFactory.newInstance().newXPath();
            xPath.setNamespaceContext(new TauNamespaceContext());
            NodeList nodeList = (NodeList)xPath.evaluate("/metadata/ProfileAttributes", document, XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                NamedNodeMap namedNodeMap = nodeList.item(i).getAttributes();
                String string = namedNodeMap.getNamedItem("node").getNodeValue();
                NodeList nodeList2 = nodeList.item(i).getChildNodes();
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Node node = nodeList2.item(j);
                    Node node2 = node.getFirstChild();
                    while (node2.getFirstChild() == null || node2.getFirstChild().getNodeValue() == null) {
                        node2 = node2.getNextSibling();
                    }
                    Node node3 = node2.getNextSibling();
                    while (node3.getFirstChild() == null || node3.getFirstChild().getNodeValue() == null) {
                        node3 = node3.getNextSibling();
                    }
                    String string2 = node3.getFirstChild().getNodeValue();
                    String string3 = node2.getFirstChild().getNodeValue();
                    if (string2 == null || string3 == null || string3.equals("pid") || string3.toLowerCase().contains("time")) continue;
                    try {
                        Double d = Double.parseDouble(string2);
                        this.putExclusive(Integer.parseInt(string), string3, "METADATA", d);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.putNameValue(Integer.parseInt(string), string3, string2);
                    }
                }
            }
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            int n = Integer.parseInt(trial.getField("node_count"));
            int n2 = Integer.parseInt(trial.getField("contexts_per_node"));
            int n3 = Integer.parseInt(trial.getField("threads_per_context"));
            int n4 = 0;
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    for (int k = 0; k < n3; ++k) {
                        this.putExclusive(n4, "node", "METADATA", i);
                        this.putExclusive(n4, "context", "METADATA", j);
                        this.putExclusive(n4, "thread", "METADATA", k);
                        this.putExclusive(n4, "MPI Rank", "METADATA", n4);
                        ++n4;
                    }
                }
            }
        }
    }

    public void putNameValue(Integer n, String string, String string2) {
        if (!this.threads.contains(n)) {
            this.threads.add(n);
        }
        if (!this.fields.contains(string)) {
            this.fields.add(string);
        }
        if (!this.stringData.containsKey(n)) {
            this.stringData.put(n, new HashMap());
        }
        this.stringData.get(n).put(string, string2);
    }

    public String getNameValue(Integer n, String string) {
        String string2 = null;
        try {
            string2 = this.stringData.get(n).get(string);
        }
        catch (NullPointerException nullPointerException) {
            string2 = "";
        }
        return string2;
    }

    public Set<String> getFields() {
        return this.fields;
    }

    public int getThreadCount() {
        return this.stringData.size();
    }
}

