/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.glue;

import edu.uoregon.tau.perfdmf.Application;
import edu.uoregon.tau.perfdmf.Experiment;
import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerClient;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerModel;
import edu.uoregon.tau.perfexplorer.common.RMISortableIntervalEvent;
import edu.uoregon.tau.perfexplorer.server.PerfExplorerServer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.swing.JFrame;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utilities {
    public static Trial getTrial(String string, String string2, String string3) {
        boolean bl = false;
        PerfExplorerServer perfExplorerServer = Utilities.getServer();
        List<Application> list = perfExplorerServer.getApplicationList();
        for (Application application : list) {
            if (!application.getName().equals(string)) continue;
            List<Experiment> list2 = perfExplorerServer.getExperimentList(application.getID());
            for (Experiment experiment : list2) {
                if (!experiment.getName().trim().equals(string2.trim())) continue;
                List<Trial> list3 = perfExplorerServer.getTrialList(experiment.getID(), false);
                for (Trial trial : list3) {
                    if (!trial.getName().trim().equals(string3.trim())) continue;
                    if (!trial.isXmlMetaDataLoaded()) {
                        try {
                            trial.loadXMLMetadata(perfExplorerServer.getDB());
                        }
                        catch (SQLException sQLException) {
                            System.err.println("Error getting metadata for trial");
                            sQLException.printStackTrace();
                        }
                    }
                    return trial;
                }
                System.out.println("Could not find trial: " + string3);
                bl = true;
            }
            if (!bl) {
                System.out.println("Could not find experiment: " + string2);
            }
            bl = true;
        }
        if (!bl) {
            System.out.println("Could not find application: " + string);
        }
        return null;
    }

    public static List<Trial> getTrialsForExperiment(String string, String string2) {
        boolean bl = false;
        PerfExplorerServer perfExplorerServer = Utilities.getServer();
        List<Application> list = perfExplorerServer.getApplicationList();
        for (Application application : list) {
            if (!application.getName().equals(string)) continue;
            List<Experiment> list2 = perfExplorerServer.getExperimentList(application.getID());
            for (Experiment experiment : list2) {
                if (!experiment.getName().trim().equals(string2.trim())) continue;
                List<Trial> list3 = perfExplorerServer.getTrialList(experiment.getID(), false);
                for (Trial trial : list3) {
                    if (trial.isXmlMetaDataLoaded()) continue;
                    try {
                        trial.loadXMLMetadata(perfExplorerServer.getDB());
                    }
                    catch (SQLException sQLException) {
                        System.err.println("Error getting metadata for trial");
                        sQLException.printStackTrace();
                    }
                }
                return list3;
            }
            if (!bl) {
                System.out.println("Could not find experiment: " + string2);
            }
            bl = true;
        }
        if (!bl) {
            System.out.println("Could not find application: " + string);
        }
        return null;
    }

    public static List<Experiment> getExperimentsForApplication(String string) {
        boolean bl = false;
        PerfExplorerServer perfExplorerServer = Utilities.getServer();
        List<Application> list = perfExplorerServer.getApplicationList();
        for (Application application : list) {
            if (!application.getName().equals(string)) continue;
            List<Experiment> list2 = perfExplorerServer.getExperimentList(application.getID());
            return list2;
        }
        if (!bl) {
            System.out.println("Could not find application: " + string);
        }
        return null;
    }

    public static Trial getCurrentTrial() {
        Trial trial = PerfExplorerModel.getModel().getTrial();
        if (trial == null) {
            System.out.println("Utilities.getCurrentTrial() failed: No trial selected.");
        }
        return trial;
    }

    private static PerfExplorerServer getServer() {
        return PerfExplorerServer.getServer(null, "", "");
    }

    private static PerfExplorerServer getServer(String string, String string2) {
        String string3 = System.getProperty("user.home");
        String string4 = System.getProperty("file.separator");
        String string5 = string3 + string4 + ".ParaProf" + string4 + "perfdmf.cfg." + string;
        return PerfExplorerServer.getServer(string5, string2, "");
    }

    public static JFrame getClient() {
        String string = System.getProperty("user.home");
        String string2 = System.getProperty("file.separator");
        String string3 = string + string2 + ".ParaProf" + string2 + "perfdmf.cfg";
        PerfExplorerClient perfExplorerClient = new PerfExplorerClient(true, string3, true);
        perfExplorerClient.pack();
        perfExplorerClient.setVisible(true);
        return perfExplorerClient;
    }

    public static int setSession(String string) {
        try {
            PerfExplorerServer perfExplorerServer = Utilities.getServer(string, "");
            List<String> list = perfExplorerServer.getConfigNames();
            for (int i = 0; i < perfExplorerServer.getSessionCount(); ++i) {
                perfExplorerServer.setConnectionIndex(i);
                String string2 = list.get(i);
                if (!string2.equals(string)) continue;
                return i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    public static LinkedHashMap<String, Double> sortHashMapByValues(Map<String, Double> map, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>(map.keySet());
        ArrayList<Double> arrayList2 = new ArrayList<Double>(map.values());
        Collections.sort(arrayList2);
        Collections.sort(arrayList);
        if (!bl) {
            Collections.reverse(arrayList2);
        }
        LinkedHashMap<String, Double> linkedHashMap = new LinkedHashMap<String, Double>();
        block0: for (Double d : arrayList2) {
            for (String string : arrayList) {
                if (!map.get(string).toString().equals(d.toString())) continue;
                map.remove(string);
                arrayList.remove(string);
                linkedHashMap.put(string, d);
                continue block0;
            }
        }
        return linkedHashMap;
    }

    public static List<RMISortableIntervalEvent> getEventsForTrial(Trial trial, int n) {
        List<RMISortableIntervalEvent> list = null;
        PerfExplorerServer perfExplorerServer = Utilities.getServer();
        list = perfExplorerServer.getEventList(trial.getID(), n);
        return list;
    }

    public static String shortenEventName(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "(");
        String string2 = null;
        try {
            string2 = stringTokenizer.nextToken();
            if (string2.length() < string.length()) {
                string2 = string2 + "()";
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            string2 = string;
        }
        string = string2;
        stringTokenizer = new StringTokenizer(string, "[{");
        string2 = null;
        try {
            string2 = stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            string2 = string;
        }
        return string2.trim();
    }
}

