/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.server;

import edu.uoregon.tau.common.Utility;
import edu.uoregon.tau.perfexplorer.clustering.DataNormalizer;
import edu.uoregon.tau.perfexplorer.clustering.RawDataInterface;
import edu.uoregon.tau.perfexplorer.clustering.weka.AnalysisFactory;
import edu.uoregon.tau.perfexplorer.common.ChartType;
import edu.uoregon.tau.perfexplorer.common.RMIPerfExplorerModel;
import edu.uoregon.tau.perfexplorer.constants.Constants;
import edu.uoregon.tau.perfexplorer.server.PCAPlotDataset;
import edu.uoregon.tau.perfexplorer.server.ScatterPlotDataset;
import java.awt.Color;
import java.awt.Paint;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.Range;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.function.Function2D;
import org.jfree.data.function.LineFunction2D;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.statistics.Regression;
import org.jfree.data.xy.XYDataset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageUtils {
    public static File generateBreakdownThumbnail(RMIPerfExplorerModel rMIPerfExplorerModel, RawDataInterface rawDataInterface, RawDataInterface rawDataInterface2, List<String> list) {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        for (int i = 0; i < rawDataInterface.numVectors(); ++i) {
            for (int j = 0; j < rawDataInterface.numDimensions(); ++j) {
                defaultCategoryDataset.addValue(rawDataInterface.getValue(i, j), (Comparable)((Object)list.get(j)), (Comparable)((Object)new String(Integer.toString(i))));
            }
        }
        JFreeChart jFreeChart = ChartFactory.createStackedBarChart(null, null, null, (CategoryDataset)defaultCategoryDataset, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)false, (boolean)true, (boolean)false);
        Utility.applyDefaultChartTheme((JFreeChart)jFreeChart);
        File file = new File(Constants.TMPDIR + "thumbnail." + rMIPerfExplorerModel.toShortString() + ".png");
        try {
            ChartUtilities.saveChartAsPNG((File)file, (JFreeChart)jFreeChart, (int)100, (int)100);
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
            iOException.printStackTrace();
        }
        return file;
    }

    public static File generateBreakdownImage(ChartType chartType, RMIPerfExplorerModel rMIPerfExplorerModel, RawDataInterface rawDataInterface, RawDataInterface rawDataInterface2, List<String> list) {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        for (int i = 0; i < rawDataInterface.numVectors(); ++i) {
            for (int j = 0; j < rawDataInterface.numDimensions(); ++j) {
                defaultCategoryDataset.addValue(rawDataInterface.getValue(i, j), (Comparable)((Object)list.get(j)), (Comparable)((Object)new String(Integer.toString(i))));
            }
        }
        String string = rMIPerfExplorerModel.toString();
        if (chartType == ChartType.CLUSTER_AVERAGES) {
            string = string + " Average Values";
        }
        if (chartType == ChartType.CLUSTER_MAXIMUMS) {
            string = string + " Maximum Values";
        }
        if (chartType == ChartType.CLUSTER_MINIMUMS) {
            string = string + " Minimum Values";
        }
        JFreeChart jFreeChart = ChartFactory.createStackedBarChart((String)string, (String)"Cluster Number", (String)"Total Runtime", (CategoryDataset)defaultCategoryDataset, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)true, (boolean)true, (boolean)false);
        Utility.applyDefaultChartTheme((JFreeChart)jFreeChart);
        File file = new File(Constants.TMPDIR + "image." + rMIPerfExplorerModel.toShortString() + ".png");
        try {
            ChartUtilities.saveChartAsPNG((File)file, (JFreeChart)jFreeChart, (int)500, (int)500);
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
            iOException.printStackTrace();
        }
        return file;
    }

    public static File generateClusterSizeThumbnail(RMIPerfExplorerModel rMIPerfExplorerModel, int[] nArray) {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        for (int i = 0; i < nArray.length; ++i) {
            defaultCategoryDataset.addValue((double)nArray[i], (Comparable)((Object)"Threads in cluster"), (Comparable)((Object)new String(Integer.toString(i))));
        }
        JFreeChart jFreeChart = ChartFactory.createStackedBarChart(null, null, null, (CategoryDataset)defaultCategoryDataset, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)false, (boolean)true, (boolean)false);
        Utility.applyDefaultChartTheme((JFreeChart)jFreeChart);
        File file = new File(Constants.TMPDIR + "thumbnail." + rMIPerfExplorerModel.toShortString() + ".png");
        try {
            ChartUtilities.saveChartAsPNG((File)file, (JFreeChart)jFreeChart, (int)100, (int)100);
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
            iOException.printStackTrace();
        }
        return file;
    }

    public static File generateClusterSizeImage(RMIPerfExplorerModel rMIPerfExplorerModel, int[] nArray) {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        for (int i = 0; i < nArray.length; ++i) {
            defaultCategoryDataset.addValue((double)nArray[i], (Comparable)((Object)"Threads in cluster"), (Comparable)((Object)new String(Integer.toString(i))));
        }
        JFreeChart jFreeChart = ChartFactory.createStackedBarChart((String)rMIPerfExplorerModel.toString(), (String)"Cluster Number", (String)"Threads in cluster", (CategoryDataset)defaultCategoryDataset, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)true, (boolean)true, (boolean)false);
        Utility.applyDefaultChartTheme((JFreeChart)jFreeChart);
        File file = new File(Constants.TMPDIR + "image." + rMIPerfExplorerModel.toShortString() + ".png");
        try {
            ChartUtilities.saveChartAsPNG((File)file, (JFreeChart)jFreeChart, (int)500, (int)500);
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
            iOException.printStackTrace();
        }
        return file;
    }

    public static File generateClusterScatterplotThumbnail(ChartType chartType, RMIPerfExplorerModel rMIPerfExplorerModel, RawDataInterface[] rawDataInterfaceArray) {
        File file = null;
        if (chartType == ChartType.PCA_SCATTERPLOT) {
            PCAPlotDataset pCAPlotDataset = new PCAPlotDataset(rawDataInterfaceArray, false);
            JFreeChart jFreeChart = ChartFactory.createScatterPlot(null, null, null, (XYDataset)pCAPlotDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
            file = new File(Constants.TMPDIR + "thumbnail." + rMIPerfExplorerModel.toShortString() + ".png");
            try {
                ChartUtilities.saveChartAsPNG((File)file, (JFreeChart)jFreeChart, (int)100, (int)100);
            }
            catch (IOException iOException) {
                System.err.println(iOException.getMessage());
                iOException.printStackTrace();
            }
        }
        return file;
    }

    public static File generateClusterScatterplotImage(ChartType chartType, RMIPerfExplorerModel rMIPerfExplorerModel, RawDataInterface rawDataInterface, RawDataInterface[] rawDataInterfaceArray, boolean bl) {
        File file = null;
        if (chartType == ChartType.PCA_SCATTERPLOT) {
            PCAPlotDataset pCAPlotDataset = new PCAPlotDataset(rawDataInterfaceArray, bl);
            JFreeChart jFreeChart = ChartFactory.createScatterPlot((String)"Correlation Results", (String)Utility.shortenFunctionName((String)rawDataInterface.getEventNames().get(0)), (String)Utility.shortenFunctionName((String)rawDataInterface.getEventNames().get(1)), (XYDataset)pCAPlotDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
            Utility.applyDefaultChartTheme((JFreeChart)jFreeChart);
            if (bl) {
                XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
                XYItemRenderer xYItemRenderer = xYPlot.getRenderer();
                xYItemRenderer.setSeriesPaint(rawDataInterfaceArray.length - 1, (Paint)Color.black);
            }
            file = new File(Constants.TMPDIR + "image." + rMIPerfExplorerModel.toShortString() + ".png");
            try {
                ChartUtilities.saveChartAsPNG((File)file, (JFreeChart)jFreeChart, (int)500, (int)500);
            }
            catch (IOException iOException) {
                System.err.println(iOException.getMessage());
                iOException.printStackTrace();
            }
        }
        return file;
    }

    public static File generateCorrelationScatterplotThumbnail(ChartType chartType, RMIPerfExplorerModel rMIPerfExplorerModel, RawDataInterface rawDataInterface, int n, int n2, boolean bl) {
        File file = null;
        if (chartType == ChartType.CORRELATION_SCATTERPLOT) {
            DataNormalizer dataNormalizer = AnalysisFactory.createDataNormalizer(rawDataInterface);
            RawDataInterface rawDataInterface2 = dataNormalizer.getNormalizedData();
            ScatterPlotDataset scatterPlotDataset = new ScatterPlotDataset(rawDataInterface2, rMIPerfExplorerModel.toString(), n, n2, bl);
            JFreeChart jFreeChart = ChartFactory.createScatterPlot(null, null, null, (XYDataset)scatterPlotDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
            file = new File(Constants.TMPDIR + "thumbnail." + rMIPerfExplorerModel.toShortString() + ".png");
            try {
                ChartUtilities.saveChartAsPNG((File)file, (JFreeChart)jFreeChart, (int)100, (int)100);
            }
            catch (IOException iOException) {
                System.err.println(iOException.getMessage());
                iOException.printStackTrace();
            }
        }
        return file;
    }

    public static File generateCorrelationScatterplotImage(ChartType chartType, RMIPerfExplorerModel rMIPerfExplorerModel, RawDataInterface rawDataInterface, int n, int n2, boolean bl, double d) {
        File file = null;
        if (chartType == ChartType.CORRELATION_SCATTERPLOT) {
            XYDataset xYDataset;
            DataNormalizer dataNormalizer = AnalysisFactory.createDataNormalizer(rawDataInterface);
            RawDataInterface rawDataInterface2 = dataNormalizer.getNormalizedData();
            ScatterPlotDataset scatterPlotDataset = new ScatterPlotDataset(rawDataInterface2, rMIPerfExplorerModel.toString(), n, n2, bl);
            NumberAxis numberAxis = new NumberAxis(Utility.shortenFunctionName((String)rawDataInterface2.getEventNames().get(n)));
            numberAxis.setAutoRangeIncludesZero(false);
            NumberAxis numberAxis2 = null;
            numberAxis2 = bl ? new NumberAxis(rawDataInterface2.getMainEventName()) : new NumberAxis(Utility.shortenFunctionName((String)rawDataInterface2.getEventNames().get(n2)));
            numberAxis2.setAutoRangeIncludesZero(false);
            StandardXYItemRenderer standardXYItemRenderer = new StandardXYItemRenderer(1);
            standardXYItemRenderer.setBaseShapesFilled(true);
            if (bl) {
                standardXYItemRenderer.setSeriesPaint(0, (Paint)Color.green);
            }
            XYPlot xYPlot = new XYPlot((XYDataset)scatterPlotDataset, (ValueAxis)numberAxis, (ValueAxis)numberAxis2, (XYItemRenderer)standardXYItemRenderer);
            double[] dArray = Regression.getOLSRegression((XYDataset)scatterPlotDataset, (int)0);
            LineFunction2D lineFunction2D = new LineFunction2D(dArray[0], dArray[1]);
            Range range = DatasetUtilities.findDomainBounds((XYDataset)scatterPlotDataset);
            if (range != null) {
                xYDataset = DatasetUtilities.sampleFunction2D((Function2D)lineFunction2D, (double)range.getLowerBound(), (double)range.getUpperBound(), (int)100, (Comparable)((Object)"Fitted Linear Regression Line"));
                xYPlot.setDataset(1, xYDataset);
                StandardXYItemRenderer standardXYItemRenderer2 = new StandardXYItemRenderer();
                standardXYItemRenderer2.setSeriesPaint(0, (Paint)Color.blue);
                standardXYItemRenderer2.setBaseShapesVisible(false);
                xYPlot.setRenderer(1, (XYItemRenderer)standardXYItemRenderer2);
            }
            if (range != null) {
                xYPlot.getDomainAxis().setRange(range);
                xYPlot.getRangeAxis().setRange(range);
            }
            xYDataset = new JFreeChart("Correlation Results: r = " + d, JFreeChart.DEFAULT_TITLE_FONT, (Plot)xYPlot, true);
            Utility.applyDefaultChartTheme((JFreeChart)xYDataset);
            file = new File(Constants.TMPDIR + "image." + rMIPerfExplorerModel.toShortString() + ".png");
            try {
                ChartUtilities.saveChartAsPNG((File)file, (JFreeChart)xYDataset, (int)500, (int)500);
            }
            catch (IOException iOException) {
                System.err.println(iOException.getMessage());
                iOException.printStackTrace();
            }
        }
        return file;
    }
}

