/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.client;

import edu.uoregon.tau.common.Utility;
import edu.uoregon.tau.perfdmf.Application;
import edu.uoregon.tau.perfdmf.Experiment;
import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfexplorer.client.PECategoryDataset;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerChart;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerClient;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerConnection;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerModel;
import edu.uoregon.tau.perfexplorer.client.ScriptFacade;
import edu.uoregon.tau.perfexplorer.common.ChartDataType;
import edu.uoregon.tau.perfexplorer.common.RMIGeneralChartData;
import edu.uoregon.tau.perfexplorer.common.TransformationType;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalComboBoxUI;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.LogarithmicAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.SeriesException;
import org.jfree.data.xy.DefaultTableXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;

public class ChartPane
extends JScrollPane
implements ActionListener {
    private static final String IDEAL = "Ideal";
    private static final long serialVersionUID = -8971827392560223964L;
    private static ChartPane thePane = null;
    private PerfExplorerConnection server = null;
    private JPanel mainPanel = null;
    private ScriptFacade facade = null;
    private JCheckBox mainOnly = new JCheckBox("Main Only");
    private JCheckBox callPath = new JCheckBox("Call Paths");
    private JCheckBox logY = new JCheckBox("Log Y");
    JRadioButton valueRB = new JRadioButton("Value Chart");
    JRadioButton scalaRB = new JRadioButton("Scalability Chart");
    JRadioButton efficRB = new JRadioButton("Efficency Chart");
    ButtonGroup chartType = new ButtonGroup();
    JRadioButton strongScaling = new JRadioButton("Strong Scaling");
    JRadioButton weakScaling = new JRadioButton("Weak Scaling");
    ButtonGroup scalingType = new ButtonGroup();
    private JCheckBox horizontal = new JCheckBox("Horizontal");
    private JCheckBox showZero = new JCheckBox("Show Y-Axis Zero");
    private List<String> tableColumns = null;
    private JLabel titleLabel = new JLabel("Chart Title:");
    private JTextField chartTitle = new MyJTextField(5);
    private JLabel seriesLabel = new JLabel("Series Name/Value:");
    private JComboBox series = null;
    private JLabel xaxisNameLabel = new JLabel("X Axis Name:");
    private JTextField xaxisName = new MyJTextField(5);
    private JLabel yaxisNameLabel = new JLabel("Y Axis Name:");
    private JTextField yaxisName = new MyJTextField(5);
    private JLabel xaxisValueLabel = new JLabel("X Axis Value:");
    private JComboBox xaxisValue = null;
    private JLabel yaxisStatLabel = new JLabel("Y Axis Statistic:");
    private JComboBox yaxisStat = null;
    private JLabel yaxisValueLabel = new JLabel("Y Axis Value:");
    private JComboBox yaxisValue = null;
    private JLabel dimensionLabel = new JLabel("Dimension Reduction Type:");
    private JComboBox dimension = new MyJComboBox();
    private JLabel dimensionXLabel = new JLabel("Cutoff (0<x<100):");
    private JTextField dimensionXValue = new MyJTextField(5);
    private JLabel eventLabel = new JLabel("Interval Event:");
    private JList event = null;
    private JScrollPane eventScrollPane = null;
    private JLabel metricLabel = new JLabel("Metric:");
    private JComboBox metric = new MyJComboBox();
    private JLabel unitsLabel = new JLabel("Units:");
    private JComboBox units = new MyJComboBox();
    private JLabel seriesXmlNameLabel = new JLabel("Series XML Field:");
    private JComboBox seriesXmlName = new MyJComboBox();
    private JLabel xmlNameLabel = new JLabel("X Axis XML Field:");
    private JComboBox xmlName = new MyJComboBox();
    private JCheckBox angleXLabels = new JCheckBox("Angle X Axis Labels");
    private JCheckBox alwaysCategory = new JCheckBox("Categorical X Axis");
    private JCheckBox logX = new JCheckBox("Log X");
    private String[] unitOptions = new String[]{"microseconds", "milliseconds", "seconds", "minutes", "hours", "units", "thousands (x 1.0E3)", "millions (x 1.0E6)", "billions (x 1.0E9)", "trillions (x 1.0E12)"};
    private JButton apply = null;
    private JCheckBox exportdata = null;
    private JButton reset = null;
    private JFileChooser fc = new JFileChooser(System.getProperty("user.dir"));
    private static final String ATOMIC_EVENT_ALL = "All Atomic Events";
    private static final String INTERVAL_EVENT_ALL = "All Events";
    private static final String INTERVAL_EVENT_GROUP_ALL = "All Groups";
    private static final String ATOMIC_EVENT_NAME = "atomic_event.name";
    private static final String INTERVAL_EVENT_NAME = "interval_event.name";
    private static final String INTERVAL_EVENT_GROUP_NAME = "interval_event.group_name";
    private static final String EXPERIMENT_NAME = "experiment.name";
    private static final String EXPERIMENT_ID = "experiment.id";
    private static final String TOTAL = "total";
    private static final String MEAN = "mean";
    private static final String MAX = "max";
    private static final String MIN = "min";
    private static final String AVG = "avg";
    private static final String ATOMIC = "atomic";
    private static final String INCLUSIVE = "inclusive";
    private static final String EXCLUSIVE = "exclusive";

    public static ChartPane getPane() {
        if (thePane == null) {
            JPanel jPanel = new JPanel(new GridLayout(1, 3, 10, 5));
            thePane = new ChartPane(jPanel);
        }
        thePane.repaint();
        return thePane;
    }

    private ChartPane(JPanel jPanel) {
        super(jPanel);
        this.server = PerfExplorerConnection.getConnection();
        this.mainPanel = jPanel;
        this.facade = new ScriptFacade();
        JScrollBar jScrollBar = this.getVerticalScrollBar();
        jScrollBar.setUnitIncrement(35);
        this.tableColumns = this.server.getChartFieldNames();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.add(this.createChartTypeMenu());
        jPanel2.add(Box.createVerticalStrut(10));
        jPanel2.add(this.createDataMenu());
        jPanel2.add(Box.createVerticalStrut(10));
        jPanel2.add(this.createButtonMenu());
        this.mainPanel.add((Component)jPanel2, "West");
        jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.add(this.createXAxisMenu());
        jPanel2.add(Box.createVerticalStrut(10));
        jPanel2.add(this.createYAxisMenu());
        this.mainPanel.add((Component)jPanel2, "Center");
        jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.add(this.createSeriesMenu());
        jPanel2.add(Box.createVerticalStrut(10));
        jPanel2.add(this.createDimensionReductionMenu());
        this.mainPanel.add((Component)jPanel2, "South");
        this.resetChartSettings();
    }

    private JPanel createDimensionReductionMenu() {
        JPanel jPanel = new JPanel();
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Dimension Reduction");
        jPanel.setBorder(titledBorder);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(Box.createVerticalStrut(10));
        jPanel.add(this.dimensionLabel);
        Object[] objectArray = TransformationType.getDimensionReductions();
        this.dimension = new MyJComboBox(objectArray);
        this.dimension.addActionListener(this);
        this.dimension.addActionListener(this);
        jPanel.add(this.dimension);
        jPanel.add(Box.createVerticalStrut(10));
        jPanel.add(this.dimensionXLabel);
        this.dimensionXValue.addActionListener(this);
        jPanel.add(this.dimensionXValue);
        return jPanel;
    }

    private JPanel createDataMenu() {
        JPanel jPanel = new JPanel();
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Chart Data");
        jPanel.setBorder(titledBorder);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(Box.createVerticalStrut(10));
        jPanel.add(this.titleLabel);
        this.chartTitle.addActionListener(this);
        jPanel.add(this.chartTitle);
        jPanel.add(Box.createVerticalStrut(10));
        jPanel.add(this.metricLabel);
        this.metric = new MyJComboBox();
        this.metric.addActionListener(this);
        jPanel.add(this.metric);
        jPanel.add(Box.createVerticalStrut(10));
        jPanel.add(this.unitsLabel);
        this.units = new MyJComboBox(this.unitOptions);
        this.units.addActionListener(this);
        this.units.setSelectedIndex(2);
        jPanel.add(this.units);
        jPanel.add(Box.createVerticalStrut(10));
        jPanel.add(this.eventLabel);
        this.event = new JList();
        this.eventScrollPane = new JScrollPane(this.event);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add(this.eventScrollPane);
        jPanel.add(jPanel2);
        jPanel.add(Box.createVerticalStrut(10));
        this.mainOnly.setToolTipText("Only select the \"main\" event (i.e. maximum inclusive)");
        this.mainOnly.addActionListener(this);
        jPanel.add(this.mainOnly);
        jPanel.add(Box.createVerticalStrut(10));
        this.callPath.setToolTipText("Include \"call path\" events (i.e. main() => foo())");
        this.callPath.addActionListener(this);
        jPanel.add(this.callPath);
        return jPanel;
    }

    private JPanel createXAxisMenu() {
        JPanel jPanel = new JPanel();
        TitledBorder titledBorder = BorderFactory.createTitledBorder("X Axis");
        jPanel.setBorder(titledBorder);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(Box.createVerticalStrut(10));
        jPanel.add(this.xaxisNameLabel);
        this.xaxisName.addActionListener(this);
        jPanel.add(this.xaxisName);
        jPanel.add(Box.createVerticalStrut(10));
        jPanel.add(this.xaxisValueLabel);
        this.xaxisValue = new MyJComboBox(this.tableColumns.toArray());
        this.xaxisValue.addActionListener(this);
        jPanel.add(this.xaxisValue);
        jPanel.add(Box.createVerticalStrut(10));
        jPanel.add(this.xmlNameLabel);
        this.xmlName = new MyJComboBox();
        this.xmlName.addActionListener(this);
        jPanel.add(this.xmlName);
        jPanel.add(Box.createVerticalStrut(10));
        jPanel.add(this.angleXLabels);
        jPanel.add(Box.createVerticalStrut(10));
        jPanel.add(this.alwaysCategory);
        jPanel.add(Box.createVerticalStrut(10));
        jPanel.add(this.logX);
        this.logX.setToolTipText("Use a Logarithmic X axis");
        this.logX.addActionListener(this);
        return jPanel;
    }

    private JPanel createYAxisMenu() {
        JPanel jPanel = new JPanel();
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Y Axis");
        jPanel.setBorder(titledBorder);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(Box.createVerticalStrut(10));
        jPanel.add(this.yaxisNameLabel);
        this.yaxisName.addActionListener(this);
        jPanel.add(this.yaxisName);
        jPanel.add(Box.createVerticalStrut(10));
        jPanel.add(this.yaxisStatLabel);
        Object[] objectArray = new String[]{"tmp"};
        this.yaxisStat = new MyJComboBox(objectArray);
        this.yaxisStat.addActionListener(this);
        this.yaxisValue = new MyJComboBox(objectArray);
        this.yaxisValue.addActionListener(this);
        this.resetYAxisValues(true);
        jPanel.add(this.yaxisStat);
        jPanel.add(this.yaxisValueLabel);
        jPanel.add(this.yaxisValue);
        jPanel.add(Box.createVerticalStrut(10));
        this.logY.setToolTipText("Use a Logarithmic Y axis");
        this.logY.addActionListener(this);
        jPanel.add(this.logY);
        jPanel.add(Box.createVerticalStrut(10));
        this.showZero.setToolTipText("Include zero value in y-axis range");
        this.showZero.addActionListener(this);
        jPanel.add(this.showZero);
        return jPanel;
    }

    private JPanel createSeriesMenu() {
        JPanel jPanel = new JPanel();
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Series");
        jPanel.setBorder(titledBorder);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(Box.createVerticalStrut(10));
        jPanel.add(this.seriesLabel);
        this.series = new MyJComboBox(this.tableColumns.toArray());
        this.series.addItem(INTERVAL_EVENT_NAME);
        this.series.addItem(INTERVAL_EVENT_GROUP_NAME);
        this.series.addItem(ATOMIC_EVENT_NAME);
        this.series.addActionListener(this);
        jPanel.add(this.series);
        jPanel.add(Box.createVerticalStrut(10));
        jPanel.add(this.seriesXmlNameLabel);
        this.seriesXmlName = new MyJComboBox();
        this.seriesXmlName.addActionListener(this);
        jPanel.add(this.seriesXmlName);
        return jPanel;
    }

    private JPanel createChartTypeMenu() {
        JPanel jPanel = new JPanel();
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Chart Type");
        jPanel.setBorder(titledBorder);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setAlignmentX(0.5f);
        jPanel.add(Box.createVerticalStrut(10));
        jPanel.add(this.valueRB);
        jPanel.add(this.scalaRB);
        jPanel.add(this.efficRB);
        this.chartType.add(this.valueRB);
        this.chartType.add(this.scalaRB);
        this.chartType.add(this.efficRB);
        jPanel.add(Box.createVerticalStrut(10));
        jPanel.add(this.weakScaling);
        jPanel.add(this.strongScaling);
        this.scalingType.add(this.strongScaling);
        this.scalingType.add(this.weakScaling);
        jPanel.add(Box.createVerticalStrut(10));
        this.horizontal.setToolTipText("Create a horizontal chart");
        this.horizontal.addActionListener(this);
        jPanel.add(this.horizontal);
        return jPanel;
    }

    private JPanel createButtonMenu() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        this.exportdata = new JCheckBox("Export");
        this.exportdata.setToolTipText("Export chart data to file");
        this.exportdata.addActionListener(this);
        jPanel.add(this.exportdata);
        this.apply = new JButton("Apply");
        this.apply.setToolTipText("Apply changes and redraw chart");
        this.apply.addActionListener(this);
        jPanel.add(this.apply);
        this.reset = new JButton("Reset");
        this.reset.setToolTipText("Change back to default settings");
        this.reset.addActionListener(this);
        jPanel.add(this.reset);
        return jPanel;
    }

    private void resetChartSettings() {
        this.mainOnly.setSelected(true);
        this.callPath.setSelected(false);
        this.logY.setSelected(false);
        this.logX.setSelected(false);
        this.exportdata.setSelected(false);
        this.valueRB.setSelected(true);
        this.weakScaling.setSelected(true);
        this.horizontal.setSelected(false);
        this.showZero.setSelected(true);
        this.dimension.setSelectedIndex(0);
        this.dimensionXLabel.setEnabled(false);
        this.dimensionXValue.setEnabled(false);
        this.eventLabel.setEnabled(false);
        this.event.setEnabled(false);
        this.seriesXmlNameLabel.setEnabled(false);
        this.seriesXmlName.setEnabled(false);
        this.xmlNameLabel.setEnabled(false);
        this.xmlName.setEnabled(false);
        this.seriesXmlNameLabel.setEnabled(false);
        this.seriesXmlName.setEnabled(false);
        for (String string : this.tableColumns) {
            String string2 = string;
            if (string2.equalsIgnoreCase(EXPERIMENT_NAME)) {
                this.series.setSelectedItem(string);
                continue;
            }
            if (!string2.equalsIgnoreCase("trial.threads_of_execution")) continue;
            this.xaxisValue.setSelectedItem(string);
        }
        this.yaxisValue.setSelectedIndex(0);
        this.yaxisStat.setSelectedIndex(0);
        this.refreshDynamicControls(true, true, false);
    }

    private void refreshEventList(PerfExplorerModel perfExplorerModel, String string, String string2) {
        Object[] objectArray = null;
        Object[] objectArray2 = null;
        objectArray = this.event.getSelectedValues();
        objectArray2 = objectArray != null ? objectArray : new Object[]{};
        int n = this.eventScrollPane.getWidth();
        List<String> list = null;
        list = string2.equals(INTERVAL_EVENT_GROUP_ALL) ? this.server.getPotentialGroups(perfExplorerModel) : (string2.equals(ATOMIC_EVENT_ALL) ? this.server.getPotentialAtomicEvents(perfExplorerModel) : (string2.equals(INTERVAL_EVENT_ALL) ? this.server.getPotentialEvents(perfExplorerModel) : new ArrayList<String>()));
        if (!perfExplorerModel.getEventNoCallpath()) {
            List<String> list2 = this.server.getPotentialCallPathEvents(perfExplorerModel);
            for (String string3 : list2) {
                list.add(string3);
            }
        }
        this.event.removeAll();
        list.add(0, string2);
        this.eventLabel.setText(string);
        this.event.setSelectedIndex(0);
        int n2 = 0;
        this.event.setListData(list.toArray());
        this.eventScrollPane.setPreferredSize(new Dimension(n, this.eventScrollPane.getHeight()));
        for (String string3 : list) {
            List<Object> list3 = Arrays.asList(objectArray2);
            if (list3.contains(string3)) {
                this.event.addSelectionInterval(n2, n2);
            }
            ++n2;
        }
    }

    public void refreshDynamicControls(boolean bl, boolean bl2, boolean bl3) {
        PerfExplorerModel perfExplorerModel = PerfExplorerModel.getModel();
        Object object = perfExplorerModel.getCurrentSelection();
        String string = "";
        String string2 = "";
        String string3 = "";
        Object object2 = null;
        if (bl) {
            object2 = this.metric.getSelectedItem();
            if (object2 != null) {
                string = (String)object2;
            }
            this.metric.removeAllItems();
        }
        if (bl3) {
            object2 = this.xmlName.getSelectedItem();
            if (object2 != null) {
                string2 = (String)object2;
            }
            this.xmlName.removeAllItems();
            object2 = this.seriesXmlName.getSelectedItem();
            if (object2 != null) {
                string3 = (String)object2;
            }
            this.seriesXmlName.removeAllItems();
        }
        if (object instanceof Application || object instanceof Experiment || object instanceof Trial) {
            List<String> list;
            Object object3;
            Object object4;
            if (bl) {
                object4 = this.server.getPotentialMetrics(perfExplorerModel);
                object3 = object4.iterator();
                while (object3.hasNext()) {
                    list = object3.next();
                    this.metric.addItem(list);
                    if (!string.equals(list)) continue;
                    this.metric.setSelectedItem(list);
                }
            }
            if (bl2 && !this.mainOnly.isSelected()) {
                object4 = (String)this.series.getSelectedItem();
                if (((String)object4).equalsIgnoreCase(INTERVAL_EVENT_GROUP_NAME)) {
                    this.resetYAxisValues(true);
                    this.yaxisStat.setSelectedItem(MEAN);
                    this.yaxisValue.setSelectedItem(EXCLUSIVE);
                    this.refreshEventList(perfExplorerModel, "Groups:", INTERVAL_EVENT_GROUP_ALL);
                } else if (((String)object4).equalsIgnoreCase(ATOMIC_EVENT_NAME)) {
                    this.resetYAxisValues(false);
                    this.refreshEventList(perfExplorerModel, "Atomic Events:", ATOMIC_EVENT_ALL);
                } else {
                    this.refreshEventList(perfExplorerModel, "Events:", INTERVAL_EVENT_ALL);
                }
            }
            if (bl3) {
                object4 = (String)this.series.getSelectedItem();
                object3 = (String)this.xaxisValue.getSelectedItem();
                list = null;
                if (((String)object3).equalsIgnoreCase("trial.xml_metadata")) {
                    list = this.server.getXMLFields(perfExplorerModel);
                    for (String string4 : list) {
                        this.xmlName.addItem(string4);
                        if (string2.equals("") && string4.equalsIgnoreCase("UTC Time")) {
                            this.xmlName.setSelectedItem(string4);
                            continue;
                        }
                        if (!string2.equals(string4)) continue;
                        this.xmlName.setSelectedItem(string4);
                    }
                }
                if (((String)object4).equalsIgnoreCase("trial.xml_metadata")) {
                    if (list == null) {
                        list = this.server.getXMLFields(perfExplorerModel);
                    }
                    for (String string4 : list) {
                        this.seriesXmlName.addItem(string4);
                        if (string3.equals("") && string4.equalsIgnoreCase("UTC Time")) {
                            this.seriesXmlName.setSelectedItem(string4);
                            continue;
                        }
                        if (!string3.equals(string4)) continue;
                        this.seriesXmlName.setSelectedItem(string4);
                    }
                }
            }
        }
    }

    private void resetYAxisValues(boolean bl) {
        Object object = this.yaxisValue.getSelectedItem();
        Object object2 = this.yaxisStat.getSelectedItem();
        this.yaxisValue.removeAllItems();
        this.yaxisStat.removeAllItems();
        if (bl) {
            this.yaxisStat.addItem(MEAN);
            this.yaxisStat.addItem(TOTAL);
            this.yaxisStat.addItem(MAX);
            this.yaxisStat.addItem(MIN);
            this.yaxisStat.addItem(AVG);
            this.yaxisValue.addItem(INCLUSIVE);
            this.yaxisValue.addItem(EXCLUSIVE);
            this.yaxisValue.addItem("inclusive_percentage");
            this.yaxisValue.addItem("exclusive_percentage");
            this.yaxisValue.addItem("call");
            this.yaxisValue.addItem("subroutines");
            this.yaxisValue.addItem("inclusive_per_call");
            this.yaxisValue.addItem("sum_exclusive_squared");
        } else {
            this.yaxisStat.addItem(ATOMIC);
            this.yaxisValue.addItem("sample_count");
            this.yaxisValue.addItem("maximum_value");
            this.yaxisValue.addItem("minimum_value");
            this.yaxisValue.addItem("mean_value");
            this.yaxisValue.addItem("standard_deviation");
            this.yaxisValue.setSelectedItem("mean_value");
        }
        this.yaxisValue.setSelectedItem(object);
        this.yaxisStat.setSelectedItem(object2);
    }

    private void updateYAxis() {
        String string;
        String string2;
        String string3 = (String)this.yaxisStat.getSelectedItem();
        String string4 = (String)this.yaxisValue.getSelectedItem();
        String string5 = AVG;
        if (string3.equals(ATOMIC)) {
            string2 = "atomic_location_profile." + string4;
        } else if (string3.equals(MEAN)) {
            string2 = "interval_mean_summary." + string4;
        } else if (string3.equals(TOTAL)) {
            string2 = "interval_total_summary." + string4;
        } else {
            string5 = string3;
            string2 = "interval_location_profile." + string4;
        }
        if (!this.mainOnly.isSelected() && (string = (String)this.series.getSelectedItem()).equalsIgnoreCase(INTERVAL_EVENT_GROUP_NAME)) {
            string5 = "sum";
        }
        string2 = string5 + "(" + string2 + ")";
        String string6 = this.yaxisName.getText();
        if (string6 == null || string6.length() == 0) {
            string = (String)this.series.getSelectedItem();
            if (this.scalaRB.isSelected()) {
                string6 = "Speedup Factor";
            } else if (this.efficRB.isSelected()) {
                string6 = "Efficiency (%) ";
            } else if (string.equalsIgnoreCase(ATOMIC_EVENT_NAME)) {
                string6 = (String)this.yaxisStat.getSelectedItem() + "." + (String)this.yaxisValue.getSelectedItem();
                string6 = string6 + " - " + (String)this.units.getSelectedItem();
            } else {
                String string7 = string5;
                if (string3.equals(MEAN)) {
                    string7 = "Mean";
                } else if (string3.equals(TOTAL)) {
                    string7 = "Total";
                }
                string6 = string7 + " " + (String)this.metric.getSelectedItem();
                string6 = string6 + " - " + (String)this.units.getSelectedItem();
            }
        } else {
            string6 = string6 + " - " + (String)this.units.getSelectedItem();
        }
        this.facade.setChartYAxisName(string2, string6);
    }

    private void updateChart() {
        Object object;
        Object object2;
        String string;
        Object object3;
        this.facade.resetChartDefaults();
        String string2 = this.chartTitle.getText();
        if (string2.length() == 0) {
            object3 = this.series.getSelectedItem();
            string = (String)object3;
            if (string.equalsIgnoreCase(ATOMIC_EVENT_NAME)) {
                string2 = "Atomic Events";
                string2 = string2 + " : " + (String)this.yaxisStat.getSelectedItem() + "." + (String)this.yaxisValue.getSelectedItem();
            } else {
                string2 = (String)this.metric.getSelectedItem();
            }
            object2 = this.strongScaling.isSelected() ? "(Strong Scaling): " : "(Weak Scaling): ";
            string2 = this.scalaRB.isSelected() ? "Relative Speedup " + (String)object2 + string2 : (this.efficRB.isSelected() ? "Efficiency " + (String)object2 + string2 : "Value Chart: " + string2);
        }
        this.facade.setChartTitle(string2);
        object3 = this.series.getSelectedItem();
        string = (String)object3;
        this.facade.setChartSeriesXML(false);
        if (string.equalsIgnoreCase("trial.threads_of_execution")) {
            string = "trial.node_count * trial.contexts_per_node * trial.threads_per_context";
        } else if (string.equalsIgnoreCase("trial.XML_METADATA")) {
            string = "temp_xml_metadata.metadata_value";
            object2 = this.seriesXmlName.getSelectedItem();
            object = (String)object2;
            this.facade.setChartMetadataFieldName((String)object);
            string = object;
            this.facade.setChartSeriesXML(true);
        }
        this.facade.setChartSeriesName(string);
        object3 = this.xaxisValue.getSelectedItem();
        string = (String)object3;
        object2 = null;
        if (string.equalsIgnoreCase("trial.threads_of_execution")) {
            string = "trial.node_count * trial.contexts_per_node * trial.threads_per_context";
        } else if (string.equalsIgnoreCase("trial.XML_METADATA")) {
            string = "temp_xml_metadata.metadata_value";
            object = this.xmlName.getSelectedItem();
            object2 = (String)object;
            this.facade.setChartMetadataFieldName((String)object2);
            this.facade.setChartMetadataFieldValue(null);
        }
        object = this.xaxisName.getText();
        if (object == null || ((String)object).length() == 0) {
            object = string.equalsIgnoreCase("temp_xml_metadata.metadata_value") ? object2 : string;
        }
        this.facade.setChartXAxisName(string, (String)object);
        this.updateYAxis();
        object3 = this.metric.getSelectedItem();
        string = (String)object3;
        this.facade.setMetricName(string);
        object3 = this.units.getSelectedItem();
        string = (String)object3;
        this.facade.setChartUnits(string);
        object3 = this.dimension.getSelectedItem();
        TransformationType transformationType = (TransformationType)object3;
        if (transformationType == TransformationType.OVER_X_PERCENT) {
            object = this.dimensionXValue.getText();
            if (object == null || ((String)object).length() == 0) {
                this.facade.setDimensionReduction(TransformationType.NONE, null);
            } else {
                this.facade.setDimensionReduction(TransformationType.OVER_X_PERCENT, (String)object);
            }
        } else {
            this.facade.setDimensionReduction(TransformationType.NONE, null);
        }
        this.facade.setChartMainEventOnly(this.mainOnly.isSelected() ? 1 : 0);
        if (!this.mainOnly.isSelected()) {
            object3 = this.series.getSelectedItem();
            string = (String)object3;
            this.facade.setEventName(null);
            this.facade.setGroupName(null);
            if (string.equalsIgnoreCase(INTERVAL_EVENT_NAME) || string.equalsIgnoreCase(EXPERIMENT_NAME) || string.equalsIgnoreCase(EXPERIMENT_ID)) {
                this.setEvents(INTERVAL_EVENT_ALL);
            } else if (string.equalsIgnoreCase(INTERVAL_EVENT_GROUP_NAME)) {
                this.setEvents(INTERVAL_EVENT_GROUP_ALL);
            } else if (string.equalsIgnoreCase(ATOMIC_EVENT_NAME)) {
                this.setEvents(ATOMIC_EVENT_ALL);
            }
        }
        this.facade.setChartEventNoCallPath(this.callPath.isSelected() ? 0 : 1);
        this.facade.setChartLogYAxis(this.logY.isSelected() ? 1 : 0);
        this.facade.setChartLogXAxis(this.logX.isSelected() ? 1 : 0);
        this.facade.setChartScalability(this.scalaRB.isSelected() ? 1 : 0);
        this.facade.setChartEfficiency(this.efficRB.isSelected() ? 1 : 0);
        this.facade.setChartConstantProblem(this.strongScaling.isSelected() ? 0 : 1);
        this.facade.setChartHorizontal(this.horizontal.isSelected() ? 1 : 0);
        this.facade.setShowZero(this.showZero.isSelected() ? 1 : 0);
        try {
            this.doGeneralChart();
        }
        catch (SeriesException seriesException) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Two or more trials in this selection have the same total number of threads of execution, and an error occurred.\n");
            stringBuilder.append("To create a scalability chart, please ensure the trials selected have different numbers of threads.\n");
            JOptionPane.showMessageDialog(PerfExplorerClient.getMainFrame(), stringBuilder.toString(), "Selection Warning", 0);
        }
        catch (Exception exception) {
            System.err.println("actionPerformed Exception: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    private void setEvents(String string) {
        Object[] objectArray = this.event.getSelectedValues();
        if (!objectArray[0].equals(string)) {
            for (int i = 0; i < objectArray.length; ++i) {
                this.facade.addEventName((String)objectArray[i]);
            }
        } else {
            this.facade.setEventName(null);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.apply) {
            PerfExplorerModel perfExplorerModel = PerfExplorerModel.getModel();
            Object object2 = perfExplorerModel.getCurrentSelection();
            if (object2 instanceof Application || object2 instanceof Experiment || object2 instanceof Trial) {
                this.updateChart();
            } else {
                JOptionPane.showMessageDialog(PerfExplorerClient.getMainFrame(), "Please select one or more Applications, Experiments or Trials.", "Selection Error", 0);
            }
        } else if (object == this.reset) {
            this.resetChartSettings();
        } else if (object == this.mainOnly) {
            if (this.mainOnly.isSelected()) {
                this.eventLabel.setEnabled(false);
                this.event.setEnabled(false);
                this.series.setSelectedItem(EXPERIMENT_NAME);
                this.yaxisValue.setSelectedItem(INCLUSIVE);
            } else {
                this.eventLabel.setEnabled(true);
                this.event.setEnabled(true);
                this.series.setSelectedItem(INTERVAL_EVENT_NAME);
                this.resetYAxisValues(true);
                this.yaxisStat.setSelectedItem(MEAN);
                this.yaxisValue.setSelectedItem(EXCLUSIVE);
                this.refreshDynamicControls(false, true, false);
            }
        } else if (object == this.callPath) {
            this.facade.setChartEventNoCallPath(this.callPath.isSelected() ? 0 : 1);
            this.refreshDynamicControls(false, true, false);
        } else if (object == this.dimension) {
            if (this.dimension.getSelectedIndex() == 0) {
                this.dimensionXLabel.setEnabled(false);
                this.dimensionXValue.setEnabled(false);
            } else {
                this.dimensionXLabel.setEnabled(true);
                this.dimensionXValue.setEnabled(true);
            }
        } else if (object == this.series || object == this.xaxisValue) {
            Object object3 = this.series.getSelectedItem();
            String string = (String)object3;
            Object object4 = this.xaxisValue.getSelectedItem();
            String string2 = (String)object4;
            if (object == this.series) {
                if (string.equalsIgnoreCase("trial.xml_metadata")) {
                    this.seriesXmlNameLabel.setEnabled(true);
                    this.seriesXmlName.setEnabled(true);
                    this.refreshDynamicControls(false, false, true);
                } else {
                    this.seriesXmlNameLabel.setEnabled(false);
                    this.seriesXmlName.setEnabled(false);
                }
            } else if (object == this.xaxisValue) {
                if (string2.equalsIgnoreCase("trial.xml_metadata")) {
                    this.xmlNameLabel.setEnabled(true);
                    this.xmlName.setEnabled(true);
                    this.refreshDynamicControls(false, false, true);
                } else {
                    this.xmlNameLabel.setEnabled(false);
                    this.xmlName.setEnabled(false);
                }
            }
            if (string.equalsIgnoreCase(INTERVAL_EVENT_NAME) || string.equalsIgnoreCase(INTERVAL_EVENT_GROUP_NAME)) {
                this.refreshDynamicControls(false, true, false);
            }
            if (string.equalsIgnoreCase(ATOMIC_EVENT_NAME)) {
                this.metricLabel.setEnabled(false);
                this.metric.setEnabled(false);
                this.dimensionLabel.setEnabled(false);
                this.dimension.setEnabled(false);
                this.refreshDynamicControls(false, true, false);
                this.units.setSelectedIndex(5);
            } else {
                this.metricLabel.setEnabled(true);
                this.metric.setEnabled(true);
                this.dimensionLabel.setEnabled(true);
                this.dimension.setEnabled(true);
            }
        }
        this.drawChart();
    }

    public void drawChart() {
    }

    private PerfExplorerChart doGeneralChart() {
        PerfExplorerModel perfExplorerModel = PerfExplorerModel.getModel();
        RMIGeneralChartData rMIGeneralChartData = this.server.requestGeneralChartData(perfExplorerModel, ChartDataType.PARAMETRIC_STUDY_DATA);
        PECategoryDataset pECategoryDataset = new PECategoryDataset();
        DefaultTableXYDataset defaultTableXYDataset = new DefaultTableXYDataset();
        String string = perfExplorerModel.getChartUnits();
        if (string == null) {
            string = new String("microseconds");
        }
        double d = 1.0;
        if (string.equals("milliseconds")) {
            d = 1000.0;
        } else if (string.equals("seconds")) {
            d = 1000000.0;
        } else if (string.equals("minutes")) {
            d = 6.0E7;
        } else if (string.equals("hours")) {
            d = 3.6E9;
        } else if (string.equals("units")) {
            d = 1.0;
        } else if (string.equals("thousands (x 1.0E3)")) {
            d = 1000.0;
        } else if (string.equals("millions (x 1.0E6)")) {
            d = 1000000.0;
        } else if (string.equals("billions (x 1.0E9)")) {
            d = 1.0E9;
        } else if (string.equals("billions (x 1.0E12)")) {
            d = 1.0E12;
        }
        PlotOrientation plotOrientation = PlotOrientation.VERTICAL;
        if (perfExplorerModel.getChartHorizontal()) {
            plotOrientation = PlotOrientation.HORIZONTAL;
        }
        JFreeChart jFreeChart = null;
        XYSeries xYSeries = null;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (rMIGeneralChartData.getCategoryType() == Integer.class) {
            Object object3;
            Object object2;
            if (perfExplorerModel.getChartScalability()) {
                RMIGeneralChartData.CategoryDataRow categoryDataRow = rMIGeneralChartData.getRowData(0);
                for (int i = 0; i < rMIGeneralChartData.getRows(); ++i) {
                    RMIGeneralChartData.CategoryDataRow categoryDataRow2 = rMIGeneralChartData.getRowData(i);
                    if (!this.shortName(categoryDataRow2.series).equals(this.shortName(categoryDataRow.series))) {
                        categoryDataRow = categoryDataRow2;
                    }
                    if ((object2 = (XYSeries)hashMap.get(categoryDataRow2.series)) == null) {
                        object2 = new XYSeries((Comparable)((Object)this.shortName(categoryDataRow2.series)), true, false);
                        hashMap.put(categoryDataRow2.series, object2);
                    }
                    if (perfExplorerModel.getConstantProblem().booleanValue()) {
                        double d2 = categoryDataRow.categoryInteger.doubleValue() / categoryDataRow2.categoryInteger.doubleValue();
                        double d3 = categoryDataRow.value / categoryDataRow2.value;
                        pECategoryDataset.addValue(d3 / d2, (Comparable)((Object)this.shortName(categoryDataRow2.series)), (Comparable)categoryDataRow2.categoryInteger);
                        object2.add(categoryDataRow2.categoryInteger.doubleValue(), d3 / d2);
                        continue;
                    }
                    pECategoryDataset.addValue(categoryDataRow.value / categoryDataRow2.value, (Comparable)((Object)this.shortName(categoryDataRow2.series)), (Comparable)categoryDataRow2.categoryInteger);
                    object2.add(categoryDataRow2.categoryInteger.doubleValue(), categoryDataRow.value / categoryDataRow2.value);
                }
                xYSeries = new XYSeries((Comparable)((Object)IDEAL), true, false);
                object3 = pECategoryDataset.getColumnKeys();
                for (int i = 0; i < object3.size(); ++i) {
                    object2 = (Integer)object3.get(i);
                    pECategoryDataset.addValue(((Integer)object2).doubleValue() / (double)rMIGeneralChartData.getMinimum(), (Comparable)((Object)IDEAL), (Comparable)object2);
                    xYSeries.add(((Integer)object2).doubleValue(), ((Integer)object2).doubleValue() / (double)rMIGeneralChartData.getMinimum());
                }
            } else if (perfExplorerModel.getChartEfficiency()) {
                RMIGeneralChartData.CategoryDataRow categoryDataRow = rMIGeneralChartData.getRowData(0);
                for (int i = 0; i < rMIGeneralChartData.getRows(); ++i) {
                    RMIGeneralChartData.CategoryDataRow categoryDataRow3 = rMIGeneralChartData.getRowData(i);
                    if (!this.shortName(categoryDataRow3.series).equals(this.shortName(categoryDataRow.series))) {
                        categoryDataRow = categoryDataRow3;
                    }
                    if ((object2 = (XYSeries)hashMap.get(categoryDataRow3.series)) == null) {
                        object2 = new XYSeries((Comparable)((Object)this.shortName(categoryDataRow3.series)), true, false);
                        hashMap.put(categoryDataRow3.series, object2);
                    }
                    if (perfExplorerModel.getConstantProblem().booleanValue()) {
                        pECategoryDataset.addValue(categoryDataRow.value / categoryDataRow3.value * 100.0, (Comparable)((Object)this.shortName(categoryDataRow3.series)), (Comparable)categoryDataRow3.categoryInteger);
                        object2.add(categoryDataRow3.categoryInteger.doubleValue(), categoryDataRow.value / categoryDataRow3.value * 100.0);
                        continue;
                    }
                    pECategoryDataset.addValue(categoryDataRow.value * categoryDataRow.categoryInteger.doubleValue() / (categoryDataRow3.value * categoryDataRow3.categoryInteger.doubleValue()) * 100.0, (Comparable)((Object)this.shortName(categoryDataRow3.series)), (Comparable)categoryDataRow3.categoryInteger);
                    object2.add(categoryDataRow3.categoryInteger.doubleValue(), categoryDataRow.value * categoryDataRow.categoryInteger.doubleValue() / (categoryDataRow3.value * categoryDataRow3.categoryInteger.doubleValue()) * 100.0);
                }
                xYSeries = new XYSeries((Comparable)((Object)IDEAL), true, false);
                object3 = pECategoryDataset.getColumnKeys();
                for (int i = 0; i < object3.size(); ++i) {
                    object2 = (Integer)object3.get(i);
                    pECategoryDataset.addValue(100.0, (Comparable)((Object)IDEAL), (Comparable)object2);
                    xYSeries.add(((Integer)object2).doubleValue(), 100.0);
                }
            } else {
                for (int i = 0; i < rMIGeneralChartData.getRows(); ++i) {
                    object3 = rMIGeneralChartData.getRowData(i);
                    XYSeries xYSeries2 = (XYSeries)hashMap.get(((RMIGeneralChartData.CategoryDataRow)object3).series);
                    if (xYSeries2 == null) {
                        xYSeries2 = new XYSeries((Comparable)((Object)this.shortName(((RMIGeneralChartData.CategoryDataRow)object3).series)), true, false);
                        hashMap.put(((RMIGeneralChartData.CategoryDataRow)object3).series, xYSeries2);
                    }
                    pECategoryDataset.addValue(((RMIGeneralChartData.CategoryDataRow)object3).value / d, (Comparable)((Object)this.shortName(((RMIGeneralChartData.CategoryDataRow)object3).series)), (Comparable)((RMIGeneralChartData.CategoryDataRow)object3).categoryInteger);
                    xYSeries2.add(((RMIGeneralChartData.CategoryDataRow)object3).categoryInteger.doubleValue(), ((RMIGeneralChartData.CategoryDataRow)object3).value / d);
                }
            }
            for (Object object3 : hashMap.keySet()) {
                XYSeries xYSeries3 = (XYSeries)hashMap.get(object3);
                defaultTableXYDataset.addSeries(xYSeries3);
            }
            if (xYSeries != null) {
                defaultTableXYDataset.addSeries(xYSeries);
            }
            if (this.exportdata.isSelected()) {
                this.printData(defaultTableXYDataset);
            }
            if (!this.alwaysCategory.isSelected()) {
                jFreeChart = ChartFactory.createXYLineChart((String)perfExplorerModel.getChartTitle(), (String)perfExplorerModel.getChartXAxisLabel(), (String)perfExplorerModel.getChartYAxisLabel(), (XYDataset)defaultTableXYDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
                Utility.applyDefaultChartTheme((JFreeChart)jFreeChart);
                this.customizeLineChart(perfExplorerModel, rMIGeneralChartData, jFreeChart);
                PerfExplorerChart.customizeChart(jFreeChart, hashMap.keySet().size(), xYSeries != null);
            } else {
                jFreeChart = ChartFactory.createLineChart((String)perfExplorerModel.getChartTitle(), (String)perfExplorerModel.getChartXAxisLabel(), (String)perfExplorerModel.getChartYAxisLabel(), (CategoryDataset)pECategoryDataset, (PlotOrientation)plotOrientation, (boolean)true, (boolean)true, (boolean)false);
                Utility.applyDefaultChartTheme((JFreeChart)jFreeChart);
                this.customizeCategoryChart(perfExplorerModel, rMIGeneralChartData, jFreeChart);
            }
        } else {
            for (int i = 0; i < rMIGeneralChartData.getRows(); ++i) {
                RMIGeneralChartData.CategoryDataRow categoryDataRow = rMIGeneralChartData.getRowData(i);
                pECategoryDataset.addValue(categoryDataRow.value / d, (Comparable)((Object)this.shortName(categoryDataRow.series)), (Comparable)((Object)categoryDataRow.categoryString));
            }
            jFreeChart = ChartFactory.createLineChart((String)perfExplorerModel.getChartTitle(), (String)perfExplorerModel.getChartXAxisLabel(), (String)perfExplorerModel.getChartYAxisLabel(), (CategoryDataset)pECategoryDataset, (PlotOrientation)plotOrientation, (boolean)true, (boolean)true, (boolean)false);
            Utility.applyDefaultChartTheme((JFreeChart)jFreeChart);
            this.customizeCategoryChart(perfExplorerModel, rMIGeneralChartData, jFreeChart);
        }
        PerfExplorerChart perfExplorerChart = new PerfExplorerChart(jFreeChart, perfExplorerModel.getChartTitle());
        return perfExplorerChart;
    }

    private boolean getFiletoSave() {
        int n = this.fc.showSaveDialog(this);
        if (n == 0) {
            int n2;
            File file = this.fc.getSelectedFile();
            if (file.exists() && (n2 = JOptionPane.showOptionDialog(this, "\"" + file.getName() + "\" already exists. Do you want to replace it? ", "Replace File", 0, 2, null, null, null)) == 1) {
                return this.getFiletoSave();
            }
            return true;
        }
        return false;
    }

    private void printData(DefaultTableXYDataset defaultTableXYDataset) {
        if (this.getFiletoSave()) {
            try {
                File file = this.fc.getSelectedFile();
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                PerfExplorerModel perfExplorerModel = PerfExplorerModel.getModel();
                this.writeln(perfExplorerModel.getChartTitle(), fileOutputStream);
                this.writeln(perfExplorerModel.getChartXAxisLabel(), fileOutputStream);
                this.writeln(perfExplorerModel.getChartYAxisLabel(), fileOutputStream);
                for (int i = 0; i < defaultTableXYDataset.getSeriesCount(); ++i) {
                    XYSeries xYSeries = defaultTableXYDataset.getSeries(i);
                    this.writeln(xYSeries.getKey(), fileOutputStream);
                    for (int j = 0; j < xYSeries.getItemCount(); ++j) {
                        this.write(xYSeries.getX(j) + "\t", fileOutputStream);
                        this.writeln(xYSeries.getY(j) + "\t", fileOutputStream);
                    }
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("File not found.\n");
                JOptionPane.showMessageDialog(PerfExplorerClient.getMainFrame(), stringBuilder.toString(), "Selection Warning", 0);
                fileNotFoundException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private void writeln(Object object, FileOutputStream fileOutputStream) throws IOException {
        this.write(object + "\n", fileOutputStream);
    }

    private void write(String string, FileOutputStream fileOutputStream) throws IOException {
        fileOutputStream.write(string.getBytes());
    }

    private void customizeLineChart(PerfExplorerModel perfExplorerModel, RMIGeneralChartData rMIGeneralChartData, JFreeChart jFreeChart) {
        LogarithmicAxis logarithmicAxis;
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        XYLineAndShapeRenderer xYLineAndShapeRenderer = (XYLineAndShapeRenderer)xYPlot.getRenderer();
        xYLineAndShapeRenderer.setBaseShapesFilled(true);
        xYLineAndShapeRenderer.setBaseShapesVisible(true);
        xYLineAndShapeRenderer.setDrawOutlines(true);
        xYLineAndShapeRenderer.setBaseItemLabelsVisible(true);
        if (perfExplorerModel.getChartScalability()) {
            // empty if block
        }
        for (int i = 0; i < rMIGeneralChartData.getRows(); ++i) {
            xYLineAndShapeRenderer.setSeriesStroke(i, (Stroke)new BasicStroke(2.0f));
        }
        NumberAxis numberAxis = (NumberAxis)xYPlot.getRangeAxis();
        if (perfExplorerModel.getShowZero()) {
            numberAxis.setAutoRangeIncludesZero(true);
        } else {
            numberAxis.setAutoRangeIncludesZero(false);
        }
        if (perfExplorerModel.getChartLogYAxis()) {
            logarithmicAxis = new LogarithmicAxis(PerfExplorerModel.getModel().getChartYAxisLabel());
            if (perfExplorerModel.getShowZero()) {
                logarithmicAxis.setAutoRangeIncludesZero(true);
            } else {
                logarithmicAxis.setAutoRangeIncludesZero(false);
            }
            logarithmicAxis.setAllowNegativesFlag(true);
            logarithmicAxis.setLog10TickLabelsFlag(true);
            xYPlot.setRangeAxis(0, (ValueAxis)logarithmicAxis);
        }
        if (perfExplorerModel.getChartLogXAxis()) {
            logarithmicAxis = new LogarithmicAxis(PerfExplorerModel.getModel().getChartXAxisLabel());
            if (perfExplorerModel.getShowZero()) {
                logarithmicAxis.setAutoRangeIncludesZero(true);
            } else {
                logarithmicAxis.setAutoRangeIncludesZero(false);
            }
            logarithmicAxis.setAllowNegativesFlag(true);
            logarithmicAxis.setLog10TickLabelsFlag(true);
            xYPlot.setDomainAxis(0, (ValueAxis)logarithmicAxis);
        }
    }

    private void customizeCategoryChart(PerfExplorerModel perfExplorerModel, RMIGeneralChartData rMIGeneralChartData, JFreeChart jFreeChart) {
        LogarithmicAxis logarithmicAxis;
        CategoryPlot categoryPlot = (CategoryPlot)jFreeChart.getPlot();
        LineAndShapeRenderer lineAndShapeRenderer = (LineAndShapeRenderer)categoryPlot.getRenderer();
        lineAndShapeRenderer.setBaseShapesFilled(true);
        lineAndShapeRenderer.setBaseShapesVisible(true);
        lineAndShapeRenderer.setDrawOutlines(true);
        lineAndShapeRenderer.setBaseItemLabelsVisible(true);
        if (perfExplorerModel.getChartScalability()) {
            // empty if block
        }
        for (int i = 0; i < rMIGeneralChartData.getRows(); ++i) {
            lineAndShapeRenderer.setSeriesStroke(i, (Stroke)new BasicStroke(2.0f));
        }
        NumberAxis numberAxis = (NumberAxis)categoryPlot.getRangeAxis();
        if (perfExplorerModel.getShowZero()) {
            numberAxis.setAutoRangeIncludesZero(true);
        } else {
            numberAxis.setAutoRangeIncludesZero(false);
        }
        if (perfExplorerModel.getChartLogYAxis()) {
            logarithmicAxis = new LogarithmicAxis(PerfExplorerModel.getModel().getChartYAxisLabel());
            if (perfExplorerModel.getShowZero()) {
                logarithmicAxis.setAutoRangeIncludesZero(true);
            } else {
                logarithmicAxis.setAutoRangeIncludesZero(false);
            }
            logarithmicAxis.setAllowNegativesFlag(true);
            logarithmicAxis.setLog10TickLabelsFlag(true);
            categoryPlot.setRangeAxis(0, (ValueAxis)logarithmicAxis);
        }
        if (this.angleXLabels.isSelected()) {
            logarithmicAxis = categoryPlot.getDomainAxis();
            logarithmicAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_45);
        }
    }

    private String shortName(String string) {
        int n = string.indexOf("[{");
        if (n < 1) {
            string = string.trim();
            return string;
        }
        String string2 = string.substring(0, n).trim();
        return string2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SteppedComboBox
    extends JComboBox {
        private static final long serialVersionUID = -6511789381891153830L;
        protected int popupWidth;

        public SteppedComboBox() {
            this.setUI(new SteppedComboBoxUI());
            this.popupWidth = 0;
            Dimension dimension = this.getPreferredSize();
            this.setPreferredSize(new Dimension(50, dimension.height));
            this.setPopupWidth(dimension.width);
        }

        public SteppedComboBox(Object[] objectArray) {
            super(objectArray);
            this.setUI(new SteppedComboBoxUI());
            this.popupWidth = 0;
            Dimension dimension = this.getPreferredSize();
            this.setPreferredSize(new Dimension(50, dimension.height));
            this.setPopupWidth(dimension.width);
        }

        public SteppedComboBox(List<Object> list) {
            super(list.toArray());
            this.setUI(new SteppedComboBoxUI());
            this.popupWidth = 0;
            Dimension dimension = this.getPreferredSize();
            this.setPreferredSize(new Dimension(50, dimension.height));
            this.setPopupWidth(dimension.width);
        }

        public void setPopupWidth(int n) {
            this.popupWidth = n;
        }

        public Dimension getPopupSize() {
            Dimension dimension = this.getSize();
            if (this.popupWidth < 1) {
                this.popupWidth = dimension.width;
            }
            return new Dimension(this.popupWidth, dimension.height);
        }

        @Override
        public Dimension getMaximumSize() {
            Dimension dimension = super.getMaximumSize();
            Dimension dimension2 = this.getPreferredSize();
            dimension.height = dimension2.height;
            return dimension;
        }
    }

    private class SteppedComboBoxUI
    extends MetalComboBoxUI {
        private SteppedComboBoxUI() {
        }

        protected ComboPopup createPopup() {
            BasicComboPopup basicComboPopup = new BasicComboPopup(this.comboBox){
                private static final long serialVersionUID = -992135884016287671L;

                public void setVisible(boolean bl) {
                    if (bl) {
                        Dimension dimension = ((SteppedComboBox)this.comboBox).getPopupSize();
                        dimension.setSize(dimension.width, this.getPopupHeightForRowCount(this.comboBox.getMaximumRowCount()));
                        Rectangle rectangle = this.computePopupBounds(0, this.comboBox.getBounds().height, dimension.width, dimension.height);
                        this.scroller.setMaximumSize(rectangle.getSize());
                        this.scroller.setPreferredSize(rectangle.getSize());
                        this.scroller.setMinimumSize(rectangle.getSize());
                        this.list.invalidate();
                        int n = this.comboBox.getSelectedIndex();
                        if (n == -1) {
                            this.list.clearSelection();
                        } else {
                            this.list.setSelectedIndex(n);
                        }
                        this.list.ensureIndexIsVisible(this.list.getSelectedIndex());
                        this.setLightWeightPopupEnabled(this.comboBox.isLightWeightPopupEnabled());
                        this.show(this.comboBox, rectangle.x, rectangle.y);
                    } else {
                        super.setVisible(false);
                    }
                }
            };
            basicComboPopup.getAccessibleContext().setAccessibleParent(this.comboBox);
            return basicComboPopup;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MyJComboBox
    extends JComboBox {
        private static final long serialVersionUID = -7805756500468380965L;

        public MyJComboBox(Object[] objectArray) {
            super(objectArray);
            this.setPrototypeDisplayValue("WWWWW");
        }

        public MyJComboBox() {
            this.setPrototypeDisplayValue("WWWWW");
        }

        public MyJComboBox(List<Object> list) {
            super(list.toArray());
            this.setPrototypeDisplayValue("WWWWW");
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            if (this.isMinimumSizeSet()) {
                Dimension dimension2 = this.getMinimumSize();
                if (dimension2.width > dimension.width) {
                    dimension.width = dimension2.width;
                }
            }
            return dimension;
        }

        @Override
        public Dimension getMaximumSize() {
            Dimension dimension = super.getMaximumSize();
            Dimension dimension2 = this.getPreferredSize();
            dimension.height = dimension2.height;
            return dimension;
        }
    }

    class MyJTextField
    extends JTextField {
        private static final long serialVersionUID = -7156539927712296439L;

        public MyJTextField() {
        }

        public MyJTextField(String string, int n) {
            super(string, n);
        }

        public MyJTextField(int n) {
            super(n);
        }

        public MyJTextField(String string) {
            super(string);
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            if (this.isMinimumSizeSet()) {
                Dimension dimension2 = this.getMinimumSize();
                if (dimension2.width > dimension.width) {
                    dimension.width = dimension2.width;
                }
            }
            return dimension;
        }

        public Dimension getMaximumSize() {
            Dimension dimension = super.getMaximumSize();
            Dimension dimension2 = this.getPreferredSize();
            dimension.height = dimension2.height;
            return dimension;
        }
    }
}

