/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.client;

import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerClient;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerConnection;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerImageButton;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerModel;
import edu.uoregon.tau.perfexplorer.common.RMIPerformanceResults;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;

public class PerfExplorerCorrelationPane
extends JScrollPane
implements ActionListener {
    private static final long serialVersionUID = -1776096417971557334L;
    private static PerfExplorerCorrelationPane thePane = null;
    private JPanel imagePanel = null;
    private Hashtable<String, RMIPerformanceResults> resultsHash = null;
    private RMIPerformanceResults results = null;

    public static PerfExplorerCorrelationPane getPane() {
        if (thePane == null) {
            JPanel jPanel = new JPanel(new BorderLayout());
            thePane = new PerfExplorerCorrelationPane(jPanel);
        }
        thePane.repaint();
        return thePane;
    }

    private PerfExplorerCorrelationPane(JPanel jPanel) {
        super(jPanel);
        this.imagePanel = jPanel;
        this.resultsHash = new Hashtable();
        JScrollBar jScrollBar = this.getVerticalScrollBar();
        jScrollBar.setUnitIncrement(35);
    }

    public JPanel getImagePanel() {
        return this.imagePanel;
    }

    public void updateImagePanel() {
        this.imagePanel.removeAll();
        PerfExplorerModel perfExplorerModel = PerfExplorerModel.getModel();
        if (perfExplorerModel.getCurrentSelection() instanceof Metric || perfExplorerModel.getCurrentSelection() instanceof Trial) {
            PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
            this.results = perfExplorerConnection.getCorrelationResults(perfExplorerModel);
            if (this.results.getResultCount() == 0) {
                return;
            }
            int n = 0;
            List<String> list = this.results.getDescriptions();
            List<byte[]> list2 = this.results.getThumbnails();
            int n2 = list.size();
            this.resultsHash.put(perfExplorerModel.toString(), this.results);
            JPanel jPanel = null;
            int n3 = (int)Math.sqrt(this.results.getResultCount());
            jPanel = new JPanel(new GridLayout(this.results.getResultCount() / n3, n3));
            for (int i = n; i < n2; ++i) {
                ImageIcon imageIcon = new ImageIcon(list2.get(i));
                String string = list.get(i);
                PerfExplorerImageButton perfExplorerImageButton = new PerfExplorerImageButton(imageIcon, i, string);
                perfExplorerImageButton.addActionListener(this);
                jPanel.add(perfExplorerImageButton);
            }
            this.imagePanel.add((Component)jPanel, "South");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n = Integer.parseInt(actionEvent.getActionCommand());
        String string = this.results.getDescriptions().get(n);
        ImageIcon imageIcon = new ImageIcon(this.results.getImages().get(n));
        JOptionPane.showMessageDialog(PerfExplorerClient.getMainFrame(), null, string, -1, imageIcon);
    }
}

