/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.client;

import edu.uoregon.tau.common.ExternalTool;
import edu.uoregon.tau.common.Utility;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerConnection;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerModel;
import edu.uoregon.tau.perfexplorer.common.RMICubeData;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;

public class PerfExplorerWekaLauncher {
    private static final int numFunctions = 10;

    public static void launch() {
        PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
        RMICubeData rMICubeData = perfExplorerConnection.requestCubeData(PerfExplorerModel.getModel(), 10);
        if (rMICubeData == null) {
            return;
        }
        float[][] fArray = rMICubeData.getValues();
        try {
            int n;
            String string = System.getProperty("user.home") + File.separator + ".ParaProf" + File.separator + "wekadata.csv";
            FileWriter fileWriter = new FileWriter(string);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            for (n = 0; n < 10; ++n) {
                if (n > 0) {
                    bufferedWriter.write(",");
                }
                bufferedWriter.write(Utility.shortenFunctionName((String)rMICubeData.getNames(n)));
            }
            bufferedWriter.newLine();
            for (n = 0; n < fArray.length; ++n) {
                for (int i = 0; i < fArray[n].length; ++i) {
                    if (i > 0) {
                        bufferedWriter.write(",");
                    }
                    bufferedWriter.write(Float.toString(fArray[n][i]));
                }
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
            ExternalTool externalTool = ExternalTool.createWekaConfiguration((boolean)true);
            ExternalTool.launch((ExternalTool)externalTool);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            exception.printStackTrace();
        }
    }
}

