/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.client;

import edu.uoregon.tau.perfdmf.Application;
import edu.uoregon.tau.perfdmf.DBDataSource;
import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.DataSourceException;
import edu.uoregon.tau.perfdmf.DatabaseAPI;
import edu.uoregon.tau.perfdmf.Experiment;
import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfexplorer.client.ConnectionNodeObject;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Enumeration;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeDropTarget
implements DropTargetListener {
    DropTarget target;
    JTree targetTree;

    public TreeDropTarget(JTree jTree) {
        this.targetTree = jTree;
        this.target = new DropTarget(this.targetTree, this);
    }

    private TreeNode getNodeForEvent(DropTargetDragEvent dropTargetDragEvent) {
        Point point = dropTargetDragEvent.getLocation();
        DropTargetContext dropTargetContext = dropTargetDragEvent.getDropTargetContext();
        JTree jTree = (JTree)dropTargetContext.getComponent();
        TreePath treePath = jTree.getClosestPathForLocation(point.x, point.y);
        return (TreeNode)treePath.getLastPathComponent();
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        TreeNode treeNode = this.getNodeForEvent(dropTargetDragEvent);
        if (treeNode.isLeaf()) {
            dropTargetDragEvent.rejectDrag();
        } else {
            dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        TreeNode treeNode = this.getNodeForEvent(dropTargetDragEvent);
        dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        Point point = dropTargetDropEvent.getLocation();
        DropTargetContext dropTargetContext = dropTargetDropEvent.getDropTargetContext();
        JTree jTree = (JTree)dropTargetContext.getComponent();
        TreePath treePath = jTree.getClosestPathForLocation(point.x, point.y);
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        boolean bl = dropTargetDropEvent.getDropAction() == 1;
        System.out.println("We are " + (bl ? "copying" : "moving"));
        try {
            Transferable transferable = dropTargetDropEvent.getTransferable();
            DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (!transferable.isDataFlavorSupported(dataFlavorArray[i])) continue;
                dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)transferable.getTransferData(dataFlavorArray[i]);
                Object object = defaultMutableTreeNode2.getUserObject();
                if (defaultMutableTreeNode2.getParent() == defaultMutableTreeNode) {
                    return;
                }
                if (object instanceof Application) {
                    if (!(defaultMutableTreeNode.getUserObject() instanceof ConnectionNodeObject)) {
                        System.out.println(defaultMutableTreeNode.getUserObject().getClass());
                        return;
                    }
                    Application application = (Application)object;
                    String string = this.getAppName(application);
                    String string2 = ((ConnectionNodeObject)defaultMutableTreeNode.getUserObject()).toString();
                    if (JOptionPane.showConfirmDialog(this.targetTree.getParent(), "Are you sure you want to " + (bl ? "copy " : "move ") + string + " to " + string2 + " ?", (bl ? "Copy " : "Move ") + "Application", 0) == 1) {
                        return;
                    }
                } else if (object instanceof Experiment) {
                    if (!(defaultMutableTreeNode.getUserObject() instanceof Application)) {
                        return;
                    }
                    Experiment experiment = (Experiment)object;
                    Application application = (Application)defaultMutableTreeNode.getUserObject();
                    String string = this.getAppName(application) + ":" + experiment.getName();
                    String string3 = this.getAppName(application);
                } else if (object instanceof Trial) {
                    if (!(defaultMutableTreeNode.getUserObject() instanceof Experiment)) {
                        return;
                    }
                    Trial trial = (Trial)defaultMutableTreeNode2.getUserObject();
                    Experiment experiment = (Experiment)defaultMutableTreeNode.getUserObject();
                    String string = this.getAppName((Application)((DefaultMutableTreeNode)defaultMutableTreeNode.getParent()).getUserObject()) + ":" + experiment.getName();
                    String string4 = this.getAppName((Application)((DefaultMutableTreeNode)defaultMutableTreeNode2.getParent().getParent()).getUserObject()) + ":" + ((Experiment)((DefaultMutableTreeNode)defaultMutableTreeNode2.getParent()).getUserObject()).getName() + ":" + trial.getName();
                    if (JOptionPane.showConfirmDialog(this.targetTree.getParent(), "Are you sure you want to " + (bl ? "copy " : "move ") + string4 + " to " + string + "?", (bl ? "Copy " : "Move ") + " Trial", 0) == 1) {
                        return;
                    }
                    DatabaseAPI databaseAPI = new DatabaseAPI();
                    databaseAPI.initialize(experiment.getDatabase());
                    DBDataSource dBDataSource = new DBDataSource(databaseAPI);
                    trial.setDataSource((DataSource)dBDataSource);
                    this.uploadTrial(trial, experiment, databaseAPI);
                } else {
                    return;
                }
                dropTargetDropEvent.dropComplete(true);
                return;
            }
            dropTargetDropEvent.rejectDrop();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String getAppName(Application application) {
        if (application.getDatabase() != null) {
            return application.getDatabase().getName() + ":" + application.getName();
        }
        return "Standard Applications:" + application.getName();
    }

    private void uploadExperment(Application application, Experiment experiment, Enumeration<DefaultMutableTreeNode> enumeration) throws FileNotFoundException, DataSourceException, InterruptedException, IOException, SQLException {
    }

    private void uploadTrial(Trial trial, Experiment experiment, DatabaseAPI databaseAPI) {
        if (trial.getDataSource().getMetadataString().equals("")) {
            trial.getDataSource().buildXMLMetaData();
        }
        trial.setID(-1);
        trial.setExperimentID(experiment.getID());
        trial.setApplicationID(experiment.getApplicationID());
        if (databaseAPI != null) {
            trial.saveTrial(databaseAPI.getDb());
        }
    }
}

