/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.clustering.weka;

import edu.uoregon.tau.perfexplorer.clustering.ClusterException;
import edu.uoregon.tau.perfexplorer.clustering.KMeansClusterInterface;
import edu.uoregon.tau.perfexplorer.clustering.weka.WekaAbstractCluster;
import weka.clusterers.SimpleKMeans;
import weka.core.Instance;
import weka.core.Instances;

public class WekaKMeansCluster
extends WekaAbstractCluster
implements KMeansClusterInterface {
    private int k = 0;
    private SimpleKMeans kmeans = null;

    WekaKMeansCluster() {
    }

    public void findClusters() throws ClusterException {
        try {
            this.kmeans = new SimpleKMeans();
            this.kmeans.setNumClusters(this.k);
            Instances instances = null;
            instances = this.doPCA ? this.handlePCA(this.instances) : this.instances;
            this.kmeans.buildClusterer(instances);
            this.clusterCentroids = this.kmeans.getClusterCentroids();
            this.clusterStandardDeviations = this.kmeans.getClusterStandardDevs();
            this.evaluateCluster();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }

    public void setK(int n) {
        this.k = n;
    }

    public int getK() {
        return this.k;
    }

    public int[] getClusterSizes() {
        return this.kmeans.getClusterSizes();
    }

    public int clusterInstance(int n) {
        int n2 = 0;
        try {
            n2 = this.kmeans.clusterInstance(this.instances.instance(n));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n2;
    }

    protected double getSquaredError() {
        return this.kmeans.getSquaredError();
    }

    public int clusterInstance(Instance instance) throws Exception {
        return this.kmeans.clusterInstance(instance);
    }
}

