/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.common;

import edu.uoregon.tau.perfexplorer.common.ChartDataType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RMIGeneralChartData
implements Serializable {
    private static final long serialVersionUID = -5430395494124130200L;
    protected ChartDataType dataType = ChartDataType.FRACTION_OF_TOTAL;
    protected List<CategoryDataRow> data = null;
    protected Class<?> categoryType = Integer.class;
    protected int xMinimum = -1;
    protected int xMaximum = -1;
    protected List<String> rowLabels = null;

    public RMIGeneralChartData(ChartDataType chartDataType) {
        this.dataType = chartDataType;
        this.data = new ArrayList<CategoryDataRow>();
        this.rowLabels = new ArrayList<String>();
    }

    public void addRow(String string, String string2, double d) {
        CategoryDataRow categoryDataRow = new CategoryDataRow(string, string2, d);
        this.data.add(categoryDataRow);
        this.rowLabels.add(string);
        if (categoryDataRow.categoryType == String.class) {
            this.categoryType = String.class;
        } else {
            if (this.xMaximum == -1 || categoryDataRow.categoryInteger > this.xMaximum) {
                this.xMaximum = categoryDataRow.categoryInteger;
            }
            if (this.xMinimum == -1 || categoryDataRow.categoryInteger < this.xMinimum) {
                this.xMinimum = categoryDataRow.categoryInteger;
            }
        }
    }

    public int getRows() {
        return this.data.size();
    }

    public CategoryDataRow getRowData(int n) {
        return this.data.get(n);
    }

    public int getMinimum() {
        return this.xMinimum;
    }

    public int getMaximum() {
        return this.xMaximum;
    }

    public Class<?> getCategoryType() {
        return this.categoryType;
    }

    public List<String> getRowLabels() {
        return this.rowLabels;
    }

    public class CategoryDataRow
    implements Serializable {
        private static final long serialVersionUID = -5571689459430495190L;
        public String series = null;
        public String categoryString = null;
        public Integer categoryInteger = null;
        public double value = 0.0;
        public Class<?> categoryType = Integer.class;

        public CategoryDataRow(String string, String string2, double d) {
            this.series = string;
            this.categoryString = string2;
            try {
                int n = Integer.parseInt(string2);
                this.categoryInteger = new Integer(n);
            }
            catch (NumberFormatException numberFormatException) {
                this.categoryType = String.class;
            }
            this.value = d;
        }
    }
}

