/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.glue;

import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfexplorer.clustering.LinearRegressionInterface;
import edu.uoregon.tau.perfexplorer.clustering.RawDataInterface;
import edu.uoregon.tau.perfexplorer.clustering.weka.AnalysisFactory;
import edu.uoregon.tau.perfexplorer.glue.AbstractPerformanceOperation;
import edu.uoregon.tau.perfexplorer.glue.AbstractResult;
import edu.uoregon.tau.perfexplorer.glue.CorrelationResult;
import edu.uoregon.tau.perfexplorer.glue.PerformanceResult;
import edu.uoregon.tau.perfexplorer.glue.TrialMetadata;
import edu.uoregon.tau.perfexplorer.glue.TrialResult;
import edu.uoregon.tau.perfexplorer.glue.TrialThreadMetadata;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorrelateEventsWithMetadata
extends AbstractPerformanceOperation {
    private static final long serialVersionUID = -7728642909863765823L;
    private PerformanceResult trialData = null;
    private TrialThreadMetadata trialMetadata = null;
    private List<TrialMetadata> metadatas = null;

    protected CorrelateEventsWithMetadata(PerformanceResult performanceResult) {
        super(performanceResult);
    }

    protected CorrelateEventsWithMetadata(Trial trial) {
        super(trial);
    }

    protected CorrelateEventsWithMetadata(List<PerformanceResult> list) {
        super(list);
    }

    public CorrelateEventsWithMetadata(PerformanceResult performanceResult, TrialThreadMetadata trialThreadMetadata) {
        super(performanceResult);
        this.inputs.add(trialThreadMetadata);
        this.trialData = performanceResult;
        this.trialMetadata = trialThreadMetadata;
    }

    public CorrelateEventsWithMetadata(List<PerformanceResult> list, List<TrialMetadata> list2) {
        super(list);
        this.trialData = null;
        this.metadatas = list2;
    }

    @Override
    public List<PerformanceResult> processData() {
        if (this.trialData != null) {
            this.processOneTrial();
        } else {
            this.processNTrials();
        }
        return this.outputs;
    }

    private void processOneTrial() {
        CorrelationResult correlationResult = new CorrelationResult(this.trialData, false);
        this.outputs.add(correlationResult);
        for (String string : this.trialData.getEvents()) {
            for (String string2 : this.trialData.getMetrics()) {
                for (Integer n : AbstractResult.getTypes()) {
                    for (String string3 : this.trialMetadata.getEvents()) {
                        String string4 = "METADATA";
                        Integer n2 = 1;
                        double d = 0.0;
                        double[] dArray = new double[this.trialData.getThreads().size()];
                        double[] dArray2 = new double[this.trialData.getThreads().size()];
                        ArrayList<String> arrayList = new ArrayList<String>();
                        arrayList.add(string);
                        arrayList.add(string3);
                        RawDataInterface rawDataInterface = AnalysisFactory.createRawData("Correlation Test", arrayList, this.trialData.getThreads().size(), arrayList.size(), null);
                        for (Integer n3 : this.trialData.getThreads()) {
                            dArray[n3.intValue()] = this.trialMetadata.getDataPoint(n3, string3, string4, n2);
                            dArray2[n3.intValue()] = this.trialData.getDataPoint(n3, string, string2, n);
                            rawDataInterface.addValue((int)n3, 0, this.trialMetadata.getDataPoint(n3, string3, string4, n2));
                            rawDataInterface.addValue((int)n3, 1, this.trialData.getDataPoint(n3, string, string2, n));
                        }
                        boolean bl = true;
                        for (int i = 1; i < this.trialData.getThreads().size(); ++i) {
                            if (dArray2[i] == dArray2[i - 1] || dArray[i] == dArray[i - 1]) continue;
                            bl = false;
                            break;
                        }
                        if (bl) continue;
                        d = AnalysisFactory.getUtilities().doCorrelation(dArray, dArray2, this.trialData.getThreads().size());
                        if (Double.isNaN(d) || Double.isInfinite(d)) {
                            d = 0.0;
                        }
                        correlationResult.putDataPoint(9, string + ":" + string2 + ":" + AbstractResult.typeToString(n), string3 + ":" + string4, n2, d);
                        LinearRegressionInterface linearRegressionInterface = AnalysisFactory.createLinearRegressionEngine();
                        linearRegressionInterface.setInputData(rawDataInterface);
                        try {
                            linearRegressionInterface.findCoefficients();
                        }
                        catch (Exception exception) {
                            System.err.println("failure to perform linear regression.");
                            System.exit(0);
                        }
                        List<Double> list = linearRegressionInterface.getCoefficients();
                        double d2 = list.get(0);
                        double d3 = list.get(2);
                        if (Double.isNaN(d2) || Double.isInfinite(d2)) {
                            d2 = 0.0;
                        }
                        if (Double.isNaN(d3) || Double.isInfinite(d3)) {
                            d3 = 0.0;
                        }
                        correlationResult.putDataPoint(10, string + ":" + string2 + ":" + AbstractResult.typeToString(n), string3 + ":" + string4, n2, d2);
                        correlationResult.putDataPoint(11, string + ":" + string2 + ":" + AbstractResult.typeToString(n), string3 + ":" + string4, n2, d3);
                        correlationResult.assertFact(string, string2, n, string3, string4, 12, d, d2, d3);
                    }
                }
            }
        }
    }

    private void processNTrials() {
        int n;
        this.trialData = new TrialResult();
        this.trialMetadata = new TrialThreadMetadata();
        for (n = 0; n < this.inputs.size(); ++n) {
            PerformanceResult performanceResult = (PerformanceResult)this.inputs.get(n);
            for (String string : performanceResult.getEvents()) {
                for (String string2 : performanceResult.getMetrics()) {
                    this.trialData.putInclusive(n, string, string2, performanceResult.getInclusive(0, string, string2));
                    this.trialData.putExclusive(n, string, string2, performanceResult.getExclusive(0, string, string2));
                    this.trialData.putCalls(n, string, performanceResult.getCalls(0, string));
                    this.trialData.putSubroutines(n, string, performanceResult.getSubroutines(0, string));
                }
            }
        }
        n = 0;
        for (TrialMetadata trialMetadata : this.metadatas) {
            Hashtable<String, String> hashtable = trialMetadata.getCommonAttributes();
            for (String string2 : hashtable.keySet()) {
                if (string2.equals("pid") || string2.toLowerCase().contains("time")) continue;
                try {
                    Double d = Double.parseDouble(hashtable.get(string2));
                    this.trialMetadata.putExclusive(n, string2, "METADATA", d);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            ++n;
        }
        this.processOneTrial();
    }
}

