/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.glue;

import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerExpression;
import edu.uoregon.tau.perfexplorer.glue.AbstractPerformanceOperation;
import edu.uoregon.tau.perfexplorer.glue.DefaultResult;
import edu.uoregon.tau.perfexplorer.glue.PerformanceResult;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.List;
import java.util.Stack;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeriveMetricEquation
extends AbstractPerformanceOperation {
    private static final long serialVersionUID = 2874115882488110455L;
    private ArrayList<String> equation = null;
    private PerformanceResult input = null;
    private String newName = null;
    private boolean correctEquation = true;

    public DeriveMetricEquation(PerformanceResult performanceResult) {
        super(performanceResult);
    }

    public DeriveMetricEquation(Trial trial) {
        super(trial);
    }

    public DeriveMetricEquation(List<PerformanceResult> list) {
        super(list);
    }

    public DeriveMetricEquation(PerformanceResult performanceResult, String string) {
        super(performanceResult);
        this.input = performanceResult;
        int n = string.indexOf("=");
        if (n != -1) {
            this.newName = string.substring(0, n);
            string = string.substring(n + 1);
        } else {
            this.newName = PerfExplorerExpression.getNewName(string);
        }
        if (PerfExplorerExpression.validate(string)) {
            try {
                this.equation = DeriveMetricEquation.infixToPostfix(string);
                this.checkMetrics(this.equation);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            System.err.println("\n\n *** ERROR: Equation is not correct: " + string + " ***\n\n");
            this.correctEquation = false;
        }
    }

    private void checkMetrics(ArrayList<String> arrayList) {
        for (String string : arrayList) {
            if (this.isOperation(string) || this.isValue(string) || string.equals("CALLS") || string.equals("SUBROUTINES") || this.input.getMetrics().contains(string)) continue;
            System.err.println("\n\n *** ERROR: Trial does not have a metric named: " + string + " ***\n\n");
            this.correctEquation = false;
        }
    }

    public DeriveMetricEquation(PerformanceResult performanceResult, String string, String string2) {
        this(performanceResult, string);
        this.newName = string2;
    }

    public DeriveMetricEquation(PerformanceResult performanceResult, String[] stringArray) {
        super(performanceResult);
        this.input = performanceResult;
        this.equation = this.infixToPostfix(stringArray);
    }

    public boolean noErrors() {
        return this.correctEquation;
    }

    private static ArrayList<String> infixToPostfix(String string) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = "";
        Stack<Character> stack = new Stack<Character>();
        char[] cArray = string.toCharArray();
        block20: for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            switch (c) {
                case '\"': {
                    ++i;
                    while (cArray[i] != '\"') {
                        string2 = string2 + cArray[i];
                        ++i;
                    }
                    continue block20;
                }
                case '+': {
                    if (!string2.equals("")) {
                        arrayList.add(string2 + "");
                    }
                    string2 = "";
                    try {
                        while (((Character)stack.peek()).charValue() != '(') {
                            arrayList.add(stack.pop() + "");
                        }
                    }
                    catch (EmptyStackException emptyStackException) {
                        // empty catch block
                    }
                    stack.push(new Character('+'));
                    continue block20;
                }
                case '-': {
                    if (!string2.equals("")) {
                        arrayList.add(string2 + "");
                    }
                    string2 = "";
                    try {
                        while (((Character)stack.peek()).charValue() != '(') {
                            arrayList.add(stack.pop() + "");
                        }
                    }
                    catch (EmptyStackException emptyStackException) {
                        // empty catch block
                    }
                    stack.push(new Character('-'));
                    continue block20;
                }
                case '/': {
                    if (!string2.equals("")) {
                        arrayList.add(string2 + "");
                    }
                    string2 = "";
                    try {
                        while (((Character)stack.peek()).charValue() != '(' && ((Character)stack.peek()).charValue() != '-' && ((Character)stack.peek()).charValue() != '+') {
                            arrayList.add(stack.pop() + "");
                        }
                    }
                    catch (EmptyStackException emptyStackException) {
                        // empty catch block
                    }
                    stack.push(new Character('/'));
                    continue block20;
                }
                case '*': {
                    if (!string2.equals("")) {
                        arrayList.add(string2 + "");
                    }
                    string2 = "";
                    try {
                        while (((Character)stack.peek()).charValue() != '(' && ((Character)stack.peek()).charValue() != '-' && ((Character)stack.peek()).charValue() != '+') {
                            arrayList.add(stack.pop() + "");
                        }
                    }
                    catch (EmptyStackException emptyStackException) {
                        // empty catch block
                    }
                    stack.push(new Character('*'));
                    continue block20;
                }
                case '(': {
                    stack.push(new Character('('));
                    continue block20;
                }
                case ')': {
                    if (!string2.equals("")) {
                        arrayList.add(string2 + "");
                    }
                    string2 = "";
                    try {
                        while (((Character)stack.peek()).charValue() != '(') {
                            arrayList.add(stack.pop() + "");
                        }
                        stack.pop();
                        continue block20;
                    }
                    catch (EmptyStackException emptyStackException) {
                        throw new Exception("Unmatched )");
                    }
                }
                case ' ': {
                    continue block20;
                }
                default: {
                    string2 = string2 + c;
                }
            }
        }
        if (!string2.equals("")) {
            arrayList.add(string2 + "");
        }
        string2 = "";
        while (!stack.isEmpty()) {
            arrayList.add(stack.pop() + "");
        }
        return arrayList;
    }

    private ArrayList<String> infixToPostfix(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Stack<Character> stack = new Stack<Character>();
        block18: for (String string : stringArray) {
            char c = string.charAt(0);
            switch (c) {
                case '+': {
                    try {
                        while (((Character)stack.peek()).charValue() != '(') {
                            arrayList.add(stack.pop() + "");
                        }
                    }
                    catch (EmptyStackException emptyStackException) {
                        // empty catch block
                    }
                    stack.push(Character.valueOf('+'));
                    continue block18;
                }
                case '-': {
                    try {
                        while (((Character)stack.peek()).charValue() != '(') {
                            arrayList.add(stack.pop() + "");
                        }
                    }
                    catch (EmptyStackException emptyStackException) {
                        // empty catch block
                    }
                    stack.push(Character.valueOf('-'));
                    continue block18;
                }
                case '/': {
                    try {
                        while (((Character)stack.peek()).charValue() != '(' && ((Character)stack.peek()).charValue() != '-' && ((Character)stack.peek()).charValue() != '+') {
                            arrayList.add(stack.pop() + "");
                        }
                    }
                    catch (EmptyStackException emptyStackException) {
                        // empty catch block
                    }
                    stack.push(Character.valueOf('/'));
                    continue block18;
                }
                case '*': {
                    try {
                        while (((Character)stack.peek()).charValue() != '(' && ((Character)stack.peek()).charValue() != '-' && ((Character)stack.peek()).charValue() != '+') {
                            arrayList.add(stack.pop() + "");
                        }
                    }
                    catch (EmptyStackException emptyStackException) {
                        // empty catch block
                    }
                    stack.push(Character.valueOf('*'));
                    continue block18;
                }
                case '(': {
                    stack.push(Character.valueOf('('));
                    continue block18;
                }
                case ')': {
                    try {
                        while (((Character)stack.peek()).charValue() != '(') {
                            arrayList.add(stack.pop() + "");
                        }
                        stack.pop();
                    }
                    catch (EmptyStackException emptyStackException) {
                        System.err.println("Unmatched )");
                    }
                    continue block18;
                }
                default: {
                    arrayList.add(string);
                }
            }
        }
        while (!stack.isEmpty()) {
            arrayList.add(stack.pop() + "");
        }
        return arrayList;
    }

    private boolean isValue(String string) {
        return Pattern.matches("[\\x00-\\x20]*[+-]?(NaN|Infinity|((((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?)|(((0[xX](\\p{XDigit}+)(\\.)?)|(0[xX](\\p{XDigit}+)?(\\.)(\\p{XDigit}+)))[pP][+-]?(\\p{Digit}+)))[fFdD]?))[\\x00-\\x20]*", string);
    }

    private static boolean isOperation(Object object) {
        if (object instanceof String) {
            String string = (String)object;
            char c = string.charAt(0);
            return c == '+' || c == '-' || c == '*' || c == '/';
        }
        return false;
    }

    private static double apply(char c, double d, double d2) {
        double d3 = 0.0;
        switch (c) {
            case '+': {
                d3 = d + d2;
                break;
            }
            case '-': {
                if (!(d > d2)) break;
                d3 = d - d2;
                break;
            }
            case '*': {
                d3 = d * d2;
                break;
            }
            case '/': {
                if (d2 == 0.0) break;
                return d / d2;
            }
        }
        return d3;
    }

    private double[] eval(ArrayList<Object> arrayList) {
        for (int i = 0; arrayList.size() > 1 && arrayList.size() > i; ++i) {
            if (!DeriveMetricEquation.isOperation(arrayList.get(i))) continue;
            char c = ((String)arrayList.remove(i)).trim().charAt(0);
            double[] dArray = (double[])arrayList.remove(i - 1);
            double[] dArray2 = (double[])arrayList.remove(i - 2);
            double d = DeriveMetricEquation.apply(c, dArray2[0], dArray[0]);
            double d2 = DeriveMetricEquation.apply(c, dArray2[1], dArray[1]);
            double[] dArray3 = new double[]{d, d2};
            arrayList.add(i -= 2, dArray3);
            continue;
        }
        return (double[])arrayList.get(0);
    }

    @Override
    public List<PerformanceResult> processData() {
        if (this.newName != null) {
            this.newName = this.newName.trim();
        }
        for (int i = 0; i < this.equation.size(); ++i) {
            Object object = this.equation.get(i);
            if (this.isOperation((String)object) || this.isValue((String)object)) continue;
            this.input.getMetrics().contains(object);
        }
        for (Object object : this.inputs) {
            DefaultResult defaultResult = new DefaultResult((PerformanceResult)object, false);
            for (String string : object.getEvents()) {
                for (Integer n : object.getThreads()) {
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    for (int i = 0; i < this.equation.size(); ++i) {
                        Object object2;
                        String string2 = this.equation.get(i);
                        if (this.isOperation(string2)) {
                            arrayList.add(string2);
                            continue;
                        }
                        if (this.isValue(string2)) {
                            object2 = new double[]{Double.valueOf(string2), Double.valueOf(string2)};
                            arrayList.add(object2);
                            continue;
                        }
                        object2 = string2;
                        double[] dArray = this.getValue((String)object2, n, string);
                        arrayList.add(dArray);
                    }
                    double[] dArray = this.eval(arrayList);
                    defaultResult.putInclusive(n, string, this.newName, dArray[0]);
                    defaultResult.putExclusive(n, string, this.newName, dArray[1]);
                    defaultResult.putCalls(n, string, object.getCalls(n, string));
                    defaultResult.putSubroutines(n, string, object.getSubroutines(n, string));
                }
            }
            this.outputs.add(defaultResult);
        }
        return this.outputs;
    }

    private double[] getValue(String string, Integer n, String string2) {
        double[] dArray = new double[2];
        if (string.equals("CALLS")) {
            dArray[0] = this.input.getCalls(n, string2);
            dArray[1] = this.input.getCalls(n, string2);
        } else if (string.equals("SUBROUTINES")) {
            dArray[0] = this.input.getSubroutines(n, string2);
            dArray[1] = this.input.getSubroutines(n, string2);
        } else {
            dArray[0] = this.input.getInclusive(n, string2, string);
            dArray[1] = this.input.getExclusive(n, string2, string);
        }
        return dArray;
    }

    private boolean isOperation(String string) {
        char c = string.charAt(0);
        return c == '+' || c == '-' || c == '*' || c == '/';
    }

    public String getNewName() {
        return this.newName;
    }

    public void setNewName(String string) {
        this.newName = string;
    }

    public boolean exists() {
        return ((PerformanceResult)this.inputs.get(0)).getMetrics().contains(this.newName);
    }
}

