/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.glue;

import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfdmf.database.DB;
import edu.uoregon.tau.perfexplorer.glue.AbstractPerformanceOperation;
import edu.uoregon.tau.perfexplorer.glue.PerformanceResult;
import edu.uoregon.tau.perfexplorer.server.PerfExplorerServer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaveResultOperation
extends AbstractPerformanceOperation {
    private static final long serialVersionUID = 1285952458769047610L;
    private boolean forceOverwrite = false;
    private int maxContexts = 1;
    private int maxThreads = 1;
    private int curNode = 0;
    private int curContext = 0;
    private int curThread = -1;
    private DB db = null;
    private Trial trial;
    private StringBuilder buf = null;
    private PreparedStatement statement = null;
    private double mainInclusive = 0.0;
    private double[] accumulators = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};

    public SaveResultOperation(PerformanceResult performanceResult) {
        super(performanceResult);
    }

    public SaveResultOperation(Trial trial) {
        super(trial);
        this.trial = trial;
    }

    public SaveResultOperation(List<PerformanceResult> list) {
        super(list);
    }

    @Override
    public List<PerformanceResult> processData() {
        for (PerformanceResult performanceResult : this.inputs) {
            this.trial = performanceResult.getTrial();
            if (this.trial == null) {
                System.err.println("SaveResultOperation.processData() not implemented for " + performanceResult.getClass().getName());
                System.err.println("The Trial reference is null - no idea where this data is supposed to go.");
                continue;
            }
            this.db = PerfExplorerServer.getServer().getDB();
            try {
                Object object2;
                this.db.setAutoCommit(false);
                Map<String, Integer> map = this.insertEvents(performanceResult.getEvents());
                map = this.insertEvents(performanceResult.getEvents());
                this.getNodeContextThreadInfo();
                HashSet<String> hashSet = new HashSet<String>();
                for (Object object2 : this.trial.getMetrics()) {
                    hashSet.add(object2.getName());
                }
                object2 = performanceResult.getMetrics().iterator();
                while (object2.hasNext()) {
                    String string = (String)object2.next();
                    if (hashSet.contains(string)) {
                        if (!this.forceOverwrite) continue;
                        continue;
                    }
                    this.mainInclusive = performanceResult.getInclusive(0, performanceResult.getMainEvent(), string);
                    PreparedStatement preparedStatement = this.getStatementILP();
                    PreparedStatement preparedStatement2 = this.getStatementTA1();
                    PreparedStatement preparedStatement3 = this.getStatementTA2();
                    int n = this.insertMetric(string);
                    for (String string2 : performanceResult.getEvents()) {
                        int n2 = map.get(string2);
                        this.curNode = 0;
                        this.curContext = 0;
                        this.curThread = -1;
                        for (int i = 0; i < this.accumulators.length; ++i) {
                            this.accumulators[i] = 0.0;
                        }
                        for (Integer n3 : performanceResult.getThreads()) {
                            double d = performanceResult.getExclusive(n3, string2, string);
                            double d2 = performanceResult.getInclusive(n3, string2, string);
                            double d3 = performanceResult.getCalls(n3, string2);
                            double d4 = performanceResult.getSubroutines(n3, string2);
                            this.insertILP(preparedStatement, n, n2, d2, d, d3, d4);
                        }
                        this.insertTotalAndAverage(preparedStatement2, preparedStatement3, performanceResult.getThreads().size(), n, n2);
                    }
                    preparedStatement.executeBatch();
                    preparedStatement.close();
                    preparedStatement2.executeBatch();
                    preparedStatement2.close();
                    preparedStatement3.executeBatch();
                    preparedStatement3.close();
                    this.db.commit();
                }
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
                if (this.db.getDBType().equals("postgresql")) {
                    System.err.println(this.statement.toString());
                } else {
                    System.err.println(this.buf.toString());
                }
                exception.printStackTrace();
                try {
                    this.db.rollback();
                    this.db.setAutoCommit(true);
                }
                catch (Exception exception2) {}
            }
        }
        return this.inputs;
    }

    private PreparedStatement getStatementTA2() throws SQLException {
        this.buf = new StringBuilder();
        this.buf.append("insert into interval_mean_summary (interval_event, metric, ");
        this.buf.append("inclusive_percentage, inclusive, ");
        if (this.db.getDBType().compareTo("oracle") == 0) {
            this.buf.append("exclusive_percentage, excl, ");
        } else {
            this.buf.append("exclusive_percentage, exclusive, ");
        }
        if (this.db.getDBType().compareTo("derby") == 0) {
            this.buf.append("num_calls, subroutines, ");
        } else if (this.db.getDBType().compareTo("mysql") == 0) {
            this.buf.append("`call`, subroutines, ");
        } else {
            this.buf.append("call, subroutines, ");
        }
        this.buf.append("inclusive_per_call) values (?, ?, ?, ?, ?, ?, ?, ?, ?)");
        return this.db.prepareStatement(this.buf.toString());
    }

    private PreparedStatement getStatementTA1() throws SQLException {
        this.buf = new StringBuilder();
        this.buf.append("insert into interval_total_summary (interval_event, metric, ");
        this.buf.append("inclusive_percentage, inclusive, ");
        if (this.db.getDBType().compareTo("oracle") == 0) {
            this.buf.append("exclusive_percentage, excl, ");
        } else {
            this.buf.append("exclusive_percentage, exclusive, ");
        }
        if (this.db.getDBType().compareTo("derby") == 0) {
            this.buf.append("num_calls, subroutines, ");
        } else if (this.db.getDBType().compareTo("mysql") == 0) {
            this.buf.append("`call`, subroutines, ");
        } else {
            this.buf.append("call, subroutines, ");
        }
        this.buf.append("inclusive_per_call) values (?, ?, ?, ?, ?, ?, ?, ?, ?)");
        return this.db.prepareStatement(this.buf.toString());
    }

    private PreparedStatement getStatementILP() throws SQLException {
        this.buf = new StringBuilder();
        this.buf.append("insert into interval_location_profile (interval_event, node, ");
        this.buf.append("context, thread, metric, inclusive_percentage, inclusive, ");
        if (this.db.getDBType().compareTo("oracle") == 0) {
            this.buf.append("exclusive_percentage, excl, ");
        } else {
            this.buf.append("exclusive_percentage, exclusive, ");
        }
        if (this.db.getDBType().compareTo("derby") == 0) {
            this.buf.append("num_calls, subroutines, ");
        } else if (this.db.getDBType().compareTo("mysql") == 0) {
            this.buf.append("`call`, subroutines, ");
        } else {
            this.buf.append("call, subroutines, ");
        }
        this.buf.append("inclusive_per_call) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        return this.db.prepareStatement(this.buf.toString());
    }

    private Map<String, Integer> insertEvents(Set<String> set) throws SQLException {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        this.buf = new StringBuilder();
        this.buf.append("insert into interval_event (trial, name) values (?, ?)");
        PreparedStatement preparedStatement = this.db.prepareStatement(this.buf.toString());
        for (String string : set) {
            int n = 0;
            this.buf = new StringBuilder();
            this.buf.append("select id from interval_event where trial = ? and name = ?");
            this.statement = this.db.prepareStatement(this.buf.toString());
            this.statement.setInt(1, this.trial.getID());
            this.statement.setString(2, string);
            ResultSet resultSet = this.statement.executeQuery();
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
            resultSet.close();
            this.statement.close();
            if (n == 0) {
                preparedStatement.setInt(1, this.trial.getID());
                preparedStatement.setString(2, string);
            }
            hashMap.put(string, n);
        }
        preparedStatement.executeBatch();
        preparedStatement.close();
        return hashMap;
    }

    private void getNodeContextThreadInfo() throws SQLException {
        this.buf = new StringBuilder();
        this.buf.append("select node_count, contexts_per_node, threads_per_context from trial where id = ?");
        this.statement = this.db.prepareStatement(this.buf.toString());
        this.statement.setInt(1, this.trial.getID());
        ResultSet resultSet = this.statement.executeQuery();
        if (resultSet.next()) {
            this.maxContexts = resultSet.getInt(2);
            this.maxThreads = resultSet.getInt(3);
        }
        resultSet.close();
        this.statement.close();
    }

    private void insertILP(PreparedStatement preparedStatement, int n, int n2, double d, double d2, double d3, double d4) throws SQLException {
        ++this.curThread;
        if (this.curThread >= this.maxThreads) {
            this.curThread = 0;
            ++this.curContext;
        }
        if (this.curContext >= this.maxContexts) {
            this.curContext = 0;
            ++this.curNode;
        }
        preparedStatement.setInt(1, n2);
        preparedStatement.setInt(2, this.curNode);
        preparedStatement.setInt(3, this.curContext);
        preparedStatement.setInt(4, this.curThread);
        preparedStatement.setInt(5, n);
        if (this.mainInclusive == 0.0) {
            preparedStatement.setDouble(6, 0.0);
        } else {
            preparedStatement.setDouble(6, d / this.mainInclusive);
        }
        preparedStatement.setDouble(7, d);
        if (this.mainInclusive == 0.0) {
            preparedStatement.setDouble(8, 0.0);
        } else {
            preparedStatement.setDouble(8, d2 / this.mainInclusive);
        }
        preparedStatement.setDouble(9, d2);
        preparedStatement.setDouble(10, d3);
        preparedStatement.setDouble(11, d4);
        if (d3 == 0.0) {
            preparedStatement.setDouble(12, 0.0);
        } else {
            preparedStatement.setDouble(12, d / d3);
            this.accumulators[6] = this.accumulators[6] + d / d3;
        }
        preparedStatement.addBatch();
        if (this.mainInclusive != 0.0) {
            this.accumulators[0] = this.accumulators[0] + d / this.mainInclusive;
        }
        this.accumulators[1] = this.accumulators[1] + d;
        if (this.mainInclusive != 0.0) {
            this.accumulators[2] = this.accumulators[2] + d2 / this.mainInclusive;
        }
        this.accumulators[3] = this.accumulators[3] + d2;
        this.accumulators[4] = this.accumulators[4] + d3;
        this.accumulators[5] = this.accumulators[5] + d4;
    }

    private void insertTotalAndAverage(PreparedStatement preparedStatement, PreparedStatement preparedStatement2, int n, int n2, int n3) throws SQLException {
        preparedStatement.setInt(1, n3);
        preparedStatement.setInt(2, n2);
        preparedStatement.setDouble(3, this.accumulators[0]);
        preparedStatement.setDouble(4, this.accumulators[1]);
        preparedStatement.setDouble(5, this.accumulators[2]);
        preparedStatement.setDouble(6, this.accumulators[3]);
        preparedStatement.setDouble(7, this.accumulators[4]);
        preparedStatement.setDouble(8, this.accumulators[5]);
        preparedStatement.setDouble(9, this.accumulators[6]);
        preparedStatement.addBatch();
        preparedStatement2.setInt(1, n3);
        preparedStatement2.setInt(2, n2);
        preparedStatement2.setDouble(3, this.accumulators[0] / (double)n);
        preparedStatement2.setDouble(4, this.accumulators[1] / (double)n);
        preparedStatement2.setDouble(5, this.accumulators[2] / (double)n);
        preparedStatement2.setDouble(6, this.accumulators[3] / (double)n);
        preparedStatement2.setDouble(7, this.accumulators[4] / (double)n);
        preparedStatement2.setDouble(8, this.accumulators[5] / (double)n);
        preparedStatement2.setDouble(9, this.accumulators[6] / (double)n);
        preparedStatement2.addBatch();
    }

    private int insertMetric(String string) throws SQLException, NumberFormatException {
        this.buf = new StringBuilder();
        this.buf.append("insert into metric (trial, name) values (?, ?) ");
        this.statement = this.db.prepareStatement(this.buf.toString());
        this.statement.setInt(1, this.trial.getID());
        this.statement.setString(2, string);
        this.statement.execute();
        this.statement.close();
        this.statement.close();
        String string2 = new String();
        string2 = this.db.getDBType().compareTo("mysql") == 0 ? "select LAST_INSERT_ID();" : (this.db.getDBType().compareTo("db2") == 0 ? "select IDENTITY_VAL_LOCAL() FROM metric" : (this.db.getDBType().compareTo("derby") == 0 ? "select IDENTITY_VAL_LOCAL() FROM metric" : (this.db.getDBType().compareTo("oracle") == 0 ? "SELECT metric_id_seq.currval FROM DUAL" : "select currval('metric_id_seq');")));
        int n = Integer.parseInt(this.db.getDataItem(string2));
        return n;
    }

    public boolean isForceOverwrite() {
        return this.forceOverwrite;
    }

    public void setForceOverwrite(boolean bl) {
        this.forceOverwrite = bl;
    }
}

