/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.glue;

import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfexplorer.glue.DefaultResult;
import edu.uoregon.tau.perfexplorer.glue.PerformanceResult;
import edu.uoregon.tau.perfexplorer.glue.TopXEvents;
import edu.uoregon.tau.perfexplorer.glue.Utilities;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopXPercentEvents
extends TopXEvents {
    private static final long serialVersionUID = -8866264929579290819L;

    public TopXPercentEvents(PerformanceResult performanceResult, String string, int n, double d) {
        super(performanceResult, string, n, d);
        this.threshold = this.threshold / 100.0;
    }

    public TopXPercentEvents(Trial trial, String string, int n, double d) {
        super(trial, string, n, d);
        this.threshold = this.threshold / 100.0;
    }

    public TopXPercentEvents(List<PerformanceResult> list, String string, int n, double d) {
        super(list, string, n, d);
        this.threshold = this.threshold / 100.0;
    }

    @Override
    public List<PerformanceResult> processData() {
        HashMap<String, Double> hashMap = new HashMap<String, Double>();
        for (PerformanceResult performanceResult : this.inputs) {
            DefaultResult defaultResult = new DefaultResult(performanceResult, false);
            this.outputs.add(defaultResult);
            Set<String> set = performanceResult.getEvents();
            Set<Integer> set2 = performanceResult.getThreads();
            for (Integer n : set2) {
                String string;
                double d = 0.0;
                for (String string2 : set) {
                    d += performanceResult.getDataPoint(n, string2, this.metric, this.type);
                    hashMap.put(string2, performanceResult.getDataPoint(n, string2, this.metric, this.type));
                }
                double d2 = d * this.threshold;
                LinkedHashMap<String, Double> linkedHashMap = Utilities.sortHashMapByValues(hashMap, false);
                Iterator iterator = linkedHashMap.keySet().iterator();
                while (iterator.hasNext() && !((Double)linkedHashMap.get(string = (String)iterator.next()) < d2)) {
                    defaultResult.putExclusive(n, string, this.metric, performanceResult.getExclusive(n, string, this.metric));
                    defaultResult.putInclusive(n, string, this.metric, performanceResult.getInclusive(n, string, this.metric));
                    defaultResult.putCalls(n, string, performanceResult.getCalls(n, string));
                    defaultResult.putSubroutines(n, string, performanceResult.getSubroutines(n, string));
                }
            }
            defaultResult.updateEventMap();
        }
        return this.outputs;
    }
}

