/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.rules;

import edu.uoregon.tau.perfdmf.IntervalEvent;
import edu.uoregon.tau.perfdmf.IntervalLocationProfile;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfexplorer.client.ScriptFacade;
import edu.uoregon.tau.perfexplorer.common.RMISortableIntervalEvent;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.WorkingMemory;
import org.drools.compiler.PackageBuilder;
import org.drools.rule.Package;

public class RuleHarnessOld {
    private static ScriptFacade facade = new ScriptFacade();
    public static WorkingMemory workingMemory = null;

    public static final void processRules(Trial trial, Trial trial2) {
        try {
            RuleBase ruleBase = RuleHarnessOld.readRule();
            workingMemory = ruleBase.newWorkingMemory();
            workingMemory.assertObject((Object)new RelativeTrial(trial, 0));
            workingMemory.assertObject((Object)new RelativeTrial(trial2, 1));
            System.out.println(" done.");
            workingMemory.fireAllRules();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private static RuleBase readRule() throws Exception {
        InputStreamReader inputStreamReader = new InputStreamReader(RuleHarnessOld.class.getResourceAsStream("/rules/PerfExplorerOld.drl"));
        PackageBuilder packageBuilder = new PackageBuilder();
        System.out.print("Reading rules...");
        packageBuilder.addPackageFromDrl((Reader)inputStreamReader);
        System.out.println(" done.");
        Package package_ = packageBuilder.getPackage();
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(package_);
        return ruleBase;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Helper {
        private final String name;
        private final Object object;
        private final Class<? extends Object> objectClass;

        public Helper(String string, Object object) {
            this.name = string;
            this.object = object;
            this.objectClass = object.getClass();
        }

        public String getName() {
            return this.name;
        }

        public Object getObject() {
            return this.object;
        }

        public Class<? extends Object> getObjectClass() {
            return this.objectClass;
        }
    }

    public static class Difference {
        public static final int SAME = 0;
        public static final int SLOWER = 2;
        public static final int FASTER = 1;
        public static final double million = 1000000.0;
        private final int type;
        private final double baseline;
        private final double comparison;
        private final double difference;
        private final double percent;
        private final String eventName;
        private final String metricName;

        public Difference(int n, double d, double d2, String string, String string2) {
            this.type = n;
            this.baseline = d;
            this.comparison = d2;
            double d3 = this.baseline - this.comparison;
            if (d3 > 0.0) {
                this.difference = d3;
                this.percent = d3 / this.comparison;
            } else {
                this.difference = -1.0 * d3;
                this.percent = this.difference / this.baseline;
            }
            this.eventName = string;
            this.metricName = string2;
        }

        public int getType() {
            return this.type;
        }

        public double getBaseline() {
            return this.baseline;
        }

        public double getComparison() {
            return this.comparison;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.metricName != null) {
                stringBuilder.append(this.metricName + ", ");
            } else if (this.eventName != null) {
                stringBuilder.append(this.eventName + ", ");
            } else {
                stringBuilder.append("Event, Baseline, Comparison, Difference, Percent,\n");
                stringBuilder.append("main, ");
            }
            stringBuilder.append(this.baseline / 1000000.0 + ", " + this.comparison / 1000000.0 + ", " + (this.type == 1 ? "-" : "") + this.difference / 1000000.0 + ", " + this.percent * 100.0 + "%");
            return stringBuilder.toString();
        }

        public String getEventName() {
            return this.eventName;
        }

        public String getMetricName() {
            return this.metricName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RelativeTrial {
        public static final int BASELINE = 0;
        public static final int COMPARISON = 1;
        private final int type;
        private Trial trial;
        private List<Metric> metrics;
        private HashMap<IntervalEvent, IntervalLocationProfile> events;
        private HashMap<String, IntervalEvent> eventNames;
        private IntervalEvent main;
        private int timeIndex;

        public RelativeTrial(Trial trial, int n) {
            this.trial = trial;
            this.type = n;
            this.metrics = this.trial.getMetrics();
            this.timeIndex = this.findMetricIndex("Time");
            this.events = this.buildEventMap();
        }

        private HashMap<IntervalEvent, IntervalLocationProfile> buildEventMap() {
            HashMap<IntervalEvent, IntervalLocationProfile> hashMap = new HashMap<IntervalEvent, IntervalLocationProfile>();
            this.eventNames = new HashMap();
            ListIterator<RMISortableIntervalEvent> listIterator = facade.getEventList(this.trial, 0);
            int n = this.timeIndex == -1 ? 0 : this.timeIndex;
            double d = 0.0;
            while (listIterator.hasNext()) {
                IntervalEvent intervalEvent = listIterator.next();
                this.eventNames.put(intervalEvent.getName(), intervalEvent);
                try {
                    IntervalLocationProfile intervalLocationProfile = intervalEvent.getMeanSummary();
                    if (intervalLocationProfile.getInclusive(n) > d) {
                        d = intervalLocationProfile.getInclusive(n);
                        this.main = intervalEvent;
                    }
                    hashMap.put(intervalEvent, intervalLocationProfile);
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            }
            return hashMap;
        }

        public int findMetricIndex(String string) {
            String string2;
            Metric metric;
            ListIterator<Metric> listIterator;
            int n = 0;
            if (string.equalsIgnoreCase("TIME")) {
                listIterator = this.metrics.listIterator();
                while (listIterator.hasNext()) {
                    metric = listIterator.next();
                    string2 = metric.getName();
                    if (string2.indexOf("WALL_CLOCK_TIME") > -1) {
                        return n;
                    }
                    ++n;
                }
                n = 0;
                listIterator = this.metrics.listIterator();
                while (listIterator.hasNext()) {
                    metric = listIterator.next();
                    string2 = metric.getName();
                    if (string2.indexOf("GET_TIME_OF_DAY") > -1) {
                        return n;
                    }
                    ++n;
                }
                n = 0;
            }
            listIterator = this.metrics.listIterator();
            while (listIterator.hasNext()) {
                metric = listIterator.next();
                string2 = metric.getName();
                if (string2.equalsIgnoreCase(string)) {
                    return n;
                }
                ++n;
            }
            return -1;
        }

        public Trial getTrial() {
            return this.trial;
        }

        public int getType() {
            return this.type;
        }

        public IntervalEvent getMain() {
            return this.main;
        }

        public int getTimeIndex() {
            return this.timeIndex;
        }

        public Iterator<IntervalEvent> getEventIterator() {
            return this.events.keySet().iterator();
        }

        public IntervalEvent getEvent(String string) {
            return this.eventNames.get(string);
        }

        public List<Metric> getMetrics() {
            return this.metrics;
        }
    }
}

