/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.server;

import edu.uoregon.tau.common.Gzip;
import edu.uoregon.tau.perfdmf.Application;
import edu.uoregon.tau.perfdmf.AtomicEvent;
import edu.uoregon.tau.perfdmf.Experiment;
import edu.uoregon.tau.perfdmf.IntervalEvent;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfdmf.database.DB;
import edu.uoregon.tau.perfexplorer.common.ChartDataType;
import edu.uoregon.tau.perfexplorer.common.PerfExplorerOutput;
import edu.uoregon.tau.perfexplorer.common.RMIGeneralChartData;
import edu.uoregon.tau.perfexplorer.common.RMIPerfExplorerModel;
import edu.uoregon.tau.perfexplorer.common.TransformationType;
import edu.uoregon.tau.perfexplorer.server.PerfExplorerServer;
import edu.uoregon.tau.perfexplorer.server.TauNamespaceContext;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneralChartData
extends RMIGeneralChartData {
    private static final long serialVersionUID = -6775990055590146350L;
    private RMIPerfExplorerModel model;
    private StringBuilder buf = null;

    public GeneralChartData(RMIPerfExplorerModel rMIPerfExplorerModel, ChartDataType chartDataType) {
        super(chartDataType);
        this.model = rMIPerfExplorerModel;
    }

    public static GeneralChartData getChartData(RMIPerfExplorerModel rMIPerfExplorerModel, ChartDataType chartDataType) {
        GeneralChartData generalChartData = new GeneralChartData(rMIPerfExplorerModel, chartDataType);
        generalChartData.doQuery();
        return generalChartData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doQuery() {
        Object object = null;
        DB dB = null;
        try {
            dB = PerfExplorerServer.getServer().getDB();
            this.createPopulateTempTrailTable(dB);
            boolean bl = this.checkAndLoadXML(dB);
            this.createPopTempMetricTable(dB);
            this.mainOnly(dB);
            this.createPopTempEventTable(dB);
            String string = this.model.getChartSeriesName();
            String string2 = this.model.getChartXAxisName();
            String string3 = this.model.getChartYAxisName();
            this.buf = new StringBuilder();
            String string4 = "interval_mean_summary";
            if (this.model.getChartSeriesName().equals("atomic_event.name")) {
                string4 = "atomic_location_profile";
                this.buf.append("select ");
                if (dB.getDBType().compareTo("derby") == 0) {
                    if (this.model.isChartSeriesXML()) {
                        this.buf.append("'");
                    }
                    this.buf.append(this.fixClause(string, dB));
                    if (this.model.isChartSeriesXML()) {
                        this.buf.append("'");
                    }
                    this.buf.append(", ");
                    this.buf.append(this.fixClause(string2, dB) + ", ");
                    this.buf.append(this.fixClause(string3, dB) + " ");
                } else {
                    if (this.model.isChartSeriesXML()) {
                        this.buf.append("'");
                    }
                    this.buf.append(this.fixClause(string, dB));
                    if (this.model.isChartSeriesXML()) {
                        this.buf.append("'");
                    }
                    this.buf.append(" as series_name, ");
                    this.buf.append(this.fixClause(string2, dB) + " as xaxis_value, ");
                    this.buf.append(this.fixClause(string3, dB) + " as yaxis_value ");
                }
                this.buf.append("from " + string4 + " ");
                this.buf.append("inner join temp_event ");
                this.buf.append("on " + string4 + ".atomic_event = temp_event.id ");
            } else {
                if (string3.indexOf("interval_mean_summary") >= 0) {
                    string4 = "interval_mean_summary";
                } else if (string3.indexOf("interval_total_summary") >= 0) {
                    string4 = "interval_total_summary";
                } else if (string3.indexOf("interval_location_profile") >= 0) {
                    string4 = "interval_location_profile";
                }
                this.buf.append("select ");
                if (dB.getDBType().compareTo("derby") == 0) {
                    if (this.model.isChartSeriesXML()) {
                        this.buf.append("'");
                    }
                    this.buf.append(this.fixClause(string, dB));
                    if (this.model.isChartSeriesXML()) {
                        this.buf.append("'");
                    }
                    this.buf.append(", ");
                    this.buf.append(this.fixClause(string2, dB) + ", ");
                    this.buf.append(this.fixClause(string3, dB) + " ");
                } else {
                    if (this.model.isChartSeriesXML()) {
                        this.buf.append("'");
                    }
                    this.buf.append(this.fixClause(string, dB));
                    if (this.model.isChartSeriesXML()) {
                        this.buf.append("'");
                    }
                    this.buf.append(" as series_name, ");
                    this.buf.append(this.fixClause(string2, dB) + " as xaxis_value, ");
                    this.buf.append(this.fixClause(string3, dB) + " as yaxis_value ");
                }
                this.buf.append("from " + string4 + " ");
                this.buf.append("inner join temp_metric ");
                this.buf.append("on " + string4 + ".metric = temp_metric.id ");
                this.buf.append("inner join temp_event ");
                this.buf.append("on " + string4 + ".interval_event = temp_event.id ");
            }
            this.buf.append("inner join temp_trial ");
            this.buf.append("on temp_event.trial = temp_trial.id ");
            if (bl) {
                this.buf.append("inner join temp_xml_metadata ");
                this.buf.append("on temp_event.trial = temp_xml_metadata.trial ");
            }
            this.buf.append("inner join experiment ");
            this.buf.append("on temp_trial.experiment = experiment.id ");
            this.buf.append("inner join application ");
            this.buf.append("on experiment.application = application.id ");
            if (dB.getDBType().compareTo("derby") == 0) {
                this.buf.append("group by " + this.fixClause(string, dB));
                if (!string.equals(string2)) {
                    this.buf.append(", " + this.fixClause(string2, dB));
                }
                if (string.startsWith("trial.node_count") || string2.startsWith("trial.node_count")) {
                    this.buf.append(" order by 1, 2, 3, 4 ");
                } else {
                    this.buf.append(" order by 1, 2 ");
                }
            } else {
                this.buf.append("group by series_name, xaxis_value ");
                this.buf.append("order by 1, 2 ");
            }
            object = dB.prepareStatement(this.buf.toString());
            ResultSet resultSet = object.executeQuery();
            while (resultSet.next()) {
                if (dB.getDBType().compareTo("derby") == 0) {
                    if (string.startsWith("trial.node_count")) {
                        this.addRow(Integer.toString(resultSet.getInt(1) * resultSet.getInt(2) * resultSet.getInt(3)), resultSet.getString(4), resultSet.getDouble(5));
                        continue;
                    }
                    if (string2.startsWith("trial.node_count")) {
                        this.addRow(resultSet.getString(1), Integer.toString(resultSet.getInt(2) * resultSet.getInt(3) * resultSet.getInt(4)), resultSet.getDouble(5));
                        continue;
                    }
                    this.addRow(resultSet.getString(1), resultSet.getString(2), resultSet.getDouble(3));
                    continue;
                }
                this.addRow(resultSet.getString(1), resultSet.getString(2), resultSet.getDouble(3));
            }
            resultSet.close();
            object.close();
        }
        catch (Exception exception) {
            if (object != null) {
                PerfExplorerOutput.println(object.toString());
            } else {
                PerfExplorerOutput.println(this.buf.toString());
            }
            System.err.println(exception.getMessage());
            exception.printStackTrace();
        }
        finally {
            try {
                dB.setAutoCommit(true);
                GeneralChartData.dropTable(dB, "temp_event");
                if (!this.model.getChartSeriesName().equals("atomic_event.name")) {
                    GeneralChartData.dropTable(dB, "temp_metric");
                }
                GeneralChartData.dropTable(dB, "temp_xml_metadata");
                GeneralChartData.dropTable(dB, "temp_trial");
            }
            catch (Exception exception) {}
        }
    }

    private void createPopTempEventTable(DB dB) throws SQLException {
        String string;
        int n;
        int n2;
        boolean bl;
        List<String> list = this.model.getGroupNames();
        List<String> list2 = this.model.getEventNames();
        if (this.model.getChartSeriesName().equals("atomic_event.name")) {
            this.buf = GeneralChartData.buildCreateTableStatement("event", "temp_event", dB, true, this.model.getChartSeriesName().equals("atomic_event.name"));
            this.buf.append("(select atomic_event.* from atomic_event ");
            this.buf.append("inner join temp_trial ");
            this.buf.append("on atomic_event.trial = temp_trial.id ");
            bl = false;
            if (this.model.getEventNoCallpath()) {
                if (bl) {
                    this.buf.append("and ");
                } else {
                    this.buf.append("where ");
                    bl = true;
                }
                this.buf.append("atomic_event.name not like ' : ' ");
            }
            if (list2 != null) {
                n2 = 0;
                for (n = 0; n < list2.size(); ++n) {
                    if (bl) {
                        if (n2 != 0) {
                            this.buf.append("or ");
                        } else {
                            this.buf.append("and ");
                            n2 = 1;
                        }
                    } else {
                        this.buf.append("where ");
                        bl = true;
                    }
                    if (dB.getDBType().compareTo("db2") == 0) {
                        this.buf.append("atomic_event.name like ? ");
                        continue;
                    }
                    this.buf.append("atomic_event.name = ? ");
                }
            }
            this.buf.append(")");
        } else {
            this.buf = GeneralChartData.buildCreateTableStatement("event", "temp_event", dB, true, false);
            this.buf.append("(select interval_event.* from interval_event ");
            this.buf.append("inner join temp_trial ");
            this.buf.append("on interval_event.trial = temp_trial.id ");
            this.buf.append("inner join interval_mean_summary ");
            this.buf.append("on interval_mean_summary.interval_event = interval_event.id ");
            this.buf.append("inner join temp_metric ");
            this.buf.append("on interval_mean_summary.metric = temp_metric.id ");
            bl = false;
            if (this.model.getEventNoCallpath()) {
                if (bl) {
                    this.buf.append("and ");
                } else {
                    this.buf.append("where ");
                    bl = true;
                }
                this.buf.append("(interval_event.group_name is null ");
                this.buf.append("or (interval_event.group_name not like '%TAU_CALLPATH%')) ");
            }
            if (this.model.getDimensionReduction() == TransformationType.OVER_X_PERCENT) {
                if (bl) {
                    this.buf.append("and ");
                } else {
                    this.buf.append("where ");
                    bl = true;
                }
                this.buf.append("interval_mean_summary.exclusive_percentage > ");
                this.buf.append(this.model.getXPercent());
                this.buf.append(" ");
            }
            if (this.model.getEventExclusive100()) {
                if (bl) {
                    this.buf.append("and ");
                } else {
                    this.buf.append("where ");
                    bl = true;
                }
                this.buf.append("interval_mean_summary.exclusive_percentage = 100 ");
            }
            if (list != null) {
                n2 = 0;
                for (n = 0; n < list.size(); ++n) {
                    if (bl) {
                        if (n2 != 0) {
                            this.buf.append("or ");
                        } else {
                            this.buf.append("and ");
                            n2 = 1;
                        }
                    } else {
                        this.buf.append("where ");
                        bl = true;
                    }
                    if (dB.getDBType().compareTo("db2") == 0) {
                        this.buf.append("interval_event.group_name like ? ");
                        continue;
                    }
                    this.buf.append("interval_event.group_name = ? ");
                }
            }
            if (list2 != null) {
                for (n2 = 0; n2 < list2.size(); ++n2) {
                    if (n2 == 0 && bl) {
                        this.buf.append("and ");
                    } else if (n2 == 0) {
                        this.buf.append("where ");
                        bl = true;
                    } else {
                        this.buf.append("or ");
                    }
                    if (dB.getDBType().compareTo("db2") == 0) {
                        this.buf.append("interval_event.name like ? ");
                        continue;
                    }
                    this.buf.append("interval_event.name = ? ");
                }
            }
            this.buf.append(")");
        }
        PreparedStatement preparedStatement = dB.prepareStatement(this.buf.toString());
        n2 = 1;
        if (list != null) {
            for (n = 0; n < list.size(); ++n) {
                string = list.get(n);
                preparedStatement.setString(n2, string);
                ++n2;
            }
        }
        if (list2 != null) {
            for (n = 0; n < list2.size(); ++n) {
                string = list2.get(n);
                preparedStatement.setString(n2, string);
                ++n2;
            }
        }
        preparedStatement.execute();
        preparedStatement.close();
    }

    private void mainOnly(DB dB) throws SQLException {
        if (this.model.getMainEventOnly()) {
            this.buf = new StringBuilder();
            this.buf.append("select ie.name from interval_event ie ");
            this.buf.append("inner join interval_mean_summary ims ");
            this.buf.append("on ie.id = ims.interval_event, ");
            this.buf.append("(select temp_trial.id as trialid, ");
            this.buf.append("temp_metric.id as metricid, ");
            this.buf.append("max(interval_mean_summary.inclusive) as maxinclusive ");
            this.buf.append("from interval_event inner join temp_trial ");
            this.buf.append("on interval_event.trial = temp_trial.id ");
            this.buf.append("inner join interval_mean_summary on ");
            this.buf.append("interval_mean_summary.interval_event = interval_event.id ");
            this.buf.append("inner join temp_metric ");
            this.buf.append("on interval_mean_summary.metric = temp_metric.id ");
            if (dB.getDBType().compareTo("derby") == 0) {
                this.buf.append("group by temp_trial.id, temp_metric.id) mr ");
            } else {
                this.buf.append("group by 1, 2) mr ");
            }
            this.buf.append("where ie.trial = trialid ");
            this.buf.append("and ims.metric = metricid ");
            this.buf.append("and ims.inclusive = maxinclusive");
            PreparedStatement preparedStatement = dB.prepareStatement(this.buf.toString());
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                this.model.addEventName(resultSet.getString(1));
            }
            resultSet.close();
            preparedStatement.close();
        }
    }

    private void createPopTempMetricTable(DB dB) throws SQLException {
        if (!this.model.getChartSeriesName().equals("atomic_event.name")) {
            this.buf = GeneralChartData.buildCreateTableStatement("metric", "temp_metric", dB, true, false);
            this.buf.append("(select metric.* from metric ");
            this.buf.append("inner join temp_trial ");
            this.buf.append("on metric.trial = temp_trial.id ");
            List<String> list = this.model.getMetricNames();
            if (list != null) {
                this.buf.append("where upper(metric.name) like ? ");
                for (int i = 1; i < list.size(); ++i) {
                    this.buf.append("or upper(metric.name) like ? ");
                }
            }
            this.buf.append(") ");
            PreparedStatement preparedStatement = dB.prepareStatement(this.buf.toString());
            if (list != null) {
                for (int i = 1; i <= list.size(); ++i) {
                    String string = list.get(i - 1);
                    preparedStatement.setString(i, string.toUpperCase());
                }
            }
            preparedStatement.execute();
            preparedStatement.close();
        }
    }

    private boolean checkAndLoadXML(DB dB) throws SQLException, ParserConfigurationException, SAXException, IOException, XPathExpressionException {
        boolean bl = false;
        if (this.model.getChartMetadataFieldName() != null || this.model.getChartMetadataFieldValue() != null || this.model.getChartSeriesName().toUpperCase().indexOf("XML") > 0 || this.model.getChartXAxisName().toUpperCase().indexOf("XML") > 0) {
            bl = true;
            Trial.getMetaData((DB)dB, (boolean)true);
            String[] stringArray = dB.getDatabase().getTrialFieldNames();
            boolean bl2 = false;
            boolean bl3 = false;
            for (int i = 0; i < Array.getLength(stringArray); ++i) {
                if (stringArray[i].equalsIgnoreCase("XML_METADATA")) {
                    bl2 = true;
                    continue;
                }
                if (!stringArray[i].equalsIgnoreCase("XML_METADATA_GZ")) continue;
                bl3 = true;
            }
            if (bl2) {
                this.buf = GeneralChartData.buildCreateTableStatement("xml_metadata", "temp_xml_metadata", dB, false, false);
                if (dB.getDBType().compareTo("derby") == 0) {
                    this.buf.append(" (trial int, metadata_name varchar(4000), metadata_value varchar(4000))");
                } else {
                    this.buf.append(" (trial int, metadata_name text, metadata_value text)");
                }
                PreparedStatement preparedStatement = dB.prepareStatement(this.buf.toString());
                preparedStatement.execute();
                preparedStatement.close();
                preparedStatement = bl3 ? dB.prepareStatement("select id, XML_METADATA, XML_METADATA_GZ from temp_trial ") : dB.prepareStatement("select id, XML_METADATA from temp_trial ");
                ResultSet resultSet = preparedStatement.executeQuery();
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                dB.setAutoCommit(false);
                while (resultSet.next()) {
                    Closeable closeable;
                    String string = resultSet.getString(2);
                    if (bl3 && (string == null || string.length() == 0)) {
                        closeable = resultSet.getBinaryStream(3);
                        string = Gzip.decompress((InputStream)closeable);
                    }
                    if (string == null || string.length() == 0) continue;
                    closeable = new StringReader(string);
                    InputSource inputSource = new InputSource((Reader)closeable);
                    Document document = documentBuilder.parse(inputSource);
                    NodeList nodeList = null;
                    NodeList nodeList2 = null;
                    XPath xPath = XPathFactory.newInstance().newXPath();
                    xPath.setNamespaceContext(new TauNamespaceContext());
                    nodeList = (NodeList)xPath.evaluate("/metadata/CommonProfileAttributes/attribute/name", document, XPathConstants.NODESET);
                    nodeList2 = (NodeList)xPath.evaluate("/metadata/CommonProfileAttributes/attribute/value", document, XPathConstants.NODESET);
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        Node node = nodeList.item(i).getFirstChild();
                        Node node2 = nodeList2.item(i).getFirstChild();
                        if (this.model.getChartMetadataFieldName() != null && !this.model.getChartMetadataFieldName().equals(node.getNodeValue()) || this.model.getChartMetadataFieldValue() != null && !this.model.getChartMetadataFieldValue().equals(node2.getNodeValue())) continue;
                        this.buf = new StringBuilder();
                        this.buf.append("insert into temp_xml_metadata VALUES (?,?,?)");
                        PreparedStatement preparedStatement2 = dB.prepareStatement(this.buf.toString());
                        preparedStatement2.setInt(1, resultSet.getInt(1));
                        preparedStatement2.setString(2, node.getNodeValue());
                        if (node2 == null) {
                            preparedStatement2.setString(3, "");
                        } else {
                            preparedStatement2.setString(3, node2.getNodeValue());
                        }
                        preparedStatement2.executeUpdate();
                        preparedStatement2.close();
                    }
                }
                dB.commit();
                resultSet.close();
                preparedStatement.close();
                dB.setAutoCommit(true);
            }
        }
        return bl;
    }

    private void createPopulateTempTrailTable(DB dB) throws SQLException {
        Object object;
        this.buf = GeneralChartData.buildCreateTableStatement("trial", "temp_trial", dB, true, false);
        this.buf.append("(select trial.* from trial ");
        this.buf.append("inner join experiment ");
        this.buf.append("on trial.experiment = experiment.id ");
        this.buf.append("inner join application ");
        this.buf.append("on experiment.application = application.id ");
        this.buf.append("where ");
        List<Object> list = this.model.getMultiSelection();
        if (list == null) {
            object = this.model.getCurrentSelection();
            if (object instanceof Application) {
                this.buf.append("application.id = " + this.model.getApplication().getID());
            } else if (object instanceof Experiment) {
                this.buf.append("experiment.id = " + this.model.getExperiment().getID());
            } else if (object instanceof Trial) {
                this.buf.append("trial.id = " + this.model.getTrial().getID());
            }
        } else {
            int n;
            int n2;
            boolean bl = false;
            for (n2 = 0; n2 < list.size(); ++n2) {
                if (!(list.get(n2) instanceof Application)) continue;
                Application application = (Application)list.get(n2);
                if (!bl) {
                    this.buf.append("application.id in (");
                    bl = true;
                } else {
                    this.buf.append(",");
                }
                this.buf.append(application.getID());
            }
            if (bl) {
                this.buf.append(") ");
            }
            n2 = 0;
            for (n = 0; n < list.size(); ++n) {
                if (!(list.get(n) instanceof Experiment)) continue;
                Experiment experiment = (Experiment)list.get(n);
                if (n2 == 0) {
                    if (bl) {
                        this.buf.append(" and ");
                    }
                    this.buf.append("experiment.id in (");
                    n2 = 1;
                } else {
                    this.buf.append(",");
                }
                this.buf.append(experiment.getID());
            }
            if (n2 != 0) {
                this.buf.append(") ");
            }
            n = 0;
            for (int i = 0; i < list.size(); ++i) {
                if (!(list.get(i) instanceof Trial)) continue;
                Trial trial = (Trial)list.get(i);
                if (n == 0) {
                    if (bl || n2 != 0) {
                        this.buf.append(" and ");
                    }
                    this.buf.append("trial.id in (");
                    n = 1;
                } else {
                    this.buf.append(",");
                }
                this.buf.append(trial.getID());
            }
            if (n != 0) {
                this.buf.append(") ");
            }
        }
        this.buf.append(") ");
        object = dB.prepareStatement(this.buf.toString());
        object.execute();
        object.close();
    }

    private static StringBuilder buildCreateTableStatement(String string, String string2, DB dB, boolean bl, boolean bl2) {
        GeneralChartData.dropTable(dB, string2);
        StringBuilder stringBuilder = new StringBuilder();
        if (dB.getDBType().equalsIgnoreCase("oracle")) {
            stringBuilder.append("create global temporary table ");
        } else if (dB.getDBType().equalsIgnoreCase("derby") || dB.getDBType().equalsIgnoreCase("db2")) {
            stringBuilder.append("create table ");
        } else {
            stringBuilder.append("create temporary table ");
        }
        stringBuilder.append(string2 + " ");
        if (bl) {
            if (dB.getDBType().equalsIgnoreCase("derby")) {
                String[] stringArray = null;
                String[] stringArray2 = null;
                if (string.equalsIgnoreCase("trial")) {
                    Trial.getMetaData((DB)dB, (boolean)true);
                    stringArray = dB.getDatabase().getTrialFieldNames();
                    stringArray2 = dB.getDatabase().getTrialFieldTypeNames();
                    Trial.getMetaData((DB)dB, (boolean)false);
                } else if (string.equalsIgnoreCase("metric")) {
                    Metric.getMetaData((DB)dB);
                    stringArray = dB.getDatabase().getMetricFieldNames();
                    stringArray2 = dB.getDatabase().getMetricFieldTypeNames();
                } else if (string.equalsIgnoreCase("event")) {
                    if (bl2) {
                        AtomicEvent.getMetaData((DB)dB);
                        stringArray = dB.getDatabase().getAtomicEventFieldNames();
                        stringArray2 = dB.getDatabase().getAtomicEventFieldTypeNames();
                    } else {
                        IntervalEvent.getMetaData((DB)dB);
                        stringArray = dB.getDatabase().getIntervalEventFieldNames();
                        stringArray2 = dB.getDatabase().getIntervalEventFieldTypeNames();
                    }
                }
                stringBuilder.append(" (");
                for (int i = 0; i < Array.getLength(stringArray); ++i) {
                    if (i > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(stringArray[i] + " " + stringArray2[i]);
                }
                stringBuilder.append(") ");
                try {
                    PreparedStatement preparedStatement = dB.prepareStatement(stringBuilder.toString());
                    preparedStatement.execute();
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {
                    System.err.println(stringBuilder.toString());
                    System.err.println(sQLException.getMessage());
                    sQLException.printStackTrace(System.err);
                }
                stringBuilder = new StringBuilder();
                stringBuilder.append(" insert into " + string2 + " ");
            } else {
                stringBuilder.append("as ");
            }
        }
        return stringBuilder;
    }

    private String fixClause(String string, DB dB) {
        String string2 = string.replaceAll("trial.", "temp_trial.").replaceAll("metric.", "temp_metric.").replaceAll("interval_event.", "temp_event.").replaceAll("atomic_event.", "temp_event.");
        if (dB.getDBType().equalsIgnoreCase("oracle")) {
            string2 = string2.replaceAll("exclusive", "exec");
        }
        if (dB.getDBType().equalsIgnoreCase("derby")) {
            string2 = string2.replaceAll("call", "num_calls");
            string2 = string2.replaceAll(" \\* ", ", ");
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getXMLFields(RMIPerfExplorerModel rMIPerfExplorerModel) {
        Object object;
        StringBuilder stringBuilder = null;
        Statement statement = null;
        HashSet<String> hashSet = new HashSet<String>();
        DB dB = null;
        try {
            Object object2;
            dB = PerfExplorerServer.getServer().getDB();
            Trial.getMetaData((DB)dB, (boolean)true);
            object = dB.getDatabase().getTrialFieldNames();
            boolean bl = false;
            boolean bl2 = false;
            for (int i = 0; i < Array.getLength(object); ++i) {
                if (object[i].equalsIgnoreCase("XML_METADATA")) {
                    bl = true;
                    continue;
                }
                if (!object[i].equalsIgnoreCase("XML_METADATA_GZ")) continue;
                bl2 = true;
            }
            if (!bl) {
                ArrayList<String> arrayList = new ArrayList<String>();
                return arrayList;
            }
            stringBuilder = GeneralChartData.buildCreateTableStatement("trial", "temp_trial", dB, true, false);
            stringBuilder.append("(select trial.* from trial ");
            stringBuilder.append("inner join experiment ");
            stringBuilder.append("on trial.experiment = experiment.id ");
            stringBuilder.append("inner join application ");
            stringBuilder.append("on experiment.application = application.id ");
            stringBuilder.append("where ");
            List<Object> list = rMIPerfExplorerModel.getMultiSelection();
            if (list == null) {
                Object object3 = rMIPerfExplorerModel.getCurrentSelection();
                if (object3 instanceof Application) {
                    stringBuilder.append("application.id = " + rMIPerfExplorerModel.getApplication().getID());
                } else if (object3 instanceof Experiment) {
                    stringBuilder.append("experiment.id = " + rMIPerfExplorerModel.getExperiment().getID());
                } else if (object3 instanceof Trial) {
                    stringBuilder.append("trial.id = " + rMIPerfExplorerModel.getTrial().getID());
                }
            } else {
                int n;
                int n2;
                boolean bl3 = false;
                for (n2 = 0; n2 < list.size(); ++n2) {
                    if (!(list.get(n2) instanceof Application)) continue;
                    Application application = (Application)list.get(n2);
                    if (!bl3) {
                        stringBuilder.append("application.id in (");
                        bl3 = true;
                    } else {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append(application.getID());
                }
                if (bl3) {
                    stringBuilder.append(") ");
                }
                n2 = 0;
                for (n = 0; n < list.size(); ++n) {
                    if (!(list.get(n) instanceof Experiment)) continue;
                    Experiment experiment = (Experiment)list.get(n);
                    if (n2 == 0) {
                        if (bl3) {
                            stringBuilder.append(" and ");
                        }
                        stringBuilder.append("experiment.id in (");
                        n2 = 1;
                    } else {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append(experiment.getID());
                }
                if (n2 != 0) {
                    stringBuilder.append(") ");
                }
                n = 0;
                for (int i = 0; i < list.size(); ++i) {
                    if (!(list.get(i) instanceof Trial)) continue;
                    object2 = (Trial)list.get(i);
                    if (n == 0) {
                        if (bl3 || n2 != 0) {
                            stringBuilder.append(" and ");
                        }
                        stringBuilder.append("trial.id in (");
                        n = 1;
                    } else {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append(object2.getID());
                }
                if (n != 0) {
                    stringBuilder.append(") ");
                }
            }
            stringBuilder.append(") ");
            statement = dB.prepareStatement(stringBuilder.toString());
            statement.execute();
            statement.close();
            statement = null;
            statement = bl2 ? dB.prepareStatement("select id, XML_METADATA, XML_METADATA_GZ from temp_trial ") : dB.prepareStatement("select id, XML_METADATA from temp_trial ");
            ResultSet resultSet = statement.executeQuery();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            while (resultSet.next()) {
                Node node;
                int n;
                String string = resultSet.getString(2);
                if (bl2 && (string == null || string.length() == 0)) {
                    object2 = resultSet.getBinaryStream(3);
                    string = Gzip.decompress((InputStream)object2);
                }
                object2 = new StringReader(string);
                InputSource inputSource = new InputSource((Reader)object2);
                Document document = documentBuilder.parse(inputSource);
                NodeList nodeList = null;
                XPath xPath = XPathFactory.newInstance().newXPath();
                xPath.setNamespaceContext(new TauNamespaceContext());
                nodeList = (NodeList)xPath.evaluate("/metadata/CommonProfileAttributes/attribute/name", document, XPathConstants.NODESET);
                for (n = 0; n < nodeList.getLength(); ++n) {
                    node = nodeList.item(n).getFirstChild();
                    hashSet.add(node.getNodeValue());
                }
                nodeList = (NodeList)xPath.evaluate("/metadata/CommonProfileAttributes/attribute/name", document, XPathConstants.NODESET);
                for (n = 0; n < nodeList.getLength(); ++n) {
                    node = nodeList.item(n).getFirstChild();
                    hashSet.add(node.getNodeValue());
                }
            }
            resultSet.close();
            statement.close();
            statement = null;
        }
        catch (Exception exception) {
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
            GeneralChartData.dropTable(dB, "temp_trial");
        }
        object = new ArrayList(hashSet);
        Collections.sort(object, String.CASE_INSENSITIVE_ORDER);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dropTable(DB dB, String string) {
        Statement statement = null;
        try {
            if (dB.getDBType().compareTo("oracle") == 0) {
                statement = dB.prepareStatement("truncate table " + string);
                statement.execute();
                statement.close();
            }
            statement = dB.prepareStatement("drop table " + string);
            statement.execute();
            statement.close();
        }
        catch (Exception exception) {
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
    }
}

