/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.perfdmf.AtomicLocationProfile;
import edu.uoregon.tau.perfdmf.DatabaseAPI;
import edu.uoregon.tau.perfdmf.database.DB;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtomicEvent {
    private int atomicEventID;
    private String name;
    private String group;
    private int trialID;
    private int experimentID;
    private int applicationID;
    private AtomicLocationProfile meanSummary = null;
    private AtomicLocationProfile totalSummary = null;
    private DatabaseAPI dataSession = null;

    public AtomicEvent(DatabaseAPI databaseAPI) {
        this.dataSession = databaseAPI;
    }

    public int getID() {
        return this.atomicEventID;
    }

    public String getName() {
        return this.name;
    }

    public String getGroup() {
        return this.group;
    }

    public int getTrialID() {
        return this.trialID;
    }

    public int getExperimentID() {
        return this.experimentID;
    }

    public int getApplicationID() {
        return this.applicationID;
    }

    public AtomicLocationProfile getMeanSummary() {
        if (this.meanSummary == null) {
            this.dataSession.getAtomicEventDetail(this);
        }
        return this.meanSummary;
    }

    public AtomicLocationProfile getTotalSummary() {
        if (this.totalSummary == null) {
            this.dataSession.getAtomicEventDetail(this);
        }
        return this.totalSummary;
    }

    public void setID(int n) {
        this.atomicEventID = n;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setGroup(String string) {
        this.group = string;
    }

    public void setTrialID(int n) {
        this.trialID = n;
    }

    public void setExperimentID(int n) {
        this.experimentID = n;
    }

    public void setApplicationID(int n) {
        this.applicationID = n;
    }

    public void setMeanSummary(AtomicLocationProfile atomicLocationProfile) {
        this.meanSummary = atomicLocationProfile;
    }

    public void setTotalSummary(AtomicLocationProfile atomicLocationProfile) {
        this.totalSummary = atomicLocationProfile;
    }

    public static Vector<AtomicEvent> getAtomicEvents(DatabaseAPI databaseAPI, DB dB, String string) {
        Vector<AtomicEvent> vector = new Vector<AtomicEvent>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select u.id, u.trial, u.name, ");
        stringBuffer.append("u.group_name ");
        stringBuffer.append("from " + dB.getSchemaPrefix() + "atomic_event u inner join " + dB.getSchemaPrefix() + "trial t on u.trial = t.id ");
        stringBuffer.append("inner join " + dB.getSchemaPrefix() + "experiment e on t.experiment = e.id ");
        stringBuffer.append(string);
        stringBuffer.append(" order by id ");
        try {
            ResultSet resultSet = dB.executeQuery(stringBuffer.toString());
            while (resultSet.next()) {
                AtomicEvent atomicEvent = new AtomicEvent(databaseAPI);
                atomicEvent.setID(resultSet.getInt(1));
                atomicEvent.setTrialID(resultSet.getInt(2));
                atomicEvent.setName(resultSet.getString(3));
                atomicEvent.setGroup(resultSet.getString(4));
                vector.addElement(atomicEvent);
            }
            resultSet.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return vector;
    }

    public int saveAtomicEvent(DB dB, int n) {
        int n2 = 0;
        try {
            PreparedStatement preparedStatement = null;
            preparedStatement = dB.prepareStatement("INSERT INTO " + dB.getSchemaPrefix() + "atomic_event (trial, name, group_name) VALUES (?, ?, ?)");
            preparedStatement.setInt(1, n);
            preparedStatement.setString(2, this.name);
            preparedStatement.setString(3, this.group);
            preparedStatement.executeUpdate();
            String string = new String();
            string = dB.getDBType().compareTo("mysql") == 0 ? "select LAST_INSERT_ID();" : (dB.getDBType().compareTo("derby") == 0 ? "select IDENTITY_VAL_LOCAL() FROM atomic_event" : (dB.getDBType().compareTo("h2") == 0 ? "select IDENTITY_VAL_LOCAL() FROM atomic_event" : (dB.getDBType().compareTo("db2") == 0 ? "select IDENTITY_VAL_LOCAL() FROM atomic_event" : (dB.getDBType().compareTo("oracle") == 0 ? "select " + dB.getSchemaPrefix() + "atomic_event_id_seq.currval FROM dual" : "select currval('atomic_event_id_seq');"))));
            n2 = Integer.parseInt(dB.getDataItem(string));
        }
        catch (SQLException sQLException) {
            System.out.println("An error occurred while saving the trial.");
            sQLException.printStackTrace();
        }
        return n2;
    }

    public static void getMetaData(DB dB) {
        try {
            String[] stringArray;
            Object object;
            int n;
            ResultSet resultSet = null;
            DatabaseMetaData databaseMetaData = dB.getMetaData();
            resultSet = dB.getDBType().compareTo("oracle") == 0 || dB.getDBType().compareTo("derby") == 0 || dB.getDBType().compareTo("db2") == 0 ? databaseMetaData.getColumns(null, null, "ATOMIC_EVENT", "%") : databaseMetaData.getColumns(null, null, "atomic_event", "%");
            Vector<String> vector = new Vector<String>();
            Vector<Integer> vector2 = new Vector<Integer>();
            ArrayList<String[]> arrayList = new ArrayList<String[]>();
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            boolean bl = false;
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            for (n = 0; n < resultSetMetaData.getColumnCount(); ++n) {
            }
            while (resultSet.next()) {
                n = resultSet.getInt("DATA_TYPE");
                object = resultSet.getString("COLUMN_NAME");
                stringArray = resultSet.getString("TYPE_NAME");
                Integer n2 = new Integer(resultSet.getInt("COLUMN_SIZE"));
                if (((String)object).equals("ID")) {
                    if (bl) break;
                    bl = true;
                }
                vector.add(resultSet.getString("COLUMN_NAME"));
                vector2.add(new Integer(n));
                arrayList.add(stringArray);
                arrayList2.add(n2);
            }
            resultSet.close();
            String[] stringArray2 = new String[vector.size()];
            object = new int[vector2.size()];
            stringArray = new String[vector2.size()];
            for (int i = 0; i < vector2.size(); ++i) {
                stringArray2[i] = (String)vector.get(i);
                object[i] = (Integer)vector2.get(i);
                stringArray[i] = (Integer)arrayList2.get(i) > 255 ? (String)arrayList.get(i) + "(" + ((Integer)arrayList2.get(i)).toString() + ")" : (String)arrayList.get(i);
            }
            dB.getDatabase().setAtomicEventFieldNames(stringArray2);
            dB.getDatabase().setAtomicEventFieldTypeNames(stringArray);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }
}

