/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.common.Utility;
import edu.uoregon.tau.perfdmf.CallPathUtilFuncs;
import edu.uoregon.tau.perfdmf.Context;
import edu.uoregon.tau.perfdmf.DataSourceException;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.Group;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.Node;
import edu.uoregon.tau.perfdmf.Snapshot;
import edu.uoregon.tau.perfdmf.Thread;
import edu.uoregon.tau.perfdmf.UserEvent;
import edu.uoregon.tau.perfdmf.UserEventProfile;
import edu.uoregon.tau.perfdmf.UtilFncs;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DataSource {
    public static final SimpleDateFormat dateTime = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    public static final int PPK = 0;
    public static final int TAUPROFILE = 1;
    public static final int SNAP = 2;
    public static final int DYNAPROF = 3;
    public static final int MPIP = 4;
    public static final int HPM = 5;
    public static final int GPROF = 6;
    public static final int PSRUN = 7;
    public static final int PPROF = 8;
    public static final int CUBE = 9;
    public static final int HPCTOOLKIT = 10;
    public static final int OMPP = 11;
    public static final int PERIXML = 12;
    public static final int GPTL = 13;
    public static final int PARAVER = 14;
    public static final int IPM = 15;
    public static final int GOOGLE = 16;
    public static final int CUBE3 = 17;
    public static final int GYRO = 100;
    public static final int GAMESS = 101;
    public static final String FILE_TYPE_INDEX = "File Type Index";
    public static final String FILE_TYPE_NAME = "File Type Name";
    public static String[] formatTypeStrings = new String[]{"ParaProf Packed Profile", "TAU profiles", "TAU Snapshot", "Dynaprof", "MpiP", "HPMToolkit", "Gprof", "PSRun", "Tau pprof.dat", "Cube", "HPCToolkit", "ompP", "PERI-XML", "General Purpose Timing Library (GPTL)", "Paraver", "IPM", "Google PerfTools", "Cube 3 (Old parser)"};
    private static boolean meanIncludeNulls = true;
    private boolean userEventsPresent = false;
    private boolean callPathDataPresent = false;
    private boolean groupNamesPresent = false;
    private boolean phasesPresent = false;
    private Function topLevelPhase;
    protected List<Metric> metrics = null;
    protected Thread meanData = null;
    protected Thread totalData = null;
    protected Thread stddevData = null;
    protected Thread meanDataAll = null;
    protected Thread stddevDataAll = null;
    protected Thread meanDataNoNull = null;
    protected Thread stddevDataNoNull = null;
    protected Thread minData = null;
    protected Thread maxData = null;
    private Map<Integer, Node> nodes = new TreeMap<Integer, Node>();
    private Map<String, Function> functions = new TreeMap<String, Function>();
    private Map<String, Group> groups = new TreeMap<String, Group>();
    private Map<String, UserEvent> userEvents = new TreeMap<String, UserEvent>();
    private List<Thread> allThreads;
    private boolean generateIntermediateCallPathData;
    private boolean reverseDataAvailable;
    private int[] maxNCT = null;
    protected volatile boolean reloading;
    protected Map<String, String> metaData = new TreeMap<String, String>();
    protected Map<String, String> uncommonMetaData = new TreeMap<String, String>();
    private File metadataFile;
    private StringBuffer metadataString = new StringBuffer();
    private boolean wellBehavedSnapshots;
    private long avgStartTime;
    protected boolean monitored;
    protected boolean hasThreads = true;
    protected boolean hasContexts = true;
    protected boolean hasMPI = false;
    private int fileType = 1;
    protected boolean derivedProvided = false;
    protected boolean derivedAtomicProvided = false;
    private List<Thread> aggThreads = null;
    public static final int EXEC_TYPE_SINGLE = 0;
    public static final int EXEC_TYPE_MPI = 1;
    public static final int EXEC_TYPE_THREADED = 2;
    public static final int EXEC_TYPE_HYBRID = 3;
    public static final int EXEC_TYPE_OTHER = 4;

    public abstract void load() throws FileNotFoundException, IOException, DataSourceException, SQLException;

    public abstract int getProgress();

    public abstract void cancelLoad();

    public boolean isDerivedProvided() {
        return this.derivedProvided;
    }

    public void setDerivedProvided(boolean bl) {
        this.derivedProvided = bl;
    }

    public int getFileType() {
        return this.fileType;
    }

    public void setFileType(int n) {
        this.fileType = n;
    }

    public List<File> getFiles() {
        return new ArrayList<File>();
    }

    public boolean isReloading() {
        return this.reloading;
    }

    public boolean reloadData() throws Exception {
        if (this.reloading) {
            return false;
        }
        this.reloading = true;
        this.cleanData();
        this.load();
        this.reloading = false;
        return true;
    }

    protected void cleanData() {
        for (Thread thread : this.getAllThreads()) {
            Iterator<FunctionProfile> iterator = thread.getFunctionProfileIterator();
            while (iterator.hasNext()) {
                FunctionProfile functionProfile = iterator.next();
                if (functionProfile == null) continue;
                for (int i = 0; i < this.getNumberOfMetrics(); ++i) {
                    functionProfile.setExclusive(i, 0.0);
                    functionProfile.setInclusive(i, 0.0);
                }
                functionProfile.setNumSubr(0.0);
                functionProfile.setNumCalls(0.0);
            }
        }
    }

    public void setMonitored(boolean bl) {
        this.monitored = bl;
    }

    public Thread getMeanData() {
        return this.meanData;
    }

    public Thread getStdDevData() {
        return this.stddevData;
    }

    public Thread getTotalData() {
        return this.totalData;
    }

    public Thread getMaxData() {
        return this.maxData;
    }

    public Thread getMinData() {
        return this.minData;
    }

    private void setCallPathDataPresent(boolean bl) {
        this.callPathDataPresent = bl;
    }

    public boolean getCallPathDataPresent() {
        return this.callPathDataPresent;
    }

    protected void setGroupNamesPresent(boolean bl) {
        this.groupNamesPresent = bl;
    }

    public boolean getGroupNamesPresent() {
        return this.groupNamesPresent;
    }

    protected void setUserEventsPresent(boolean bl) {
        this.userEventsPresent = bl;
    }

    public boolean getUserEventsPresent() {
        return this.userEventsPresent;
    }

    public Function addFunction(String string) {
        return this.addFunction(string, this.getNumberOfMetrics());
    }

    public Function addFunction(String string, int n) {
        Function function = this.functions.get(string = string.trim());
        if (function != null) {
            return function;
        }
        function = new Function(string, this.functions.size(), n);
        this.functions.put(string, function);
        return function;
    }

    public Function getFunction(String string) {
        Function function = this.functions.get(string.trim());
        if (function != null) {
            return function;
        }
        return this.functions.get(string.trim() + " [THROTTLED]");
    }

    public int getNumFunctions() {
        return this.functions.size();
    }

    public Iterator<Function> getFunctions() {
        return this.functions.values().iterator();
    }

    public UserEvent addUserEvent(String string) {
        UserEvent userEvent = this.userEvents.get(string);
        if (userEvent != null) {
            return userEvent;
        }
        UserEvent userEvent2 = new UserEvent(string, this.userEvents.size() + 1);
        this.userEvents.put(string, userEvent2);
        this.setUserEventsPresent(true);
        return userEvent2;
    }

    public UserEvent getUserEvent(String string) {
        return this.userEvents.get(string);
    }

    public int getNumUserEvents() {
        return this.userEvents.size();
    }

    public Iterator<UserEvent> getUserEvents() {
        return this.userEvents.values().iterator();
    }

    public Group getGroup(String string) {
        return this.groups.get(string);
    }

    public Group addGroup(String string) {
        Group group;
        if ((string = string.trim()) == "TAU_MPI") {
            this.hasMPI = true;
        }
        if ((group = this.groups.get(string)) != null) {
            return group;
        }
        Group group2 = new Group(string, this.groups.size() + 1);
        this.groups.put(string, group2);
        return group2;
    }

    protected void addGroups(String string, Function function) {
        if (string == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2 == null) continue;
            Group group = this.addGroup(string2.trim());
            function.addGroup(group);
        }
        this.setGroupNamesPresent(true);
    }

    public int getNumGroups() {
        return this.groups.size();
    }

    public Iterator<Group> getGroups() {
        return this.groups.values().iterator();
    }

    public int[] getMaxNCTNumbers() {
        if (this.maxNCT == null) {
            this.maxNCT = new int[3];
            Iterator<Node> iterator = this.getNodes();
            while (iterator.hasNext()) {
                Node node = iterator.next();
                this.maxNCT[0] = Math.max(this.maxNCT[0], node.getNodeID());
                Iterator<Context> iterator2 = node.getContexts();
                while (iterator2.hasNext()) {
                    Context context = iterator2.next();
                    this.maxNCT[1] = Math.max(this.maxNCT[1], context.getContextID());
                    Iterator<Thread> iterator3 = context.getThreads();
                    while (iterator3.hasNext()) {
                        Thread thread = iterator3.next();
                        this.maxNCT[2] = Math.max(this.maxNCT[2], thread.getThreadID());
                    }
                }
            }
        }
        return this.maxNCT;
    }

    public int getNumThreads() {
        int n = 0;
        Iterator<Node> iterator = this.getNodes();
        while (iterator.hasNext()) {
            Node node = iterator.next();
            Iterator<Context> iterator2 = node.getContexts();
            while (iterator2.hasNext()) {
                Context context = iterator2.next();
                Iterator<Thread> iterator3 = context.getThreads();
                while (iterator3.hasNext()) {
                    iterator3.next();
                    ++n;
                }
            }
        }
        return n;
    }

    public void setMetrics(List<Metric> list) {
        this.metrics = list;
    }

    public void addMetric(Metric metric) {
        if (this.metrics == null) {
            this.metrics = new ArrayList<Metric>();
        } else {
            for (Thread thread : this.getAllThreads()) {
                thread.addMetric();
            }
            if (this.meanData != null) {
                this.meanData.addMetric();
                this.totalData.addMetric();
                this.stddevData.addMetric();
                if (this.maxData != null && this.minData != null) {
                    this.maxData.addMetric();
                    this.minData.addMetric();
                }
            }
        }
        metric.setID(this.getNumberOfMetrics());
        this.metrics.add(metric);
    }

    public Metric addMetric(String string) {
        if (this.metrics != null) {
            for (Metric metric : this.metrics) {
                if (!metric.getName().equals(string)) continue;
                return metric;
            }
        }
        Metric metric = new Metric();
        metric.setName(string);
        this.addMetric(metric);
        return metric;
    }

    public Metric addMetricNoCheck(String string) {
        Metric metric = new Metric();
        metric.setName(string);
        this.addMetric(metric);
        return metric;
    }

    public Metric addMetric(String string, Thread thread) {
        Metric metric = null;
        if (this.metrics == null) {
            this.metrics = new ArrayList<Metric>();
        } else {
            for (Metric metric2 : this.metrics) {
                if (!metric2.getName().equals(string)) continue;
                metric = metric2;
                break;
            }
        }
        if (metric == null) {
            metric = new Metric();
            metric.setName(string);
            metric.setID(this.getNumberOfMetrics());
            this.metrics.add(metric);
        }
        if (thread.getNumMetrics() < this.getNumberOfMetrics()) {
            thread.addMetric();
        }
        return metric;
    }

    public List<Metric> getMetrics() {
        return this.metrics;
    }

    public void clearMetrics() {
        this.metrics = null;
    }

    public Metric getMetric(String string) {
        for (Metric metric : this.metrics) {
            if (!metric.getName().equals(string)) continue;
            return metric;
        }
        return null;
    }

    public Metric getMetric(int n) {
        if (this.metrics != null && n < this.metrics.size()) {
            return this.metrics.get(n);
        }
        return null;
    }

    public String getMetricName(int n) {
        if (this.metrics != null && n < this.metrics.size()) {
            return this.metrics.get(n).getName();
        }
        return null;
    }

    public int getNumberOfMetrics() {
        if (this.metrics != null) {
            return this.metrics.size();
        }
        return 0;
    }

    private void generateBonusCallPathData() {
        Comparable<Function> comparable;
        if (!this.getCallPathDataPresent()) {
            return;
        }
        ArrayList<Function> arrayList = new ArrayList<Function>();
        Iterator<Function> iterator = this.getFunctions();
        while (iterator.hasNext()) {
            comparable = iterator.next();
            arrayList.add((Function)comparable);
        }
        this.initAllThreadsList();
        int n = this.allThreads.size();
        comparable = this.addGroup("TAU_CALLPATH_DERIVED");
        this.reverseDataAvailable = true;
        for (Function function : arrayList) {
            if (!function.isCallPathFunction() || !CallPathUtilFuncs.containsDoublePath(function.getName())) continue;
            String string = function.getName();
            string = string.substring(string.indexOf("=>") + 2);
            while (string.indexOf("=>") != -1) {
                Function function2 = this.getFunction(string);
                if (function2 == null) {
                    function2 = this.addFunction(string);
                    Iterator<Group> iterator2 = function.getGroups().iterator();
                    while (iterator2.hasNext()) {
                        function2.addGroup(iterator2.next());
                    }
                }
                function2.addGroup((Group)comparable);
                string = string.substring(string.indexOf("=>") + 2);
                for (int i = 0; i < n; ++i) {
                    Thread thread = this.allThreads.get(i);
                    FunctionProfile functionProfile = thread.getFunctionProfile(function);
                    if (functionProfile == null) continue;
                    FunctionProfile functionProfile2 = thread.getFunctionProfile(function2);
                    if (functionProfile2 == null) {
                        functionProfile2 = new FunctionProfile(function2, this.getNumberOfMetrics(), thread.getNumSnapshots());
                        thread.addFunctionProfile(functionProfile2);
                    }
                    for (int j = 0; j < this.getNumberOfMetrics(); ++j) {
                        functionProfile2.setExclusive(j, functionProfile2.getExclusive(j) + functionProfile.getExclusive(j));
                        functionProfile2.setInclusive(j, functionProfile2.getInclusive(j) + functionProfile.getInclusive(j));
                    }
                    functionProfile2.setNumCalls(functionProfile2.getNumCalls() + functionProfile.getNumCalls());
                    functionProfile2.setNumSubr(functionProfile2.getNumSubr() + functionProfile.getNumSubr());
                }
            }
        }
    }

    private void addDerivedSnapshots(Thread thread, Thread thread2) {
        if (this.wellBehavedSnapshots) {
            thread2.setStartTime(this.avgStartTime);
            for (Snapshot snapshot : thread.getSnapshots()) {
                Snapshot snapshot2 = thread2.addSnapshot(snapshot.getName());
                snapshot2.setTimestamp(snapshot.getTimestamp());
            }
        }
    }

    public void generateDerivedData() {
        this.allThreads = null;
        if (CallPathUtilFuncs.checkCallPathsPresent(this.getFunctions())) {
            this.setCallPathDataPresent(true);
        }
        if (this.generateIntermediateCallPathData) {
            this.generateBonusCallPathData();
        }
        this.checkForPhases();
        int n = this.getAllThreads().get(0).getNumSnapshots();
        long l = 0L;
        for (Thread thread : this.getAllThreads()) {
            String string;
            thread.setThreadDataAllMetrics();
            int n2 = thread.getNumSnapshots();
            if (n2 != n) {
                n = -1;
            }
            if ((string = thread.getMetaData().get("Starting Timestamp")) == null) continue;
            l += Long.parseLong(string);
        }
        if (n > 1) {
            this.wellBehavedSnapshots = true;
            this.avgStartTime = (long)((double)l / (double)this.getAllThreads().size());
        }
        try {
            this.generateStatistics(0, this.getNumberOfMetrics() - 1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.meanData.setThreadDataAllMetrics();
        this.totalData.setThreadDataAllMetrics();
        this.stddevData.setThreadDataAllMetrics();
        if (this.maxData != null) {
            this.maxData.setThreadDataAllMetrics();
        }
        if (this.minData != null) {
            this.minData.setThreadDataAllMetrics();
        }
        this.generateAtomicEventStatistics();
        this.finishPhaseAnalysis();
        this.getMetaData().put(FILE_TYPE_INDEX, Integer.toString(this.fileType));
        this.getMetaData().put(FILE_TYPE_NAME, formatTypeStrings[this.fileType]);
    }

    private double computeStdDev(double d, double d2, int n) {
        double d3 = 0.0;
        if (n > 1) {
            d3 = Math.sqrt(Math.abs(d / (double)n - d2 * d2));
        }
        return d3;
    }

    private void generateAtomicEventStatistics() {
        if (this.derivedAtomicProvided) {
            return;
        }
        this.initAllThreadsList();
        int n = this.allThreads.size();
        int n2 = this.meanData.getNumSnapshots();
        int[] nArray = new int[this.getNumUserEvents() + 1];
        for (int i = 0; i < n2; ++i) {
            Object object;
            UserEventProfile userEventProfile;
            Object object2;
            Comparable<Thread> comparable;
            for (int j = 0; j < n; ++j) {
                comparable = this.allThreads.get(j);
                object2 = ((Thread)comparable).getUserEventProfiles();
                while (object2.hasNext()) {
                    userEventProfile = object2.next();
                    object = userEventProfile.getUserEvent();
                    UserEventProfile userEventProfile2 = this.meanData.getUserEventProfile((UserEvent)object);
                    userEventProfile2 = new UserEventProfile((UserEvent)object, n2);
                    this.meanData.addUserEventProfile(userEventProfile2);
                    UserEventProfile userEventProfile3 = this.totalData.getUserEventProfile((UserEvent)object);
                    userEventProfile3 = new UserEventProfile((UserEvent)object, n2);
                    this.totalData.addUserEventProfile(userEventProfile3);
                    UserEventProfile userEventProfile4 = this.stddevData.getUserEventProfile((UserEvent)object);
                    userEventProfile4 = new UserEventProfile((UserEvent)object, n2);
                    this.stddevData.addUserEventProfile(userEventProfile4);
                    int n3 = ((UserEvent)object).getID();
                    nArray[n3] = nArray[n3] + 1;
                    userEventProfile3.setNumSamples(userEventProfile3.getNumSamples() + userEventProfile.getNumSamples(i), i);
                    userEventProfile3.setMaxValue(userEventProfile3.getMaxValue() + userEventProfile.getMaxValue(i), i);
                    userEventProfile3.setMinValue(userEventProfile3.getMinValue() + userEventProfile.getMinValue(i), i);
                    userEventProfile3.setMeanValue(userEventProfile3.getMeanValue() + userEventProfile.getMeanValue(i), i);
                    userEventProfile3.setStdDev(userEventProfile3.getStdDev() + userEventProfile.getStdDev(i), i);
                    userEventProfile4.setNumSamples(userEventProfile4.getNumSamples() + userEventProfile.getNumSamples(i) * userEventProfile.getNumSamples(i), i);
                    userEventProfile4.setMaxValue(userEventProfile4.getMaxValue() + userEventProfile.getMaxValue(i) * userEventProfile.getMaxValue(i), i);
                    userEventProfile4.setMinValue(userEventProfile4.getMinValue() + userEventProfile.getMinValue(i) * userEventProfile.getMinValue(i), i);
                    userEventProfile4.setMeanValue(userEventProfile4.getMeanValue() + userEventProfile.getMeanValue(i) * userEventProfile.getMeanValue(i), i);
                    userEventProfile4.setStdDev(userEventProfile4.getStdDev() + userEventProfile.getStdDev(i) * userEventProfile.getStdDev(i), i);
                }
            }
            Iterator<UserEvent> iterator = this.getUserEvents();
            while (iterator.hasNext()) {
                comparable = iterator.next();
                object2 = this.meanData.getUserEventProfile((UserEvent)comparable);
                userEventProfile = this.totalData.getUserEventProfile((UserEvent)comparable);
                object = this.stddevData.getUserEventProfile((UserEvent)comparable);
                int n4 = n;
                if (!meanIncludeNulls) {
                    n4 = nArray[((UserEvent)comparable).getID()];
                }
                ((UserEventProfile)object2).setNumSamples(userEventProfile.getNumSamples() / (double)n4, i);
                ((UserEventProfile)object2).setMaxValue(userEventProfile.getMaxValue(i) / (double)n4, i);
                ((UserEventProfile)object2).setMinValue(userEventProfile.getMinValue(i) / (double)n4, i);
                ((UserEventProfile)object2).setMeanValue(userEventProfile.getMeanValue(i) / (double)n4, i);
                ((UserEventProfile)object2).setStdDev(userEventProfile.getStdDev(i) / (double)n4, i);
                ((UserEventProfile)object).setNumSamples(this.computeStdDev(((UserEventProfile)object).getNumSamples(i), ((UserEventProfile)object2).getNumSamples(i), n4), i);
                ((UserEventProfile)object).setMaxValue(this.computeStdDev(((UserEventProfile)object).getMaxValue(i), ((UserEventProfile)object2).getMaxValue(i), n4), i);
                ((UserEventProfile)object).setMinValue(this.computeStdDev(((UserEventProfile)object).getMinValue(i), ((UserEventProfile)object2).getMinValue(i), n4), i);
                ((UserEventProfile)object).setMeanValue(this.computeStdDev(((UserEventProfile)object).getMeanValue(i), ((UserEventProfile)object2).getMeanValue(i), n4), i);
                ((UserEventProfile)object).setStdDev(this.computeStdDev(((UserEventProfile)object).getStdDev(i), ((UserEventProfile)object2).getStdDev(i), n4), i);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void generateStatistics(int n, int n2) {
        if (this.derivedProvided) {
            if (meanIncludeNulls) {
                this.meanData = this.meanDataAll;
                this.stddevData = this.stddevDataAll;
            } else {
                this.meanData = this.meanDataNoNull;
                this.stddevData = this.stddevDataNoNull;
            }
        }
        int n3 = this.getNumberOfMetrics();
        Thread thread = this.getAllThreads().get(0);
        if (this.meanData == null) {
            this.meanData = new Thread(-1, -1, -1, n3, this);
            this.addDerivedSnapshots(thread, this.meanData);
        }
        if (this.totalData == null) {
            this.totalData = new Thread(-2, -2, -2, n3, this);
            this.addDerivedSnapshots(thread, this.totalData);
        }
        if (this.stddevData == null) {
            this.stddevData = new Thread(-3, -3, -3, n3, this);
            this.addDerivedSnapshots(thread, this.stddevData);
        }
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        double[] dArray3 = new double[n3];
        double[] dArray4 = new double[n3];
        this.initAllThreadsList();
        for (int i = 0; i < this.meanData.getNumSnapshots(); ++i) {
            Object object;
            for (int j = n; j <= n2; ++j) {
                object = new double[n3];
                for (Thread thread2 : this.allThreads) {
                    if (this.wellBehavedSnapshots) {
                        Object object2 = object;
                        int n4 = j;
                        object2[n4] = object2[n4] + thread2.getMaxInclusive(j, i);
                        continue;
                    }
                    Object object3 = object;
                    int n5 = j;
                    object3[n5] = object3[n5] + thread2.getMaxInclusive(j, thread2.getNumSnapshots() - 1);
                }
                this.totalData.setPercentDivider(j, i, object[j] / 100.0);
                this.meanData.setPercentDivider(j, i, (double)(object[j] / 100.0));
                this.stddevData.setPercentDivider(j, i, (double)(object[j] / 100.0));
                if (this.minData != null) {
                    this.minData.setPercentDivider(j, i, (double)(object[j] / 100.0));
                }
                if (this.maxData == null) continue;
                this.maxData.setPercentDivider(j, i, (double)(object[j] / 100.0));
            }
            Iterator<Function> iterator = this.getFunctions();
            while (iterator.hasNext()) {
                int n6;
                int n7;
                FunctionProfile functionProfile;
                void var13_19;
                object = iterator.next();
                Object object5 = this.meanData.getFunctionProfile((Function)object);
                if (object5 == null) {
                    object5 = new FunctionProfile((Function)object, n3, this.meanData.getNumSnapshots());
                    this.meanData.addFunctionProfile((FunctionProfile)object5);
                }
                ((Function)object).setMeanProfile((FunctionProfile)object5);
                FunctionProfile functionProfile2 = this.totalData.getFunctionProfile((Function)object);
                if (functionProfile2 == null) {
                    FunctionProfile functionProfile3 = new FunctionProfile((Function)object, n3, this.meanData.getNumSnapshots());
                    this.totalData.addFunctionProfile(functionProfile3);
                }
                ((Function)object).setTotalProfile((FunctionProfile)var13_19);
                FunctionProfile functionProfile4 = this.stddevData.getFunctionProfile((Function)object);
                if (functionProfile4 == null) {
                    functionProfile4 = new FunctionProfile((Function)object, n3, this.meanData.getNumSnapshots());
                    this.stddevData.addFunctionProfile(functionProfile4);
                }
                ((Function)object).setStddevProfile(functionProfile4);
                if (this.minData != null) {
                    functionProfile = this.minData.getFunctionProfile((Function)object);
                    if (functionProfile == null) {
                        functionProfile = new FunctionProfile((Function)object, n3, this.meanData.getNumSnapshots());
                        this.minData.addFunctionProfile(functionProfile);
                    }
                    ((Function)object).setMinProfile(functionProfile);
                }
                if (this.maxData != null) {
                    functionProfile = this.maxData.getFunctionProfile((Function)object);
                    if (functionProfile == null) {
                        functionProfile = new FunctionProfile((Function)object, n3, this.meanData.getNumSnapshots());
                        this.maxData.addFunctionProfile(functionProfile);
                    }
                    ((Function)object).setMaxProfile(functionProfile);
                }
                if (this.derivedProvided) continue;
                int n8 = 0;
                double d = 0.0;
                double d2 = 0.0;
                double d3 = 0.0;
                double d4 = 0.0;
                for (n7 = 0; n7 < n3; ++n7) {
                    dArray[n7] = 0.0;
                    dArray2[n7] = 0.0;
                    dArray3[n7] = 0.0;
                    dArray4[n7] = 0.0;
                }
                n7 = this.allThreads.size();
                for (n6 = 0; n6 < n7; ++n6) {
                    Thread thread3 = this.allThreads.get(n6);
                    FunctionProfile functionProfile5 = thread3.getFunctionProfile((Function)object);
                    int n9 = i;
                    if (!this.wellBehavedSnapshots) {
                        n9 = thread3.getNumSnapshots() - 1;
                    }
                    if (functionProfile5 == null) continue;
                    ++n8;
                    for (int j = n; j <= n2; ++j) {
                        int n10 = j;
                        dArray[n10] = dArray[n10] + functionProfile5.getExclusive(n9, j);
                        int n11 = j;
                        dArray2[n11] = dArray2[n11] + functionProfile5.getInclusive(n9, j);
                        int n12 = j;
                        dArray3[n12] = dArray3[n12] + functionProfile5.getExclusive(n9, j) * functionProfile5.getExclusive(n9, j);
                        int n13 = j;
                        dArray4[n13] = dArray4[n13] + functionProfile5.getInclusive(n9, j) * functionProfile5.getInclusive(n9, j);
                        if (j != 0) continue;
                        d += functionProfile5.getNumCalls(n9);
                        d2 += functionProfile5.getNumSubr(n9);
                        d3 += functionProfile5.getNumCalls(n9) * functionProfile5.getNumCalls(n9);
                        d4 += functionProfile5.getNumSubr(n9) * functionProfile5.getNumSubr(n9);
                    }
                }
                n6 = n7;
                if (!meanIncludeNulls) {
                    n6 = n8;
                }
                if (n == 0) {
                    var13_19.setNumCalls(i, d);
                    var13_19.setNumSubr(i, d2);
                    ((FunctionProfile)object5).setNumCalls(i, d / (double)n6);
                    ((FunctionProfile)object5).setNumSubr(i, d2 / (double)n6);
                    double d5 = 0.0;
                    if (n6 > 1) {
                        d5 = Math.sqrt(Math.abs(d3 / (double)n6 - ((FunctionProfile)object5).getNumCalls(i) * ((FunctionProfile)object5).getNumCalls(i)));
                    }
                    functionProfile4.setNumCalls(i, d5);
                    d5 = 0.0;
                    if (n6 > 1) {
                        d5 = Math.sqrt(Math.abs(d4 / (double)n6 - ((FunctionProfile)object5).getNumSubr(i) * ((FunctionProfile)object5).getNumSubr(i)));
                    }
                    functionProfile4.setNumSubr(i, d5);
                }
                for (int j = n; j <= n2; ++j) {
                    var13_19.setExclusive(i, j, dArray[j]);
                    var13_19.setInclusive(i, j, dArray2[j]);
                    ((FunctionProfile)object5).setExclusive(i, j, dArray[j] / (double)n6);
                    ((FunctionProfile)object5).setInclusive(i, j, dArray2[j] / (double)n6);
                    double d6 = 0.0;
                    if (n6 > 1) {
                        d6 = Math.sqrt(Math.abs(dArray3[j] / (double)n6 - ((FunctionProfile)object5).getExclusive(i, j) * ((FunctionProfile)object5).getExclusive(i, j)));
                    }
                    functionProfile4.setExclusive(i, j, d6);
                    d6 = 0.0;
                    if (n6 > 1) {
                        d6 = Math.sqrt(Math.abs(dArray4[j] / (double)n6 - ((FunctionProfile)object5).getInclusive(i, j) * ((FunctionProfile)object5).getInclusive(i, j)));
                    }
                    functionProfile4.setInclusive(i, j, d6);
                }
            }
        }
        int[] nArray = this.getMaxNCTNumbers();
        this.hasContexts = nArray[1] > 0;
        this.hasThreads = nArray[2] > 0;
    }

    public Node addNode(int n) {
        Node node = this.nodes.get(new Integer(n));
        if (node != null) {
            return node;
        }
        Node node2 = new Node(n, this);
        this.nodes.put(new Integer(n), node2);
        return node2;
    }

    public Thread addThread(int n, int n2, int n3) {
        Node node = this.addNode(n);
        Context context = node.addContext(n2);
        Thread thread = context.addThread(n3, this.getNumberOfMetrics());
        this.allThreads = null;
        return thread;
    }

    public Node getNode(int n) {
        return this.nodes.get(new Integer(n));
    }

    public int getNumberOfNodes() {
        return this.nodes.size();
    }

    public Iterator<Node> getNodes() {
        return this.nodes.values().iterator();
    }

    public Map<Integer, Node> getNodeMap() {
        return this.nodes;
    }

    public int getTotalNumberOfContexts() {
        int n = -1;
        Iterator<Node> iterator = this.getNodes();
        while (iterator.hasNext()) {
            Node node = iterator.next();
            n += node.getNumberOfContexts();
        }
        return n;
    }

    public int getNumberOfContexts(int n) {
        return this.getNode(n).getNumberOfContexts();
    }

    public Iterator<Context> getContexts(int n) {
        Node node = this.getNode(n);
        if (node != null) {
            return node.getContexts();
        }
        return null;
    }

    public Context getContext(int n, int n2) {
        Node node = this.getNode(n);
        if (node != null) {
            return node.getContext(n2);
        }
        return null;
    }

    public int getTotalNumberOfThreads() {
        int n = 0;
        Iterator<Node> iterator = this.getNodes();
        while (iterator.hasNext()) {
            Node node = iterator.next();
            Iterator<Context> iterator2 = node.getContexts();
            while (iterator2.hasNext()) {
                Context context = iterator2.next();
                n += context.getNumberOfThreads();
            }
        }
        return n;
    }

    public int getNumberOfThreads(int n, int n2) {
        return this.getContext(n, n2).getNumberOfThreads();
    }

    public List<Thread> getThreads() {
        ArrayList<Thread> arrayList = new ArrayList<Thread>();
        Iterator<Node> iterator = this.getNodes();
        while (iterator.hasNext()) {
            Node node = iterator.next();
            Iterator<Context> iterator2 = node.getContexts();
            while (iterator2.hasNext()) {
                Context context = iterator2.next();
                Iterator<Thread> iterator3 = context.getThreads();
                while (iterator3.hasNext()) {
                    Thread thread = iterator3.next();
                    arrayList.add(thread);
                }
            }
        }
        return arrayList;
    }

    public Thread getThread(int n, int n2, int n3) {
        if (n == -1) {
            return this.getMeanData();
        }
        if (n == -3) {
            return this.getStdDevData();
        }
        Context context = this.getContext(n, n2);
        Thread thread = null;
        if (context != null) {
            thread = context.getThread(n3);
        }
        return thread;
    }

    private void initAllThreadsList() {
        this.allThreads = new ArrayList<Thread>();
        Iterator<Node> iterator = this.getNodes();
        while (iterator.hasNext()) {
            Node node = iterator.next();
            Iterator<Context> iterator2 = node.getContexts();
            while (iterator2.hasNext()) {
                Context context = iterator2.next();
                Iterator<Thread> iterator3 = context.getThreads();
                while (iterator3.hasNext()) {
                    Thread thread = iterator3.next();
                    this.allThreads.add(thread);
                }
            }
        }
    }

    private void initAggThreadsList() {
        this.aggThreads = new ArrayList<Thread>();
        this.aggThreads.add(this.meanData);
        this.aggThreads.add(this.stddevData);
        this.aggThreads.add(this.totalData);
        if (this.maxData != null) {
            this.aggThreads.add(this.maxData);
        }
        if (this.minData != null) {
            this.aggThreads.add(this.minData);
        }
    }

    public List<Thread> getAggThreads() {
        if (this.aggThreads == null) {
            this.initAggThreadsList();
        }
        return this.aggThreads;
    }

    public List<Thread> getAllThreads() {
        if (this.allThreads == null) {
            this.initAllThreadsList();
        }
        return this.allThreads;
    }

    public static void setMeanIncludeNulls(boolean bl) {
        meanIncludeNulls = bl;
    }

    protected void checkForPhases() {
        Group group = this.getGroup("TAU_PHASE");
        if (group != null) {
            Function function;
            this.phasesPresent = true;
            Iterator<Function> iterator = this.getFunctions();
            while (iterator.hasNext()) {
                function = iterator.next();
                if (!function.isGroupMember(group)) continue;
                function.setPhase(true);
                function.setActualPhase(function);
            }
            iterator = this.getFunctions();
            while (iterator.hasNext()) {
                function = iterator.next();
                int n = function.getName().indexOf("=>");
                if (n <= 0) continue;
                String string = UtilFncs.getLeftSide(function.getName());
                String string2 = UtilFncs.getRightSide(function.getName());
                Function function2 = this.getFunction(string2);
                if (function2 != null && function2.isPhase()) {
                    function.setPhase(true);
                    function.setActualPhase(function2);
                }
                function.setParentPhase(this.getFunction(string));
            }
        }
    }

    protected void finishPhaseAnalysis() {
        if (this.phasesPresent) {
            Group group = this.getGroup("TAU_PHASE");
            ArrayList<Function> arrayList = new ArrayList<Function>();
            Iterator<Function> iterator = this.getFunctions();
            while (iterator.hasNext()) {
                Function function = iterator.next();
                if (!function.isGroupMember(group)) continue;
                arrayList.add(function);
            }
            if (arrayList.size() == 0) {
                throw new RuntimeException("Error: TAU_PHASE found, but no phases!");
            }
            this.topLevelPhase = (Function)arrayList.get(0);
            for (Function function : arrayList) {
                if (!(function.getMeanInclusive(0) > this.topLevelPhase.getMeanInclusive(0))) continue;
                this.topLevelPhase = function;
            }
        }
    }

    public boolean getPhasesPresent() {
        return this.phasesPresent;
    }

    public Function getTopLevelPhase() {
        return this.topLevelPhase;
    }

    public boolean getGenerateIntermediateCallPathData() {
        return this.generateIntermediateCallPathData;
    }

    public void setGenerateIntermediateCallPathData(boolean bl) {
        this.generateIntermediateCallPathData = bl;
    }

    public boolean getReverseDataAvailable() {
        return this.reverseDataAvailable;
    }

    public Map<String, String> getMetaData() {
        return this.metaData;
    }

    public void setMetaData(Map<String, String> map) {
        this.metaData = map;
    }

    /*
     * WARNING - void declaration
     */
    public void buildXMLMetaData() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement("tau:metadata");
            element.setAttribute("xmlns:tau", "http://www.cs.uoregon.edu/research/tau");
            document.appendChild(element);
            Element element2 = null;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ArrayList<Boolean> arrayList2 = new ArrayList<Boolean>();
            if (this.metaData.size() > 0) {
                element2 = document.createElement("tau:CommonProfileAttributes");
                element.appendChild(element2);
                for (String object52 : this.metaData.keySet()) {
                    object4 = this.metaData.get(object52);
                    Element element3 = document.createElement("tau:attribute");
                    element2.appendChild(element3);
                    Element element4 = document.createElement("tau:name");
                    element3.appendChild(element4);
                    element4.appendChild(document.createTextNode(object52));
                    Element element5 = document.createElement("tau:value");
                    element3.appendChild(element5);
                    element5.appendChild(document.createTextNode((String)object4));
                }
            }
            for (Thread thread : this.getAllThreads()) {
                object4 = document.createElement("tau:ProfileAttributes");
                object4.setAttribute("node", Integer.toString(thread.getNodeID()));
                object4.setAttribute("context", Integer.toString(thread.getContextID()));
                object4.setAttribute("thread", Integer.toString(thread.getThreadID()));
                boolean bl = false;
                for (String string : thread.getMetaData().keySet()) {
                    object3 = thread.getMetaData().get(string);
                    if (this.metaData.containsKey(string)) continue;
                    object2 = document.createElement("tau:attribute");
                    object4.appendChild((org.w3c.dom.Node)object2);
                    Element element6 = document.createElement("tau:name");
                    object2.appendChild(element6);
                    element6.appendChild(document.createTextNode(string));
                    Element element7 = document.createElement("tau:value");
                    object2.appendChild(element7);
                    element7.appendChild(document.createTextNode((String)object3));
                    bl = true;
                }
                arrayList.add(object4);
                if (bl) {
                    element.appendChild((org.w3c.dom.Node)object4);
                    arrayList2.add(new Boolean(true));
                    continue;
                }
                arrayList2.add(new Boolean(false));
            }
            if (this.metadataFile != null) {
                object = documentBuilder.parse(this.metadataFile);
                Element element8 = object.getDocumentElement();
                object4 = document.importNode(element8, true);
                System.out.println(object4.getPrefix());
                System.out.println(object4.getNodeName());
                if (element2 != null && object4.getNodeType() == 1 && object4.getNodeName().equals("tau:metadata")) {
                    void var13_28;
                    NodeList nodeList = object4.getChildNodes();
                    int n = 0;
                    boolean bl = false;
                    while (var13_28 < nodeList.getLength()) {
                        object3 = nodeList.item((int)var13_28);
                        if (object3.getNodeType() == 1 && object3.getNodeName().equals("tau:CommonProfileAttributes")) {
                            object2 = object3.getChildNodes();
                            for (int i = 0; i < object2.getLength(); ++i) {
                                org.w3c.dom.Node node = object2.item(i);
                                if (node.getNodeType() != 1 || !node.getNodeName().equals("tau:attribute")) continue;
                                element2.appendChild(node);
                            }
                        } else if (object3.getNodeType() == 1 && object3.getNodeName().equals("tau:ProfileAttributes")) {
                            object2 = (Element)arrayList.get(n);
                            if (((Boolean)arrayList2.get(n)).booleanValue()) {
                                NodeList nodeList2 = object3.getChildNodes();
                                for (int i = 0; i < nodeList2.getLength(); ++i) {
                                    org.w3c.dom.Node node = nodeList2.item(i);
                                    if (node.getNodeType() != 1 || !node.getNodeName().equals("tau:attribute")) continue;
                                    object2.appendChild(node);
                                }
                            } else {
                                element.appendChild((org.w3c.dom.Node)object3);
                            }
                            ++n;
                        }
                        ++var13_28;
                    }
                } else {
                    element.appendChild((org.w3c.dom.Node)object4);
                }
            }
            document.getDocumentElement().normalize();
            object = TransformerFactory.newInstance();
            Transformer transformer = ((TransformerFactory)object).newTransformer();
            object4 = new DOMSource(document);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            StreamResult streamResult = new StreamResult(byteArrayOutputStream);
            transformer.transform((Source)object4, streamResult);
            if (element.hasChildNodes()) {
                this.metadataString.append(byteArrayOutputStream.toString());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void aggregateMetaData() {
        Thread thread = this.getAllThreads().get(0);
        if (thread == null) {
            return;
        }
        for (String object : thread.getMetaData().keySet()) {
            Iterator<String> iterator = thread.getMetaData().get(object);
            this.metaData.put(object, (String)((Object)iterator));
        }
        for (Thread thread2 : this.getAllThreads()) {
            for (String string : thread2.getMetaData().keySet()) {
                String string2 = thread2.getMetaData().get(string);
                String string3 = this.metaData.get(string);
                if (string3 != null && string2.equals(string3)) continue;
                this.metaData.remove(string);
                this.uncommonMetaData.put(string, string2);
            }
        }
        for (Thread thread3 : this.getAllThreads()) {
            for (String string : this.metaData.keySet()) {
                thread3.getMetaData().remove(string);
            }
        }
    }

    public void setMetadataFile(String string) throws IOException {
        this.metadataFile = new File(string);
        if (!this.metadataFile.exists()) {
            throw new FileNotFoundException("The file " + string + " does not exist.");
        }
        if (!this.metadataFile.canRead()) {
            throw new IOException("The file " + string + " does not have read permission.");
        }
        if (!this.metadataFile.isFile()) {
            throw new FileNotFoundException(string + " is not a valid file.");
        }
    }

    public String getMetadataString() {
        return this.metadataString.toString();
    }

    public boolean getWellBehavedSnapshots() {
        return this.wellBehavedSnapshots;
    }

    public Map<String, String> getUncommonMetaData() {
        return this.uncommonMetaData;
    }

    public boolean getHasThreads() {
        return this.hasThreads;
    }

    public boolean getHasContexts() {
        return this.hasContexts;
    }

    public int getExecutionType() {
        if (this.getAllThreads().size() == 1) {
            if (this.hasMPI) {
                return 1;
            }
            return 0;
        }
        if (!this.getHasContexts() && !this.getHasThreads()) {
            return 1;
        }
        if (!this.getHasContexts()) {
            return 3;
        }
        return 4;
    }

    private static void renameInternalFunction(Function function, String string, String string2) {
        String string3 = function.getName();
        CharSequence[] charSequenceArray = string3.split("=>");
        for (int i = 0; i < charSequenceArray.length; ++i) {
            charSequenceArray[i] = ((String)charSequenceArray[i]).trim();
            if (!((String)charSequenceArray[i]).equals(string)) continue;
            charSequenceArray[i] = string2;
        }
        function.setName(Utility.join((CharSequence)" => ", (CharSequence[])charSequenceArray));
    }

    public void renameFunction(Function function, String string) {
        string = string.trim();
        Group group = this.getGroup("TAU_CALLPATH");
        for (String string2 : this.functions.keySet()) {
            Function function2 = this.functions.get(string2);
            if (!function2.isGroupMember(group)) continue;
            DataSource.renameInternalFunction(function2, function.getName(), string);
        }
        function.setName(string);
    }
}

