/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.Group;
import edu.uoregon.tau.perfdmf.Thread;
import edu.uoregon.tau.perfdmf.UserEvent;
import edu.uoregon.tau.perfdmf.UserEventProfile;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourceExport {
    private static int findGroupID(Group[] groupArray, Group group) {
        for (int i = 0; i < groupArray.length; ++i) {
            if (groupArray[i] != group) continue;
            return i;
        }
        throw new RuntimeException("Couldn't find group: " + group.getName());
    }

    public static void writeDelimited(DataSource dataSource, File file) throws FileNotFoundException, IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        DataSourceExport.writeDelimited(dataSource, fileOutputStream);
    }

    public static void writeDelimited(DataSource dataSource, OutputStream outputStream) throws IOException {
        Object object;
        Iterator<Object> iterator;
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
        int n = dataSource.getNumberOfMetrics();
        bufferedWriter.write("Node\tContext\tThread\tFunction\tNumCalls\tNumSubr");
        for (int i = 0; i < n; ++i) {
            String object2 = dataSource.getMetricName(i);
            bufferedWriter.write("\tInclusive " + object2);
            bufferedWriter.write("\tExclusive " + object2);
        }
        bufferedWriter.write("\tGroup");
        bufferedWriter.write("\n");
        for (Thread thread : dataSource.getAllThreads()) {
            iterator = thread.getFunctionProfileIterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                if (object == null) continue;
                bufferedWriter.write(thread.getNodeID() + "\t" + thread.getContextID() + "\t" + thread.getThreadID() + "\t");
                bufferedWriter.write(((FunctionProfile)object).getName() + "\t");
                bufferedWriter.write(((FunctionProfile)object).getNumCalls() + "\t");
                bufferedWriter.write(((FunctionProfile)object).getNumSubr() + "");
                for (int i = 0; i < n; ++i) {
                    bufferedWriter.write("\t" + ((FunctionProfile)object).getInclusive(i));
                    bufferedWriter.write("\t" + ((FunctionProfile)object).getExclusive(i));
                }
                bufferedWriter.write("\t" + ((FunctionProfile)object).getFunction().getGroupString());
                bufferedWriter.write("\n");
            }
            bufferedWriter.write("\n");
        }
        bufferedWriter.write("Node\tContext\tThread\tUser Event\tNumSamples\tMin\tMax\tMean\tStdDev\n");
        for (Thread thread : dataSource.getAllThreads()) {
            iterator = thread.getUserEventProfiles();
            while (iterator.hasNext()) {
                object = (UserEventProfile)iterator.next();
                if (object == null) continue;
                bufferedWriter.write(thread.getNodeID() + "\t" + thread.getContextID() + "\t" + thread.getThreadID());
                bufferedWriter.write("\t" + ((UserEventProfile)object).getUserEvent().getName());
                bufferedWriter.write("\t" + ((UserEventProfile)object).getNumSamples());
                bufferedWriter.write("\t" + ((UserEventProfile)object).getMinValue());
                bufferedWriter.write("\t" + ((UserEventProfile)object).getMaxValue());
                bufferedWriter.write("\t" + ((UserEventProfile)object).getMeanValue());
                bufferedWriter.write("\t" + ((UserEventProfile)object).getStdDev());
                bufferedWriter.write("\n");
            }
            bufferedWriter.write("\n");
        }
        bufferedWriter.close();
        outputStreamWriter.close();
        outputStream.close();
    }

    public static void writePacked(DataSource dataSource, File file) throws FileNotFoundException, IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        DataSourceExport.writePacked(dataSource, fileOutputStream);
    }

    public static void writePacked(DataSource dataSource, OutputStream outputStream) throws IOException {
        int n;
        Object object2;
        UserEvent[] userEventArray;
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(outputStream);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(gZIPOutputStream);
        DataOutputStream dataOutputStream = new DataOutputStream(bufferedOutputStream);
        Group group = dataSource.getGroup("TAU_CALLPATH_DERIVED");
        int n2 = 0;
        Iterator<Function> iterator = dataSource.getFunctions();
        while (iterator.hasNext()) {
            Function function = iterator.next();
            if (function.isGroupMember(group)) continue;
            ++n2;
        }
        int n3 = dataSource.getNumberOfMetrics();
        int n4 = dataSource.getNumUserEvents();
        int n5 = dataSource.getNumGroups();
        dataOutputStream.writeChar(80);
        dataOutputStream.writeChar(80);
        dataOutputStream.writeChar(75);
        dataOutputStream.writeInt(2);
        dataOutputStream.writeInt(1);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream2.writeInt(0);
        if (dataSource.getMetaData() != null) {
            Map<String, String> map = dataSource.getMetaData();
            dataOutputStream2.writeInt(map.size());
            for (String string : map.keySet()) {
                userEventArray = (String)map.get(string);
                dataOutputStream2.writeUTF(string);
                dataOutputStream2.writeUTF((String)userEventArray);
            }
        } else {
            dataOutputStream2.writeInt(0);
        }
        dataOutputStream2.writeInt(dataSource.getAllThreads().size());
        for (Thread thread : dataSource.getAllThreads()) {
            Map<String, String> map = thread.getMetaData();
            dataOutputStream2.writeInt(thread.getNodeID());
            dataOutputStream2.writeInt(thread.getContextID());
            dataOutputStream2.writeInt(thread.getThreadID());
            dataOutputStream2.writeInt(map.size());
            for (Object object2 : map.keySet()) {
                String string = map.get(object2);
                dataOutputStream2.writeUTF((String)object2);
                dataOutputStream2.writeUTF(string);
            }
        }
        dataOutputStream2.close();
        dataOutputStream.writeInt(dataOutputStream2.size());
        dataOutputStream.write(byteArrayOutputStream.toByteArray());
        dataOutputStream.writeInt(n3);
        for (int i = 0; i < n3; ++i) {
            String string = dataSource.getMetricName(i);
            dataOutputStream.writeUTF(string);
        }
        dataOutputStream.writeInt(n5);
        Group[] groupArray = new Group[n5];
        boolean bl = false;
        Iterator<Group> iterator2 = dataSource.getGroups();
        while (iterator2.hasNext()) {
            userEventArray = iterator2.next();
            object2 = userEventArray.getName();
            dataOutputStream.writeUTF((String)object2);
            groupArray[++var13_23] = userEventArray;
        }
        Function[] functionArray = new Function[n2];
        boolean bl2 = false;
        dataOutputStream.writeInt(n2);
        userEventArray = dataSource.getFunctions();
        while (userEventArray.hasNext()) {
            object2 = userEventArray.next();
            if (((Function)object2).isGroupMember(group)) continue;
            functionArray[++var13_25] = object2;
            dataOutputStream.writeUTF(((Function)object2).getName());
            List<Group> list = ((Function)object2).getGroups();
            if (list == null) {
                dataOutputStream.writeInt(0);
                continue;
            }
            dataOutputStream.writeInt(list.size());
            for (n = 0; n < list.size(); ++n) {
                Group group2 = list.get(n);
                dataOutputStream.writeInt(DataSourceExport.findGroupID(groupArray, group2));
            }
        }
        userEventArray = new UserEvent[n4];
        boolean bl3 = false;
        dataOutputStream.writeInt(n4);
        object2 = dataSource.getUserEvents();
        while (object2.hasNext()) {
            UserEvent userEvent = object2.next();
            userEventArray[++var13_27] = userEvent;
            dataOutputStream.writeUTF(userEvent.getName());
        }
        dataOutputStream.writeInt(dataSource.getAllThreads().size());
        for (Thread thread : dataSource.getAllThreads()) {
            Object object3;
            int n6;
            dataOutputStream.writeInt(thread.getNodeID());
            dataOutputStream.writeInt(thread.getContextID());
            dataOutputStream.writeInt(thread.getThreadID());
            n = 0;
            for (n6 = 0; n6 < n2; ++n6) {
                object3 = thread.getFunctionProfile(functionArray[n6]);
                if (object3 == null) continue;
                ++n;
            }
            dataOutputStream.writeInt(n);
            for (n6 = 0; n6 < n2; ++n6) {
                object3 = thread.getFunctionProfile(functionArray[n6]);
                if (object3 == null) continue;
                dataOutputStream.writeInt(n6);
                dataOutputStream.writeDouble(((FunctionProfile)object3).getNumCalls());
                dataOutputStream.writeDouble(((FunctionProfile)object3).getNumSubr());
                for (int i = 0; i < n3; ++i) {
                    dataOutputStream.writeDouble(((FunctionProfile)object3).getExclusive(i));
                    dataOutputStream.writeDouble(((FunctionProfile)object3).getInclusive(i));
                }
            }
            n = 0;
            for (n6 = 0; n6 < n4; ++n6) {
                object3 = thread.getUserEventProfile(userEventArray[n6]);
                if (object3 == null) continue;
                ++n;
            }
            dataOutputStream.writeInt(n);
            for (n6 = 0; n6 < n4; ++n6) {
                object3 = thread.getUserEventProfile(userEventArray[n6]);
                if (object3 == null) continue;
                dataOutputStream.writeInt(n6);
                dataOutputStream.writeInt((int)((UserEventProfile)object3).getNumSamples());
                dataOutputStream.writeDouble(((UserEventProfile)object3).getMinValue());
                dataOutputStream.writeDouble(((UserEventProfile)object3).getMaxValue());
                dataOutputStream.writeDouble(((UserEventProfile)object3).getMeanValue());
                dataOutputStream.writeDouble(((UserEventProfile)object3).getSumSquared());
            }
        }
        dataOutputStream.close();
        gZIPOutputStream.close();
        outputStream.close();
    }

    private static String xmlFixUp(String string) {
        string = string.replaceAll("&", "&amp;");
        string = string.replaceAll(">", "&gt;");
        string = string.replaceAll("<", "&lt;");
        string = string.replaceAll("\n", "&#xa;");
        return string;
    }

    private static void writeXMLSnippet(BufferedWriter bufferedWriter, Map<String, String> map) throws IOException {
        for (String string : map.keySet()) {
            String string2 = map.get(string);
            bufferedWriter.write("<attribute><name>" + DataSourceExport.xmlFixUp(string) + "</name><value>" + DataSourceExport.xmlFixUp(string2) + "</value></attribute>");
        }
    }

    private static void writeMetric(File file, DataSource dataSource, int n, Function[] functionArray, String[] stringArray, UserEvent[] userEventArray, List<Thread> list) throws IOException {
        int n2 = dataSource.getNumUserEvents();
        for (Thread thread : list) {
            Object object;
            int n3;
            String string = null;
            string = thread.getNodeID() >= 0 ? thread.getNodeID() + "." + thread.getContextID() + "." + thread.getThreadID() : thread.toString().replace(" ", "");
            File file2 = new File(file + "/profile." + string);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream);
            BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
            int n4 = 0;
            for (n3 = 0; n3 < functionArray.length; ++n3) {
                object = thread.getFunctionProfile(functionArray[n3]);
                if (object == null) continue;
                ++n4;
            }
            if (dataSource.getNumberOfMetrics() == 1 && dataSource.getMetricName(n).equals("Time")) {
                bufferedWriter.write(n4 + " templated_functions\n");
            } else {
                bufferedWriter.write(n4 + " templated_functions_MULTI_" + dataSource.getMetricName(n) + "\n");
            }
            if (dataSource.getMetaData() != null) {
                bufferedWriter.write("# Name Calls Subrs Excl Incl ProfileCalls<metadata>");
                DataSourceExport.writeXMLSnippet(bufferedWriter, dataSource.getMetaData());
                DataSourceExport.writeXMLSnippet(bufferedWriter, thread.getMetaData());
                bufferedWriter.write("</metadata>\n");
            } else {
                bufferedWriter.write("# Name Calls Subrs Excl Incl ProfileCalls\n");
            }
            for (n3 = 0; n3 < functionArray.length; ++n3) {
                object = thread.getFunctionProfile(functionArray[n3]);
                if (object == null) continue;
                bufferedWriter.write('\"' + functionArray[n3].getName() + "\" ");
                bufferedWriter.write((int)((FunctionProfile)object).getNumCalls() + " ");
                bufferedWriter.write((int)((FunctionProfile)object).getNumSubr() + " ");
                bufferedWriter.write(((FunctionProfile)object).getExclusive(n) + " ");
                bufferedWriter.write(((FunctionProfile)object).getInclusive(n) + " ");
                bufferedWriter.write("0 GROUP=\"" + stringArray[n3] + "\"\n");
            }
            bufferedWriter.write("0 aggregates\n");
            n4 = 0;
            for (n3 = 0; n3 < n2; ++n3) {
                object = thread.getUserEventProfile(userEventArray[n3]);
                if (object == null) continue;
                ++n4;
            }
            if (n4 > 0) {
                bufferedWriter.write(n4 + " userevents\n");
                bufferedWriter.write("# eventname numevents max min mean sumsqr\n");
                for (n3 = 0; n3 < n2; ++n3) {
                    object = thread.getUserEventProfile(userEventArray[n3]);
                    if (object == null) continue;
                    bufferedWriter.write('\"' + userEventArray[n3].getName() + "\" ");
                    bufferedWriter.write(((UserEventProfile)object).getNumSamples() + " ");
                    bufferedWriter.write(((UserEventProfile)object).getMaxValue() + " ");
                    bufferedWriter.write(((UserEventProfile)object).getMinValue() + " ");
                    bufferedWriter.write(((UserEventProfile)object).getMeanValue() + " ");
                    bufferedWriter.write(((UserEventProfile)object).getSumSquared() + "\n");
                }
            }
            bufferedWriter.close();
            outputStreamWriter.close();
            fileOutputStream.close();
        }
    }

    public static String createSafeMetricName(String string) {
        String string2 = string.replace('/', '\\');
        return string2;
    }

    public static void writeProfiles(DataSource dataSource, File file) throws IOException {
        DataSourceExport.writeProfiles(dataSource, file, dataSource.getAllThreads());
    }

    public static void writeAggProfiles(DataSource dataSource, File file) throws IOException {
        DataSourceExport.writeProfiles(dataSource, file, dataSource.getAggThreads());
    }

    public static void writeAggMPISummary(DataSource dataSource, boolean bl, boolean bl2) throws IOException {
        DataSourceExport.writeMPISummary(dataSource, dataSource.getAggThreads(), bl, bl2);
    }

    public static void writeMetaDataSummary(DataSource dataSource) throws IOException {
        Object object;
        Map<String, String> map = dataSource.getMetaData();
        System.out.println("Metadata:");
        Iterator<String> iterator = map.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            object = iterator.next();
            n = Math.max(n, ((String)object).length());
        }
        object = map.entrySet();
        Iterator iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator2.next();
            System.out.format("%-" + n + "s%s", entry.getKey(), ": " + (String)entry.getValue());
            System.out.println();
        }
    }

    public static void writeProfiles(DataSource dataSource, File file, List<Thread> list) throws IOException {
        int n;
        Object object;
        Object object2;
        String[] stringArray;
        Object object3;
        int n2 = dataSource.getNumberOfMetrics();
        int n3 = dataSource.getNumUserEvents();
        int n4 = dataSource.getNumGroups();
        int n5 = 0;
        Group group = dataSource.getGroup("TAU_CALLPATH_DERIVED");
        int n6 = 0;
        Group[] groupArray = dataSource.getFunctions();
        while (groupArray.hasNext()) {
            object3 = groupArray.next();
            if (object3.isGroupMember(group)) continue;
            ++n6;
        }
        groupArray = new Group[n4];
        object3 = dataSource.getGroups();
        while (object3.hasNext()) {
            stringArray = (String[])object3.next();
            groupArray[n5++] = stringArray;
        }
        object3 = new Function[n6];
        stringArray = new String[n6];
        n5 = 0;
        UserEvent[] userEventArray = dataSource.getFunctions();
        while (userEventArray.hasNext()) {
            object2 = userEventArray.next();
            if (((Function)object2).isGroupMember(group)) continue;
            object3[n5] = object2;
            object = ((Function)object2).getGroups();
            if (object == null) {
                stringArray[n5] = "";
            } else {
                stringArray[n5] = "";
                for (n = 0; n < object.size(); ++n) {
                    Group group2 = (Group)object.get(n);
                    stringArray[n5] = n == 0 ? group2.getName() : stringArray[n5] + " | " + group2.getName();
                }
                stringArray[n5] = stringArray[n5].trim();
            }
            ++n5;
        }
        userEventArray = new UserEvent[n3];
        n5 = 0;
        object2 = dataSource.getUserEvents();
        while (object2.hasNext()) {
            object = (UserEvent)object2.next();
            userEventArray[n5++] = object;
        }
        if (n2 == 1) {
            DataSourceExport.writeMetric(file, dataSource, 0, object3, stringArray, userEventArray, list);
        } else {
            for (int i = 0; i < n2; ++i) {
                object = "MULTI__" + DataSourceExport.createSafeMetricName(dataSource.getMetricName(i));
                n = new File((String)object).mkdir() ? 1 : 0;
                if (n == 0) {
                    System.err.print("Failed to create directory: " + (String)object);
                    continue;
                }
                DataSourceExport.writeMetric(new File(file + "/" + (String)object), dataSource, i, object3, stringArray, userEventArray, list);
            }
        }
    }

    public static void writeMPISummary(DataSource dataSource, List<Thread> list, boolean bl, boolean bl2) throws IOException {
        List<Group> list2;
        Object object;
        String[] stringArray;
        int n = dataSource.getNumberOfMetrics();
        int n2 = dataSource.getNumUserEvents();
        int n3 = 0;
        Group group = dataSource.getGroup("TAU_CALLPATH_DERIVED");
        int n4 = 0;
        Function[] functionArray = dataSource.getFunctions();
        while (functionArray.hasNext()) {
            stringArray = functionArray.next();
            if (stringArray.isGroupMember(group)) continue;
            ++n4;
        }
        functionArray = new Function[n4];
        stringArray = new String[n4];
        n3 = 0;
        UserEvent[] userEventArray = dataSource.getFunctions();
        while (userEventArray.hasNext()) {
            object = userEventArray.next();
            if (((Function)object).isGroupMember(group)) continue;
            functionArray[n3] = object;
            list2 = ((Function)object).getGroups();
            if (list2 == null) {
                stringArray[n3] = "";
            } else {
                stringArray[n3] = "";
                for (int i = 0; i < list2.size(); ++i) {
                    Group group2 = (Group)list2.get(i);
                    stringArray[n3] = i == 0 ? group2.getName() : stringArray[n3] + " | " + group2.getName();
                }
                stringArray[n3] = stringArray[n3].trim();
            }
            ++n3;
        }
        userEventArray = new UserEvent[n2];
        n3 = 0;
        object = dataSource.getUserEvents();
        while (object.hasNext()) {
            list2 = (UserEvent)object.next();
            userEventArray[n3++] = list2;
        }
        if (n == 1) {
            DataSourceExport.writeMPIMetric(dataSource, 0, functionArray, stringArray, userEventArray, list, bl);
        } else {
            for (int i = 0; i < n; ++i) {
                list2 = "MULTI__" + DataSourceExport.createSafeMetricName(dataSource.getMetricName(i));
                System.out.print((String)((Object)list2));
                DataSourceExport.writeMPIMetric(dataSource, i, functionArray, stringArray, userEventArray, list, bl);
            }
        }
        if (bl2) {
            System.out.println();
            DataSourceExport.writeMetaDataSummary(dataSource);
        }
    }

    private static void writeMPIMetric(DataSource dataSource, int n, Function[] functionArray, String[] stringArray, UserEvent[] userEventArray, List<Thread> list, boolean bl) throws IOException {
        int n2;
        int n3 = dataSource.getNumUserEvents();
        Thread[] threadArray = new Thread[3];
        for (n2 = 0; n2 < list.size(); ++n2) {
            if (list.get(n2).getThreadID() == -4) {
                threadArray[0] = list.get(n2);
                continue;
            }
            if (list.get(n2).getThreadID() == -5) {
                threadArray[1] = list.get(n2);
                continue;
            }
            if (list.get(n2).getThreadID() != -1) continue;
            threadArray[2] = list.get(n2);
        }
        for (n2 = 0; n2 < 3; ++n2) {
            if (threadArray[n2] != null) continue;
            String string = "Min";
            if (n2 == 1) {
                string = "Max";
            } else if (n2 == 2) {
                string = "Mean";
            }
            System.out.println("No " + string + " data available.");
        }
        String string = dataSource.getMetric(n).getName();
        System.out.println();
        if (dataSource.getNumberOfMetrics() != 1) {
            System.out.print("MULTI_" + string + "\n");
        }
        string = string.toLowerCase().contains("time") ? string + " (Microseconds)" : string + " (Counts)";
        int n4 = 15;
        String string2 = "%-8s%-8s%-8s%-8s%-8s%-8s%-16s%-16s%-16s%-16s%-16s%-16s%-16s%-16s%-16s";
        if (bl) {
            n4 = 9;
            System.out.format("%-24s%-48s%-48s%-8s", "   Calls", "   Inclusive " + string, "   Bytes Transferred", "   Name");
            string2 = "%-8s%-8s%-8s%-16s%-16s%-16s%-16s%-16s%-16s";
        } else {
            System.out.format("%-24s%-24s%-48s%-48s%-48s%-8s", "   Calls", "   Child Calls", "   Exclusive " + string, "   Inclusive " + string, "   Bytes Transferred", "   Name");
        }
        System.out.println();
        String[] stringArray2 = new String[n4];
        for (int i = 0; i < stringArray2.length; ++i) {
            if (i % 3 == 0) {
                stringArray2[i] = "   Min";
                continue;
            }
            if (i % 3 == 1) {
                stringArray2[i] = "   Max";
                continue;
            }
            if (i % 3 != 2) continue;
            stringArray2[i] = "   Mean";
        }
        System.out.format(string2, stringArray2);
        System.out.println();
        double[] dArray = new double[15];
        for (int i = 0; i < functionArray.length; ++i) {
            String string3 = "";
            for (int j = 0; j < threadArray.length; ++j) {
                FunctionProfile functionProfile;
                if (threadArray[j] == null || (functionProfile = threadArray[j].getFunctionProfile(functionArray[i])) == null) continue;
                string3 = functionArray[i].getName();
                dArray[j] = functionProfile.getNumCalls();
                dArray[j + 3] = functionProfile.getNumSubr();
                dArray[j + 6] = functionProfile.getExclusive(n);
                dArray[j + 9] = functionProfile.getInclusive(n);
                boolean bl2 = false;
                for (int k = 0; k < n3; ++k) {
                    String string4;
                    UserEventProfile userEventProfile = threadArray[j].getUserEventProfile(userEventArray[k]);
                    if (userEventProfile == null || !(string4 = userEventArray[k].getName()).contains(string3)) continue;
                    if (j == 0) {
                        dArray[j + 12] = userEventProfile.getMinValue();
                    } else if (j == 1) {
                        dArray[j + 12] = userEventProfile.getMaxValue();
                    } else if (j == 2) {
                        dArray[j + 12] = userEventProfile.getMeanValue();
                    }
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                dArray[j + 12] = 0.0;
            }
            DataSourceExport.printValues(dArray, string3, bl);
        }
    }

    private static void printValues(double[] dArray, String string, boolean bl) {
        if (bl) {
            System.out.format("%8.3f%8.3f%8.3f%16.5f%16.5f%16.5f%16.5f%16.5f%16.5f", dArray[0], dArray[1], dArray[2], dArray[9], dArray[10], dArray[11], dArray[12], dArray[13], dArray[14]);
        } else {
            System.out.format("%8.3f%8.3f%8.3f%8.3f%8.3f%8.3f%16.5f%16.5f%16.5f%16.5f%16.5f%16.5f%16.5f%16.5f%16.5f", dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5], dArray[6], dArray[7], dArray[8], dArray[9], dArray[10], dArray[11], dArray[12], dArray[13], dArray[14]);
        }
        System.out.print("   " + string);
        System.out.println();
    }
}

