/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.perfdmf.Context;
import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.LineData;
import edu.uoregon.tau.perfdmf.Node;
import edu.uoregon.tau.perfdmf.Thread;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class GoogleDataSource
extends DataSource {
    private int linenumber = 0;
    private File[] files;

    public static void main(String[] stringArray) {
        String string = "/Users/somillstein/Desktop/irs_benchmark_code_google_perftools_output/irs_cpuprofile_0000";
        String string2 = ".out.txt";
        File[] fileArray = new File[8];
        for (int i = 0; i < 8; ++i) {
            fileArray[i] = new File(string + i + string2);
        }
        GoogleDataSource googleDataSource = new GoogleDataSource(fileArray);
        try {
            googleDataSource.load();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public GoogleDataSource(File[] fileArray) {
        this.files = fileArray == null ? this.findTxtFiles() : (fileArray.length == 0 ? this.findTxtFiles() : fileArray);
    }

    private File[] findTxtFiles() {
        String string = System.getProperty("user.dir");
        File file = new File(string);
        String[] stringArray = file.list();
        ArrayList<File> arrayList = new ArrayList<File>();
        for (String string2 : stringArray) {
            if (!string2.endsWith(".txt")) continue;
            arrayList.add(new File(string2));
        }
        Object[] objectArray = new File[arrayList.size()];
        return (File[])arrayList.toArray(objectArray);
    }

    public void cancelLoad() {
    }

    public int getProgress() {
        return 0;
    }

    public void load() throws FileNotFoundException, IOException {
        long l = System.currentTimeMillis();
        Function function = null;
        FunctionProfile functionProfile = null;
        Node node = null;
        Context context = null;
        Thread thread = null;
        int n = -1;
        String string = null;
        for (int i = 0; i < this.files.length; ++i) {
            File file = this.files[i];
            FileInputStream fileInputStream = new FileInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            string = bufferedReader.readLine();
            if (string.indexOf("Total:") == -1) continue;
            node = this.addNode(++n);
            context = node.addContext(0);
            thread = context.addThread(0);
            this.addMetric("Time");
            this.linenumber = 2;
            while ((string = bufferedReader.readLine()) != null) {
                int n2 = string.length();
                if (n2 != 0) {
                    LineData lineData = this.getLineData(string);
                    function = this.addFunction(lineData.s0, 1);
                    function.addGroup(this.addGroup("TAU_DEFAULT"));
                    functionProfile = new FunctionProfile(function);
                    thread.addFunctionProfile(functionProfile);
                    functionProfile.setInclusive(0, lineData.d1);
                    functionProfile.setExclusive(0, lineData.d0);
                    functionProfile.setNumCalls(1.0);
                }
                ++this.linenumber;
            }
        }
        this.generateDerivedData();
        l = System.currentTimeMillis() - l;
    }

    private LineData getLineData(String string) {
        LineData lineData = new LineData();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r%");
        lineData.d0 = 10.0 * Double.parseDouble(stringTokenizer.nextToken());
        stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        lineData.d1 = 10.0 * Double.parseDouble(stringTokenizer.nextToken());
        stringTokenizer.nextToken();
        lineData.s0 = stringTokenizer.nextToken();
        return lineData;
    }
}

