/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.common.TrackerInputStream;
import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.DataSourceException;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.Group;
import edu.uoregon.tau.perfdmf.Thread;
import edu.uoregon.tau.perfdmf.UserEvent;
import edu.uoregon.tau.perfdmf.UserEventProfile;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.SQLException;
import java.util.TreeMap;
import java.util.zip.GZIPInputStream;

public class PackedProfileDataSource
extends DataSource {
    private File file;
    private volatile long totalBytes = 0L;
    private volatile TrackerInputStream tracker;

    public PackedProfileDataSource(File file) {
        this.file = file;
    }

    public void cancelLoad() {
    }

    public int getProgress() {
        if (this.totalBytes != 0L) {
            return (int)((float)this.tracker.byteCount() / (float)this.totalBytes * 100.0f);
        }
        return 0;
    }

    public void load() throws FileNotFoundException, IOException, DataSourceException, SQLException {
        int n;
        int n2;
        int n3;
        Comparable<Thread> comparable;
        int n4;
        int n5;
        int n6;
        int n7;
        InputStream inputStream;
        Object object;
        long l = System.currentTimeMillis();
        if (this.file.toString().toLowerCase().startsWith("http:")) {
            object = new URL("http://" + this.file.toString().substring(6).replace('\\', '/'));
            inputStream = ((URL)object).openStream();
        } else {
            inputStream = new FileInputStream(this.file);
        }
        this.tracker = new TrackerInputStream(inputStream);
        GZIPInputStream gZIPInputStream = null;
        try {
            gZIPInputStream = new GZIPInputStream((InputStream)this.tracker);
            object = new BufferedInputStream(gZIPInputStream);
        }
        catch (IOException iOException) {
            if (iOException.getMessage().equals("Not in GZIP format")) {
                object = new BufferedInputStream(inputStream);
            }
            throw iOException;
        }
        DataInputStream dataInputStream = new DataInputStream((InputStream)object);
        this.totalBytes = this.file.length();
        char c = dataInputStream.readChar();
        char c2 = dataInputStream.readChar();
        char c3 = dataInputStream.readChar();
        if (c != 'P' || c2 != 'P' || c3 != 'K') {
            throw new DataSourceException("This doesn't look like a packed profile");
        }
        int n8 = dataInputStream.readInt();
        int n9 = dataInputStream.readInt();
        if (n9 > 2) {
            throw new DataSourceException("This packed profile is not compatible, please upgrade\nVersion: " + n9 + " > " + "2");
        }
        this.metaData = new TreeMap();
        if (n8 >= 2) {
            int n10;
            dataInputStream.readInt();
            n7 = dataInputStream.readInt();
            dataInputStream.skipBytes(n7);
            n6 = dataInputStream.readInt();
            for (n10 = 0; n10 < n6; ++n10) {
                String string = dataInputStream.readUTF();
                String string2 = dataInputStream.readUTF();
                this.metaData.put(string, string2);
            }
            n10 = dataInputStream.readInt();
            for (n5 = 0; n5 < n10; ++n5) {
                int n11 = dataInputStream.readInt();
                n4 = dataInputStream.readInt();
                int n12 = dataInputStream.readInt();
                comparable = this.addThread(n11, n4, n12);
                n3 = dataInputStream.readInt();
                for (n2 = 0; n2 < n3; ++n2) {
                    String string = dataInputStream.readUTF();
                    String string3 = dataInputStream.readUTF();
                    ((Thread)comparable).getMetaData().put(string, string3);
                    this.uncommonMetaData.put(string, string3);
                }
            }
        } else {
            n7 = dataInputStream.readInt();
            dataInputStream.skipBytes(n7);
        }
        n7 = dataInputStream.readInt();
        for (n6 = 0; n6 < n7; ++n6) {
            String string = dataInputStream.readUTF();
            this.addMetric(string);
        }
        n6 = dataInputStream.readInt();
        if (n6 != 0) {
            this.setGroupNamesPresent(true);
        }
        Group[] groupArray = new Group[n6];
        for (n5 = 0; n5 < n6; ++n5) {
            groupArray[n5] = this.addGroup(dataInputStream.readUTF());
        }
        n5 = dataInputStream.readInt();
        Function[] functionArray = new Function[n5];
        for (n4 = 0; n4 < n5; ++n4) {
            String string = dataInputStream.readUTF();
            comparable = this.addFunction(string, n7);
            functionArray[n4] = comparable;
            n3 = dataInputStream.readInt();
            for (n2 = 0; n2 < n3; ++n2) {
                int n13 = dataInputStream.readInt();
                ((Function)comparable).addGroup(groupArray[n13]);
            }
        }
        n4 = dataInputStream.readInt();
        UserEvent[] userEventArray = new UserEvent[n4];
        for (n = 0; n < n4; ++n) {
            UserEvent userEvent;
            String string = dataInputStream.readUTF();
            userEventArray[n] = userEvent = this.addUserEvent(string);
        }
        n = dataInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            int n14;
            int n15;
            int n16 = dataInputStream.readInt();
            int n17 = dataInputStream.readInt();
            int n18 = dataInputStream.readInt();
            Thread thread = this.addThread(n16, n17, n18);
            int n19 = dataInputStream.readInt();
            for (n15 = 0; n15 < n19; ++n15) {
                n14 = dataInputStream.readInt();
                FunctionProfile functionProfile = new FunctionProfile(functionArray[n14], n7);
                thread.addFunctionProfile(functionProfile);
                functionProfile.setNumCalls(dataInputStream.readDouble());
                functionProfile.setNumSubr(dataInputStream.readDouble());
                for (int j = 0; j < n7; ++j) {
                    functionProfile.setExclusive(j, dataInputStream.readDouble());
                    functionProfile.setInclusive(j, dataInputStream.readDouble());
                }
            }
            n15 = dataInputStream.readInt();
            for (n14 = 0; n14 < n15; ++n14) {
                int n20 = dataInputStream.readInt();
                UserEventProfile userEventProfile = new UserEventProfile(userEventArray[n20]);
                userEventProfile.setNumSamples(dataInputStream.readInt());
                userEventProfile.setMinValue(dataInputStream.readDouble());
                userEventProfile.setMaxValue(dataInputStream.readDouble());
                userEventProfile.setMeanValue(dataInputStream.readDouble());
                userEventProfile.setSumSquared(dataInputStream.readDouble());
                userEventProfile.updateMax();
                thread.addUserEventProfile(userEventProfile);
            }
        }
        dataInputStream.close();
        if (gZIPInputStream != null) {
            gZIPInputStream.close();
        }
        this.tracker.close();
        inputStream.close();
        if (n4 > 0) {
            this.setUserEventsPresent(true);
        }
        this.generateDerivedData();
        this.buildXMLMetaData();
        l = System.currentTimeMillis() - l;
    }
}

