/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.common.LineCountBufferedReader;
import edu.uoregon.tau.common.Utility;
import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.DataSourceException;
import edu.uoregon.tau.perfdmf.EBSTraceReader;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.MetaDataParser;
import edu.uoregon.tau.perfdmf.Thread;
import edu.uoregon.tau.perfdmf.UserEvent;
import edu.uoregon.tau.perfdmf.UserEventProfile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TauDataSource
extends DataSource {
    private volatile boolean abort = false;
    private volatile int totalFiles = 0;
    private volatile int filesRead = 0;
    private boolean profileStatsPresent = false;
    private boolean groupCheck = false;
    private List<File[]> dirs;
    private File fileToMonitor;
    private File currentFile;
    private LineCountBufferedReader br;

    public TauDataSource(List<?> list) {
        if (list.size() > 0) {
            if (list.get(0) instanceof File[]) {
                this.dirs = list;
                File[] fileArray = (File[])list.get(0);
                if (fileArray.length > 0) {
                    this.fileToMonitor = fileArray[0];
                }
            } else {
                this.dirs = new ArrayList<File[]>();
                File[] fileArray = new File[]{(File)list.get(0)};
                this.dirs.add(fileArray);
                this.fileToMonitor = fileArray[0];
            }
        }
    }

    @Override
    public void cancelLoad() {
        this.abort = true;
    }

    @Override
    public int getProgress() {
        if (this.totalFiles != 0) {
            return (int)((float)this.filesRead / (float)this.totalFiles * 100.0f);
        }
        return 0;
    }

    @Override
    public List<File> getFiles() {
        ArrayList<File> arrayList = new ArrayList<File>();
        arrayList.add(this.fileToMonitor);
        return arrayList;
    }

    @Override
    public void load() throws FileNotFoundException, IOException, DataSourceException {
        int n;
        long l = System.currentTimeMillis();
        boolean bl = false;
        try {
            FileInputStream.class.getMethod("getChannel", null);
            bl = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        for (File[] fileArray : this.dirs) {
            for (n = 0; n < fileArray.length; ++n) {
                ++this.totalFiles;
            }
        }
        boolean bl2 = false;
        int n2 = 0;
        n = 0;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        String string = null;
        for (File[] fileArray : this.dirs) {
            n = 0;
            for (int i = 0; i < fileArray.length; ++i) {
                boolean bl3 = false;
                int n6 = 0;
                while (!bl3) {
                    Object object;
                    Object object2;
                    Thread thread = null;
                    try {
                        ++this.filesRead;
                        if (this.abort) {
                            return;
                        }
                        int[] nArray = TauDataSource.getNCT(fileArray[i].getName());
                        if (nArray == null && this.dirs.size() == 1 && fileArray.length == 1) {
                            if (!fileArray[i].exists()) {
                                throw new DataSourceException("Error: File '" + fileArray[i].getName() + "' does not exist.");
                            }
                            throw new DataSourceException("Error: File '" + fileArray[i].getName() + "': This doesn't look like a TAU profile\n" + "Did you mean do use the -f option to specify a file format?");
                        }
                        if (nArray == null) {
                            bl3 = true;
                            continue;
                        }
                        n3 = nArray[0];
                        n4 = nArray[1];
                        n5 = nArray[2];
                        thread = this.addThread(n3, n4, n5);
                        bl2 = true;
                        object2 = new FileInputStream(fileArray[i]);
                        this.currentFile = fileArray[i];
                        FileLock fileLock = null;
                        if (bl && this.monitored) {
                            object = ((FileInputStream)object2).getChannel();
                            try {
                                fileLock = ((FileChannel)object).lock(0L, Long.MAX_VALUE, true);
                            }
                            catch (IOException iOException) {
                                bl = false;
                                fileLock = null;
                            }
                        }
                        try {
                            int n7;
                            int n8;
                            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)object2);
                            this.br = new LineCountBufferedReader((Reader)inputStreamReader);
                            string = this.br.readLine();
                            if (string == null) {
                                throw new CorruptFileException("Unexpected end of file: Looking for 'templated_functions' line");
                            }
                            StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r");
                            String string2 = stringTokenizer.nextToken();
                            try {
                                n8 = Integer.parseInt(string2);
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw new CorruptFileException("Couldn't read number of functions");
                            }
                            String string3 = this.getMetricName(string);
                            string = this.br.readLine();
                            if (string == null) {
                                throw new CorruptFileException("Unexpected end of file: Looking for '# Name Calls ...' line");
                            }
                            if (string.indexOf("<metadata>") != -1) {
                                int n9 = string.indexOf("<metadata>");
                                n7 = string.indexOf("</metadata>") + 11;
                                String string4 = string.substring(n9, n7);
                                try {
                                    MetaDataParser.parse(thread.getMetaData(), string4);
                                }
                                catch (Exception exception) {
                                    throw new CorruptFileException("Unable to parse metadata block");
                                }
                            }
                            String string5 = thread.getMetaData().get("Metric Name");
                            thread.getMetaData().remove("Metric Name");
                            if (n == 0) {
                                if (string5 != null) {
                                    string3 = string5;
                                }
                                if (string3 == null) {
                                    string3 = "Time";
                                }
                                this.addMetric(string3);
                                n = 1;
                            }
                            if (i == 0 && string.indexOf("SumExclSqr") != -1) {
                                this.setProfileStatsPresent(true);
                            }
                            for (n7 = 0; n7 < n8; ++n7) {
                                string = this.br.readLine();
                                if (string == null) {
                                    throw new CorruptFileException("Unexpected end of file: Only found " + (n7 - 2) + " of " + n8 + " Function Lines");
                                }
                                this.processFunctionLine(string, thread, n2);
                            }
                            string = this.br.readLine();
                            if (string == null) {
                                throw new CorruptFileException("Unexpected end of file: Looking for 'aggregates' line");
                            }
                            stringTokenizer = new StringTokenizer(string, " \t\n\r");
                            string2 = stringTokenizer.nextToken();
                            n8 = Integer.parseInt(string2);
                            for (n7 = 0; n7 < n8; ++n7) {
                                string = this.br.readLine();
                            }
                            if (n2 == 0 && (string = this.br.readLine()) != null) {
                                stringTokenizer = new StringTokenizer(string, " \t\n\r");
                                string2 = stringTokenizer.nextToken();
                                n7 = Integer.parseInt(string2);
                                this.br.readLine();
                                for (int j = 0; j < n7; ++j) {
                                    if (j == 0) {
                                        this.setUserEventsPresent(true);
                                    }
                                    if ((string = this.br.readLine()) == null) {
                                        throw new CorruptFileException("Unexpected end of file: Only found " + (j - 2) + " of " + n7 + " User Event Lines");
                                    }
                                    this.processUserEventLine(string, thread);
                                }
                            }
                            if (fileLock != null) {
                                fileLock.release();
                            }
                            this.br.close();
                            inputStreamReader.close();
                            ((FileInputStream)object2).close();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            throw new CorruptFileException("Error parsing file (" + exception + ")");
                        }
                        bl3 = true;
                    }
                    catch (CorruptFileException corruptFileException) {
                        System.err.println("File '" + this.currentFile + "' is corrupt (at line " + this.br.getCurrentLine() + ") : " + corruptFileException.getMessage());
                        bl3 = true;
                    }
                    catch (DataSourceException dataSourceException) {
                        throw dataSourceException;
                    }
                    catch (Exception exception) {
                        System.out.println("Error: Current File: " + this.currentFile + ", Current Line: " + this.br.getCurrentLine());
                        exception.printStackTrace();
                        if (!(exception instanceof IOException) && !(exception instanceof FileNotFoundException)) {
                            throw new RuntimeException(exception == null ? null : exception.toString());
                        }
                        try {
                            java.lang.Thread.sleep(250L);
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                        if (n6 > 5) {
                            System.err.println("too many exceptions caught");
                            exception.printStackTrace();
                            bl3 = true;
                        } else if (thread != null) {
                            object2 = thread.getFunctionProfileIterator();
                            while (object2.hasNext()) {
                                object = object2.next();
                                if (object == null) continue;
                                for (int j = 0; j < this.getNumberOfMetrics(); ++j) {
                                    ((FunctionProfile)object).setExclusive(j, 0.0);
                                    ((FunctionProfile)object).setInclusive(j, 0.0);
                                }
                                ((FunctionProfile)object).setNumSubr(0.0);
                                ((FunctionProfile)object).setNumCalls(0.0);
                            }
                        }
                        ++n6;
                    }
                }
            }
            ++n2;
        }
        if (!bl2) {
            throw new DataSourceException("Didn't find any valid files.\nAre you sure these are TAU profiles? (e.g. profile.*.*.*)");
        }
        EBSTraceReader.processEBSTraces(this, new File(System.getProperty("user.dir")));
        this.generateDerivedData();
        this.aggregateMetaData();
        this.buildXMLMetaData();
        l = System.currentTimeMillis() - l;
    }

    public String toString() {
        return this.getClass().getName();
    }

    public static int[] getNCT(String string) {
        try {
            int[] nArray = new int[3];
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".\t\n\r");
            stringTokenizer.nextToken();
            nArray[0] = Integer.parseInt(stringTokenizer.nextToken());
            nArray[1] = Integer.parseInt(stringTokenizer.nextToken());
            nArray[2] = Integer.parseInt(stringTokenizer.nextToken());
            if (nArray[0] < 0 || nArray[1] < 0 || nArray[2] < 0) {
                return null;
            }
            return nArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String getMetricName(String string) {
        String string2 = null;
        int n = string.indexOf("_MULTI_");
        if (n > 0) {
            string2 = string.substring(n + 7);
            return string2;
        }
        n = string.indexOf("hw_counters");
        if (n > 0) {
            return "Hardware Counter";
        }
        return string2;
    }

    private void processFunctionLine(String string, Thread thread, int n) throws DataSourceException {
        FunctionProfile functionProfile;
        StringTokenizer stringTokenizer;
        String string2;
        Object object;
        String string3 = this.getGroupNames(string);
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '\"') continue;
            ++n2;
        }
        if (n2 == 0) {
            throw new CorruptFileException("Looking for function line, found '" + string + "' instead.");
        }
        if (n2 == 2 || n2 == 4) {
            object = new StringTokenizer(string, "\"");
            string2 = ((StringTokenizer)object).nextToken();
            stringTokenizer = new StringTokenizer(((StringTokenizer)object).nextToken(), " \t\n\r");
        } else {
            int n3;
            int n4 = 0;
            for (n3 = 0; n4 < n2 - 2 && n3 < string.length(); ++n3) {
                if (string.charAt(n3) != '\"') continue;
                ++n4;
            }
            string2 = string.substring(1, n3 - 1);
            stringTokenizer = new StringTokenizer(string.substring(n3 + 1), " \t\n\r");
        }
        string2 = Utility.removeRuns((String)string2);
        double d = Double.parseDouble(stringTokenizer.nextToken());
        double d2 = Double.parseDouble(stringTokenizer.nextToken());
        double d3 = Double.parseDouble(stringTokenizer.nextToken());
        double d4 = Double.parseDouble(stringTokenizer.nextToken());
        if (this.getProfileStatsPresent()) {
            // empty if block
        }
        if (d4 < 0.0) {
            System.err.println("File '" + this.currentFile + "' is corrupt (at line " + this.br.getCurrentLine() + ") : Negative values found in profile, ignoring! (routine: " + string2 + ")");
            d4 = 0.0;
        }
        if (d3 < 0.0) {
            System.err.println("File '" + this.currentFile + "' is corrupt (at line " + this.br.getCurrentLine() + ") : Negative values found in profile, ignoring! (routine: " + string2 + ")");
            d3 = 0.0;
        }
        if ((functionProfile = thread.getFunctionProfile((Function)(object = this.addFunction(string2, 1)))) == null) {
            functionProfile = new FunctionProfile((Function)object);
            thread.addFunctionProfile(functionProfile);
        }
        functionProfile.setExclusive(n, functionProfile.getExclusive(n) + d3);
        functionProfile.setInclusive(n, functionProfile.getInclusive(n) + d4);
        if (n == 0) {
            functionProfile.setNumCalls(functionProfile.getNumCalls() + d);
            functionProfile.setNumSubr(functionProfile.getNumSubr() + d2);
        }
        if (n == 0) {
            this.addGroups(string3, (Function)object);
        }
    }

    private String getGroupNames(String string) {
        int n;
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < string.length(); ++n2) {
            if (string.charAt(n2) != '\"') continue;
            ++n3;
        }
        n2 = 0;
        for (n = 0; n2 < n3 - 2 && n < string.length(); ++n) {
            if (string.charAt(n) != '\"') continue;
            ++n2;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string.substring(n + 1), "\"");
        String string2 = stringTokenizer.nextToken();
        if (!this.getGroupCheck()) {
            int n4 = string2.indexOf("GROUP=");
            if (n4 > 0) {
                this.setGroupNamesPresent(true);
            }
            this.setGroupCheck(true);
        }
        if (this.getGroupNamesPresent()) {
            try {
                string2 = stringTokenizer.nextToken();
                return string2;
            }
            catch (NoSuchElementException noSuchElementException) {
                return null;
            }
        }
        return null;
    }

    private void processUserEventLine(String string, Thread thread) {
        StringTokenizer stringTokenizer;
        String string2;
        Object object;
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '\"') continue;
            ++n;
        }
        if (n == 2) {
            object = new StringTokenizer(string, "\"");
            string2 = ((StringTokenizer)object).nextToken();
            stringTokenizer = new StringTokenizer(((StringTokenizer)object).nextToken(), " \t\n\r");
        } else {
            int n2;
            int n3 = 0;
            for (n2 = 0; n3 < n && n2 < string.length(); ++n2) {
                if (string.charAt(n2) != '\"') continue;
                ++n3;
            }
            string2 = string.substring(1, n2 - 1);
            stringTokenizer = new StringTokenizer(string.substring(n2 + 1), " \t\n\r");
        }
        double d = Double.parseDouble(stringTokenizer.nextToken());
        double d2 = Double.parseDouble(stringTokenizer.nextToken());
        double d3 = Double.parseDouble(stringTokenizer.nextToken());
        double d4 = Double.parseDouble(stringTokenizer.nextToken());
        double d5 = Double.parseDouble(stringTokenizer.nextToken());
        object = this.addUserEvent(string2);
        UserEventProfile userEventProfile = thread.getUserEventProfile((UserEvent)object);
        if (userEventProfile == null) {
            userEventProfile = new UserEventProfile((UserEvent)object);
            thread.addUserEventProfile(userEventProfile);
            userEventProfile.setNumSamples(d);
            userEventProfile.setMaxValue(d2);
            userEventProfile.setMinValue(d3);
            userEventProfile.setMeanValue(d4);
            userEventProfile.setSumSquared(d5);
            userEventProfile.updateMax();
        } else {
            if (userEventProfile.getNumSamples() + d != 0.0) {
                double d6 = (userEventProfile.getMeanValue() * userEventProfile.getNumSamples() + d * d4) / (userEventProfile.getNumSamples() + d);
                userEventProfile.setMeanValue(d6);
            } else {
                userEventProfile.setMeanValue(0.0);
            }
            userEventProfile.setNumSamples(d + userEventProfile.getNumSamples());
            userEventProfile.setMaxValue(Math.max(d2, userEventProfile.getMaxValue()));
            userEventProfile.setMinValue(Math.min(d3, userEventProfile.getMinValue()));
            userEventProfile.setSumSquared(d5 + userEventProfile.getSumSquared());
            userEventProfile.updateMax();
        }
    }

    protected void setProfileStatsPresent(boolean bl) {
        this.profileStatsPresent = bl;
    }

    public boolean getProfileStatsPresent() {
        return this.profileStatsPresent;
    }

    protected void setGroupCheck(boolean bl) {
        this.groupCheck = bl;
    }

    protected boolean getGroupCheck() {
        return this.groupCheck;
    }

    public class CorruptFileException
    extends RuntimeException {
        private static final long serialVersionUID = 3505483745617386975L;
        private String message;

        public CorruptFileException(String string) {
            this.message = string;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

