/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.perfdmf.Cube3DataSource;
import edu.uoregon.tau.perfdmf.CubeDataSource;
import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.DataSourceException;
import edu.uoregon.tau.perfdmf.DynaprofDataSource;
import edu.uoregon.tau.perfdmf.FileList;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.GAMESSDataSource;
import edu.uoregon.tau.perfdmf.GPTLDataSource;
import edu.uoregon.tau.perfdmf.GoogleDataSource;
import edu.uoregon.tau.perfdmf.GprofDataSource;
import edu.uoregon.tau.perfdmf.GyroDataSource;
import edu.uoregon.tau.perfdmf.HPCToolkitDataSource;
import edu.uoregon.tau.perfdmf.HPMToolkitDataSource;
import edu.uoregon.tau.perfdmf.IPMDataSource;
import edu.uoregon.tau.perfdmf.MpiPDataSource;
import edu.uoregon.tau.perfdmf.OmppDataSource;
import edu.uoregon.tau.perfdmf.PSRunDataSource;
import edu.uoregon.tau.perfdmf.PackedProfileDataSource;
import edu.uoregon.tau.perfdmf.ParaverDataSource;
import edu.uoregon.tau.perfdmf.PeriXMLDataSource;
import edu.uoregon.tau.perfdmf.SnapshotDataSource;
import edu.uoregon.tau.perfdmf.TauDataSource;
import edu.uoregon.tau.perfdmf.TauPprofDataSource;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UtilFncs {
    public static String lpad(String string, int n) {
        int n2 = n - string.length();
        if (n2 <= 0) {
            return string;
        }
        char[] cArray = new char[n2];
        for (int i = 0; i < n2; ++i) {
            cArray[i] = 32;
        }
        String string2 = new String(cArray, 0, n2);
        return string2.concat(string);
    }

    public static String pad(String string, int n) {
        int n2 = n - string.length();
        if (n2 <= 0) {
            return string;
        }
        char[] cArray = new char[n2];
        for (int i = 0; i < n2; ++i) {
            cArray[i] = 32;
        }
        return string.concat(new String(cArray, 0, n2));
    }

    public static String formatDouble(double d, int n, boolean bl) {
        boolean bl2 = false;
        if (d < 0.0) {
            String string = "-";
            if (bl) {
                return UtilFncs.lpad(string, n);
            }
            return string;
        }
        String string = Double.toString(d);
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != 'E') continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            int n2;
            String string2 = "";
            for (n2 = 0; n2 < string.length(); ++n2) {
                string2 = string.charAt(n2) != '.' ? string2 + "#" : string2 + ".";
            }
            n2 = n;
            if (string2.length() < n2) {
                n2 = string2.length();
            }
            if (string2.indexOf(46) + 4 < string2.length()) {
                n2 = string2.indexOf(46) + 4;
            }
            if ((string2 = string2.substring(0, n2)).charAt(string2.length() - 1) == '.') {
                string2 = string2.substring(0, string2.length() - 2);
            }
            DecimalFormat decimalFormat = new DecimalFormat(string2);
            string = decimalFormat.format(d);
            if (bl) {
                return UtilFncs.lpad(string, n);
            }
            return string;
        }
        String string3 = d < 0.1 ? "0.0" : "0.0###";
        string3 = string3 + "E0";
        DecimalFormat decimalFormat = new DecimalFormat(string3);
        string = decimalFormat.format(d);
        if (bl) {
            return UtilFncs.lpad(string, n);
        }
        return string;
    }

    public static String getOutputString(int n, double d, int n2, boolean bl) {
        switch (n) {
            case 0: {
                return UtilFncs.formatDouble(d, n2, true);
            }
            case 1: {
                if (bl) {
                    return UtilFncs.formatDouble(d * 1000.0, n2, true);
                }
                return UtilFncs.formatDouble(d / 1000.0, n2, true);
            }
            case 2: {
                if (bl) {
                    return UtilFncs.formatDouble(d * 1000000.0, n2, true);
                }
                return UtilFncs.formatDouble(d / 1000000.0, n2, true);
            }
            case 3: {
                int n3 = 0;
                int n4 = 0;
                n3 = (int)(d / 3.6E9);
                n4 = (int)((d -= (double)n3 * 3.6E9) / 6.0E7);
                String string = Integer.toString(n3);
                String string2 = n4 < 10 ? "0" + Integer.toString(n4) : Integer.toString(n4);
                String string3 = n3 >= 1 || n4 >= 1 ? UtilFncs.formatDouble(d / 1000000.0, 1, false) : UtilFncs.formatDouble((d -= (double)n4 * 6.0E7) / 1000000.0, 3, false);
                if (string3.indexOf(69) != -1) {
                    string3 = "00";
                }
                if (string3.length() == 1) {
                    string3 = "0" + string3;
                }
                int n5 = 0;
                for (int i = 0; i < string3.length(); ++i) {
                    if (string3.charAt(i) == ' ') continue;
                    n5 = i;
                    break;
                }
                string3 = string3.substring(n5);
                return UtilFncs.lpad(string + ":" + string2 + ":" + string3, n2);
            }
        }
        throw new RuntimeException("Unexpected string type: " + n);
    }

    public static String getUnitsString(int n, boolean bl, boolean bl2) {
        if (bl2) {
            if (!bl) {
                return "counts";
            }
            switch (n) {
                case 0: {
                    return "Derived metric shown in microseconds format";
                }
                case 1: {
                    return "Derived metric shown in milliseconds format";
                }
                case 2: {
                    return "Derived metric shown in seconds format";
                }
                case 3: {
                    return "Derived metric shown in hour:minute:seconds format";
                }
            }
            throw new RuntimeException("Unexpected string type: " + n);
        }
        if (!bl) {
            return "counts";
        }
        switch (n) {
            case 0: {
                return "microseconds";
            }
            case 1: {
                return "milliseconds";
            }
            case 2: {
                return "seconds";
            }
            case 3: {
                return "hour:minute:seconds";
            }
        }
        throw new RuntimeException("Unexpected string type: " + n);
    }

    public static int exists(Vector<Integer> vector, int n) {
        if (vector == null) {
            return -1;
        }
        Integer n2 = null;
        int n3 = vector.size();
        for (int i = 0; i < n3; ++i) {
            n2 = vector.elementAt(i);
            if (n2 != n) continue;
            return i;
        }
        return -1;
    }

    public static String getRightSide(String string) {
        int n = string.indexOf("=>");
        if (n >= 0) {
            return string.substring(n + 2).trim();
        }
        return string;
    }

    public static String getRightMost(String string) {
        int n = string.lastIndexOf("=>");
        if (n >= 0) {
            return string.substring(n + 2).trim();
        }
        return string;
    }

    public static String getAllButRightMost(String string) {
        int n = string.lastIndexOf("=>");
        if (n >= 0) {
            return string.substring(0, n).trim();
        }
        return string;
    }

    public static String getLeftSide(String string) {
        int n = string.indexOf("=>");
        if (n >= 0) {
            return string.substring(0, n).trim();
        }
        return string;
    }

    public static String getRevLeftSide(String string) {
        int n = string.indexOf("<=");
        if (n >= 0) {
            return string.substring(0, n).trim();
        }
        return string;
    }

    public static String getContextEventRoot(String string) {
        int n = string.indexOf(":");
        int n2 = string.indexOf("=>");
        if (n2 < 0) {
            if (n < 0) {
                return string;
            }
            return string.substring(n + 1);
        }
        return string.substring(n + 1, n2).trim();
    }

    public static int identifyData(File file) {
        String string = file.getName();
        if (string.toLowerCase().endsWith(".ppk")) {
            return 0;
        }
        if (string.toLowerCase().endsWith(".cubex")) {
            return 9;
        }
        if (string.toLowerCase().endsWith(".cube")) {
            return 9;
        }
        if (string.toLowerCase().endsWith(".cube.gz")) {
            return 9;
        }
        if (string.toLowerCase().endsWith(".mpip")) {
            return 4;
        }
        try {
            InputStream inputStream;
            Closeable closeable;
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                inputStream = closeable = new GZIPInputStream(fileInputStream);
            }
            catch (IOException iOException) {
                fileInputStream.close();
                inputStream = new FileInputStream(file);
            }
            closeable = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader((Reader)closeable);
            for (int i = 0; i < 10; ++i) {
                String string2 = bufferedReader.readLine();
                if (string2.startsWith("<profile_xml>")) {
                    fileInputStream.close();
                    return 2;
                }
                if (!string2.startsWith("<!DOCTYPE hwpc")) continue;
                fileInputStream.close();
                return 7;
            }
            fileInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 1;
    }

    public static DataSource initializeDataSource(File[] fileArray, int n, boolean bl) {
        return UtilFncs.initializeDataSource(fileArray, n, bl, null);
    }

    public static DataSource initializeDataSource(File[] fileArray, int n, boolean bl, String string) throws DataSourceException {
        FileList fileList;
        File[] fileArray2;
        DataSource dataSource = null;
        List<File[]> list = new ArrayList<File[]>();
        if (n == 1 && string == null && fileArray.length < 1 && (fileArray2 = (fileList = new FileList()).helperFindSnapshots(System.getProperty("user.dir"))).length > 0) {
            n = 2;
            fileArray = fileArray2;
        }
        switch (n) {
            case 1: {
                fileList = string != null ? new FileList(string) : new FileList();
                if (fileArray.length < 1) {
                    list = fileList.helperFindProfiles(System.getProperty("user.dir"));
                    if (list.size() == 0) {
                        throw new DataSourceException("profiles type: no profiles specified");
                    }
                } else if (fileArray[0].isDirectory()) {
                    if (fileArray.length > 1) {
                        throw new DataSourceException("profiles type: you can only specify one directory");
                    }
                    list = fileList.helperFindProfiles(fileArray[0].toString());
                    if (list.size() == 0) {
                        throw new DataSourceException("No profiles found in directory: " + fileArray[0]);
                    }
                } else {
                    list.add(fileArray);
                }
                dataSource = new TauDataSource(list);
                break;
            }
            case 8: {
                if (fileArray.length != 1) {
                    throw new DataSourceException("pprof type: you must specify exactly one file");
                }
                if (fileArray[0].isDirectory()) {
                    throw new DataSourceException("pprof type: you must specify a file, not a directory");
                }
                list.add(fileArray);
                dataSource = new TauPprofDataSource(list);
                break;
            }
            case 3: {
                dataSource = new DynaprofDataSource(fileArray);
                break;
            }
            case 4: {
                if (fileArray.length != 1) {
                    throw new DataSourceException("MpiP type: you must specify exactly one file");
                }
                if (fileArray[0].isDirectory()) {
                    throw new DataSourceException("MpiP type: you must specify a file, not a directory");
                }
                dataSource = new MpiPDataSource(fileArray[0]);
                break;
            }
            case 5: {
                list.add(fileArray);
                dataSource = new HPMToolkitDataSource(list);
                break;
            }
            case 6: {
                dataSource = new GprofDataSource(fileArray, bl);
                break;
            }
            case 16: {
                dataSource = new GoogleDataSource(fileArray);
                break;
            }
            case 7: {
                list.add(fileArray);
                dataSource = new PSRunDataSource(list);
                break;
            }
            case 0: {
                if (fileArray.length != 1) {
                    throw new DataSourceException("Packed Profile type: you must specify exactly one file");
                }
                if (fileArray[0].isDirectory()) {
                    throw new DataSourceException("Packed Profile type: you must specify a file, not a directory");
                }
                dataSource = new PackedProfileDataSource(fileArray[0]);
                break;
            }
            case 9: {
                if (fileArray.length != 1) {
                    throw new DataSourceException("Cube type: you must specify exactly one file");
                }
                if (fileArray[0].isDirectory()) {
                    throw new DataSourceException("Cube type: you must specify a file, not a directory");
                }
                try {
                    Class.forName("org.xml.sax.SAXException");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new DataSourceException("Sorry, cube format requires Java 1.4");
                }
                dataSource = new CubeDataSource(fileArray[0]);
                break;
            }
            case 17: {
                if (fileArray.length != 1) {
                    throw new DataSourceException("Cube type : you must specify exactly one file");
                }
                if (fileArray[0].isDirectory()) {
                    throw new DataSourceException("Cube type: you must specify a file, not a directory");
                }
                try {
                    Class.forName("org.xml.sax.SAXException");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new DataSourceException("Sorry, cube format requires Java >=1.4");
                }
                dataSource = new Cube3DataSource(fileArray[0]);
                break;
            }
            case 10: {
                if (fileArray.length != 1) {
                    throw new DataSourceException("HPCToolkit type: you must specify exactly one file");
                }
                if (fileArray[0].isDirectory()) {
                    throw new DataSourceException("HPCToolkit type: you must specify a file, not a directory");
                }
                try {
                    Class.forName("org.xml.sax.SAXException");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new DataSourceException("Sorry, HPCToolkit format requires Java 1.4");
                }
                dataSource = new HPCToolkitDataSource(fileArray[0]);
                break;
            }
            case 2: {
                if (fileArray.length >= 1) {
                    dataSource = new SnapshotDataSource(fileArray);
                    break;
                }
                fileList = new FileList();
                fileArray2 = fileList.helperFindSnapshots(System.getProperty("user.dir"));
                if (fileArray2.length == 0) {
                    throw new DataSourceException("snapshot type: no snapshots found");
                }
                dataSource = new SnapshotDataSource(fileArray2);
                break;
            }
            case 11: {
                dataSource = new OmppDataSource(fileArray[0]);
                break;
            }
            case 12: {
                dataSource = new PeriXMLDataSource(fileArray[0]);
                break;
            }
            case 100: {
                list.add(fileArray);
                dataSource = new GyroDataSource(list);
                break;
            }
            case 13: {
                dataSource = new GPTLDataSource(fileArray[0]);
                break;
            }
            case 15: {
                dataSource = new IPMDataSource(fileArray[0]);
                break;
            }
            case 14: {
                dataSource = new ParaverDataSource(fileArray);
                break;
            }
            case 101: {
                dataSource = new GAMESSDataSource(fileArray[0]);
                break;
            }
            default: {
                throw new RuntimeException("Programming error: unknown format id = " + n);
            }
        }
        dataSource.setFileType(n);
        return dataSource;
    }

    public static void mergeSnapshots(File[] fileArray, String string) throws Exception {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(fileOutputStream);
        for (int i = 0; i < fileArray.length; ++i) {
            InputStream inputStream;
            FileInputStream fileInputStream = new FileInputStream(fileArray[i]);
            try {
                GZIPInputStream gZIPInputStream = new GZIPInputStream(fileInputStream);
                inputStream = gZIPInputStream;
            }
            catch (IOException iOException) {
                fileInputStream.close();
                inputStream = new FileInputStream(fileArray[i]);
            }
            int n = 0;
            byte[] byArray = new byte[4096];
            while ((n = inputStream.read(byArray)) >= 0) {
                gZIPOutputStream.write(byArray, 0, n);
            }
            fileInputStream.close();
        }
        gZIPOutputStream.close();
        fileOutputStream.close();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EmptyIterator
    implements ListIterator<FunctionProfile>,
    Iterator<FunctionProfile> {
        @Override
        public int nextIndex() {
            return 0;
        }

        @Override
        public int previousIndex() {
            return 0;
        }

        @Override
        public void remove() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public boolean hasPrevious() {
            return false;
        }

        @Override
        public FunctionProfile next() {
            return null;
        }

        @Override
        public FunctionProfile previous() {
            return null;
        }

        @Override
        public void add(FunctionProfile functionProfile) {
        }

        @Override
        public void set(FunctionProfile functionProfile) {
        }
    }
}

