/*
 * Decompiled with CFR 0.152.
 */
package scalasca.cubex.cube;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.filechooser.FileFilter;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;
import scalasca.cubex.cube.Cartesian;
import scalasca.cubex.cube.Cnode;
import scalasca.cubex.cube.CubeCalculationFlavour;
import scalasca.cubex.cube.ExclusiveMetric;
import scalasca.cubex.cube.InclusiveMetric;
import scalasca.cubex.cube.Machine;
import scalasca.cubex.cube.Metric;
import scalasca.cubex.cube.MetricType;
import scalasca.cubex.cube.Node;
import scalasca.cubex.cube.Process;
import scalasca.cubex.cube.Region;
import scalasca.cubex.cube.Thread;
import scalasca.cubex.cube.cubeparser.CubeParser;
import scalasca.cubex.cube.datalayout.data.value.Value;
import scalasca.cubex.cube.errors.BadCubeReportLayoutException;
import scalasca.cubex.cube.errors.BadSyntaxException;
import scalasca.cubex.cube.errors.NotEnumeratedCnodeException;
import scalasca.cubex.cube.errors.UnknownMetricTypeException;
import scalasca.cubex.cube.errors.UnknownValueTypeException;
import scalasca.cubex.cube.services.CubeFileFilter;
import scalasca.cubex.cube.services.ProgressReport;
import scalasca.cubex.cubexlayout.CubeLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cube
extends ProgressReport {
    private boolean loading = false;
    private FileInputStream fis;
    private BufferedInputStream buffered_fis;
    private CubeLayout cube_tar_layout;
    protected String filename;
    protected String version;
    protected Map<String, String> attributes = new HashMap<String, String>();
    protected ArrayList<String> mirrors = new ArrayList();
    protected ArrayList<Metric> metv = new ArrayList();
    protected ArrayList<Metric> root_metv = new ArrayList();
    protected ArrayList<Region> regionv = new ArrayList();
    protected ArrayList<Cnode> cnodev = new ArrayList();
    protected ArrayList<Cnode> root_cnodev = new ArrayList();
    protected ArrayList<Machine> machinev = new ArrayList();
    protected ArrayList<Node> nodev = new ArrayList();
    protected ArrayList<Process> processv = new ArrayList();
    protected ArrayList<Thread> thrdv = new ArrayList();
    protected ArrayList<Cartesian> cartv = new ArrayList();
    protected String metricsTreeTitle = "";
    protected String callTreeTitle = "";
    protected String systemTreeTitle = "";

    public void openCubeReport(String string) throws BadSyntaxException, BadCubeReportLayoutException, FileNotFoundException, IOException {
        try {
            this.progressContext.setNextStep(0.04);
            this.progressContext.setProgressMessage("Open report and get the achor file...");
            this.loading = true;
            this.filename = string;
            File file = new File(this.filename);
            this.progressContext.setAchievedStep();
            this.progressContext.setNextStep(0.22);
            this.progressContext.setProgressMessage("Parsing report structure...");
            this.cube_tar_layout = CubeLayout.getCubeLayout(file.getPath());
            this.progressContext.setAchievedStep();
            this.progressContext.setNextStep(0.04);
            this.progressContext.setProgressMessage("Parsing meta data of the report...");
            byte[] byArray = this.cube_tar_layout.getAnchorBytes();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            XMLReader xMLReader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            CubeParser cubeParser = new CubeParser(this);
            xMLReader.setContentHandler(cubeParser);
            xMLReader.setErrorHandler(cubeParser);
            this.progressContext.setSubActor(cubeParser);
            xMLReader.parse(new InputSource(byteArrayInputStream));
            this.progressContext.setAchievedStep();
            this.progressContext.setProgressMessage("Load binary data...");
            this.loadData();
            this.cube_tar_layout = null;
            System.gc();
            System.gc();
            System.gc();
            System.gc();
            this.loading = false;
        }
        catch (BadCubeReportLayoutException badCubeReportLayoutException) {
            throw badCubeReportLayoutException;
        }
        catch (SAXException sAXException) {
            throw new BadSyntaxException(sAXException.getMessage());
        }
    }

    public void set_version(String string) {
        this.version = string;
    }

    public String get_version() {
        return this.version;
    }

    public void def_attr(String string, String string2) {
        if (string != null) {
            this.attributes.put(string, string2);
        }
    }

    public void def_mirror(String string) {
        if (string != null) {
            this.mirrors.add(string);
        }
    }

    public Metric def_met(String string, String string2, String string3, String string4, String string5, String string6, MetricType metricType, Metric metric) throws UnknownMetricTypeException, UnknownValueTypeException {
        int n = this.metv.size();
        Metric metric2 = this.def_met(n, metricType, metric);
        metric2.init(string, string2, string3, string4, string5, string6);
        return metric2;
    }

    public Metric def_met(int n, String string, String string2, String string3, String string4, String string5, String string6, MetricType metricType, Metric metric) throws UnknownMetricTypeException, UnknownValueTypeException {
        Metric metric2 = this.def_met(n, metricType, metric);
        metric2.init(string, string2, string3, string4, string5, string6);
        return metric2;
    }

    public Metric def_met(int n, MetricType metricType, Metric metric) throws UnknownMetricTypeException {
        Metric metric2 = null;
        if (this.metv.size() <= n) {
            this.metv.ensureCapacity(n + 1);
            for (int i = this.metv.size(); i < n + 1; ++i) {
                this.metv.add(null);
            }
        }
        switch (metricType) {
            case INCLUSIVE: {
                metric2 = new InclusiveMetric(n, metric);
                this.metv.set(n, metric2);
                if (metric != null) break;
                this.root_metv.add(metric2);
                break;
            }
            case EXCLUSIVE: {
                metric2 = new ExclusiveMetric(n, metric);
                this.metv.set(n, metric2);
                if (metric != null) break;
                this.root_metv.add(metric2);
                break;
            }
            default: {
                throw new UnknownMetricTypeException(metricType);
            }
        }
        return metric2;
    }

    public Region def_region(String string, int n, int n2, String string2, String string3, String string4) {
        int n3 = this.regionv.size();
        return this.def_region(string, n, n2, string2, string3, string4);
    }

    public Region def_region(int n, String string, int n2, int n3, String string2, String string3, String string4) {
        Region region = null;
        if (this.regionv.size() <= n) {
            this.regionv.ensureCapacity(n + 1);
            for (int i = this.regionv.size(); i < n + 1; ++i) {
                this.regionv.add(null);
            }
        }
        region = new Region(n, string, n2, n3, string4, string2, string3);
        this.regionv.set(n, region);
        return region;
    }

    public Cnode def_cnode(int n, Cnode cnode) {
        int n2 = this.cnodev.size();
        return this.def_cnode(n2, n, cnode);
    }

    public Cnode def_cnode(int n, int n2, Cnode cnode) {
        if (this.cnodev.size() <= n) {
            this.cnodev.ensureCapacity(n + 1);
            for (int i = this.cnodev.size(); i < n + 1; ++i) {
                this.cnodev.add(null);
            }
        }
        Region region = this.regionv.get(n2);
        Cnode cnode2 = new Cnode(n, region, cnode);
        this.cnodev.set(n, cnode2);
        if (cnode == null) {
            this.root_cnodev.add(cnode2);
        }
        return cnode2;
    }

    public Machine def_machine(String string, String string2) {
        int n = this.machinev.size();
        return this.def_machine(n, string, string2);
    }

    public Machine def_machine(int n) {
        if (this.machinev.size() <= n) {
            this.machinev.ensureCapacity(n + 1);
            for (int i = this.machinev.size(); i < n + 1; ++i) {
                this.machinev.add(null);
            }
        }
        Machine machine = new Machine(n);
        this.machinev.set(n, machine);
        return machine;
    }

    public Machine def_machine(int n, String string, String string2) {
        Machine machine = this.def_machine(n);
        machine.init(string, string2);
        return machine;
    }

    public Node def_node(String string, String string2, Machine machine) {
        int n = this.nodev.size();
        return this.def_node(n, string, string2, machine);
    }

    public Node def_node(int n, Machine machine) {
        if (this.nodev.size() <= n) {
            this.nodev.ensureCapacity(n + 1);
            for (int i = this.nodev.size(); i < n + 1; ++i) {
                this.nodev.add(null);
            }
        }
        Node node = new Node(n, machine);
        this.nodev.set(n, node);
        return node;
    }

    public Node def_node(int n, String string, String string2, Machine machine) {
        Node node = this.def_node(n, machine);
        node.init(string, string2);
        return node;
    }

    public Process def_proc(long l, String string, String string2, Node node) {
        int n = this.processv.size();
        return this.def_proc(n, l, string, node);
    }

    public Process def_proc(int n, Node node) {
        if (this.processv.size() <= n) {
            this.processv.ensureCapacity(n + 1);
            for (int i = this.processv.size(); i < n + 1; ++i) {
                this.processv.add(null);
            }
        }
        Process process = new Process(n, node);
        this.processv.set(n, process);
        return process;
    }

    public Process def_proc(int n, long l, String string, Node node) {
        Process process = this.def_proc(n, node);
        process.init(l, string);
        return process;
    }

    public Thread def_thrd(long l, String string, Process process) {
        int n = this.thrdv.size();
        return this.def_thrd(n, l, string, process);
    }

    public Thread def_thrd(int n, Process process) {
        if (this.thrdv.size() <= n) {
            this.thrdv.ensureCapacity(n + 1);
            for (int i = this.thrdv.size(); i < n + 1; ++i) {
                this.thrdv.add(null);
            }
        }
        Thread thread = new Thread(n, process);
        this.thrdv.set(n, thread);
        return thread;
    }

    public Thread def_thrd(int n, long l, String string, Process process) {
        Thread thread = this.def_thrd(n, process);
        thread.init(l, string);
        return thread;
    }

    public Cartesian def_cart(int n, ArrayList<Integer> arrayList, ArrayList<Boolean> arrayList2) {
        Cartesian cartesian = new Cartesian(n, arrayList, arrayList2);
        this.cartv.add(cartesian);
        return cartesian;
    }

    public ArrayList<Metric> get_metv() {
        return this.metv;
    }

    public ArrayList<Metric> get_root_metv() {
        return this.root_metv;
    }

    public ArrayList<Region> get_regionv() {
        return this.regionv;
    }

    public ArrayList<Cnode> get_cnodev() {
        return this.cnodev;
    }

    public ArrayList<Cnode> get_root_cnodev() {
        return this.root_cnodev;
    }

    public ArrayList<Machine> get_machv() {
        return this.machinev;
    }

    public ArrayList<Node> get_nodev() {
        return this.nodev;
    }

    public ArrayList<Process> get_procv() {
        return this.processv;
    }

    public ArrayList<Thread> get_thrdv() {
        return this.thrdv;
    }

    public ArrayList<Cartesian> get_cartv() {
        return this.cartv;
    }

    public void set_metricstree_title(String string) {
        this.metricsTreeTitle = string;
    }

    public void set_calltree_title(String string) {
        this.callTreeTitle = string;
    }

    public void set_systemtree_title(String string) {
        this.systemTreeTitle = string;
    }

    public String get_metricstree_title() {
        return this.metricsTreeTitle;
    }

    public String get_calltree_title() {
        return this.callTreeTitle;
    }

    public String get_systemtree_title() {
        return this.systemTreeTitle;
    }

    public boolean isLoading() {
        return this.loading;
    }

    public void set_sev(Metric metric, Cnode cnode, Thread thread, String string) throws NotEnumeratedCnodeException {
        metric.set_sev(cnode, thread, string);
    }

    public double get_sev(Metric metric, Cnode cnode, Thread thread) throws NotEnumeratedCnodeException {
        return this.get_sev(metric, cnode, CubeCalculationFlavour.EXCLUSIVE, thread);
    }

    public double get_sev(Metric metric, Cnode cnode, CubeCalculationFlavour cubeCalculationFlavour, Thread thread) throws NotEnumeratedCnodeException {
        Value value = this.get_sev_adv(metric, cnode, cubeCalculationFlavour, thread);
        return value.getDouble();
    }

    public Value get_sev_adv(Metric metric, Cnode cnode, CubeCalculationFlavour cubeCalculationFlavour, Thread thread) throws NotEnumeratedCnodeException {
        return metric.get_sev(cnode, cubeCalculationFlavour, thread);
    }

    public Value get_sev_adv(Metric metric, Cnode cnode, Thread thread) throws NotEnumeratedCnodeException {
        return this.get_sev_adv(metric, cnode, CubeCalculationFlavour.EXCLUSIVE, thread);
    }

    private void loadData() throws BadCubeReportLayoutException {
        if (!this.version.equalsIgnoreCase("4.0")) {
            this.progressContext.setNextStep(0.3);
            return;
        }
        double d = 0.7 / (double)this.metv.size();
        for (Metric metric : this.metv) {
            this.progressContext.setNextStep(d);
            this.progressContext.setProgressMessage("Load data into CUBE for metric: " + metric.getDisplayName());
            metric.createEnumeration(this.root_cnodev);
            try {
                byte[] byArray = this.cube_tar_layout.getMetricIndexBytes(metric.getId());
                byte[] byArray2 = this.cube_tar_layout.getMetricDataBytes(metric.getId());
                this.progressContext.setSubActor(metric);
                metric.createDataMatrix(byArray, byArray2, this.cnodev.size(), this.thrdv.size());
                this.progressContext.setAchievedStep();
                byArray = null;
                byArray2 = null;
            }
            catch (Exception exception) {
                throw new BadCubeReportLayoutException("Cannot load data for metric " + metric.getUniqName() + ". Error: " + exception.getMessage());
            }
        }
    }

    public void prepareForCube3() {
        for (Metric metric : this.metv) {
            metric.createEnumeration(this.root_cnodev);
            metric.createDataMatrix(this.cnodev.size(), this.thrdv.size());
        }
    }

    public static FileFilter getCubeFilesFilter() {
        return new CubeFileFilter();
    }
}

