/*
 * Decompiled with CFR 0.152.
 */
package scalasca.cubex.cube.datalayout;

import scalasca.cubex.cube.datalayout.data.DataRows;
import scalasca.cubex.cube.datalayout.data.value.Value;
import scalasca.cubex.cube.datalayout.index.Index;

public class Matrix {
    private Value[][] matrix;
    private Value value;
    private int ncid;
    private int ntid;

    public Matrix(Value value, int n, int n2) {
        this.value = value;
        this.ncid = n;
        this.ntid = n2;
        this.matrix = new Value[this.ncid][];
        for (int i = 0; i < this.ncid; ++i) {
            this.matrix[i] = new Value[this.ntid];
            for (int j = 0; j < this.ntid; ++j) {
                this.matrix[i][j] = null;
            }
        }
    }

    public Matrix(DataRows dataRows, Index index, int n, int n2) {
        this.value = dataRows.getValue();
        this.ncid = n;
        this.ntid = n2;
        this.matrix = new Value[this.ncid][];
        for (int i = 0; i < this.ncid; ++i) {
            try {
                int n3 = index.getPosition(i, 0);
                this.matrix[i] = dataRows.getRow(n3, this.ntid);
                continue;
            }
            catch (Exception exception) {
                this.matrix[i] = null;
            }
        }
    }

    public void print() {
        System.out.println("======== Matrix " + this.ncid + "x" + this.ntid + " ============");
        for (Value[] valueArray : this.matrix) {
            if (valueArray != null) {
                for (Value value : valueArray) {
                    System.out.print(value.toString() + " ");
                }
            } else {
                System.out.print("----------");
            }
            System.out.println();
        }
        System.out.println("======== END Matrix ================================");
    }

    public Value getValue(int n, int n2) {
        Value value = null;
        if (this.matrix[n] != null) {
            value = this.matrix[n][n2];
        }
        if (value != null) {
            return value;
        }
        return this.value;
    }

    public void setValue(int n, int n2, String string) {
        Value value = this.value.clone();
        value.setValue(string);
        if (this.matrix[n] != null) {
            this.matrix[n][n2] = value;
        }
    }
}

