/*
 * Decompiled with CFR 0.152.
 */
package scalasca.cubex.cube.datalayout.data;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import scalasca.cubex.cube.datalayout.data.value.Value;
import scalasca.cubex.cube.errors.BadDataException;
import scalasca.cubex.cube.services.transformation.Endianess;

public class DataRows {
    Value value;
    Value[] data = null;

    public DataRows(byte[] byArray, Value value, Endianess endianess) throws BadDataException {
        this.loadData(byArray, value, endianess);
    }

    protected void loadData(byte[] byArray, Value value, Endianess endianess) throws BadDataException {
        this.value = value;
        byte[] byArray2 = null;
        try {
            byArray2 = this.value.correctEndianess(byArray, endianess);
            this.data = this.getRowOfValues(byArray2);
        }
        catch (Exception exception) {
            throw new BadDataException("Error in loading uncompressed data: " + exception.toString());
        }
    }

    protected Value[] getRowOfValues(byte[] byArray) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        Value[] valueArray = new Value[byArray.length / this.value.size()];
        for (int i = 0; i < valueArray.length; ++i) {
            valueArray[i] = this.value.clone(dataInputStream);
        }
        return valueArray;
    }

    public void print() {
        System.out.println("======== Raw rows of data ============");
        System.out.println("======== " + this.data.length + " bytes ============");
        for (int i = 0; i < this.data.length; ++i) {
            System.out.print(this.data[i].toString() + " ");
        }
        System.out.println();
    }

    public Value getValue() {
        return this.value;
    }

    public Value[] getRow(int n, int n2) {
        Value[] valueArray = new Value[n2];
        System.arraycopy(this.data, n, valueArray, 0, n2);
        return valueArray;
    }

    public void removeRowsFromMemory() {
        this.data = null;
    }
}

