/*
 * Decompiled with CFR 0.152.
 */
package scalasca.cubex.cube.datalayout.data.value;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import scalasca.cubex.cube.datalayout.data.value.Value;
import scalasca.cubex.cube.services.transformation.Endianess;

public class CubeDouble
extends Value {
    protected double value;

    public CubeDouble() {
        this.value = 0.0;
    }

    public CubeDouble(double d) {
        this.value = d;
    }

    public String getName() {
        return "DOUBLE";
    }

    public String toString() {
        return Double.valueOf(this.value).toString();
    }

    public int size() {
        return 8;
    }

    public void correctEndianess(Endianess endianess, DataInputStream dataInputStream, DataOutputStream dataOutputStream) throws IOException {
        double d = dataInputStream.readDouble();
        double d2 = endianess.applyOn(d);
        dataOutputStream.writeDouble(d2);
    }

    public Value clone() {
        return new CubeDouble();
    }

    public Value clone(DataInputStream dataInputStream) throws IOException {
        return new CubeDouble(dataInputStream.readDouble());
    }

    public void setValue(String string) {
        this.value = Double.parseDouble(string);
    }

    public void setValue(byte by) {
        this.value = by;
    }

    public void setValue(short s) {
        this.value = s;
    }

    public void setValue(int n) {
        this.value = n;
    }

    public void setValue(long l) {
        this.value = l;
    }

    public void setValue(double d) {
        this.value = d;
    }

    public double getDouble() {
        return this.value;
    }

    public void addValue(Value value) {
        CubeDouble cubeDouble = (CubeDouble)value;
        this.value += cubeDouble.value;
    }

    public void subtractValue(Value value) {
        CubeDouble cubeDouble = (CubeDouble)value;
        this.value -= cubeDouble.value;
    }
}

