/*
 * Decompiled with CFR 0.152.
 */
package scalasca.cubex.cube.datalayout.data.value;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import scalasca.cubex.cube.datalayout.data.value.Value;
import scalasca.cubex.cube.services.transformation.Endianess;

public class CubeInt16
extends Value {
    protected short value;

    public CubeInt16() {
        this.value = 0;
    }

    public CubeInt16(short s) {
        this.value = s;
    }

    public String getName() {
        return "INT16";
    }

    public String toString() {
        return Short.valueOf(this.value).toString();
    }

    public int size() {
        return 2;
    }

    public void correctEndianess(Endianess endianess, DataInputStream dataInputStream, DataOutputStream dataOutputStream) throws IOException {
        short s = dataInputStream.readShort();
        short s2 = endianess.applyOn(s);
        dataOutputStream.writeShort(s2);
    }

    public Value clone() {
        return new CubeInt16();
    }

    public Value clone(DataInputStream dataInputStream) throws IOException {
        return new CubeInt16(dataInputStream.readShort());
    }

    public void setValue(String string) {
        this.value = Short.parseShort(string);
    }

    public void setValue(byte by) {
        this.value = by;
    }

    public void setValue(short s) {
        this.value = s;
    }

    public void setValue(int n) {
        this.value = (short)n;
    }

    public void setValue(long l) {
        this.value = (short)l;
    }

    public void setValue(double d) {
        this.value = (short)d;
    }

    public double getDouble() {
        return Short.valueOf(this.value).doubleValue();
    }

    public void addValue(Value value) {
        CubeInt16 cubeInt16 = (CubeInt16)value;
        this.value = (short)(this.value + cubeInt16.value);
    }

    public void subtractValue(Value value) {
        CubeInt16 cubeInt16 = (CubeInt16)value;
        this.value = (short)(this.value - cubeInt16.value);
    }
}

