/*
 * Decompiled with CFR 0.152.
 */
package scalasca.cubex.cube.datalayout.data.value;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import scalasca.cubex.cube.datalayout.data.value.Value;
import scalasca.cubex.cube.services.transformation.Endianess;

public class CubeUint32
extends Value {
    protected long value;

    public CubeUint32() {
    }

    public CubeUint32(int n) {
        this.value = n;
    }

    public String getName() {
        return "UINT32";
    }

    public String toString() {
        return Long.valueOf(this.value).toString();
    }

    public int size() {
        return 4;
    }

    public void correctEndianess(Endianess endianess, DataInputStream dataInputStream, DataOutputStream dataOutputStream) throws IOException {
        int n = dataInputStream.readInt();
        int n2 = endianess.applyOn(n);
        dataOutputStream.writeInt(n2);
    }

    public Value clone() {
        return new CubeUint32();
    }

    public Value clone(DataInputStream dataInputStream) throws IOException {
        return new CubeUint32(dataInputStream.readInt());
    }

    public void setValue(String string) {
        this.value = Long.parseLong(string);
    }

    public void setValue(byte by) {
        this.value = by;
    }

    public void setValue(short s) {
        this.value = s;
    }

    public void setValue(int n) {
        this.value = n;
    }

    public void setValue(long l) {
        this.value = l;
    }

    public void setValue(double d) {
        this.value = (long)d;
    }

    public double getDouble() {
        return Long.valueOf(this.value).doubleValue();
    }

    public void addValue(Value value) {
        CubeUint32 cubeUint32 = (CubeUint32)value;
        this.value += cubeUint32.value;
    }

    public void subtractValue(Value value) {
        CubeUint32 cubeUint32 = (CubeUint32)value;
        this.value -= cubeUint32.value;
    }
}

