/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.IOException;
import org.h2.store.fs.FileObject;
import org.h2.store.fs.RecordingFileSystem;

public class RecordingFileObject
implements FileObject {
    private final RecordingFileSystem fs;
    private final FileObject file;
    private final String name;

    RecordingFileObject(RecordingFileSystem recordingFileSystem, FileObject fileObject) {
        this.fs = recordingFileSystem;
        this.file = fileObject;
        this.name = fileObject.getName();
    }

    public void close() throws IOException {
        this.file.close();
    }

    public long getFilePointer() throws IOException {
        return this.file.getFilePointer();
    }

    public String getName() {
        return "rec:" + this.name;
    }

    public long length() throws IOException {
        return this.file.length();
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        this.file.readFully(byArray, n, n2);
    }

    public void seek(long l) throws IOException {
        this.file.seek(l);
    }

    public void setFileLength(long l) throws IOException {
        this.fs.log(1, this.name, null, l);
        this.file.setFileLength(l);
    }

    public void sync() throws IOException {
        this.file.sync();
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        byte[] byArray2 = byArray;
        if (n != 0 || n2 != byArray.length) {
            byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
        }
        this.file.write(byArray, n, n2);
        this.fs.log(0, this.name, byArray2, this.file.getFilePointer());
    }

    public boolean tryLock() {
        return this.file.tryLock();
    }

    public void releaseLock() {
        this.file.releaseLock();
    }
}

